/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedItems;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobBurgersWaiter
extends Job {
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public int runDelay = 1000;
    private long timeSinceLastRun = 0L;
    private Building theStore = null;

    public JobBurgersWaiter(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.theStore == null) {
            this.theStore = Building.getBuilding(this.theFolk.employedAt);
        }
        if (this.theStore == null) {
            return;
        }
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.ARRIVEDATSTORE) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.runDelay = 11000;
        } else {
            this.runDelay = this.theStage == Stage.SERVING ? 45000 : 5000;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATSTORE) {
                this.theStage = Stage.SERVING;
                this.theFolk.statusText = "\u4e3a\u987e\u5ba2\u670d\u52a1\u4e2d";
            } else if (this.theStage == Stage.SERVING) {
                this.stageServing();
            }
        }
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
    }

    private void stageServing() {
        ArrayList<CommonProxy.V3> serve = this.theStore.getSpecialBlocks(2);
        if (serve.isEmpty()) {
            return;
        }
        ArrayList<IInventory> theChests = JobBurgersWaiter.inventoriesFindClosest(serve.get(0), 3);
        if (theChests.isEmpty()) {
            return;
        }
        this.theFolk.gotoXYZ(serve.get(0), null);
        try {
            this.theFolk.destination.destinationAcc = 0.3;
        }
        catch (Exception e) {
            // empty catch block
        }
        ItemStack is = JobBurgersWaiter.inventoriesGet(theChests, null, true, false);
        if (is == null) {
            this.theFolk.statusText = "\u5e0c\u671b\u6211\u4eec\u6709\u66f4\u591a\u7684\u987e\u5ba2";
            return;
        }
        if (is.func_77973_b() == SimukraftReloadedItems.itemFood) {
            is = new ItemStack(is.func_77973_b(), 1, is.func_77960_j());
            JobBurgersWaiter.inventoriesGet(theChests, is, false, true);
            this.theFolk.statusText = "Just sold " + is.func_82833_r();
            int r = new Random().nextInt(SimukraftReloaded.theFolks.size() - 1);
            FolkData folk = SimukraftReloaded.theFolks.get(r);
            if (folk.levelFood < 10) {
                ++folk.levelFood;
            }
            folk.saveThisFolk();
            SimukraftReloaded.log.info("JobBurgersWaiter: Just fed " + folk.name);
            SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.45);
        } else {
            this.theFolk.statusText = "\u8c01\u628a" + is.func_82833_r() + "\u5728\u6211\u7684\u7bb1\u5b50\u91cc\u6ca1\u6709\u5403\u7684\u4e1c\u897f\uff01";
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u62b5\u8fbe\u5546\u5e97";
            this.theStage = Stage.ARRIVEDATSTORE;
            ArrayList<CommonProxy.V3> back = this.theStore.getSpecialBlocks(2);
            if (!back.isEmpty()) {
                this.theFolk.gotoXYZ(back.get(0), null);
            }
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATSTORE,
        SERVING;

    }
}

