/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedItems;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class JobBurgersManager
extends Job {
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public int runDelay = 1000;
    private long timeSinceLastRun = 0L;
    private Building theStore = null;
    private int currentPickup = 0;
    private ArrayList<Building> pickupBuildings = new ArrayList();
    public int beefCount;
    public int cheeseCount;
    public int breadCount;
    public int potatoCount;
    public boolean placedBeef;
    public boolean placedCheese;
    public boolean placedBread;
    public boolean placedPotato;

    public JobBurgersManager(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.theStore == null) {
            this.theStore = Building.getBuilding(this.theFolk.employedAt);
        }
        if (this.theStore == null) {
            return;
        }
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.ARRIVEDATSTORE) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.runDelay = 11000;
        } else {
            this.runDelay = this.theStage == Stage.HANGINGOUT ? 30000 : 5000;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATSTORE) {
                this.theFolk.statusText = "\u68c0\u67e5\u6211\u7684\u4efb\u52a1\u5217\u8868";
                this.theStage = Stage.PICKUPBAKERY;
                this.step = 1;
            } else if (this.theStage == Stage.PICKUPBAKERY) {
                this.stagePickupBakery();
            } else if (this.theStage == Stage.PICKUPGROCERY) {
                this.stagePickupGrocery();
            } else if (this.theStage == Stage.PICKUPCHEESE) {
                this.stagePickupCheese();
            } else if (this.theStage == Stage.PICKUPBUTCHERS) {
                this.stagePickupButchers();
            } else if (this.theStage == Stage.DROPOFF) {
                this.stageDropoff();
            } else if (this.theStage == Stage.HANGINGOUT) {
                this.stageHangingOut();
            }
        }
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
    }

    private void doPickup(String buildingSearch, Block pickUpItem, boolean doCompareMeta) {
        if (this.step == 1) {
            this.currentPickup = 0;
            this.pickupBuildings.clear();
            this.pickupBuildings = Building.getBuildingBySearch(buildingSearch, true);
            if (this.pickupBuildings.size() == 0) {
                this.step = 4;
                return;
            }
            this.theFolk.gotoXYZ(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, null);
            this.theFolk.statusText = "\u6211\u5728\u53bb\u7684\u8def\u4e0a" + this.pickupBuildings.get((int)this.currentPickup).displayName;
            this.step = 2;
        } else if (this.step == 2) {
            if (this.theFolk.destination == null) {
                this.step = 3;
            }
        } else if (this.step == 3) {
            int count;
            int buy;
            this.theFolk.statusText = "\u5728\u8d2d\u4e70\u7269\u54c1" + this.pickupBuildings.get((int)this.currentPickup).displayName;
            ArrayList<IInventory> chests = JobBurgersManager.inventoriesFindClosest(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, 5);
            if (!chests.isEmpty() && (buy = (count = this.getItemCountInChests(chests, new ItemStack(pickUpItem, 1), doCompareMeta)) / 4) > 0) {
                SimukraftReloaded.log.info("JobBurgersManager: buying " + buy + " out of " + count + " items");
                this.inventoriesTransferLimitedToFolk(this.theFolk.inventory, chests, new ItemStack(pickUpItem, 1, pickUpItem.func_149692_a(1)), buy, doCompareMeta);
            }
            ++this.currentPickup;
            if (this.currentPickup <= this.pickupBuildings.size() - 1) {
                this.theFolk.gotoXYZ(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, null);
                this.theFolk.statusText = "\u6211\u5728\u53bb\u7684\u8def\u4e0a" + this.pickupBuildings.get((int)this.currentPickup).displayName;
                this.step = 2;
            } else {
                this.step = 4;
            }
        }
    }

    private void doPickup(String buildingSearch, Item pickUpItem, boolean doCompareMeta) {
        if (this.step == 1) {
            this.currentPickup = 0;
            this.pickupBuildings.clear();
            this.pickupBuildings = Building.getBuildingBySearch(buildingSearch, true);
            if (this.pickupBuildings.size() == 0) {
                this.step = 4;
                return;
            }
            this.theFolk.gotoXYZ(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, null);
            this.theFolk.statusText = "\u6211\u5728\u53bb\u7684\u8def\u4e0a" + this.pickupBuildings.get((int)this.currentPickup).displayName;
            this.step = 2;
        } else if (this.step == 2) {
            if (this.theFolk.destination == null) {
                this.step = 3;
            }
        } else if (this.step == 3) {
            this.theFolk.statusText = "\u5728\u8d2d\u4e70\u7269\u54c1" + this.pickupBuildings.get((int)this.currentPickup).displayName;
            ArrayList<IInventory> chests = JobBurgersManager.inventoriesFindClosest(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, 5);
            SimukraftReloaded.log.info(chests.toString());
            if (!chests.isEmpty()) {
                SimukraftReloaded.log.info("\u7bb1\u5b50\u6ee1\u4e86");
                int count = this.getItemCountInChests(chests, new ItemStack(pickUpItem, 1), doCompareMeta);
                SimukraftReloaded.log.info(Integer.toString(count));
                int buy = count / 4;
                SimukraftReloaded.log.info(Integer.toString(buy));
                if (buy > 0) {
                    if (pickUpItem == Items.field_151174_bG) {
                        this.potatoCount = count / 4;
                    }
                    if (pickUpItem == Items.field_151025_P) {
                        this.breadCount = count / 4;
                    }
                    if (pickUpItem == Items.field_151082_bd) {
                        this.beefCount = count / 4;
                    }
                    if (pickUpItem == SimukraftReloadedItems.itemFood || pickUpItem == SimukraftReloadedItems.itemFoodCheese) {
                        this.cheeseCount = count / 4;
                    }
                    SimukraftReloaded.log.info("JobBurgersManager: buying " + buy + " out of " + count + " items");
                    for (int i = 0; i < chests.get(0).func_70302_i_(); ++i) {
                        if (chests.get(0).func_70301_a(i) != new ItemStack(pickUpItem)) continue;
                        this.inventoriesTransferLimitedToFolk(this.theFolk.inventory, chests, new ItemStack(pickUpItem, 1, 0), buy, doCompareMeta);
                        break;
                    }
                }
            }
            ++this.currentPickup;
            if (this.currentPickup <= this.pickupBuildings.size() - 1) {
                this.theFolk.gotoXYZ(this.pickupBuildings.get((int)this.currentPickup).primaryXYZ, null);
                this.theFolk.statusText = "\u6211\u5728\u53bb\u7684\u8def\u4e0a" + this.pickupBuildings.get((int)this.currentPickup).displayName;
                this.step = 2;
            } else {
                this.step = 4;
            }
        }
    }

    private void stagePickupBakery() {
        if (this.step < 4) {
            this.doPickup("bakery", new ItemStack(Items.field_151025_P).func_77973_b(), false);
        } else {
            this.theStage = Stage.PICKUPGROCERY;
            this.step = 1;
        }
    }

    private void stagePickupGrocery() {
        if (this.step < 4) {
            this.doPickup("grocery", new ItemStack(Items.field_151174_bG).func_77973_b(), false);
        } else {
            this.theStage = Stage.PICKUPCHEESE;
            this.step = 1;
        }
    }

    private void stagePickupCheese() {
        if (this.step < 4) {
            this.doPickup("cheese factory", new ItemStack(SimukraftReloadedItems.itemFood, 1, 0).func_77973_b(), true);
        } else {
            this.theStage = Stage.PICKUPBUTCHERS;
            this.step = 1;
        }
    }

    private void stagePickupButchers() {
        if (this.step < 4) {
            this.doPickup("butchers", new ItemStack(Items.field_151082_bd, 1, 0).func_77973_b(), false);
        } else {
            this.theStage = Stage.DROPOFF;
            this.step = 1;
        }
    }

    private void stageDropoff() {
        if (this.step == 1) {
            this.theFolk.statusText = "\u5728\u53bb\u5546\u5e97\u56de\u6765\u7684\u8def\u4e0a";
            ArrayList<CommonProxy.V3> back = this.theStore.getSpecialBlocks(0);
            if (!back.isEmpty()) {
                this.theFolk.gotoXYZ(back.get(0), null);
                this.step = 2;
            }
        } else if (this.step == 2) {
            if (this.theFolk.destination == null) {
                this.step = 3;
            }
        } else if (this.step == 3) {
            SimukraftReloaded.log.info("\u5378\u6599\u7684\u6750\u6599");
            this.theFolk.statusText = "\u5378\u6599\u7684\u6750\u6599";
            ArrayList<CommonProxy.V3> back = this.theStore.getSpecialBlocks(0);
            SimukraftReloaded.log.info(back.get(0).toString());
            ArrayList<IInventory> backstoreChests = JobBurgersManager.inventoriesFindClosest(back.get(0), 3);
            SimukraftReloaded.log.info(backstoreChests.get(0).toString());
            boolean ok = this.inventoriesTransferFromFolk(this.theFolk.inventory, backstoreChests, null);
            if (!ok) {
                SimukraftReloaded.sendChat(this.theFolk.name + "\uff1a\u5feb\u9910\u5e97\u53a8\u623f\u91cc\u7684\u7bb1\u5b50\u6ee1\u4e86\uff01");
            }
            for (int i = 0; i < backstoreChests.get(0).func_70302_i_(); ++i) {
                ItemStack chest = backstoreChests.get(0).func_70301_a(i);
                if (backstoreChests.get(0).func_70301_a(i) != null) {
                    if (chest.func_77973_b() == Items.field_151082_bd && chest.field_77994_a < 64 - this.beefCount) {
                        backstoreChests.get(0).func_70299_a(i, new ItemStack(Items.field_151082_bd, chest.field_77994_a + this.beefCount));
                        this.placedBeef = true;
                        this.beefCount = 0;
                    }
                    if (chest.func_77973_b() == Items.field_151025_P && chest.field_77994_a < 64 - this.breadCount) {
                        backstoreChests.get(0).func_70299_a(i, new ItemStack(Items.field_151025_P, chest.field_77994_a + this.breadCount));
                        this.placedBread = true;
                        this.breadCount = 0;
                    }
                    if (chest.func_77973_b() == SimukraftReloadedItems.itemFood && chest.field_77994_a < 64 - this.cheeseCount) {
                        backstoreChests.get(0).func_70299_a(i, new ItemStack(SimukraftReloadedItems.itemFood, chest.field_77994_a + this.cheeseCount, 0));
                        this.placedCheese = true;
                        this.cheeseCount = 0;
                    }
                    if (chest.func_77973_b() == Items.field_151174_bG && chest.field_77994_a < 64 - this.potatoCount) {
                        backstoreChests.get(0).func_70299_a(i, new ItemStack(Items.field_151174_bG, chest.field_77994_a + this.potatoCount));
                        this.placedPotato = true;
                        this.potatoCount = 0;
                    }
                }
                if (backstoreChests.get(0).func_70301_a(i) != null) continue;
                if (!this.placedBeef && this.beefCount > 0) {
                    backstoreChests.get(0).func_70299_a(i, new ItemStack(Items.field_151082_bd, this.beefCount));
                    this.placedBeef = true;
                    this.beefCount = 0;
                    return;
                }
                if (!this.placedBread && this.breadCount > 0) {
                    backstoreChests.get(0).func_70299_a(i, new ItemStack(Items.field_151025_P, this.breadCount));
                    this.placedBread = true;
                    this.breadCount = 0;
                    return;
                }
                if (!this.placedCheese && this.cheeseCount > 0) {
                    backstoreChests.get(0).func_70299_a(i, new ItemStack(SimukraftReloadedItems.itemFood, this.cheeseCount, 0));
                    this.placedCheese = true;
                    this.cheeseCount = 0;
                    return;
                }
                if (this.placedPotato || this.potatoCount <= 0) continue;
                backstoreChests.get(0).func_70299_a(i, new ItemStack(Items.field_151174_bG, this.potatoCount));
                this.placedPotato = true;
                this.potatoCount = 0;
                return;
            }
            this.theStage = Stage.HANGINGOUT;
            this.step = 0;
            SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 2.45);
        }
    }

    private void stageHangingOut() {
        if (this.step % 2 == 0) {
            this.theFolk.gotoXYZ(this.theStore.primaryXYZ, FolkData.GotoMethod.WALK);
        } else {
            this.theFolk.gotoXYZ(this.theStore.getSpecialBlocks(0).get(0), FolkData.GotoMethod.WALK);
        }
        String say = "";
        switch (this.step) {
            case 0: {
                say = "\u8ba1\u7b97\u4eca\u5929\u7684\u6536\u5165";
                break;
            }
            case 1: {
                say = "\u53d6\u6d88\u5458\u5de5\u4f11\u5047";
                break;
            }
            case 2: {
                say = "\u975e\u5e38\u9738\u9053";
                break;
            }
            case 3: {
                say = "\u7b97\u6211\u7684\u7a0e\u6536";
                break;
            }
            case 4: {
                say = "\u5458\u5de5\u57f9\u8bad";
                break;
            }
            case 5: {
                say = "\u964d\u4f4e\u5458\u5de5\u7684\u5de5\u8d44";
                break;
            }
            case 6: {
                say = "\u8c03\u6574\u83dc\u5355\u5b57\u4f53";
            }
        }
        ++this.step;
        if (this.step > 6) {
            this.step = 0;
        }
        this.theFolk.statusText = say;
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u62b5\u8fbe\u5546\u5e97";
            this.theStage = Stage.ARRIVEDATSTORE;
            ArrayList<CommonProxy.V3> back = this.theStore.getSpecialBlocks(0);
            if (!back.isEmpty()) {
                this.theFolk.gotoXYZ(back.get(0), null);
            }
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATSTORE,
        PICKUPBAKERY,
        PICKUPGROCERY,
        PICKUPCHEESE,
        PICKUPBUTCHERS,
        DROPOFF,
        HANGINGOUT;

    }
}

