/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedItems;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.util.ArrayList;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class JobBurgersFryCook
extends Job {
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public int runDelay = 1000;
    private long timeSinceLastRun = 0L;
    private Building theStore = null;
    private ItemStack isMakeFood = null;
    private int tryMeta = 3;

    public JobBurgersFryCook(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.theStore == null) {
            this.theStore = Building.getBuilding(this.theFolk.employedAt);
        }
        if (this.theStore == null) {
            return;
        }
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.ARRIVEDATSTORE) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.runDelay = 11000;
        } else {
            this.runDelay = this.theStage == Stage.NOINGREDIANTS ? 30000 : (this.theStage == Stage.MAKEFOOD ? 15000 : 5000);
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATSTORE) {
                this.theStage = Stage.MAKEFOOD;
            } else if (this.theStage == Stage.MAKEFOOD) {
                this.stageMakeFood();
            } else if (this.theStage == Stage.NOINGREDIANTS) {
                this.stageNoIngrediants();
            }
        }
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
    }

    private void stageNoIngrediants() {
        this.theFolk.statusText = "\u56e0\u4e3a\u6ca1\u6709\u98df\u6750\u5bfc\u81f4\u6211\u65e0\u6cd5\u70f9\u996a\u54df!";
        this.theStage = Stage.MAKEFOOD;
        this.step = 1;
    }

    private void stageMakeFood() {
        ArrayList<CommonProxy.V3> ch = this.theStore.getSpecialBlocks(0);
        if (ch.isEmpty()) {
            this.theStage = Stage.NOINGREDIANTS;
            return;
        }
        ArrayList<IInventory> chestsIn = JobBurgersFryCook.inventoriesFindClosest(ch.get(0), 3);
        if (chestsIn.isEmpty()) {
            this.theStage = Stage.NOINGREDIANTS;
            return;
        }
        ArrayList<CommonProxy.V3> ch2 = this.theStore.getSpecialBlocks(2);
        if (ch.isEmpty()) {
            this.theStage = Stage.NOINGREDIANTS;
            return;
        }
        ArrayList<IInventory> chestsOut = JobBurgersFryCook.inventoriesFindClosest(ch2.get(0), 3);
        if (chestsIn.isEmpty()) {
            this.theStage = Stage.NOINGREDIANTS;
            return;
        }
        ArrayList<CommonProxy.V3> back = this.theStore.getSpecialBlocks(1);
        if (!back.isEmpty()) {
            this.theFolk.gotoXYZ(back.get(0), null);
            try {
                this.theFolk.destination.destinationAcc = 0.3;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.step == 1) {
            if (this.tryMeta == 3) {
                int c = this.getItemCountInChests(chestsIn, new ItemStack(SimukraftReloadedItems.itemFood, 1, 0), true);
                if (c == 0) {
                    this.tryMeta = 1;
                    return;
                }
                c = this.getItemCountInChests(chestsIn, new ItemStack(Items.field_151082_bd, 1), false);
                if (c == 0) {
                    this.tryMeta = 2;
                    return;
                }
                c = this.getItemCountInChests(chestsIn, new ItemStack(Items.field_151025_P, 1), false);
                if (c == 0) {
                    this.tryMeta = 2;
                    return;
                }
                this.isMakeFood = new ItemStack(SimukraftReloadedItems.itemFood, 1, 3);
                this.step = 2;
                this.theFolk.statusText = "\u70f9\u996a\u4e00\u4efd\u829d\u58eb\u6c49\u5821";
            } else if (this.tryMeta == 1) {
                int c = this.getItemCountInChests(chestsIn, new ItemStack(Items.field_151082_bd, 1), false);
                if (c == 0) {
                    this.tryMeta = 2;
                    return;
                }
                c = this.getItemCountInChests(chestsIn, new ItemStack(Items.field_151025_P, 1), false);
                if (c == 0) {
                    this.tryMeta = 2;
                    return;
                }
                this.isMakeFood = new ItemStack(SimukraftReloadedItems.itemFood, 1, 1);
                this.step = 2;
                this.theFolk.statusText = "\u70f9\u996a\u4e00\u4efd\u7f8e\u5473\u6c49\u5821";
            } else if (this.tryMeta == 2) {
                int c = this.getItemCountInChests(chestsIn, new ItemStack(Items.field_151174_bG), false);
                if (c == 0) {
                    this.tryMeta = 3;
                    return;
                }
                this.isMakeFood = new ItemStack(SimukraftReloadedItems.itemFood, 1, 2);
                this.step = 2;
                this.theFolk.statusText = "\u70f9\u996a\u4e00\u4efd\u85af\u6761";
            }
            if (this.step == 1) {
                this.theStage = Stage.NOINGREDIANTS;
            } else {
                this.theFolk.isWorking = true;
            }
        } else if (this.step == 2) {
            if (this.isMakeFood.func_77960_j() == 3) {
                JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(SimukraftReloadedItems.itemFood, 1, 0), false, true);
                JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(Items.field_151025_P, 1), false, false);
                JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(Items.field_151082_bd, 1), false, false);
                this.tryMeta = 1;
            } else if (this.isMakeFood.func_77960_j() == 1) {
                JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(Items.field_151025_P, 1), false, false);
                JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(Items.field_151082_bd, 1), false, false);
                this.tryMeta = 2;
            } else if (this.isMakeFood.func_77960_j() == 2) {
                JobBurgersFryCook.inventoriesGet(chestsIn, new ItemStack(Items.field_151174_bG, 1), false, false);
                this.tryMeta = 3;
            }
            this.inventoriesPut(chestsOut, this.isMakeFood, true);
            this.theFolk.isWorking = false;
            this.step = 1;
            this.theFolk.statusText = "\u68c0\u67e5\u98df\u6750";
            SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.45);
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u62b5\u8fbe\u5546\u5e97";
            this.theStage = Stage.ARRIVEDATSTORE;
            ArrayList<CommonProxy.V3> back = this.theStore.getSpecialBlocks(1);
            if (!back.isEmpty()) {
                this.theFolk.gotoXYZ(back.get(0), null);
                this.step = 1;
            }
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATSTORE,
        MAKEFOOD,
        NOINGREDIANTS;

    }
}

