/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import java.io.Serializable;

public class JobBuildersMerchant
extends Job
implements Serializable {
    private static final long serialVersionUID = 1177112214324279141L;
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;

    public JobBuildersMerchant() {
    }

    public JobBuildersMerchant(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.INSTORE) {
            this.runDelay = 10000;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (!(this.theStage == Stage.IDLE && SimukraftReloaded.isDayTime() || this.theStage != Stage.INSTORE)) {
            this.theFolk.statusText = "\u4e3a\u987e\u5ba2\u670d\u52a1\u4e2d";
            this.theFolk.updateLocationFromEntity();
            double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist > 5.0 && this.theFolk.destination == null) {
                this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            }
            if (dist <= 5.0) {
                this.theFolk.stayPut = true;
            }
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        this.theFolk.updateLocationFromEntity();
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u62b5\u8fbe\u5546\u5e97";
            this.theStage = Stage.INSTORE;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum Stage {
        IDLE,
        INSTORE;

    }
}

