/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.ModSimukraft;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.game.GameMode;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedBlocks;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedConfig;
import ashjack.simukraftreloaded.entity.EntityConBox;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class JobBuilder
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177665807904279141L;
    public Stage theStage;
    public FolkData theFolk = null;
    public Job.Vocation vocation = null;
    public int runDelay = 1000;
    public long timeSinceLastRun = 0L;
    private transient ArrayList<IInventory> constructorChests = new ArrayList();
    private transient Building theBuilding = null;
    private transient EntityConBox theConBox = null;
    private transient long lastNotifiedOfMaterials = 0L;
    private transient long soundLastPlayed = 0L;
    int l = 0;
    int ftb = 0;
    int ltr = 0;
    int xo = 0;
    int zo = 0;
    int acount = 0;
    int cx;
    int cy;
    int cz;
    int ex;
    int ey;
    int ez;
    int bx = 0;
    int by = 0;
    int bz = 0;

    public JobBuilder() {
    }

    public JobBuilder(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
        this.theBuilding = this.theFolk.theBuilding;
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    @Override
    public void onUpdate() {
        if (this.theFolk == null) {
            return;
        }
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.WAITINGFORRESOURCES) {
            this.runDelay = 3000;
            if (this.theBuilding != null) {
                // empty if block
            }
        }
        if (this.theStage == Stage.INPROGRESS && this.step == 1) {
            this.runDelay = (int)(2000.0f / this.theFolk.levelBuilder);
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theFolk.theirJob != null && this.theFolk.vocation != Job.Vocation.BUILDER) {
            this.theFolk.selfFire();
            return;
        }
        this.theFolk.updateLocationFromEntity();
        int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 3 && this.theStage == Stage.WORKERASSIGNED) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.statusText = "Arrived at work";
            this.theStage = Stage.BLUEPRINT;
        }
        if (dist < 10 && this.theStage == Stage.WORKERASSIGNED && this.theFolk.destination == null) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.statusText = "Arrived at work";
            this.theStage = Stage.BLUEPRINT;
        }
        if ((this.theStage == Stage.IDLE || this.theStage == Stage.WORKERASSIGNED) && SimukraftReloaded.isDayTime()) {
            if (this.theFolk.action != FolkData.FolkAction.ONWAYTOWORK) {
                this.theStage = Stage.WORKERASSIGNED;
            }
        } else if (this.theStage != Stage.WORKERASSIGNED) {
            if (this.theStage == Stage.BLUEPRINT) {
                this.stageBlueprint();
            } else if (this.theStage == Stage.WAITINGFORRESOURCES) {
                this.stageWaitingForResources();
            } else if (this.theStage == Stage.INPROGRESS) {
                this.stageInProgress();
            } else if (this.theStage == Stage.COMPLETE) {
                this.stageComplete();
            }
        }
    }

    private void stageBlueprint() {
        this.theBuilding = this.theFolk.theBuilding;
        if (this.theBuilding == null) {
            this.theFolk.statusText = "\u8bf7\u60a8\u9009\u62e9\u8981\u6211\u5efa\u9020\u7684\u5efa\u7b51";
        } else {
            this.theFolk.statusText = "\u7ffb\u7ffb\u84dd\u56fe......";
            this.theFolk.updateLocationFromEntity();
            double dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist < 4.0) {
                this.theFolk.stayPut = true;
            }
            if (SimukraftReloadedConfig.configFolkTalking) {
                if (this.theFolk.gender == 0) {
                    this.jobWorld.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "ashjacksimukraftreloaded:readym", 1.0f, 1.0f, false);
                } else {
                    this.jobWorld.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "ashjacksimukraftreloaded:readyf", 1.0f, 1.0f, false);
                }
            }
            this.theStage = Stage.WAITINGFORRESOURCES;
            this.step = 1;
            if (this.theConBox == null) {
                WorldServer world = MinecraftServer.func_71276_C().func_71218_a(this.theFolk.location.theDimension);
                this.theConBox = new EntityConBox((World)world);
                this.theConBox.theFolk = this.theFolk;
                this.theConBox.func_70012_b(this.theFolk.employedAt.x + 2.0, this.theFolk.employedAt.y, this.theFolk.employedAt.z, 0.0f, 0.0f);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)this.theConBox);
                }
            }
        }
    }

    private void stageWaitingForResources() {
        this.theFolk.isWorking = false;
        if (this.step == 1) {
            this.theFolk.statusText = "\u68c0\u67e5\u5efa\u8bbe\u8d44\u6e90...";
            this.constructorChests = JobBuilder.inventoriesFindClosest(this.theFolk.employedAt, 5);
            if (this.constructorChests.size() == 0) {
                this.theFolk.statusText = "\u81f3\u5c11\u9644\u8fd1\u6709\u4e00\u4e2a\u7bb1\u5b50/\u5b58\u50a8\u65b9\u5757\u3002";
            } else {
                try {
                    this.constructorChests.get(0).func_70295_k_();
                }
                catch (Exception e) {
                    SimukraftReloaded.log.info("JobBuilder:JobBuilder's chest was null");
                }
                this.step = 2;
            }
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist < 5) {
                this.theFolk.stayPut = true;
            }
        } else if (this.step == 2) {
            this.constructorChests.get(0).func_70305_f();
            this.theStage = Stage.INPROGRESS;
            this.step = 1;
        } else if (this.step == 3) {
            if (this.theFolk.vocation == Job.Vocation.BUILDER) {
                int dist;
                this.step = 2;
                this.theStage = Stage.INPROGRESS;
                if (this.theFolk.isSpawned()) {
                    this.theFolk.updateLocationFromEntity();
                }
                if ((dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt)) < 5) {
                    this.theFolk.stayPut = true;
                } else {
                    this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                }
            } else {
                this.theFolk.selfFire();
                return;
            }
        }
    }

    private void stageInProgress() {
        Block blockId = null;
        boolean alreadyPlaced = false;
        this.theFolk.updateLocationFromEntity();
        int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist > 5 && this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            return;
        }
        if (this.step == 1) {
            this.cx = this.theFolk.employedAt.x.intValue();
            this.cy = this.theFolk.employedAt.y.intValue();
            this.cz = this.theFolk.employedAt.z.intValue();
            this.ex = this.theFolk.employedAt.x.intValue();
            this.ey = this.theFolk.employedAt.y.intValue();
            this.ez = this.theFolk.employedAt.z.intValue();
            this.bx = this.ex;
            this.by = this.ey;
            this.bz = this.ez;
            if (this.theBuilding.buildDirection.contentEquals("-x")) {
                this.bx = this.cx + 1;
            } else if (this.theBuilding.buildDirection.contentEquals("+x")) {
                this.bx = this.cx - 1;
            } else if (this.theBuilding.buildDirection.contentEquals("-z")) {
                this.bz = this.cz + 1;
            } else if (this.theBuilding.buildDirection.contentEquals("+z")) {
                this.bz = this.cz - 1;
            } else {
                SimukraftReloaded.sendChat("\u4e0d\u80fd\u786e\u5b9a\u5efa\u9020\u7684\u65b9\u5411\uff0c\u5f53\u4f60\u53f3\u952e\u70b9\u51fb\u5b83\u65f6\u8bf7\u7ad9\u5728\u6784\u9020\u7684\u56db\u8fb9\u4e4b\u4e00");
                this.theFolk.selfFire();
                return;
            }
            SimukraftReloaded.sendChat(this.theFolk.name + " \u5f00\u59cb\u5efa\u9020" + this.theBuilding.displayNameWithoutPK);
            this.theFolk.statusText = "\u5efa\u9020\u4e2d" + this.theBuilding.displayNameWithoutPK;
            if (this.theBuilding == null || this.theBuilding.layerCount == 0) {
                SimukraftReloaded.sendChat(this.theFolk.name + " \u5efa\u7b51\u56fe\u7eb8\u9519\u8bef\uff0c\u5220\u9664\u4e2d\uff0c\u8bf7\u5c1d\u8bd5\u5176\u4ed6\u5efa\u7b51");
                return;
            }
            this.theFolk.stayPut = true;
            if (this.theBuilding == null) {
                this.theFolk.selfFire();
                return;
            }
            this.l = 0;
            this.ftb = 0;
            this.ltr = 0;
            this.acount = 0;
            this.step = 2;
            this.theBuilding.blockLocations.clear();
        } else if (this.step == 2) {
            do {
                block74: {
                    this.theFolk.statusText = "\u5efa\u9020\u4e2d" + this.theBuilding.displayNameWithoutPK;
                    if (this.theBuilding.buildDirection.contentEquals("+z")) {
                        this.xo = this.ltr;
                        this.zo = -this.ftb;
                    } else if (this.theBuilding.buildDirection.contentEquals("-z")) {
                        this.xo = -this.ltr;
                        this.zo = this.ftb;
                    } else if (this.theBuilding.buildDirection.contentEquals("+x")) {
                        this.xo = -this.ftb;
                        this.zo = -this.ltr;
                    } else if (this.theBuilding.buildDirection.contentEquals("-x")) {
                        this.xo = this.ftb;
                        this.zo = this.ltr;
                    }
                    if (this.theBuilding == null) {
                        this.theFolk.selfFire();
                        return;
                    }
                    String[] bl = null;
                    try {
                        bl = this.theBuilding.structure[this.acount].split(":");
                    }
                    catch (Exception e) {
                        SimukraftReloaded.log.warning("JobBuilder: NULL block in building, using Air instead");
                        bl = "0:0".split(":");
                    }
                    blockId = Block.func_149684_b((String)bl[0]);
                    int subtype = Integer.parseInt(bl[1]);
                    if (blockId == Blocks.field_150349_c) {
                        blockId = Blocks.field_150346_d;
                    }
                    if (this.theBuilding.type.contentEquals("other") && this.acount == 0) {
                        blockId = SimukraftReloadedBlocks.controlBox;
                        subtype = 2;
                    }
                    if (blockId == SimukraftReloadedBlocks.controlBox) {
                        try {
                            this.theBuilding.primaryXYZ = new CommonProxy.V3(Double.valueOf(this.bx + this.xo), Double.valueOf(this.by + this.l), Double.valueOf(this.bz + this.zo), this.theFolk.employedAt.theDimension);
                            this.theBuilding.saveThisBuilding();
                        }
                        catch (Exception e) {
                            SimukraftReloaded.log.info("JobBuilder:build is null");
                        }
                    }
                    if (blockId == SimukraftReloadedBlocks.livingBlock && this.theBuilding.type == "residential") {
                        this.theBuilding.livingXYZ = new CommonProxy.V3(Double.valueOf(this.bx + this.xo), Double.valueOf(this.by + this.l), Double.valueOf(this.bz + this.zo), this.theFolk.employedAt.theDimension);
                        blockId = null;
                        subtype = 0;
                    } else if (blockId == SimukraftReloadedBlocks.specialBlock && this.theBuilding.type != "residential") {
                        CommonProxy.V3 v3 = new CommonProxy.V3(Double.valueOf(this.bx + this.xo), Double.valueOf(this.by + this.l), Double.valueOf(this.bz + this.zo), this.theFolk.employedAt.theDimension);
                        v3.meta = subtype;
                        this.theBuilding.blockSpecial.add(v3);
                        blockId = null;
                        subtype = 0;
                    }
                    Block currBlockId = null;
                    int currBlockMeta = 0;
                    try {
                        currBlockId = this.jobWorld.func_147439_a(this.bx + this.xo, this.by + this.l, this.bz + this.zo);
                        currBlockMeta = this.jobWorld.func_72805_g(this.bx + this.xo, this.by + this.l, this.bz + this.zo);
                        alreadyPlaced = blockId == currBlockId || blockId == Blocks.field_150346_d && currBlockId == Blocks.field_150349_c || blockId == Blocks.field_150349_c && currBlockId == Blocks.field_150346_d;
                    }
                    catch (Exception e) {
                        this.theFolk.selfFire();
                        return;
                    }
                    String want = "???";
                    ItemStack wantIS = new ItemStack(blockId, 1, 0);
                    if (wantIS != null && wantIS != null) {
                        try {
                            want = wantIS.func_82833_r();
                            if (blockId != null) {
                                this.theBuilding.blockLocations.add(new CommonProxy.V3(this.bx + this.xo, this.by + this.l, this.bz + this.zo, this.theFolk.location.theDimension));
                            }
                        }
                        catch (Exception e) {
                            want = "?";
                            SimukraftReloaded.log.info("JobBuilder:wantItemStack nulled out, wantIS was null, blockID=" + blockId);
                        }
                    } else {
                        want = "???";
                    }
                    if (!alreadyPlaced && currBlockId != null) {
                        CommonProxy.V3 blockToRemove = new CommonProxy.V3(this.bx + this.xo, this.by + this.l, this.bz + this.zo);
                        this.constructorChests = JobBuilder.inventoriesFindClosest(this.theFolk.employedAt, 5);
                        this.mineBlockIntoChests(this.constructorChests, blockToRemove);
                        this.jobWorld.func_147465_d(this.bx + this.xo, this.by + this.l, this.bz + this.zo, Blocks.field_150350_a, 0, 3);
                        this.theFolk.isWorking = true;
                    }
                    if (!alreadyPlaced) {
                        boolean requiredBlocks;
                        boolean gotBlock = false;
                        boolean bl2 = requiredBlocks = blockId == Blocks.field_150344_f || blockId == Blocks.field_150347_e || blockId == Blocks.field_150359_w || blockId == Blocks.field_150325_L || blockId == Blocks.field_150336_V || blockId == Blocks.field_150346_d || blockId == Blocks.field_150417_aV || blockId == Blocks.field_150422_aJ || blockId == Blocks.field_150348_b || blockId == Blocks.field_150364_r;
                        if (GameMode.gameMode == GameMode.GAMEMODES.NORMAL) {
                            if (requiredBlocks) {
                                this.constructorChests = JobBuilder.inventoriesFindClosest(this.theFolk.employedAt, 5);
                                ItemStack got = JobBuilder.inventoriesGet(this.constructorChests, new ItemStack(blockId, 1, 0), false, false);
                                gotBlock = got != null;
                            } else {
                                gotBlock = true;
                            }
                        } else if (GameMode.gameMode == GameMode.GAMEMODES.CREATIVE) {
                            gotBlock = true;
                        } else if (GameMode.gameMode == GameMode.GAMEMODES.HARDCORE) {
                            if (blockId != null) {
                                if (blockId == Blocks.field_150349_c || blockId == Blocks.field_150355_j || blockId == Blocks.field_150355_j || blockId == Blocks.field_150353_l || blockId == Blocks.field_150353_l || blockId == Blocks.field_150444_as || blockId == Blocks.field_150414_aQ || blockId == Blocks.field_150333_U || blockId == Blocks.field_150376_bx || blockId == Blocks.field_150373_bw || blockId == Blocks.field_150334_T || blockId == Blocks.field_150458_ak || blockId == Blocks.field_150466_ao || blockId == Blocks.field_150454_av || blockId == Blocks.field_150324_C) {
                                    gotBlock = true;
                                } else {
                                    this.constructorChests = JobBuilder.inventoriesFindClosest(this.theFolk.employedAt, 5);
                                    ItemStack got = JobBuilder.inventoriesGet(this.constructorChests, new ItemStack(blockId, 1, 0), false, false);
                                    gotBlock = got != null;
                                    if (blockId == SimukraftReloadedBlocks.controlBox) {
                                        gotBlock = true;
                                    }
                                }
                            } else {
                                gotBlock = true;
                            }
                        }
                        if (!gotBlock) {
                            this.theStage = Stage.WAITINGFORRESOURCES;
                            if (want.toLowerCase().contentEquals("oak wood planks")) {
                                want = "Planks";
                            }
                            if (want.toLowerCase().contentEquals("oak wood")) {
                                want = "Logs";
                            }
                            this.theFolk.statusText = "\u7b49\u5f85" + want;
                            if (System.currentTimeMillis() - this.lastNotifiedOfMaterials > (long)(SimukraftReloadedConfig.configMaterialReminderInterval * 60 * 1000)) {
                                this.lastNotifiedOfMaterials = System.currentTimeMillis();
                                SimukraftReloaded.sendChat(this.theFolk.name + " (\u8c01\u5728\u5efa\u9020" + this.theFolk.theBuilding.displayNameWithoutPK + ") \u9700\u8981\u66f4\u591a\u7684" + want);
                            }
                            this.step = 3;
                            return;
                        }
                        try {
                            if (alreadyPlaced) break block74;
                            try {
                                int aft;
                                if (blockId == SimukraftReloadedBlocks.controlBox || blockId == SimukraftReloadedBlocks.controlBox) {
                                    blockId = SimukraftReloadedBlocks.controlBox;
                                }
                                if (blockId == SimukraftReloadedBlocks.controlBox && this.theBuilding.displayNameWithoutPK.toLowerCase().contentEquals("sim-u-bank")) {
                                    subtype = 1;
                                }
                                this.theFolk.stayPut = true;
                                this.jobWorld.func_147465_d(this.bx + this.xo, this.by + this.l, this.bz + this.zo, blockId, subtype, 3);
                                this.jobWorld.func_147471_g(this.bx + this.xo, this.by + this.l, this.bz + this.zo);
                                int b4 = (int)Math.floor(this.theFolk.levelBuilder);
                                if (this.theFolk.levelBuilder < 10.0f) {
                                    this.theFolk.levelBuilder = (float)((double)this.theFolk.levelBuilder + 0.001 / (double)b4);
                                }
                                if (b4 != (aft = (int)Math.floor(this.theFolk.levelBuilder))) {
                                    SimukraftReloaded.sendChat(this.theFolk.name + " \u5efa\u7b51\u5e08\u7b49\u7ea7\u63d0\u5347\u4e86" + aft);
                                }
                                if (this.mc.field_71441_e.field_72995_K) {
                                    this.mc.field_71441_e.func_72869_a("explode", (double)(this.bx + this.xo), (double)(this.by + this.l), (double)(this.bz + this.zo), 0.0, (double)0.3f, 0.0);
                                    this.mc.field_71441_e.func_72869_a("explode", (double)(this.bx + this.xo), (double)(this.by + this.l), (double)(this.bz + this.zo), 0.0, (double)0.2f, 0.0);
                                    this.mc.field_71441_e.func_72869_a("explode", (double)(this.bx + this.xo), (double)(this.by + this.l), (double)(this.bz + this.zo), 0.0, (double)0.1f, 0.0);
                                }
                                if (blockId != null && GameMode.gameMode != GameMode.GAMEMODES.CREATIVE) {
                                    SimukraftReloaded.states.credits -= 0.02f;
                                }
                            }
                            catch (Exception e) {
                                SimukraftReloaded.log.warning("JobBuilder: Possible non-existant block (from other mod) ID=" + blockId);
                                try {
                                    this.jobWorld.func_147465_d(this.bx + this.xo, this.by + this.l, this.bz + this.zo, blockId, 0, 3);
                                }
                                catch (Exception e2) {
                                    e2.printStackTrace();
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++this.acount;
                ++this.ltr;
                if (this.ltr == this.theBuilding.ltrCount) {
                    this.ltr = 0;
                    ++this.ftb;
                    if (this.ftb == this.theBuilding.ftbCount) {
                        this.ftb = 0;
                        ++this.l;
                        if (this.l == this.theBuilding.layerCount) {
                            this.theStage = Stage.COMPLETE;
                            this.stageComplete();
                            return;
                        }
                    }
                }
                this.runDelay = blockId == null || alreadyPlaced ? 0 : (GameMode.gameMode == GameMode.GAMEMODES.CREATIVE ? 0 : (int)(2000.0f / this.theFolk.levelBuilder));
                if (this.theFolk.theEntity == null) continue;
                this.theFolk.theEntity.func_71038_i();
            } while (blockId == null || alreadyPlaced);
        }
    }

    private void stageComplete() {
        this.theFolk.isWorking = false;
        if (this.theBuilding != null) {
            if (this.theBuilding.buildingComplete) {
                // empty if block
            }
            if (this.theBuilding != null) {
                this.theBuilding.buildingComplete = true;
                SimukraftReloaded.sendChat(this.theFolk.name + " \u5df2\u5b8c\u6210\u5efa\u8bbe" + this.theBuilding.displayNameWithoutPK);
                ModSimukraft.proxy.getClientWorld().func_72980_b(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v, "ashjacksimukraftreloaded:cash", 1.0f, 1.0f, false);
                this.theBuilding.saveThisBuilding();
                this.theFolk.theBuilding = null;
            } else {
                SimukraftReloaded.sendChat("\u9519\u8bef\uff1a\u65e0\u6cd5\u8bbe\u7f6e\u5efa\u7b51" + this.theFolk.name + " \u5728\u5efa\u9020\u4e2d" + "\u53bb'\u5b8c\u6210', \u8bd5\u56fe\u91cd\u5efa\u7684\u65f6\u5019\u4e86(\u6ca1\u6709\u91d1\u989d)\u518d\u6b21\u5c1d\u8bd5");
            }
        }
        if (this.theFolk.theEntity != null) {
            this.theFolk.theEntity.func_70095_a(false);
        }
        this.theFolk.stayPut = false;
        this.theFolk.selfFire();
        this.theStage = Stage.IDLE;
        boolean activeBuilders = false;
        for (int f = 0; f < SimukraftReloaded.theFolks.size(); ++f) {
            FolkData fd = SimukraftReloaded.theFolks.get(f);
            if (fd.vocation != Job.Vocation.BUILDER) continue;
            activeBuilders = true;
        }
        if (!activeBuilders) {
            for (int b = 0; b < SimukraftReloaded.theBuildings.size(); ++b) {
                Building building = SimukraftReloaded.theBuildings.get(b);
                building.buildingComplete = true;
            }
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u62b5\u8fbe\u73b0\u573a";
            this.theStage = Stage.BLUEPRINT;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum Stage {
        IDLE,
        WORKERASSIGNED,
        BLUEPRINT,
        WAITINGFORRESOURCES,
        INPROGRESS,
        COMPLETE;


        public String toString() {
            String ret = "";
            if (this == IDLE) {
                ret = "\u95f2\u7f6e";
            } else if (this == WORKERASSIGNED) {
                ret = "\u5efa\u7b51\u5e08\u5df2\u53d7\u8058\u5728\u8def\u4e0a";
            } else if (this == BLUEPRINT) {
                ret = "\u5efa\u7b51\u5e08\u6b63\u5728\u67e5\u770b\u8bbe\u8ba1\u56fe";
            } else if (this == WAITINGFORRESOURCES) {
                ret = "\u5efa\u7b51\u5e08\u6b63\u5728\u68c0\u67e5\u5efa\u7b51\u8d44\u6e90";
            } else if (this == INPROGRESS) {
                ret = "\u5efa\u7b51\u5e08\u6b63\u5728\u5efa\u9020\u4e2d";
            } else if (this == COMPLETE) {
                ret = "\u5efa\u9020\u5b8c\u6210";
            }
            return ret;
        }
    }
}

