/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class JobBrickMaker
extends Job
implements Serializable {
    private static final long serialVersionUID = 1177111222904279141L;
    public Job.Vocation vocation = null;
    public FolkData theFolk = null;
    public Stage theStage;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient CommonProxy.V3 blockOfClay = null;
    private transient ArrayList<IInventory> factoryChests = new ArrayList();
    private transient TileEntityFurnace factoryFurnace = null;
    private long lastGotocmd = 0L;
    private int gotoCount = 0;

    public JobBrickMaker() {
    }

    public JobBrickMaker(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.IDLE) {
            this.runDelay = 2000;
            this.theStage = Stage.SCANFORCLAY;
            return;
        }
        this.runDelay = this.theStage == Stage.COLLECTCLAY || this.theStage == Stage.GOTOCLAYBLOCK || this.theStage == Stage.SCANFORCLAY ? 250 : 2000;
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.factoryFurnace == null) {
            this.factoryFurnace = this.findFurnace(this.theFolk.employedAt);
        }
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.SCANFORCLAY) {
                this.stageScanForClay();
            } else if (this.theStage == Stage.GOTOCLAYBLOCK) {
                this.stageGotoClayBlock();
            } else if (this.theStage == Stage.COLLECTCLAY) {
                this.stageCollectClay();
            } else if (this.theStage == Stage.RETURNCLAY) {
                this.stageReturnClay();
            } else if (this.theStage == Stage.USEFURNACE) {
                this.stageUseFurnace();
            } else if (this.theStage == Stage.CANTWORK) {
                this.stageCantWork();
            }
        }
    }

    private void stageCantWork() {
        this.theFolk.statusText = "\u8fd9\u9644\u8fd1\u6709\u6ca1\u6709\u7c98\u571f\uff1f";
    }

    private void stageScanForClay() {
        if (this.theFolk.statusText.contains("\u5230\u8fbe") || this.theFolk.statusText.contains("brick")) {
            this.theFolk.statusText = "\u53bb\u6316\u6398\u4e00\u4e9b\u7c98\u571f";
        }
        try {
            this.blockOfClay = JobBrickMaker.findClosestBlockType(this.theFolk.employedAt, Blocks.field_150435_aG, 80, true);
            if (this.blockOfClay == null) {
                this.theStage = Stage.USEFURNACE;
                return;
            }
            this.theStage = Stage.GOTOCLAYBLOCK;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageGotoClayBlock() {
        try {
            if (this.theFolk.theEntity != null) {
                this.theFolk.theEntity.field_70733_aJ = 0.0f;
            }
            this.theFolk.updateLocationFromEntity();
            double dist = this.theFolk.location.getDistanceTo(this.blockOfClay);
            if (dist > 4.0 && System.currentTimeMillis() - this.lastGotocmd > 10000L) {
                this.theFolk.stayPut = false;
                this.theFolk.gotoXYZ(this.blockOfClay, null);
                this.theFolk.stayPut = false;
                this.lastGotocmd = System.currentTimeMillis();
            }
            this.theStage = Stage.COLLECTCLAY;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageCollectClay() {
        this.runDelay = 1000;
        this.theFolk.isWorking = true;
        this.theFolk.updateLocationFromEntity();
        double dist = this.theFolk.location.getDistanceTo(this.blockOfClay);
        if (dist > 6.0 && System.currentTimeMillis() - this.lastGotocmd > 10000L) {
            this.theFolk.gotoXYZ(this.blockOfClay, null);
            this.theFolk.stayPut = false;
            this.lastGotocmd = System.currentTimeMillis();
            ++this.gotoCount;
            if (this.gotoCount > 2) {
                CommonProxy.V3 bs;
                this.gotoCount = 0;
                CommonProxy.V3 v3 = bs = this.blockOfClay.clone();
                Double d = v3.y;
                Double d2 = v3.y = Double.valueOf(v3.y + 1.0);
                this.theFolk.beamMeTo(bs);
            }
            return;
        }
        if (dist > 6.0) {
            return;
        }
        try {
            if (dist < 6.0) {
                // empty if block
            }
            this.gotoCount = 0;
            this.jobWorld.func_147465_d(this.blockOfClay.x.intValue(), this.blockOfClay.y.intValue(), this.blockOfClay.z.intValue(), Blocks.field_150350_a, 0, 3);
            this.mc.field_71441_e.func_72980_b(this.blockOfClay.x.doubleValue(), this.blockOfClay.y.doubleValue(), this.blockOfClay.z.doubleValue(), "step.sand", 1.0f, 1.0f, false);
            this.theFolk.inventory.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150435_aG), 1));
            this.theFolk.statusText = "DIGGY DIGGY \u6211\u5f97\u5230\u7c98\u571f\u60f9" + this.theFolk.inventory.size();
            SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.012);
            if (this.theFolk.inventory.size() < 64) {
                this.theStage = Stage.SCANFORCLAY;
            } else {
                this.theStage = Stage.RETURNCLAY;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageReturnClay() {
        this.theFolk.isWorking = false;
        try {
            if (this.step == 1) {
                CommonProxy.V3 adj;
                CommonProxy.V3 v3 = adj = this.theFolk.employedAt.clone();
                Double d = v3.y;
                Double d2 = v3.y = Double.valueOf(v3.y + 1.0);
                this.theFolk.gotoXYZ(adj, null);
                this.step = 2;
            } else if (this.step == 2) {
                double dist;
                if (this.theFolk.gotoMethod == FolkData.GotoMethod.WALK) {
                    this.theFolk.updateLocationFromEntity();
                }
                if ((dist = (double)this.theFolk.location.getDistanceTo(this.theFolk.employedAt)) < 4.0) {
                    this.theFolk.stayPut = true;
                    this.step = 3;
                } else if (this.theFolk.destination == null) {
                    this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
                }
            } else if (this.step == 3) {
                this.factoryChests = JobBrickMaker.inventoriesFindClosest(this.theFolk.employedAt, 5);
                this.openCloseChest(this.factoryChests.get(0), 1000);
                boolean placed = this.inventoriesTransferFromFolk(this.theFolk.inventory, this.factoryChests, null);
                this.theStage = Stage.USEFURNACE;
                this.step = 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stageUseFurnace() {
        this.factoryFurnace = this.findFurnace(this.theFolk.employedAt);
        this.factoryChests = JobBrickMaker.inventoriesFindClosest(this.theFolk.employedAt, 5);
        if (this.factoryFurnace == null) {
            SimukraftReloaded.sendChat(this.theFolk.name + "\uff1a\u6211\u7684\u7089\u5b50\u4e0d\u89c1\u4e86\uff01");
            return;
        }
        if (this.step == 1) {
            this.theFolk.statusText = "\u68c0\u67e5\u71c3\u70e7\u7089";
            ItemStack currentFuel = this.factoryFurnace.func_70301_a(1);
            ItemStack gotFuel = null;
            if (currentFuel == null) {
                gotFuel = JobBrickMaker.inventoriesGet(this.factoryChests, new ItemStack(Items.field_151044_h, 64), false, false, new ItemStack(Items.field_151044_h, 64));
                if (gotFuel == null) {
                    gotFuel = JobBrickMaker.inventoriesGet(this.factoryChests, new ItemStack(Items.field_151129_at, 1), false, false, new ItemStack(Items.field_151129_at, 1));
                }
                if (gotFuel == null) {
                    gotFuel = JobBrickMaker.inventoriesGet(this.factoryChests, new ItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), 64), false, false, new ItemStack(Item.func_150898_a((Block)Blocks.field_150364_r), 64));
                }
                if (gotFuel == null) {
                    gotFuel = JobBrickMaker.inventoriesGet(this.factoryChests, new ItemStack(Item.func_150898_a((Block)Blocks.field_150344_f), 64), false, false, new ItemStack(Item.func_150898_a((Block)Blocks.field_150344_f), 1));
                }
                if (gotFuel == null) {
                    SimukraftReloaded.sendChat(this.theFolk.name + "\uff08\u677f\u7816\u5382\uff09\u7089\u5b50\u91cc\u6ca1\u6709\u4efb\u4f55\u71c3\u6599\uff0c\u8bf7\u6dfb\u52a0\u71c3\u6599\u8c22\u8c22\uff01");
                    this.theStage = Stage.SCANFORCLAY;
                    this.step = 1;
                    return;
                }
                this.factoryFurnace.func_70299_a(1, gotFuel);
                this.step = 2;
                return;
            }
            this.step = 2;
        } else if (this.step == 2) {
            this.theFolk.statusText = "\u6dfb\u52a0\u7c98\u571f\u5230\u7089\u5b50\u5185";
            if (this.factoryFurnace != null) {
                ItemStack currentClay = this.factoryFurnace.func_70301_a(0);
                ItemStack gotClay = null;
                if (currentClay == null) {
                    gotClay = JobBrickMaker.inventoriesGet(this.factoryChests, new ItemStack(Item.func_150898_a((Block)Blocks.field_150435_aG), 64), false, false, new ItemStack(Blocks.field_150435_aG, 64));
                    if (gotClay != null) {
                        this.factoryFurnace.func_70299_a(0, gotClay);
                    }
                    this.step = 3;
                    return;
                }
                gotClay = JobBrickMaker.inventoriesGet(this.factoryChests, new ItemStack(Item.func_150898_a((Block)Blocks.field_150435_aG), 64 - currentClay.field_77994_a), false, false, new ItemStack(Blocks.field_150435_aG, 64 - currentClay.field_77994_a));
                if (gotClay != null) {
                    currentClay.field_77994_a += gotClay.field_77994_a;
                    this.factoryFurnace.func_70299_a(0, currentClay);
                }
                this.step = 3;
                return;
            }
        } else if (this.step == 3) {
            ItemStack currentBricks = this.factoryFurnace.func_70301_a(2);
            if (currentBricks != null) {
                this.theFolk.statusText = "\u628a\u7816\u5165\u5e93";
                boolean placedOk = this.inventoriesPut(this.factoryChests, currentBricks, true);
                SimukraftReloaded.states.credits = (float)((double)SimukraftReloaded.states.credits - 0.005 * (double)currentBricks.field_77994_a);
                this.factoryFurnace.func_70299_a(2, null);
            } else {
                this.theFolk.statusText = "\u6ca1\u6709\u53d6\u5f97\u4efb\u4f55\u7248\u7816";
            }
            this.theStage = Stage.SCANFORCLAY;
        }
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u5230\u8fbe\u5de5\u5382";
            this.theStage = Stage.USEFURNACE;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum Stage {
        IDLE,
        SCANFORCLAY,
        GOTOCLAYBLOCK,
        COLLECTCLAY,
        RETURNCLAY,
        USEFURNACE,
        CANTWORK;

    }
}

