/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.blocks.functionality.FarmingBox;
import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class JobBaker
extends Job
implements Serializable {
    private static final long serialVersionUID = -1177112153304279141L;
    public Job.Vocation vocation = null;
    public Stage theStage;
    public FolkData theFolk;
    public transient int runDelay = 1000;
    public transient long timeSinceLastRun = 0L;
    private transient float pay = 0.0f;
    private transient ArrayList<IInventory> bakeryChests = null;
    private transient ArrayList<IInventory> farmChests = new ArrayList();
    private transient int currentFarmNum = 0;
    private transient FarmingBox farm = null;

    public JobBaker() {
    }

    public JobBaker(FolkData folk) {
        this.theFolk = folk;
        if (this.theStage == null) {
            this.theStage = Stage.IDLE;
        }
        if (this.theFolk == null) {
            return;
        }
        if (this.theFolk.destination == null) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    @Override
    public void resetJob() {
        this.theStage = Stage.IDLE;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!SimukraftReloaded.isDayTime()) {
            this.theStage = Stage.IDLE;
        }
        super.onUpdateGoingToWork(this.theFolk);
        if (this.theStage == Stage.ARRIVEDATSHOP) {
            this.runDelay = 10000;
        }
        if (this.theStage == Stage.COLLECTINGWHEAT) {
            this.runDelay = 1000;
        }
        if (this.theStage == Stage.SELLINGBREAD) {
            this.runDelay = 10000;
        }
        if (this.theStage == Stage.MAKEBREAD) {
            this.runDelay = 10000;
        }
        if (System.currentTimeMillis() - this.timeSinceLastRun < (long)this.runDelay) {
            return;
        }
        this.timeSinceLastRun = System.currentTimeMillis();
        if (this.theStage != Stage.IDLE || !SimukraftReloaded.isDayTime()) {
            if (this.theStage == Stage.ARRIVEDATSHOP) {
                this.theStage = Stage.GOINGTOWHEATFARM;
                this.step = 1;
            } else if (this.theStage == Stage.GOINGTOWHEATFARM) {
                this.stageGoingToWheatFarm();
            } else if (this.theStage == Stage.COLLECTINGWHEAT) {
                this.stageCollectingWheat();
            } else if (this.theStage == Stage.GOBACKTOBAKERY) {
                this.stageGoBackToBakery();
            } else if (this.theStage == Stage.MAKEBREAD) {
                this.stageMakeBread();
            } else if (this.theStage == Stage.SELLINGBREAD) {
                this.stageSellingBread();
            }
        }
    }

    private void stageGoingToWheatFarm() {
        this.theFolk.statusText = "Fetching wheat from farms";
        if (this.theFolk.destination == null && this.step == 1) {
            this.farm = this.getCurrentFarm();
            if (this.farm == null) {
                this.theStage = Stage.GOBACKTOBAKERY;
                this.step = 1;
            } else {
                this.theFolk.gotoXYZ(this.farm.getLocation(), null);
                this.runDelay = 1000;
                this.step = 2;
            }
        }
        if (this.step == 2) {
            double dist = 0.0;
            if (this.farm != null) {
                this.runDelay = 1000;
                if (this.theFolk.gotoMethod == FolkData.GotoMethod.WALK) {
                    this.theFolk.updateLocationFromEntity();
                }
                if ((dist = (double)this.theFolk.location.getDistanceTo(this.farm.getLocation())) <= 1.0) {
                    this.theStage = Stage.COLLECTINGWHEAT;
                    this.step = 1;
                    this.theFolk.stayPut = true;
                    if (this.theFolk.theEntity != null) {
                        this.theFolk.theEntity.field_70159_w = 0.0;
                        this.theFolk.theEntity.field_70179_y = 0.0;
                    }
                    this.runDelay = 1000;
                    return;
                }
            } else {
                this.theStage = Stage.GOBACKTOBAKERY;
            }
        }
    }

    private void stageCollectingWheat() {
        this.theFolk.statusText = "\u91c7\u8d2d\u5c0f\u9ea6";
        this.runDelay = 1000;
        if (this.step == 1) {
            this.farmChests = JobBaker.inventoriesFindClosest(this.farm.getLocation(), 5);
            if (this.farmChests.size() > 0) {
                this.farmChests.get(0).func_70295_k_();
                this.step = 2;
            }
        } else if (this.step == 2) {
            this.farmChests = JobBaker.inventoriesFindClosest(this.farm.getLocation(), 5);
            this.inventoriesTransferToFolk(this.theFolk.inventory, this.farmChests, new ItemStack(Items.field_151015_O, 640));
            this.step = 3;
        } else if (this.step == 3) {
            this.farmChests.get(0).func_70305_f();
            this.theStage = Stage.GOINGTOWHEATFARM;
            this.step = 1;
        }
    }

    private void stageGoBackToBakery() {
        this.theFolk.statusText = "\u91c7\u8d2d\u5c0f\u9ea6\u56de\u9762\u5305\u5e97";
        if (this.theFolk.destination == null && this.step == 1) {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
            this.runDelay = 100;
            this.step = 2;
        }
        if (this.step == 2) {
            int dist;
            if (this.theFolk.gotoMethod == FolkData.GotoMethod.WALK) {
                this.theFolk.updateLocationFromEntity();
            }
            if ((dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt)) <= 1) {
                this.theStage = Stage.MAKEBREAD;
                this.step = 1;
                this.theFolk.stayPut = true;
                return;
            }
        }
    }

    private void stageMakeBread() {
        this.theFolk.statusText = "\u70e4\u9762\u5305";
        this.bakeryChests = JobBaker.inventoriesFindClosest(this.theFolk.employedAt, 4);
        if (this.bakeryChests == null || this.bakeryChests.size() == 0) {
            this.theFolk.statusText = "\u8c01\u4ece\u4ece\u6211\u9762\u5305\u5e97\u7684\u7bb1\u5b50\u91cc\u5077\u8d70\u4e86\u9762\u5305\uff01";
            return;
        }
        if (this.step == 1) {
            this.theFolk.updateLocationFromEntity();
            int dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
            if (dist > 1) {
                this.theFolk.beamMeTo(this.theFolk.employedAt);
            }
            this.step = 2;
        } else if (this.step == 2) {
            int wheat = this.getInventoryCount(this.theFolk, Items.field_151015_O);
            int bread = (int)Math.floor(wheat / 3);
            this.pay = (float)((double)bread * 0.2);
            this.bakeryChests = JobBaker.inventoriesFindClosest(this.theFolk.employedAt, 4);
            try {
                this.bakeryChests.get(0).func_70295_k_();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inventoriesPut(this.bakeryChests, new ItemStack(Items.field_151025_P, bread), true);
            this.theFolk.inventory.clear();
            this.step = 3;
        } else if (this.step == 3) {
            this.bakeryChests.get(0).func_70305_f();
            this.theFolk.statusText = "\u5356\u9762\u5305\u7ed9\u987e\u5ba2";
            this.theFolk.stayPut = true;
            if (this.theFolk.theEntity != null) {
                if (this.theFolk.gender == 0) {
                    this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "ashjacksimukraftreloaded:bakerm", 1.0f, 1.0f, false);
                } else {
                    this.mc.field_71441_e.func_72980_b(this.theFolk.location.x.doubleValue(), this.theFolk.location.y.doubleValue(), this.theFolk.location.z.doubleValue(), "ashjacksimukraftreloaded:bakerf", 1.0f, 1.0f, false);
                }
            }
            this.theStage = Stage.SELLINGBREAD;
            this.step = 1;
        }
    }

    private void stageSellingBread() {
        if (this.step == 1) {
            if (this.pay > 0.0f) {
                SimukraftReloaded.states.credits -= this.pay;
                SimukraftReloaded.sendChat(this.theFolk.name + " \u505a\u4e86\u4e00\u4e9b\u8ba2\u8d2d\u7684\u9762\u5305" + SimukraftReloaded.displayMoney(this.pay) + " Sim-u-credits.");
                this.mc.field_71441_e.func_72980_b(this.mc.field_71439_g.field_70165_t, this.mc.field_71439_g.field_70163_u, this.mc.field_71439_g.field_70161_v, "ashjacksimukraftreloaded:cash", 1.0f, 1.0f, false);
            }
            this.step = 2;
        } else if (this.step == 2) {
            if (MinecraftServer.func_71276_C().field_71305_c[0].func_72820_D() % 24000L > 11600L) {
                this.step = 3;
            }
        } else if (this.step == 3) {
            this.theFolk.statusText = "\u5173\u5e97\u95e8";
            int sell = 0;
            ItemStack breadStack = null;
            if (SimukraftReloaded.theFolks.size() > 1) {
                sell = SimukraftReloaded.theFolks.size() + 1 + new Random().nextInt(SimukraftReloaded.theFolks.size());
                this.bakeryChests = JobBaker.inventoriesFindClosest(this.theFolk.employedAt, 4);
                breadStack = JobBaker.inventoriesGet(this.bakeryChests, new ItemStack(Items.field_151025_P, sell), false, false);
            }
            if (breadStack == null) {
                SimukraftReloaded.sendChat(this.theFolk.name + "\u4eca\u5929\u6ca1\u6709\u4efb\u4f55\u7684\u9762\u5305\u5356\uff0c\u4f60\u6709\u4e00\u4e2a\u9ad8\u4ea7\u91cf\u7684\u5c0f\u9ea6\u519c\u573a\u5417\uff1f");
            } else {
                SimukraftReloaded.sendChat(this.theFolk.name + "\u5df2\u5356\u7ed9\u987e\u5ba2" + breadStack.field_77994_a + " \u4e2a\u9762\u5305\u3002");
                for (int f = 0; f < SimukraftReloaded.theFolks.size(); ++f) {
                    FolkData folk = SimukraftReloaded.theFolks.get(f);
                    if (breadStack.field_77994_a <= 0) continue;
                    folk.levelFood = 10;
                    --breadStack.field_77994_a;
                }
            }
            this.step = 4;
        } else if (this.step == 4) {
            // empty if block
        }
    }

    private FarmingBox getCurrentFarm() {
        boolean found = false;
        while (!found) {
            try {
                FarmingBox farm = SimukraftReloaded.theFarmingBoxes.get(this.currentFarmNum);
                if (farm.farmType == FarmingBox.FarmType.WHEAT) {
                    found = true;
                    ++this.currentFarmNum;
                    return farm;
                }
                ++this.currentFarmNum;
                if (this.currentFarmNum <= SimukraftReloaded.theFarmingBoxes.size() - 1) continue;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void onArrivedAtWork() {
        int dist = 0;
        dist = this.theFolk.location.getDistanceTo(this.theFolk.employedAt);
        if (dist <= 1) {
            this.theFolk.action = FolkData.FolkAction.ATWORK;
            this.theFolk.stayPut = true;
            this.theFolk.statusText = "\u62b5\u8fbe\u9762\u5305\u5e97";
            this.theStage = Stage.ARRIVEDATSHOP;
            this.currentFarmNum = 0;
        } else {
            this.theFolk.gotoXYZ(this.theFolk.employedAt, null);
        }
    }

    public static enum Stage {
        IDLE,
        ARRIVEDATSHOP,
        GOINGTOWHEATFARM,
        COLLECTINGWHEAT,
        GOBACKTOBAKERY,
        MAKEBREAD,
        SELLINGBREAD;

    }
}

