/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common.jobs;

import ashjack.simukraftreloaded.blocks.functionality.TileEntityWindmill;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class Job {
    Minecraft mc = Minecraft.func_71410_x();
    public int step = 1;
    ArrayList<CommonProxy.V3> closestBlocks = new ArrayList();
    public Vocation vocation = null;
    public World jobWorld = null;
    private transient IInventory chestToClose = null;
    private transient Long chestToCloseWhen = 0L;

    public abstract void onArrivedAtWork();

    public abstract void resetJob();

    public void onUpdate() {
        if (this.chestToClose != null && System.currentTimeMillis() > this.chestToCloseWhen) {
            this.chestToClose.func_70305_f();
            this.chestToClose = null;
        }
    }

    public void onUpdateGoingToWork(FolkData theFolk) {
        if (this.jobWorld == null) {
            try {
                this.jobWorld = MinecraftServer.func_71276_C().func_71218_a(theFolk.employedAt.theDimension);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (theFolk.pregnancyStage > 0.0f) {
            return;
        }
        if (theFolk.action == FolkData.FolkAction.ONWAYTOWORK) {
            int dist = 0;
            if (theFolk.gotoMethod == FolkData.GotoMethod.WALK) {
                theFolk.stayPut = false;
                theFolk.updateLocationFromEntity();
            }
            if ((dist = theFolk.location.getDistanceTo(theFolk.employedAt)) <= 1) {
                theFolk.action = FolkData.FolkAction.ATWORK;
                this.onArrivedAtWork();
            } else if (dist > 1 && dist < 3) {
                CommonProxy.V3 work;
                CommonProxy.V3 v3 = work = theFolk.employedAt.clone();
                Double d = v3.y;
                Double d2 = v3.y = Double.valueOf(v3.y + 1.0);
                theFolk.gotoXYZ(work, FolkData.GotoMethod.SHIFT);
                theFolk.location = work;
            }
        }
        if (SimukraftReloaded.isDayTime() && theFolk.action != FolkData.FolkAction.ONWAYTOWORK && theFolk.action != FolkData.FolkAction.ATWORK) {
            theFolk.action = FolkData.FolkAction.ONWAYTOWORK;
            theFolk.stayPut = false;
            if (theFolk.destination == null) {
                theFolk.gotoXYZ(theFolk.employedAt, null);
            }
        }
    }

    public int getInventoryCount(FolkData theFolk, Item item) {
        int ret = 0;
        for (int i = 0; i < theFolk.inventory.size(); ++i) {
            ItemStack is = theFolk.inventory.get(i);
            if (is.func_77973_b() != item) continue;
            ret += is.field_77994_a;
        }
        return ret;
    }

    public int getInventoryCount(FolkData theFolk, Block item) {
        int ret = 0;
        for (int i = 0; i < theFolk.inventory.size(); ++i) {
            ItemStack is = theFolk.inventory.get(i);
            if (Block.func_149684_b((String)is.func_82833_r()) != item) continue;
            ret += is.field_77994_a;
        }
        return ret;
    }

    public TileEntityFurnace findFurnace(CommonProxy.V3 v) {
        TileEntityFurnace ret = null;
        CommonProxy.V3 vRet = Job.findClosestBlockType(v, Blocks.field_150460_al, 5, false);
        if (vRet == null) {
            vRet = Job.findClosestBlockType(v, Blocks.field_150470_am, 5, false);
        }
        if (vRet != null) {
            WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(vRet.theDimension);
            ret = (TileEntityFurnace)theWorld.func_147438_o(vRet.x.intValue(), vRet.y.intValue(), vRet.z.intValue());
        }
        return ret;
    }

    private static boolean inventoryPut(IInventory chest, ItemStack inStack) {
        Boolean placedOK = false;
        if (inStack == null) {
            return true;
        }
        block0: for (int q = 1; q <= inStack.field_77994_a; ++q) {
            for (int g = 0; g < chest.func_70302_i_(); ++g) {
                ItemStack is = chest.func_70301_a(g);
                if (is == null) {
                    is = inStack.func_77946_l();
                    is.field_77994_a = 1;
                    chest.func_70299_a(g, is);
                    ItemStack isTest = chest.func_70301_a(g);
                    if (isTest != null) {
                        placedOK = true;
                        continue block0;
                    }
                    SimukraftReloaded.log.warning("Job: placeIntoInventory() could not place " + is.func_82833_r() + " in null slot " + g);
                    placedOK = false;
                    continue;
                }
                if (is.func_77973_b() != inStack.func_77973_b() || is.field_77994_a >= is.func_77976_d()) continue;
                int isBefore = chest.func_70301_a((int)g).field_77994_a;
                ++is.field_77994_a;
                chest.func_70299_a(g, is);
                int isAfter = chest.func_70301_a((int)g).field_77994_a;
                if (isAfter > isBefore) {
                    placedOK = true;
                    continue block0;
                }
                SimukraftReloaded.log.warning("Job: placeIntoInventory() could not inc Stacksize for " + is.func_82833_r() + " in slot " + g);
                placedOK = false;
            }
        }
        return placedOK;
    }

    public static ItemStack inventoriesGet(ArrayList<IInventory> chests, ItemStack whatItem, boolean getRandomItem, boolean compareMeta, ItemStack ignoreId) {
        ItemStack retStack = null;
        for (int c = 0; c < chests.size(); ++c) {
            IInventory chest = chests.get(c);
            retStack = Job.inventoryGet(chest, whatItem, getRandomItem, compareMeta);
            if (retStack == null) continue;
            return retStack;
        }
        return null;
    }

    public static ItemStack inventoriesGet(ArrayList<IInventory> chests, ItemStack whatItem, boolean getRandomItem, boolean compareMeta) {
        ItemStack retStack = null;
        for (int c = 0; c < chests.size(); ++c) {
            IInventory chest = chests.get(c);
            retStack = Job.inventoryGet(chest, whatItem, getRandomItem, compareMeta);
            if (retStack == null) continue;
            return retStack;
        }
        return null;
    }

    private static ItemStack inventoryGet(IInventory chest, ItemStack whatItem, boolean getRandomItem, boolean compareMeta, ItemStack ignoreId) {
        if (whatItem != null) {
            ItemStack returnStack = whatItem.func_77946_l();
            returnStack.field_77994_a = 0;
            for (int g = 0; g < chest.func_70302_i_(); ++g) {
                boolean ignore = false;
                ItemStack chestStack = chest.func_70301_a(g);
                if (ignoreId != null && chestStack == ignoreId) {
                    ignore = true;
                }
                if (chestStack == null || ignore) continue;
                if (!compareMeta) {
                    chestStack.func_77964_b(whatItem.func_77960_j());
                }
                if (!chestStack.func_77969_a(whatItem)) continue;
                while (chestStack.field_77994_a >= 1) {
                    ++returnStack.field_77994_a;
                    --chestStack.field_77994_a;
                    if (chestStack.field_77994_a <= 0) {
                        chest.func_70299_a(g, null);
                    }
                    if (returnStack.field_77994_a != whatItem.field_77994_a) continue;
                    return returnStack;
                }
            }
            if (returnStack.field_77994_a > 0) {
                return returnStack;
            }
            return null;
        }
        if (getRandomItem) {
            ItemStack returnStack = null;
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int g = 0; g < chest.func_70302_i_(); ++g) {
                ItemStack chestStack = chest.func_70301_a(g);
                if (chestStack == null) continue;
                slots.add(g);
            }
            if (slots.size() == 0) {
                return null;
            }
            returnStack = chest.func_70301_a(new Random().nextInt(slots.size()));
            return returnStack;
        }
        ItemStack returnStack = null;
        for (int g = 0; g < chest.func_70302_i_(); ++g) {
            ItemStack chestStack = chest.func_70301_a(g);
            if (chestStack == null) continue;
            returnStack = chestStack.func_77946_l();
            chest.func_70299_a(g, null);
            return returnStack;
        }
        return returnStack;
    }

    private static ItemStack inventoryGet(IInventory chest, ItemStack whatItem, boolean getRandomItem, boolean compareMeta) {
        if (whatItem != null) {
            ItemStack returnStack = whatItem.func_77946_l();
            returnStack.field_77994_a = 0;
            for (int g = 0; g < chest.func_70302_i_(); ++g) {
                boolean ignore = false;
                ItemStack chestStack = chest.func_70301_a(g);
                if (chestStack == null || ignore) continue;
                if (!compareMeta) {
                    chestStack.func_77964_b(whatItem.func_77960_j());
                }
                if (!chestStack.func_77969_a(whatItem)) continue;
                while (chestStack.field_77994_a >= 1) {
                    ++returnStack.field_77994_a;
                    --chestStack.field_77994_a;
                    if (chestStack.field_77994_a <= 0) {
                        chest.func_70299_a(g, null);
                    }
                    if (returnStack.field_77994_a != whatItem.field_77994_a) continue;
                    return returnStack;
                }
            }
            if (returnStack.field_77994_a > 0) {
                return returnStack;
            }
            return null;
        }
        if (getRandomItem) {
            ItemStack returnStack = null;
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int g = 0; g < chest.func_70302_i_(); ++g) {
                ItemStack chestStack = chest.func_70301_a(g);
                if (chestStack == null) continue;
                slots.add(g);
            }
            if (slots.size() == 0) {
                return null;
            }
            returnStack = chest.func_70301_a(new Random().nextInt(slots.size()));
            return returnStack;
        }
        ItemStack returnStack = null;
        for (int g = 0; g < chest.func_70302_i_(); ++g) {
            ItemStack chestStack = chest.func_70301_a(g);
            if (chestStack == null) continue;
            returnStack = chestStack.func_77946_l();
            chest.func_70299_a(g, null);
            return returnStack;
        }
        return returnStack;
    }

    public boolean inventoriesPut(ArrayList<IInventory> chests, ItemStack inStack, boolean doOpenClose) {
        boolean placedOK = false;
        for (int i = 0; i < chests.size(); ++i) {
            IInventory chest = chests.get(i);
            if (doOpenClose) {
                this.openCloseChest(chest, 2000);
            }
            if (placedOK = Job.inventoryPut(chest, inStack)) break;
        }
        return placedOK;
    }

    public static boolean inventoriesPut(ArrayList<IInventory> chests, ItemStack inStack) {
        IInventory chest;
        boolean placedOK = false;
        for (int i = 0; i < chests.size() && !(placedOK = Job.inventoryPut(chest = chests.get(i), inStack)); ++i) {
        }
        return placedOK;
    }

    public boolean inventoriesTransferFromFolk(ArrayList<ItemStack> folkInventory, ArrayList<IInventory> toChests, ItemStack specificItems) {
        boolean placed = false;
        boolean okToPlace = false;
        for (int i = 0; i < folkInventory.size(); ++i) {
            try {
                ItemStack folkStack = folkInventory.get(i);
                okToPlace = specificItems != null && specificItems.func_77973_b() == folkStack.func_77973_b() ? true : specificItems == null;
                if (!okToPlace || (placed = this.inventoriesPut(toChests, folkStack, true))) continue;
                SimukraftReloaded.log.warning("Job: Could not place stack of " + folkStack.func_82833_r() + " in chest");
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        folkInventory.clear();
        return true;
    }

    public boolean inventoriesTransferToFolk(ArrayList<ItemStack> folkInventory, ArrayList<IInventory> fromChests, ItemStack whatItems) {
        boolean ret = false;
        int limit = 0;
        ItemStack got = null;
        for (int c = 0; c < fromChests.size(); ++c) {
            IInventory chest = fromChests.get(c);
            this.openCloseChest(chest, 2000);
        }
        do {
            if ((got = Job.inventoriesGet(fromChests, whatItems, false, false)) == null) continue;
            folkInventory.add(got);
            ret = true;
        } while (got != null && ++limit < 27);
        return ret;
    }

    public int inventoriesTransferLimitedToFolk(ArrayList<ItemStack> folkInventory, ArrayList<IInventory> fromChests, ItemStack whatItems, int getQty, boolean doCompareMeta) {
        int gotSoFar = 0;
        block0: for (IInventory chest : fromChests) {
            for (int g = 0; g < chest.func_70302_i_(); ++g) {
                boolean gotMatch = false;
                ItemStack chestStack = chest.func_70301_a(g);
                if (chestStack != null && chestStack.func_77973_b() == whatItems.func_77973_b()) {
                    if (doCompareMeta) {
                        if (chestStack.func_77960_j() == whatItems.func_77960_j()) {
                            gotMatch = true;
                        }
                    } else {
                        gotMatch = true;
                    }
                }
                if (gotMatch) {
                    while (gotSoFar < getQty && chestStack.field_77994_a > 0) {
                        ++gotSoFar;
                        --chestStack.field_77994_a;
                        folkInventory.add(new ItemStack(Block.func_149634_a((Item)chestStack.func_77973_b()), 1, chestStack.func_77960_j()));
                    }
                    if (chestStack.field_77994_a > 0) {
                        chest.func_70299_a(g, chestStack);
                    } else {
                        chest.func_70299_a(g, null);
                    }
                }
                if (gotSoFar == getQty) continue block0;
            }
        }
        return gotSoFar;
    }

    public int getItemCountInChests(ArrayList<IInventory> chests, ItemStack is, boolean doCompareMeta) {
        int ret = 0;
        for (IInventory chest : chests) {
            for (int g = 0; g < chest.func_70302_i_(); ++g) {
                ItemStack chestStack = chest.func_70301_a(g);
                if (chestStack == null || chestStack.func_77973_b() != is.func_77973_b()) continue;
                if (!doCompareMeta) {
                    ret += chestStack.field_77994_a;
                    continue;
                }
                if (chestStack.func_77960_j() != is.func_77960_j()) continue;
                ret += chestStack.field_77994_a;
            }
        }
        return ret;
    }

    public ArrayList<ItemStack> translateBlockWhenMined(World world, CommonProxy.V3 location) {
        int k;
        int j;
        int i = location.x.intValue();
        Block block = world.func_147439_a(i, j = location.y.intValue(), k = location.z.intValue());
        if (block == null) {
            return null;
        }
        int meta = world.func_72805_g(i, j, k);
        return block.getDrops(world, i, j, k, meta, 0);
    }

    public void openCloseChest(IInventory chest, int msDelay) {
        chest.func_70295_k_();
        this.chestToClose = chest;
        this.chestToCloseWhen = System.currentTimeMillis() + (long)msDelay;
    }

    public void setClosestBlocksOfType(final CommonProxy.V3 startXYZ, final ArrayList<Block> blockIDs, final int distanceLimit, final boolean needsToSeeSky, final boolean scanDownwards, final boolean oneLayerOnly) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
                HashMap<String, CommonProxy.V3> hm = new HashMap<String, CommonProxy.V3>();
                boolean skip = false;
                int YdistanceLimit = distanceLimit;
                if (oneLayerOnly) {
                    YdistanceLimit = 0;
                }
                for (int yo = 0; yo <= YdistanceLimit; ++yo) {
                    for (int d = 1; d < distanceLimit; ++d) {
                        for (int xo = -d; xo <= d; ++xo) {
                            for (int zo = -d; zo <= d; ++zo) {
                                int sx = startXYZ.x.intValue() + xo;
                                int sy = scanDownwards ? startXYZ.y.intValue() - yo : startXYZ.y.intValue() + yo;
                                int sz = startXYZ.z.intValue() + zo;
                                skip = false;
                                for (int b = 0; b < blockIDs.size(); ++b) {
                                    CommonProxy.V3 v;
                                    Block blockID = (Block)blockIDs.get(b);
                                    if (theWorld == null) {
                                        return;
                                    }
                                    Block blockInWorld = theWorld.func_147439_a(sx, sy, sz);
                                    if (blockInWorld != blockID) continue;
                                    if (needsToSeeSky) {
                                        boolean canSeeSky = theWorld.func_147439_a(sx, sy + 1, sz) == null;
                                        skip = !canSeeSky;
                                    }
                                    if (skip || hm.containsKey((v = new CommonProxy.V3(Double.valueOf(sx), Double.valueOf(sy), Double.valueOf(sz), startXYZ.theDimension)).toString())) continue;
                                    hm.put(v.toString(), v);
                                }
                            }
                        }
                    }
                }
                Job.this.closestBlocks = new ArrayList(hm.values());
                Job.this.step = 3;
            }
        });
        t.start();
    }

    public static ArrayList<IInventory> inventoriesFindClosest(CommonProxy.V3 startXYZ, int searchDistance) {
        ArrayList<IInventory> ret = new ArrayList<IInventory>();
        try {
            WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
            TileEntity te = theWorld.func_147438_o(startXYZ.x.intValue(), startXYZ.y.intValue(), startXYZ.z.intValue());
            if (te != null && te instanceof IInventory && !(te instanceof TileEntityFurnace) && !(te instanceof TileEntityWindmill)) {
                ret.add((IInventory)te);
            }
            for (int d = 1; d < searchDistance; ++d) {
                for (int yo = -d; yo <= d; ++yo) {
                    for (int xo = -d; xo <= d; ++xo) {
                        for (int zo = -d; zo <= d; ++zo) {
                            int sz;
                            int sy;
                            int sx = startXYZ.x.intValue() + xo;
                            te = theWorld.func_147438_o(sx, sy = startXYZ.y.intValue() + yo, sz = startXYZ.z.intValue() + zo);
                            if (te == null || !(te instanceof IInventory) || te instanceof TileEntityWindmill || Job.alreadyGotChest(ret, (IInventory)te)) continue;
                            ret.add((IInventory)te);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            return ret;
        }
        return ret;
    }

    private static boolean alreadyGotChest(ArrayList<IInventory> chests, IInventory chest) {
        boolean ret = false;
        for (IInventory ch : chests) {
            if (!ch.toString().contentEquals(chest.toString())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static CommonProxy.V3 findAdjacentSpace(CommonProxy.V3 startXYZ, World world) {
        CommonProxy.V3 test;
        World theWorld = world;
        if (theWorld == null) {
            theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
        }
        CommonProxy.V3 v3 = test = startXYZ.clone();
        Double d = v3.x;
        Double d2 = v3.x = Double.valueOf(v3.x + 1.0);
        if (theWorld.func_147437_c(test.x.intValue(), test.y.intValue(), test.z.intValue())) {
            return test;
        }
        v3 = test = startXYZ.clone();
        d = v3.x;
        d2 = v3.x = Double.valueOf(v3.x - 1.0);
        if (theWorld.func_147437_c(test.x.intValue(), test.y.intValue(), test.z.intValue())) {
            return test;
        }
        v3 = test = startXYZ.clone();
        d = v3.z;
        d2 = v3.z = Double.valueOf(v3.z + 1.0);
        if (theWorld.func_147437_c(test.x.intValue(), test.y.intValue(), test.z.intValue())) {
            return test;
        }
        v3 = test = startXYZ.clone();
        d = v3.z;
        d2 = v3.z = Double.valueOf(v3.z - 1.0);
        if (theWorld.func_147437_c(test.x.intValue(), test.y.intValue(), test.z.intValue())) {
            return test;
        }
        return startXYZ;
    }

    public static CommonProxy.V3 findClosestBlockType(CommonProxy.V3 startXYZ, Block block, int searchDistance, boolean mustSeeSky) {
        WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
        if (theWorld.func_147439_a(startXYZ.x.intValue(), startXYZ.y.intValue(), startXYZ.z.intValue()) == block) {
            return startXYZ;
        }
        for (int d = 1; d < searchDistance; ++d) {
            for (int yo = -searchDistance; yo <= searchDistance; ++yo) {
                for (int xo = -d; xo <= d; ++xo) {
                    for (int zo = -d; zo <= d; ++zo) {
                        int sz;
                        int sy;
                        int sx = startXYZ.x.intValue() + xo;
                        if (theWorld.func_147439_a(sx, sy = startXYZ.y.intValue() + yo, sz = startXYZ.z.intValue() + zo) != block) continue;
                        CommonProxy.V3 ret = new CommonProxy.V3(Double.valueOf(sx), Double.valueOf(sy), Double.valueOf(sz), startXYZ.theDimension);
                        return ret;
                    }
                }
            }
        }
        return null;
    }

    public static CommonProxy.V3 findClosestBlockType(CommonProxy.V3 startXYZ, Block block, int searchDistance) {
        WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
        if (theWorld.func_147439_a(startXYZ.x.intValue(), startXYZ.y.intValue(), startXYZ.z.intValue()) == block) {
            return startXYZ;
        }
        for (int d = 1; d < searchDistance; ++d) {
            for (int xo = -d; xo <= d; ++xo) {
                for (int zo = -d; zo <= d; ++zo) {
                    int sz;
                    int sy;
                    int sx = startXYZ.x.intValue() + xo;
                    if (theWorld.func_147439_a(sx, sy = startXYZ.y.intValue(), sz = startXYZ.z.intValue() + zo) != block) continue;
                    CommonProxy.V3 ret = new CommonProxy.V3(Double.valueOf(sx), Double.valueOf(sy), Double.valueOf(sz), startXYZ.theDimension);
                    return ret;
                }
            }
        }
        return null;
    }

    public static ArrayList<CommonProxy.V3> findClosestBlocks(CommonProxy.V3 startXYZ, Block block, int distanceLimit) {
        ArrayList<CommonProxy.V3> blocksFound = new ArrayList<CommonProxy.V3>();
        int count = 0;
        WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(startXYZ.theDimension);
        for (int yo = -distanceLimit; yo <= distanceLimit; ++yo) {
            for (int xo = -distanceLimit; xo <= distanceLimit; ++xo) {
                for (int zo = -distanceLimit; zo <= distanceLimit; ++zo) {
                    try {
                        CommonProxy.V3 v;
                        int sx = startXYZ.x.intValue() + xo;
                        int sy = startXYZ.y.intValue() + yo;
                        int sz = startXYZ.z.intValue() + zo;
                        ++count;
                        if (theWorld.func_147439_a(sx, sy, sz) != block || blocksFound.contains(v = new CommonProxy.V3(Double.valueOf(sx), Double.valueOf(sy), Double.valueOf(sz), startXYZ.theDimension))) continue;
                        blocksFound.add(v);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        int ci = 0;
        double cd = 999.0;
        for (int i = 0; i < blocksFound.size(); ++i) {
            CommonProxy.V3 v = (CommonProxy.V3)blocksFound.get(i);
            double distance = Math.sqrt((v.x - startXYZ.x) * (v.x - startXYZ.x) + (v.z - startXYZ.z) * (v.z - startXYZ.z));
            if (!(distance < cd)) continue;
            cd = distance;
            ci = i;
        }
        ArrayList<CommonProxy.V3> retblocksFound = new ArrayList<CommonProxy.V3>();
        if (blocksFound.size() > 0) {
            retblocksFound.add((CommonProxy.V3)blocksFound.get(ci));
            for (int i = 0; i < blocksFound.size(); ++i) {
                if (i == ci) continue;
                retblocksFound.add((CommonProxy.V3)blocksFound.get(i));
            }
        }
        return retblocksFound;
    }

    public boolean mineBlockIntoChests(ArrayList<IInventory> chests, CommonProxy.V3 blockXYZ) {
        boolean ret = false;
        ArrayList<ItemStack> minedStacks = this.translateBlockWhenMined(this.jobWorld, blockXYZ);
        if (minedStacks != null) {
            for (int s = 0; s < minedStacks.size(); ++s) {
                ItemStack stack = minedStacks.get(s);
                if (stack == null) continue;
                this.inventoriesPut(chests, stack, false);
            }
            ret = true;
        }
        return ret;
    }

    public int getAnimalCountInPen(CommonProxy.V3 controlBox, Class animal) {
        List list = this.jobWorld.func_72872_a(animal, AxisAlignedBB.func_72330_a((double)controlBox.x, (double)controlBox.y, (double)controlBox.z, (double)(controlBox.x + 1.0), (double)(controlBox.y + 1.0), (double)(controlBox.z + 1.0)).func_72314_b(3.0, 2.0, 3.0));
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public static CommonProxy.V3 getNearestBuildingForFolk(String searchWord, FolkData folk) {
        ArrayList ret = new ArrayList();
        Building shortestDist = null;
        for (int x = 0; x < SimukraftReloaded.theBuildings.size(); ++x) {
            Building b = SimukraftReloaded.theBuildings.get(x);
            if (!b.displayName.toLowerCase().contains(searchWord.toLowerCase())) continue;
            if (shortestDist.primaryXYZ == null) {
                shortestDist = b;
            }
            if (folk.location.getDistanceTo(shortestDist.primaryXYZ) >= b.primaryXYZ.getDistanceTo(folk.location)) continue;
            shortestDist = b;
        }
        return shortestDist.primaryXYZ;
    }

    public static enum Vocation {
        BUILDER,
        LUMBERJACK,
        MINER,
        CROPFARMER,
        BAKER,
        SOLDIER,
        SHEPHERD,
        GROCER,
        COURIER,
        MERCHANT,
        BUTCHER,
        PIGFARMER,
        CATTLEFARMER,
        CHICKENFARMER,
        TERRAFORMER,
        GLASSMAKER,
        FISHERMAN,
        PATHBUILDER,
        DAIRYFARMER,
        CHEESEMAKER,
        BURGERSMANAGER,
        BURGERSFRYCOOK,
        BURGERSWAITER,
        EGGFARMER,
        BRICKMAKER;


        public static Vocation getVocation(String s) {
            try {
                if (s.contentEquals("\u5efa\u7b51\u5e08")) {
                    return BUILDER;
                }
                if (s.contentEquals("\u4f10\u6728\u5de5")) {
                    return LUMBERJACK;
                }
                if (s.contentEquals("\u9e21\u86cb\u8fbe\u4eba")) {
                    return EGGFARMER;
                }
                if (s.contentEquals("\u77ff\u5de5")) {
                    return MINER;
                }
                if (s.contentEquals("\u519c\u6c11")) {
                    return CROPFARMER;
                }
                if (s.contentEquals("\u9762\u5305\u5e08")) {
                    return BAKER;
                }
                if (s.contentEquals("\u519b\u4eba")) {
                    return SOLDIER;
                }
                if (s.contentEquals("\u7267\u7f8a\u4eba")) {
                    return SHEPHERD;
                }
                if (s.contentEquals("\u98df\u54c1\u5e97\u5458")) {
                    return GROCER;
                }
                if (s.contentEquals("\u5feb\u9012\u5458")) {
                    return COURIER;
                }
                if (s.contentEquals("\u5546\u4eba")) {
                    return MERCHANT;
                }
                if (s.contentEquals("\u517b\u725b\u8fbe\u4eba")) {
                    return CATTLEFARMER;
                }
                if (s.contentEquals("\u517b\u732a\u8fbe\u4eba")) {
                    return PIGFARMER;
                }
                if (s.contentEquals("\u517b\u9e21\u8fbe\u4eba")) {
                    return CHICKENFARMER;
                }
                if (s.contentEquals("\u5c60\u592b")) {
                    return BUTCHER;
                }
                if (s.contentEquals("\u89c4\u5212\u5e08")) {
                    return TERRAFORMER;
                }
                if (s.contentEquals("\u73bb\u7483\u5236\u9020\u5546")) {
                    return GLASSMAKER;
                }
                if (s.contentEquals("\u6e14\u592b")) {
                    return FISHERMAN;
                }
                if (s.contentEquals("\u4fee\u8def\u5de5")) {
                    return PATHBUILDER;
                }
                if (s.contentEquals("\u5976\u725b\u8fbe\u4eba")) {
                    return DAIRYFARMER;
                }
                if (s.contentEquals("\u5976\u916a\u5236\u9020\u5546")) {
                    return CHEESEMAKER;
                }
                if (s.contentEquals("\u80af\u6253\u9e21\u5e97\u7ecf\u7406")) {
                    return BURGERSMANAGER;
                }
                if (s.contentEquals("\u80af\u6253\u9e21\u53a8\u5e08")) {
                    return BURGERSFRYCOOK;
                }
                if (s.contentEquals("\u80af\u6253\u9e21\u670d\u52a1\u5458")) {
                    return BURGERSWAITER;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        public String toString() {
            if (this == BUILDER) {
                return "\u5efa\u7b51\u5e08";
            }
            if (this == LUMBERJACK) {
                return "\u4f10\u6728\u5de5";
            }
            if (this == EGGFARMER) {
                return "\u9e21\u86cb\u8fbe\u4eba";
            }
            if (this == MINER) {
                return "\u77ff\u5de5";
            }
            if (this == CROPFARMER) {
                return "\u519c\u6c11";
            }
            if (this == BAKER) {
                return "\u9762\u5305\u5e08";
            }
            if (this == SOLDIER) {
                return "\u519b\u4eba";
            }
            if (this == SHEPHERD) {
                return "\u7267\u7f8a\u4eba";
            }
            if (this == GROCER) {
                return "\u98df\u54c1\u5e97\u5458";
            }
            if (this == COURIER) {
                return "\u5feb\u9012\u5458";
            }
            if (this == MERCHANT) {
                return "\u5546\u4eba";
            }
            if (this == BUTCHER) {
                return "\u5c60\u592b";
            }
            if (this == PIGFARMER) {
                return "\u517b\u732a\u8fbe\u4eba";
            }
            if (this == CATTLEFARMER) {
                return "\u517b\u725b\u8fbe\u4eba";
            }
            if (this == CHICKENFARMER) {
                return "\u517b\u9e21\u8fbe\u4eba";
            }
            if (this == TERRAFORMER) {
                return "\u89c4\u5212\u5e08";
            }
            if (this == GLASSMAKER) {
                return "\u73bb\u7483\u5236\u9020\u5546";
            }
            if (this == BRICKMAKER) {
                return "\u677f\u7816\u5de5";
            }
            if (this == FISHERMAN) {
                return "\u6e14\u592b";
            }
            if (this == PATHBUILDER) {
                return "\u4fee\u8def\u5de5";
            }
            if (this == DAIRYFARMER) {
                return "\u5976\u725b\u8fbe\u4eba";
            }
            if (this == CHEESEMAKER) {
                return "\u5976\u916a\u5236\u9020\u5546";
            }
            if (this == BURGERSMANAGER) {
                return "\u80af\u6253\u9e21\u5e97\u7ecf\u7406";
            }
            if (this == BURGERSFRYCOOK) {
                return "\u80af\u6253\u9e21\u53a8\u5e08";
            }
            if (this == BURGERSWAITER) {
                return "\u80af\u6253\u9e21\u670d\u52a1\u5458";
            }
            return "";
        }
    }
}

