/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common;

import ashjack.simukraftreloaded.core.ModSimukraft;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.folk.FolkData;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;

public class Relationship
implements Serializable {
    private static final long serialVersionUID = -1617919828251928361L;
    public FolkData folk1 = null;
    public FolkData folk2 = null;
    public Level theLevel = Level.AQUAINTANCE;
    public int theSubLevel = 0;
    public boolean isBloodRelation = false;
    private Random rand = new Random();

    public Relationship() {
    }

    public Relationship(FolkData folk1, FolkData folk2, Level startingLevel, boolean isBlood) {
        this.folk1 = folk1;
        this.folk2 = folk2;
        this.theLevel = startingLevel;
        this.isBloodRelation = isBlood;
    }

    public String toString() {
        if (this.theLevel == Level.AQUAINTANCE) {
            return "\u719f\u4eba";
        }
        if (this.theLevel == Level.BESTFRIENDS) {
            return "\u6700\u597d\u7684\u670b\u53cb";
        }
        if (this.theLevel == Level.DESPISE) {
            return "\u9119\u89c6";
        }
        if (this.theLevel == Level.DISLIKE) {
            return "\u4e0d\u559c\u6b22";
        }
        if (this.theLevel == Level.ENEMY) {
            return "\u654c\u4eba";
        }
        if (this.theLevel == Level.FRIEND) {
            return "\u670b\u53cb";
        }
        if (this.theLevel == Level.GOODFRIEND) {
            return "\u597d\u670b\u53cb";
        }
        if (this.theLevel == Level.HATE) {
            return "\u6068";
        }
        if (this.theLevel == Level.MARRIED) {
            return "\u7ed3\u5a5a";
        }
        if (this.theLevel == Level.PARTNER) {
            return "\u751f\u6d3b\u5728\u4e00\u8d77";
        }
        return "\u672a\u77e5";
    }

    public String toStringPersepctive(FolkData folk) {
        FolkData fother;
        String other = "";
        if (folk.name.contentEquals(this.folk1.name)) {
            other = this.folk2.name;
            fother = this.folk2;
        } else {
            other = this.folk1.name;
            fother = this.folk1;
        }
        if (this.theLevel == Level.AQUAINTANCE) {
            return other + "\uff1a\u719f\u4eba";
        }
        if (this.theLevel == Level.BESTFRIENDS) {
            return other + "\uff1a\u6700\u597d\u7684\u670b\u53cb";
        }
        if (this.theLevel == Level.DESPISE) {
            return other + "\uff1a\u9119\u89c6";
        }
        if (this.theLevel == Level.DISLIKE) {
            return other + "\uff1a\u8e29";
        }
        if (this.theLevel == Level.ENEMY) {
            return other + "\uff1a\u654c\u4eba";
        }
        if (this.theLevel == Level.FRIEND) {
            return other + "\uff1a\u597d\u53cb";
        }
        if (this.theLevel == Level.GOODFRIEND) {
            return other + "\uff1a\u597d\u670b\u53cb";
        }
        if (this.theLevel == Level.HATE) {
            return other + "\uff1a\u6068";
        }
        if (this.theLevel == Level.MARRIED) {
            return other + "\uff1a\u5df2\u5a5a";
        }
        if (this.theLevel == Level.PARTNER) {
            return other + "\uff1a\u5408\u4f5c\u4f19\u4f34";
        }
        if (this.theLevel == Level.MOTHERDAUGHTER) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u6bcd\u4eb2";
            }
            return other + "\uff1a\u5973\u513f";
        }
        if (this.theLevel == Level.MOTHERSON) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u6bcd\u4eb2";
            }
            return other + "\uff1a\u513f\u5b50";
        }
        if (this.theLevel == Level.FATHERSON) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u7236\u4eb2";
            }
            return other + "\uff1a\u513f\u5b50";
        }
        if (this.theLevel == Level.FATHERDAUGHTER) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u7236\u4eb2";
            }
            return other + "\uff1a\u5973\u513f";
        }
        if (this.theLevel == Level.SISTERSISTER) {
            return other + "\uff1a\u59d0";
        }
        if (this.theLevel == Level.BROTHERBROTHER) {
            return other + "\uff1a\u5144\u5f1f";
        }
        if (this.theLevel == Level.SISTERBROTHER) {
            if (fother.gender == 0) {
                return other + "\uff1a\u5144\u5f1f";
            }
            return other + "\uff1a\u59d0";
        }
        if (this.theLevel == Level.GRANDFATHERDAUGHTER) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u7956\u7236";
            }
            return other + "\uff1a\u5b59\u5973";
        }
        if (this.theLevel == Level.GRANDFATHERSON) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u7956\u7236";
            }
            return other + "\uff1a\u5b59\u5b50";
        }
        if (this.theLevel == Level.GRANDMOTHERDAUGHTER) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u7956\u6bcd";
            }
            return other + "\uff1a\u5b59\u5973";
        }
        if (this.theLevel == Level.GRANDMOTHERSON) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u7956\u6bcd";
            }
            return other + "\uff1a\u5b59\u5b50";
        }
        if (this.theLevel == Level.AUNTNEPHEW) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u963f\u59e8";
            }
            return other + "\uff1a\u4f84\u5b50";
        }
        if (this.theLevel == Level.AUNTNEICE) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u963f\u59e8";
            }
            return other + "\uff1a\u5916\u7525\u5973";
        }
        if (this.theLevel == Level.UNCLENEPHEW) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u53d4";
            }
            return other + "\uff1a\u4f84\u5b50";
        }
        if (this.theLevel == Level.UNCLENEICE) {
            if (fother.age > folk.age) {
                return other + "\uff1a\u53d4";
            }
            return other + "\uff1a\u5916\u7525\u5973";
        }
        return other + "\uff1a\u672a\u77e5\u7684\u5173\u7cfb";
    }

    public static FolkData getMotherOf(FolkData sonDaughter) {
        ArrayList<Relationship> rels = Relationship.getRelationshipsFor(sonDaughter);
        for (Relationship rel : rels) {
            if (rel.theLevel != Level.MOTHERDAUGHTER && rel.theLevel != Level.MOTHERSON) continue;
            if (rel.folk1.age > rel.folk2.age) {
                return FolkData.getFolkByName(rel.folk1.name);
            }
            return FolkData.getFolkByName(rel.folk2.name);
        }
        return null;
    }

    public static void addRelationship(Relationship rel) {
        boolean got = false;
        for (Relationship relation : SimukraftReloaded.theRelationships) {
            try {
                if (relation.folk1.name.contentEquals(rel.folk1.name) && relation.folk2.name.contentEquals(rel.folk2.name)) {
                    got = true;
                }
                if (!relation.folk1.name.contentEquals(rel.folk2.name) || !relation.folk2.name.contentEquals(rel.folk1.name)) continue;
                got = true;
            }
            catch (Exception e) {}
        }
        if (!got) {
            SimukraftReloaded.theRelationships.add(rel);
        }
    }

    public static void setupBloodRelationships(FolkData newChild, FolkData father, FolkData mother) {
        ArrayList<Relationship> mothers = Relationship.getRelationshipsFor(mother);
        for (Relationship rel : mothers) {
            FolkData other = rel.folk1.name.contentEquals(mother.name) ? rel.folk2 : rel.folk1;
            if (rel.theLevel == Level.MOTHERDAUGHTER) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.SISTERBROTHER, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.SISTERSISTER, true));
                }
            } else if (rel.theLevel == Level.MOTHERSON) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.BROTHERBROTHER, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.SISTERBROTHER, true));
                }
            }
            if (rel.theLevel == Level.MOTHERDAUGHTER && !rel.folk1.name.contentEquals(newChild.name) && !rel.folk2.name.contentEquals(newChild.name)) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDMOTHERSON, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDMOTHERDAUGHTER, true));
                }
            } else if (rel.theLevel == Level.FATHERDAUGHTER) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDFATHERSON, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDFATHERDAUGHTER, true));
                }
            }
            if (rel.theLevel == Level.SISTERBROTHER) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.UNCLENEPHEW, true));
                    continue;
                }
                Relationship.addRelationship(new Relationship(newChild, other, Level.UNCLENEICE, true));
                continue;
            }
            if (rel.theLevel != Level.SISTERSISTER) continue;
            if (newChild.gender == 0) {
                Relationship.addRelationship(new Relationship(newChild, other, Level.AUNTNEPHEW, true));
                continue;
            }
            Relationship.addRelationship(new Relationship(newChild, other, Level.AUNTNEICE, true));
        }
        ArrayList<Relationship> fathers = Relationship.getRelationshipsFor(father);
        for (Relationship rel : fathers) {
            FolkData other = rel.folk1.name.contentEquals(father.name) ? rel.folk2 : rel.folk1;
            if (rel.theLevel == Level.FATHERSON && !rel.folk1.name.contentEquals(newChild.name) && !rel.folk2.name.contentEquals(newChild.name)) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDFATHERSON, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDFATHERDAUGHTER, true));
                }
            } else if (rel.theLevel == Level.MOTHERSON) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDMOTHERSON, true));
                } else {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.GRANDMOTHERDAUGHTER, true));
                }
            }
            if (rel.theLevel == Level.SISTERBROTHER) {
                if (newChild.gender == 0) {
                    Relationship.addRelationship(new Relationship(newChild, other, Level.AUNTNEPHEW, true));
                    continue;
                }
                Relationship.addRelationship(new Relationship(newChild, other, Level.AUNTNEICE, true));
                continue;
            }
            if (rel.theLevel != Level.BROTHERBROTHER) continue;
            if (newChild.gender == 0) {
                Relationship.addRelationship(new Relationship(newChild, other, Level.UNCLENEPHEW, true));
                continue;
            }
            Relationship.addRelationship(new Relationship(newChild, other, Level.UNCLENEICE, true));
        }
        if (newChild.gender == 0) {
            Relationship.addRelationship(new Relationship(newChild, mother, Level.MOTHERSON, true));
        } else {
            Relationship.addRelationship(new Relationship(newChild, mother, Level.MOTHERDAUGHTER, true));
        }
        if (newChild.gender == 0) {
            Relationship.addRelationship(new Relationship(newChild, father, Level.FATHERSON, true));
        } else {
            Relationship.addRelationship(new Relationship(newChild, father, Level.FATHERDAUGHTER, true));
        }
    }

    public String toFullString() {
        String folk2name = "";
        folk2name = this.folk2 == null ? "You" : this.folk2.name;
        return this.folk1.name + " " + this.toString() + " " + folk2name;
    }

    public void levelIncrease(int byAmount) {
        String oldLevel = this.toFullString();
        SimukraftReloaded.log.info("Relationship: + current level and sublevel:" + this.theLevel.toString() + " " + this.theSubLevel);
        this.theSubLevel += byAmount;
        if (this.theSubLevel > 100) {
            if (this.theLevel == Level.AQUAINTANCE) {
                this.theLevel = Level.FRIEND;
                this.theSubLevel = 0;
            } else if (this.theLevel == Level.BESTFRIENDS) {
                if (this.folk2 == null) {
                    this.theSubLevel = 100;
                } else if (!(this.folk1.gender == this.folk2.gender || this.folk1.getHome() == null || this.folk2.getHome() == null || Relationship.isFolkLivingWithSomeone(this.folk1) || Relationship.isFolkLivingWithSomeone(this.folk2) || this.folk1.age < 18 || this.folk2.age < 18 || this.isBloodRelation)) {
                    this.theSubLevel = 50;
                    if (this.rand.nextBoolean()) {
                        this.theLevel = Level.MARRIED;
                        this.changeFemaleSurname();
                    } else {
                        this.theLevel = Level.PARTNER;
                    }
                    Building oldhome = this.folk1.getHome();
                    Building newhome = this.folk2.getHome();
                    if (oldhome != null) {
                        oldhome.removeTennant(this.folk1.name);
                    }
                    if (newhome != null) {
                        newhome.tennants.add(this.folk1.name);
                    }
                    Building.saveAllBuildings();
                    if (this.folk1.employedAt == null && this.folk2.employedAt == null) {
                        try {
                            this.folk1.action = FolkData.FolkAction.GOINGHOME;
                            this.folk1.actionArrival = FolkData.FolkAction.ATHOME;
                            this.folk1.gotoXYZ(this.folk1.getHome().primaryXYZ, null);
                            this.folk2.action = FolkData.FolkAction.GOINGHOME;
                            this.folk2.actionArrival = FolkData.FolkAction.ATHOME;
                            this.folk2.gotoXYZ(this.folk2.getHome().primaryXYZ, null);
                        }
                        catch (Exception e) {}
                    }
                }
            } else if (this.theLevel == Level.DESPISE) {
                this.theLevel = Level.HATE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.DISLIKE) {
                this.theLevel = Level.FRIEND;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.ENEMY) {
                this.theLevel = Level.DESPISE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.FRIEND) {
                this.theLevel = Level.GOODFRIEND;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.GOODFRIEND) {
                this.theLevel = Level.BESTFRIENDS;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.HATE) {
                this.theLevel = Level.DISLIKE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.MARRIED) {
                this.theSubLevel = 100;
            } else if (this.theLevel == Level.PARTNER) {
                this.theSubLevel = 100;
            }
            if (!this.toFullString().contentEquals(oldLevel)) {
                this.notifyRelationshipChange();
            }
        }
    }

    private void changeFemaleSurname() {
        FolkData maleFolk;
        FolkData femaleFolk;
        if (this.folk1.gender == 1) {
            femaleFolk = this.folk1;
            maleFolk = this.folk2;
        } else {
            femaleFolk = this.folk2;
            maleFolk = this.folk1;
        }
        for (int b = 0; b < SimukraftReloaded.theBuildings.size(); ++b) {
            Building building = SimukraftReloaded.theBuildings.get(b);
            if (building == null || femaleFolk.getHome() == null || !building.primaryXYZ.isSameCoordsAs(femaleFolk.getHome().primaryXYZ, true, false)) continue;
            building.removeTennant(femaleFolk.name);
        }
        File f = new File(SimukraftReloaded.getSavesDataFolder() + "Folks" + File.separator + femaleFolk.name + ".sk2");
        f.delete();
        String surname = maleFolk.name.substring(maleFolk.name.indexOf(" ") + 1).trim();
        int m = femaleFolk.name.indexOf(" ");
        femaleFolk.name = femaleFolk.name.substring(0, m).trim() + " " + surname;
    }

    public void levelDecrease(int byAmount) {
        String oldLevel = this.toFullString();
        this.theSubLevel -= byAmount;
        if (this.theSubLevel < 0) {
            if (this.theLevel == Level.AQUAINTANCE) {
                this.theLevel = Level.DISLIKE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.BESTFRIENDS) {
                if (this.folk2 == null) {
                    this.theSubLevel = 50;
                } else {
                    this.theLevel = Level.GOODFRIEND;
                    this.theSubLevel = 50;
                }
            } else if (this.theLevel == Level.DESPISE) {
                this.theLevel = Level.ENEMY;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.DISLIKE) {
                this.theLevel = Level.HATE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.ENEMY) {
                this.theSubLevel = 0;
            } else if (this.theLevel == Level.FRIEND) {
                this.theLevel = Level.DISLIKE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.GOODFRIEND) {
                this.theLevel = Level.FRIEND;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.HATE) {
                this.theLevel = Level.DESPISE;
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.MARRIED) {
                this.theSubLevel = 50;
            } else if (this.theLevel == Level.PARTNER) {
                this.theSubLevel = 50;
            }
            if (!this.toFullString().contentEquals(oldLevel)) {
                this.notifyRelationshipChange();
            }
        }
    }

    private void notifyRelationshipChange() {
        if (this.folk2 == null || this.theLevel == Level.MARRIED || this.theLevel == Level.PARTNER) {
            SimukraftReloaded.sendChat(this.toFullString().replaceAll(" is ", " is now "));
        }
    }

    public static void loadRelationships() {
        File relFiles = new File(SimukraftReloaded.getSavesDataFolder() + "Relationships" + File.separator);
        relFiles.mkdirs();
        boolean useNewFormat = false;
        for (File f : relFiles.listFiles()) {
            if (!f.getName().endsWith(".sk2")) continue;
            useNewFormat = true;
            break;
        }
        if (useNewFormat) {
            SimukraftReloaded.theRelationships.clear();
            for (File f : relFiles.listFiles()) {
                if (!f.getName().endsWith(".sk2")) continue;
                ArrayList<String> strings = SimukraftReloaded.loadSK2(f.getAbsoluteFile().toString());
                Relationship rel = new Relationship();
                for (String line : strings) {
                    FolkData folk;
                    if (!line.contains("|")) continue;
                    int m1 = line.indexOf("|");
                    String name = line.substring(0, m1);
                    String value = line.substring(m1 + 1);
                    if (name.contentEquals("folk1")) {
                        if (value.contentEquals("") || value.contentEquals("null") || (folk = FolkData.getFolkByName(value)) == null) continue;
                        rel.folk1 = folk;
                        continue;
                    }
                    if (name.contentEquals("folk2")) {
                        if (value.contentEquals("") || value.contentEquals("null") || (folk = FolkData.getFolkByName(value)) == null) continue;
                        rel.folk2 = folk;
                        continue;
                    }
                    if (name.contentEquals("level")) {
                        rel.theLevel = Level.valueOf(value);
                        continue;
                    }
                    if (name.contentEquals("sublevel")) {
                        rel.theSubLevel = Integer.parseInt(value);
                        continue;
                    }
                    if (!name.contentEquals("bloodrelation")) continue;
                    rel.isBloodRelation = Boolean.parseBoolean(value);
                }
                if (rel.folk1 == null || rel.folk2 == null) continue;
                Relationship.addRelationship(rel);
            }
        } else {
            for (File f : relFiles.listFiles()) {
                Relationship rel;
                if (!f.getName().endsWith(".suk") || (rel = (Relationship)ModSimukraft.proxy.loadObject(f.getAbsoluteFile().toString())) == null) continue;
                Relationship.addRelationship(rel);
            }
        }
    }

    public static void saveRelationships() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            ArrayList<String> strings = new ArrayList<String>();
            for (int b = 0; b < SimukraftReloaded.theRelationships.size(); ++b) {
                try {
                    Relationship rel = SimukraftReloaded.theRelationships.get(b);
                    String fn = rel.folk1.name.replaceAll(" ", "") + rel.folk2.name.replaceAll(" ", "");
                    strings.clear();
                    strings.add("folk1|" + rel.folk1.name);
                    strings.add("folk2|" + rel.folk2.name);
                    strings.add("level|" + rel.theLevel.name());
                    strings.add("sublevel|" + rel.theSubLevel);
                    strings.add("bloodrelation|" + rel.isBloodRelation);
                    SimukraftReloaded.saveSK2(SimukraftReloaded.getSavesDataFolder() + "Relationships" + File.separator + fn + ".sk2", strings);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void meddleWithRelationship(FolkData folk1, FolkData folk2) {
        if (folk1.name.contentEquals(folk2.name)) {
            SimukraftReloaded.log.warning("Relationship: meddleWithRelationship() with same folk for both");
            return;
        }
        Relationship rel = Relationship.getRelationshipBetween(folk1, folk2);
        if (rel == null) {
            Relationship.addRelationship(new Relationship(folk1, folk2, Level.AQUAINTANCE, false));
        } else {
            Random r = new Random();
            int rr = r.nextInt(5);
            if (rr == 0) {
                rel.levelDecrease(r.nextInt(30));
            } else {
                rel.levelIncrease(r.nextInt(30));
            }
        }
    }

    public static Relationship getRelationshipBetween(FolkData folk1, FolkData folk2) {
        for (int b = 0; b < SimukraftReloaded.theRelationships.size(); ++b) {
            Relationship rel = SimukraftReloaded.theRelationships.get(b);
            try {
                if (folk2 == null && rel.folk2 == null && rel.folk1.name.contentEquals(folk1.name)) {
                    return rel;
                }
                if (rel.folk1.name.contentEquals(folk1.name) && rel.folk2.name.contentEquals(folk2.name)) {
                    return rel;
                }
                if (!rel.folk1.name.contentEquals(folk2.name) || !rel.folk2.name.contentEquals(folk1.name)) continue;
                return rel;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public static ArrayList<Relationship> getRelationshipsFor(FolkData theFolk) {
        ArrayList<Relationship> rels = new ArrayList<Relationship>();
        for (int i = 0; i < SimukraftReloaded.theRelationships.size(); ++i) {
            try {
                Relationship rel = SimukraftReloaded.theRelationships.get(i);
                if (!rel.folk1.name.contentEquals(theFolk.name) && !rel.folk2.name.contentEquals(theFolk.name)) continue;
                rels.add(rel);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rels;
    }

    public static boolean isFolkLivingWithSomeone(FolkData theFolk) {
        ArrayList<Relationship> rels = Relationship.getRelationshipsFor(theFolk);
        boolean ret = false;
        for (int i = 0; i < rels.size(); ++i) {
            Relationship rel = rels.get(i);
            if (rel.theLevel != Level.MARRIED && rel.theLevel != Level.PARTNER) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static FolkData isFolkLivingWithSomeone(FolkData theFolk, boolean returnFolk) {
        ArrayList<Relationship> rels = Relationship.getRelationshipsFor(theFolk);
        for (int i = 0; i < rels.size(); ++i) {
            Relationship rel = rels.get(i);
            if (rel.theLevel != Level.MARRIED && rel.theLevel != Level.PARTNER) continue;
            if (rel.folk1.name.contentEquals(theFolk.name)) {
                return FolkData.getFolkByName(rel.folk2.name);
            }
            return FolkData.getFolkByName(rel.folk1.name);
        }
        return null;
    }

    public static enum Level {
        ENEMY,
        DESPISE,
        HATE,
        DISLIKE,
        AQUAINTANCE,
        FRIEND,
        GOODFRIEND,
        BESTFRIENDS,
        PARTNER,
        MARRIED,
        MOTHERDAUGHTER,
        MOTHERSON,
        FATHERDAUGHTER,
        FATHERSON,
        SISTERSISTER,
        BROTHERBROTHER,
        SISTERBROTHER,
        GRANDMOTHERDAUGHTER,
        GRANDMOTHERSON,
        GRANDFATHERDAUGHTER,
        GRANDFATHERSON,
        AUNTNEPHEW,
        AUNTNEICE,
        UNCLENEPHEW,
        UNCLENEICE;

    }
}

