/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class PricesForBlocks
implements Serializable {
    private static final long serialVersionUID = -2617939458756927761L;
    private static Float basePricePlanks = Float.valueOf(0.0131f);
    private static Float basePriceLogs = Float.valueOf(0.0524f);
    private static Float basePriceCobblestone = Float.valueOf(0.0032f);
    private static Float basePriceStone = Float.valueOf(0.0141f);
    private static Float basePriceGlass = Float.valueOf(0.0121f);
    private static Float basePriceWool = Float.valueOf(0.0115f);
    private static Float basePriceBrick = Float.valueOf(0.0251f);
    private static Float basePriceStonebrick = Float.valueOf(0.0261f);
    private static Float basePriceFence = Float.valueOf(0.0113f);
    public static Float bankPriceDiamond = Float.valueOf(10.23f);
    public static Float bankPriceEmerald = Float.valueOf(9.34f);
    public static Float bankPriceRedstone = Float.valueOf(3.75f);
    public static Float bankPriceGlowstone = Float.valueOf(2.48f);
    public static Float bankPriceGold = Float.valueOf(5.12f);

    public static Float getPrice(Block block, boolean isBuying) {
        float base = 0.0f;
        if (block == Blocks.field_150344_f) {
            base = basePricePlanks.floatValue();
        } else if (block == Blocks.field_150364_r) {
            base = basePriceLogs.floatValue();
        } else if (block == Blocks.field_150347_e) {
            base = basePriceCobblestone.floatValue();
        } else if (block == Blocks.field_150348_b) {
            base = basePriceStone.floatValue();
        } else if (block == Blocks.field_150359_w) {
            base = basePriceGlass.floatValue();
        } else if (block == Blocks.field_150325_L) {
            base = basePriceWool.floatValue();
        } else if (block == Blocks.field_150336_V) {
            base = basePriceBrick.floatValue();
        } else if (block == Blocks.field_150417_aV) {
            base = basePriceStonebrick.floatValue();
        } else if (block == Blocks.field_150422_aJ) {
            base = basePriceFence.floatValue();
        }
        base *= 64.0f;
        if (isBuying) {
            base = (float)((double)base + (double)base * 1.12);
        }
        return Float.valueOf(base);
    }

    public static void setPrice(Block block, float newPrice) {
        if (block == Blocks.field_150344_f) {
            basePricePlanks = Float.valueOf(newPrice);
        } else if (block == Blocks.field_150364_r) {
            basePriceLogs = Float.valueOf(newPrice);
        } else if (block == Blocks.field_150347_e) {
            basePriceCobblestone = Float.valueOf(newPrice);
        } else if (block == Blocks.field_150348_b) {
            basePriceStone = Float.valueOf(newPrice);
        } else if (block == Blocks.field_150359_w) {
            basePriceGlass = Float.valueOf(newPrice);
        } else if (block == Blocks.field_150325_L) {
            basePriceWool = Float.valueOf(newPrice);
        } else if (block == Blocks.field_150336_V) {
            basePriceBrick = Float.valueOf(newPrice);
        } else if (block == Blocks.field_150417_aV) {
            basePriceStonebrick = Float.valueOf(newPrice);
        } else if (block == Blocks.field_150422_aJ) {
            basePriceFence = Float.valueOf(newPrice);
        }
    }

    public static void adjustPrice(Block block, boolean afterBuying) {
        float cprice;
        Random r = new Random();
        if (afterBuying) {
            cprice = PricesForBlocks.getPrice(block, false).floatValue() / 64.0f;
            if ((double)(cprice += r.nextFloat() / 100.0f) > 0.99) {
                cprice = 0.99f;
            }
            PricesForBlocks.setPrice(block, cprice);
        } else {
            cprice = PricesForBlocks.getPrice(block, false).floatValue() / 64.0f;
            if ((double)(cprice -= r.nextFloat() / 100.0f) < 0.012) {
                cprice = 0.012f;
            }
            PricesForBlocks.setPrice(block, cprice);
        }
        if (block == Blocks.field_150344_f) {
            PricesForBlocks.setPrice(Blocks.field_150364_r, cprice * 4.0f);
        }
        if (block == Blocks.field_150364_r) {
            PricesForBlocks.setPrice(Blocks.field_150344_f, cprice / 4.0f);
        }
    }

    public static String formatPrice(float price) {
        DecimalFormat formatter = new DecimalFormat("#0.00");
        return formatter.format(price);
    }
}

