/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common;

import ashjack.simukraftreloaded.common.jobs.Job;
import ashjack.simukraftreloaded.core.ModSimukraft;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;

public class CourierTask
implements Serializable {
    private static final long serialVersionUID = 1825349728277158061L;
    public String name = "";
    public String folkname = "";
    public CommonProxy.V3 pickup = new CommonProxy.V3();
    public CommonProxy.V3 dropoff = new CommonProxy.V3();
    public boolean repeat = true;

    public static CommonProxy.V3 getCourierPoint(String name) {
        CommonProxy.V3 v = new CommonProxy.V3();
        for (int x = 0; x < SimukraftReloaded.theCourierPoints.size(); ++x) {
            v = SimukraftReloaded.theCourierPoints.get(x);
            if (!v.name.contentEquals(name)) continue;
            return v;
        }
        return null;
    }

    private static boolean alreadyGotTask(CourierTask theTask) {
        boolean got = false;
        for (int i = 0; i < SimukraftReloaded.theCourierTasks.size(); ++i) {
            CourierTask checkTask = SimukraftReloaded.theCourierTasks.get(i);
            try {
                if (!checkTask.pickup.name.contentEquals(theTask.name)) continue;
                got = true;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return got;
    }

    private static boolean alreadyGotPoint(CommonProxy.V3 thePoint) {
        boolean got = false;
        for (int i = 0; i < SimukraftReloaded.theCourierPoints.size(); ++i) {
            CommonProxy.V3 checkPoint = SimukraftReloaded.theCourierPoints.get(i);
            if (!checkPoint.isSameCoordsAs(thePoint, true, true)) continue;
            got = true;
            break;
        }
        return got;
    }

    public static void loadCourierTasksAndPoints() {
        SimukraftReloaded.theCourierPoints.clear();
        SimukraftReloaded.theCourierTasks.clear();
        File courierPoints = new File(SimukraftReloaded.getSavesDataFolder() + "CourierPoints" + File.separator);
        courierPoints.mkdirs();
        File courierTasks = new File(SimukraftReloaded.getSavesDataFolder() + "CourierTasks" + File.separator);
        courierTasks.mkdirs();
        boolean useNewFormat = false;
        for (File f : courierPoints.listFiles()) {
            if (!f.getName().endsWith(".sk2")) continue;
            useNewFormat = true;
            break;
        }
        if (useNewFormat) {
            String value;
            String name;
            int m1;
            ArrayList<String> strings;
            for (File f : courierPoints.listFiles()) {
                if (!f.getName().endsWith(".sk2")) continue;
                strings = SimukraftReloaded.loadSK2(f.getAbsoluteFile().toString());
                CommonProxy.V3 v = new CommonProxy.V3();
                for (String line : strings) {
                    if (!line.contains("|")) continue;
                    m1 = line.indexOf("|");
                    name = line.substring(0, m1);
                    value = line.substring(m1 + 1);
                    if (name.contentEquals("location")) {
                        v = new CommonProxy.V3(value);
                        continue;
                    }
                    if (!name.contentEquals("name")) continue;
                    v.name = value;
                }
                if (v != null && !CourierTask.alreadyGotPoint(v)) {
                    SimukraftReloaded.theCourierPoints.add(v);
                    continue;
                }
                f.delete();
            }
            for (File f : courierTasks.listFiles()) {
                if (!f.getName().endsWith(".sk2")) continue;
                strings = SimukraftReloaded.loadSK2(f.getAbsoluteFile().toString());
                CourierTask ct = new CourierTask();
                for (String line : strings) {
                    if (!line.contains("|")) continue;
                    m1 = line.indexOf("|");
                    name = line.substring(0, m1);
                    value = line.substring(m1 + 1);
                    if (name.contentEquals("folk")) {
                        ct.folkname = value;
                        continue;
                    }
                    if (name.contentEquals("pickup")) {
                        ct.pickup = new CommonProxy.V3(value);
                        continue;
                    }
                    if (name.contentEquals("dropoff")) {
                        if (value.contentEquals("null")) continue;
                        ct.dropoff = new CommonProxy.V3(value);
                        continue;
                    }
                    if (name.contentEquals("repeat")) {
                        ct.repeat = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (!name.contentEquals("name")) continue;
                    ct.name = value;
                }
                if (!CourierTask.alreadyGotTask(ct) && ct != null && ct.dropoff != null && ct.pickup != null) {
                    SimukraftReloaded.theCourierTasks.add(ct);
                    continue;
                }
                f.delete();
            }
        } else {
            for (File f : courierPoints.listFiles()) {
                if (!f.getName().endsWith(".suk")) continue;
                CommonProxy.V3 point = (CommonProxy.V3)ModSimukraft.proxy.loadObject(f.getAbsoluteFile().toString());
                if (!CourierTask.alreadyGotPoint(point)) {
                    SimukraftReloaded.theCourierPoints.add(point);
                    continue;
                }
                f.delete();
            }
            for (File f : courierTasks.listFiles()) {
                if (!f.getName().endsWith(".suk")) continue;
                CourierTask task = (CourierTask)ModSimukraft.proxy.loadObject(f.getAbsoluteFile().toString());
                if (!CourierTask.alreadyGotTask(task)) {
                    SimukraftReloaded.theCourierTasks.add(task);
                    continue;
                }
                f.delete();
            }
        }
    }

    public static void saveCourierTasksAndPoints() {
        String names = "";
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            ArrayList<String> strings;
            int mofo;
            for (mofo = 0; mofo < SimukraftReloaded.theCourierPoints.size(); ++mofo) {
                strings = new ArrayList<String>();
                CommonProxy.V3 point = SimukraftReloaded.theCourierPoints.get(mofo);
                if (point == null) continue;
                ArrayList<IInventory> chests = Job.inventoriesFindClosest(point, 5);
                String fn = "cp" + point.x.intValue() + "_" + point.y.intValue() + "_" + point.z.intValue() + "_D" + point.theDimension;
                if (chests.size() > 0) {
                    if (names.contains(point.name)) continue;
                    names = names + " " + point.name;
                    strings.add("location|" + point.toString());
                    strings.add("name|" + point.name);
                    SimukraftReloaded.saveSK2(SimukraftReloaded.getSavesDataFolder() + "CourierPoints" + File.separator + fn + ".sk2", strings);
                    continue;
                }
                try {
                    File fi = new File(SimukraftReloaded.getSavesDataFolder() + "CourierPoints" + File.separator + fn + ".sk2");
                    fi.delete();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (mofo = 0; mofo < SimukraftReloaded.theCourierTasks.size(); ++mofo) {
                strings = new ArrayList();
                CourierTask task = SimukraftReloaded.theCourierTasks.get(mofo);
                String fn = "ct" + mofo + task.folkname.replace(" ", "");
                boolean okToSave = true;
                strings.add("folk|" + task.folkname);
                strings.add("pickup|" + task.pickup.toString());
                if (task.dropoff == null) {
                    strings.add("dropoff|null");
                } else {
                    try {
                        strings.add("dropoff|" + task.dropoff.toString());
                    }
                    catch (Exception e) {
                        okToSave = false;
                    }
                }
                strings.add("repeat|" + task.repeat);
                strings.add("name|" + task.name);
                if (!okToSave) continue;
                SimukraftReloaded.saveSK2(SimukraftReloaded.getSavesDataFolder() + "CourierTasks" + File.separator + fn + ".sk2", strings);
            }
        }
    }
}

