/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.common;

import ashjack.simukraftreloaded.blocks.functionality.FarmingBox;
import ashjack.simukraftreloaded.blocks.functionality.MiningBox;
import ashjack.simukraftreloaded.client.Gui.other.GuiRunMod;
import ashjack.simukraftreloaded.common.CourierTask;
import ashjack.simukraftreloaded.common.Relationship;
import ashjack.simukraftreloaded.core.ModSimukraft;
import ashjack.simukraftreloaded.core.building.Building;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedConfig;
import ashjack.simukraftreloaded.folk.FolkData;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class CommonTickHandler {
    private World serverWorld = null;
    Long lastSecondTickAt = 0L;
    Long lastMinuteTickAt = 0L;
    GuiRunMod runModui = null;
    String currentWorld = "";
    Minecraft mc = Minecraft.func_71410_x();
    long lastReset = 0L;
    boolean haveRunStartup = false;
    int ticks = 0;
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("SUKMain");

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (this.ticks == 200) {
            this.onTickInGame();
        } else {
            ++this.ticks;
        }
    }

    public void onTickInGame() {
        if (this.mc.field_71462_r != null && this.mc.field_71462_r.toString().toLowerCase().contains("guimainmenu")) {
            SimukraftReloaded.log.info("CommTH: in Gui Main menu");
        }
        if (SimukraftReloaded.states.gameModeNumber == 10) {
            ModSimukraft.proxy.ranStartup = true;
            return;
        }
        Long now = System.currentTimeMillis();
        if (this.serverWorld != null) {
            FolkData.triggerAllUpdates();
            SimukraftReloaded.dayTransitionHandler();
            if (SimukraftReloaded.farmToUpgrade != null) {
                SimukraftReloaded.upgradeFarm();
            }
            if (SimukraftReloaded.demolishBlocks.size() > 0) {
                SimukraftReloaded.demolishBlocks();
            }
        }
        if (now - this.lastSecondTickAt > 1000L) {
            if (!ModSimukraft.proxy.ranStartup) {
                System.out.println("Haven't run startup - doing that now");
                this.serverWorld = MinecraftServer.func_71276_C().func_130014_f_();
                this.currentWorld = SimukraftReloaded.getSavesDataFolder();
                SimukraftReloaded.log.info("CommTH: Startup - set serverWorld/currentWorld");
                System.out.println("Running Reset World Function");
                SimukraftReloaded.resetAndLoadNewWorld();
            } else {
                if (!this.currentWorld.contentEquals(SimukraftReloaded.getSavesDataFolder()) && now - this.lastReset > 30000L) {
                    SimukraftReloaded.log.info("currentWorld=" + this.currentWorld + "     getSaves=" + SimukraftReloaded.getSavesDataFolder());
                    this.currentWorld = SimukraftReloaded.getSavesDataFolder();
                    ModSimukraft.proxy.ranStartup = false;
                    SimukraftReloaded.resetAndLoadNewWorld();
                }
                if (this.serverWorld.func_72896_J() && this.serverWorld.func_72912_H().func_76083_p() > 1 && SimukraftReloadedConfig.configStopRain) {
                    this.serverWorld.func_72912_H().func_76080_g(2);
                }
            }
            this.lastSecondTickAt = now;
        }
        if (this.serverWorld != null && System.currentTimeMillis() - this.lastMinuteTickAt > 60000L) {
            if (this.lastMinuteTickAt > 0L) {
                Long start = System.currentTimeMillis();
                FolkData.generateNewFolk(this.serverWorld);
                SimukraftReloaded.states.saveStates();
                Building.checkTennants();
                Building.saveAllBuildings();
                CourierTask.saveCourierTasksAndPoints();
                MiningBox.saveMiningBoxes();
                FarmingBox.saveFarmingBoxes();
                Relationship.saveRelationships();
                SimukraftReloaded.log.info("CTH: Saved game data in " + (System.currentTimeMillis() - start) + " ms");
            }
            this.lastMinuteTickAt = now;
        }
    }

    public void resetSimUKraft() {
        if (System.currentTimeMillis() - this.lastReset > 30000L) {
            this.lastReset = System.currentTimeMillis();
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            SimukraftReloaded.log.info(side.toString() + "-side CommTH: resetSimUKraft()");
        }
    }

    private void startingWorld() {
        if (!ModSimukraft.proxy.ranStartup) {
            // empty if block
        }
    }

    public String getLabel() {
        return "CommonTickHandler";
    }
}

