/*
 * Decompiled with CFR 0.152.
 */
package ashjack.simukraftreloaded.blocks.functionality;

import ashjack.simukraftreloaded.core.ModSimukraft;
import ashjack.simukraftreloaded.core.registry.SimukraftReloaded;
import ashjack.simukraftreloaded.core.registry.SimukraftReloadedBlocks;
import ashjack.simukraftreloaded.proxies.CommonProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class FarmingBox
implements Serializable {
    private static final long serialVersionUID = -4049876797684922153L;
    public CommonProxy.V3 location;
    public CommonProxy.V3 marker1XYZ;
    public CommonProxy.V3 marker2XYZ;
    public CommonProxy.V3 marker3XYZ;
    public FarmType farmType = FarmType.WHEAT;
    public int level = 1;

    public FarmingBox() {
    }

    public FarmingBox(CommonProxy.V3 inxyz) {
        this.location = inxyz;
        if (this.level == 0) {
            this.level = 1;
        }
    }

    public FarmingBox(CommonProxy.V3 inxyz, CommonProxy.V3 m1xyz, CommonProxy.V3 m2xyz, CommonProxy.V3 m3xyz) {
        this.location = inxyz;
        this.marker1XYZ = m1xyz;
        this.marker2XYZ = m2xyz;
        this.marker3XYZ = m3xyz;
        if (this.level == 0) {
            this.level = 1;
        }
    }

    public CommonProxy.V3 getMarkerVector(int markerNum) {
        CommonProxy.V3 ret = null;
        try {
            if (markerNum == 1) {
                ret = this.marker1XYZ;
            } else if (markerNum == 2) {
                ret = this.marker2XYZ;
            } else if (markerNum == 3) {
                ret = this.marker3XYZ;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonProxy.V3(0.0, 0.0, 0.0, 0);
        }
        return ret;
    }

    public int getSizeWidth() {
        int ltr = 0;
        try {
            CommonProxy.V3 m1 = this.getMarkerVector(1);
            CommonProxy.V3 m2 = this.getMarkerVector(2);
            CommonProxy.V3 m3 = this.getMarkerVector(3);
            ltr = m1.x.intValue() == m2.x.intValue() ? (int)(Math.abs(m2.z - m1.z) - 1.0) : (int)(Math.abs(m2.x - m1.x) - 1.0);
        }
        catch (Exception e) {
            return 5;
        }
        return Math.abs(ltr);
    }

    public int getSizeLength() {
        int ftb = 0;
        try {
            CommonProxy.V3 m1 = this.getMarkerVector(1);
            CommonProxy.V3 m2 = this.getMarkerVector(2);
            CommonProxy.V3 m3 = this.getMarkerVector(3);
            ftb = m1.x.intValue() == m3.x.intValue() ? (int)(Math.abs(m3.z - m1.z) - 1.0) : (int)(Math.abs(m3.x - m1.x) - 1.0);
        }
        catch (Exception e) {
            return 5;
        }
        return Math.abs(ftb);
    }

    public ArrayList<CommonProxy.V3> getSoilBlockPoints() {
        ArrayList<CommonProxy.V3> ret = new ArrayList<CommonProxy.V3>();
        CommonProxy.V3 m1 = this.getMarkerVector(1);
        CommonProxy.V3 m2 = this.getMarkerVector(2);
        CommonProxy.V3 m3 = this.getMarkerVector(3);
        CommonProxy.V3 c = m1.clone();
        int length = this.getSizeLength();
        if (length == 1) {
            SimukraftReloaded.log.warning("FarmingBox: Farm size cannot be determined, using 5x5 default");
        }
        for (int o = 0; o <= length; ++o) {
            for (int i = 0; i <= this.getSizeWidth(); ++i) {
                ret.add(c.clone());
                if (m2.x > m1.x) {
                    c.x = m1.x + (double)i;
                    continue;
                }
                if (m2.x < m1.x) {
                    c.x = m1.x - (double)i;
                    continue;
                }
                if (m2.z > m1.z) {
                    c.z = m1.z + (double)i;
                    continue;
                }
                if (!(m2.z < m1.z)) continue;
                c.z = m1.z - (double)i;
            }
            if (m3.x > m1.x) {
                c.x = m1.x + (double)o;
                continue;
            }
            if (m3.x < m1.x) {
                c.x = m1.x - (double)o;
                continue;
            }
            if (m3.z > m1.z) {
                c.z = m1.z + (double)o;
                continue;
            }
            if (!(m3.z < m1.z)) continue;
            c.z = m1.z - (double)o;
        }
        return ret;
    }

    public ArrayList<CommonProxy.V3> getPerimeterPoints() {
        ArrayList<CommonProxy.V3> ret = new ArrayList<CommonProxy.V3>();
        try {
            Double d;
            Double d2;
            CommonProxy.V3 v3;
            int i;
            CommonProxy.V3 m1 = this.getMarkerVector(1);
            CommonProxy.V3 m2 = this.getMarkerVector(2);
            CommonProxy.V3 m3 = this.getMarkerVector(3);
            CommonProxy.V3 b = this.getLocation();
            CommonProxy.V3 c = b.clone();
            for (i = 0; i <= this.getSizeWidth() + 1; ++i) {
                if (m2.x - b.x > 1.0) {
                    v3 = c;
                    d2 = v3.x;
                    d = v3.x = Double.valueOf(v3.x + 1.0);
                } else if (m2.x - b.x < -1.0) {
                    v3 = c;
                    d2 = v3.x;
                    d = v3.x = Double.valueOf(v3.x - 1.0);
                } else if (m2.z - b.z > 1.0) {
                    v3 = c;
                    d2 = v3.z;
                    d = v3.z = Double.valueOf(v3.z + 1.0);
                } else if (m2.z - b.z < -1.0) {
                    v3 = c;
                    d2 = v3.z;
                    d = v3.z = Double.valueOf(v3.z - 1.0);
                }
                ret.add(c.clone());
            }
            for (i = 0; i <= this.getSizeLength() + 2; ++i) {
                if (m3.x - b.x > 1.0) {
                    v3 = c;
                    d2 = v3.x;
                    d = v3.x = Double.valueOf(v3.x + 1.0);
                } else if (m3.x - b.x < -1.0) {
                    v3 = c;
                    d2 = v3.x;
                    d = v3.x = Double.valueOf(v3.x - 1.0);
                } else if (m3.z - b.z > 1.0) {
                    v3 = c;
                    d2 = v3.z;
                    d = v3.z = Double.valueOf(v3.z + 1.0);
                } else if (m3.z - b.z < -1.0) {
                    v3 = c;
                    d2 = v3.z;
                    d = v3.z = Double.valueOf(v3.z - 1.0);
                }
                ret.add(c.clone());
            }
            for (i = 0; i <= this.getSizeWidth() + 2; ++i) {
                if (m2.x - b.x > 1.0) {
                    v3 = c;
                    d2 = v3.x;
                    d = v3.x = Double.valueOf(v3.x - 1.0);
                } else if (m2.x - b.x < -1.0) {
                    v3 = c;
                    d2 = v3.x;
                    d = v3.x = Double.valueOf(v3.x + 1.0);
                } else if (m2.z - b.z > 1.0) {
                    v3 = c;
                    d2 = v3.z;
                    d = v3.z = Double.valueOf(v3.z - 1.0);
                } else if (m2.z - b.z < -1.0) {
                    v3 = c;
                    d2 = v3.z;
                    d = v3.z = Double.valueOf(v3.z + 1.0);
                }
                ret.add(c.clone());
            }
            for (i = 0; i <= this.getSizeLength() + 2; ++i) {
                if (m3.x - b.x > 1.0) {
                    v3 = c;
                    d2 = v3.x;
                    d = v3.x = Double.valueOf(v3.x - 1.0);
                } else if (m3.x - b.x < -1.0) {
                    v3 = c;
                    d2 = v3.x;
                    d = v3.x = Double.valueOf(v3.x + 1.0);
                } else if (m3.z - b.z > 1.0) {
                    v3 = c;
                    d2 = v3.z;
                    d = v3.z = Double.valueOf(v3.z - 1.0);
                } else if (m3.z - b.z < -1.0) {
                    v3 = c;
                    d2 = v3.z;
                    d = v3.z = Double.valueOf(v3.z + 1.0);
                }
                ret.add(c.clone());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public CommonProxy.V3 getLocation() {
        return this.location;
    }

    public static FarmingBox getFarmingBlockByBoxXYZ(CommonProxy.V3 xyz) {
        FarmingBox ret = null;
        if (SimukraftReloaded.theFarmingBoxes.size() == 0) {
            FarmingBox.loadFarmingBoxes();
        }
        for (int x = 0; x < SimukraftReloaded.theFarmingBoxes.size(); ++x) {
            FarmingBox block = SimukraftReloaded.theFarmingBoxes.get(x);
            if (!block.location.isSameCoordsAs(xyz, true, true)) continue;
            ret = block;
            break;
        }
        return ret;
    }

    public static void loadFarmingBoxes() {
        Minecraft mc = Minecraft.func_71410_x();
        File farmFiles = new File(SimukraftReloaded.getSavesDataFolder() + "Farming" + File.separator);
        farmFiles.mkdirs();
        boolean useNewFormat = false;
        for (File f : farmFiles.listFiles()) {
            if (!f.getName().endsWith(".sk2")) continue;
            useNewFormat = true;
            break;
        }
        if (useNewFormat) {
            SimukraftReloaded.theFarmingBoxes.clear();
            for (File f : farmFiles.listFiles()) {
                if (!f.getName().endsWith(".sk2")) continue;
                ArrayList<String> strings = SimukraftReloaded.loadSK2(f.getAbsoluteFile().toString());
                FarmingBox box = new FarmingBox();
                for (String line : strings) {
                    if (!line.contains("|")) continue;
                    int m1 = line.indexOf("|");
                    String name = line.substring(0, m1);
                    String value = line.substring(m1 + 1);
                    if (name.contentEquals("location")) {
                        box.location = new CommonProxy.V3(value);
                        continue;
                    }
                    if (name.contentEquals("m1")) {
                        if (value.contentEquals("null")) continue;
                        box.marker1XYZ = new CommonProxy.V3(value);
                        continue;
                    }
                    if (name.contentEquals("m2")) {
                        if (value.contentEquals("null")) continue;
                        box.marker2XYZ = new CommonProxy.V3(value);
                        continue;
                    }
                    if (name.contentEquals("m3")) {
                        if (value.contentEquals("null")) continue;
                        box.marker3XYZ = new CommonProxy.V3(value);
                        continue;
                    }
                    if (name.contentEquals("type")) {
                        box.farmType = FarmType.valueOf(value);
                        continue;
                    }
                    if (!name.contentEquals("level")) continue;
                    box.level = Integer.parseInt(value);
                }
                WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(box.location.theDimension);
                if (theWorld == null) continue;
                Block id = theWorld.func_147439_a(box.location.x.intValue(), box.location.y.intValue(), box.location.z.intValue());
                if (id == SimukraftReloadedBlocks.farmingBox) {
                    SimukraftReloaded.theFarmingBoxes.add(box);
                    continue;
                }
                f.delete();
            }
        } else {
            for (File f : farmFiles.listFiles()) {
                if (!f.getName().endsWith(".suk")) continue;
                FarmingBox farming = (FarmingBox)ModSimukraft.proxy.loadObject(f.getAbsoluteFile().toString());
                if (farming != null) {
                    CommonProxy.V3 xyz = farming.location;
                    WorldServer theWorld = MinecraftServer.func_71276_C().func_71218_a(xyz.theDimension);
                    if (theWorld == null) {
                        f.delete();
                        continue;
                    }
                    try {
                        Block id = theWorld.func_147439_a(xyz.x.intValue(), xyz.y.intValue(), xyz.z.intValue());
                        if (id == SimukraftReloadedBlocks.farmingBox) {
                            SimukraftReloaded.theFarmingBoxes.add(farming);
                            continue;
                        }
                        f.delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                f.delete();
                SimukraftReloaded.sendChat("One of your farming boxes had a problem with it, you may have to replace it");
            }
        }
    }

    public static void saveFarmingBoxes() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            ArrayList<String> strings = new ArrayList<String>();
            for (int b = 0; b < SimukraftReloaded.theFarmingBoxes.size(); ++b) {
                FarmingBox farming = SimukraftReloaded.theFarmingBoxes.get(b);
                strings.clear();
                if (farming == null || farming.location == null || farming.marker1XYZ == null) continue;
                try {
                    strings.add("location|" + farming.location.toString());
                    strings.add("m1|" + farming.marker1XYZ.toString());
                    strings.add("m2|" + farming.marker2XYZ.toString());
                    strings.add("m3|" + farming.marker3XYZ.toString());
                    strings.add("type|" + farming.farmType.name());
                    strings.add("level|" + farming.level);
                    String xyz = "f" + farming.location.toString().replaceAll(",", "_");
                    SimukraftReloaded.saveSK2(SimukraftReloaded.getSavesDataFolder() + "Farming" + File.separator + xyz + ".sk2", strings);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static enum FarmType {
        WHEAT,
        MELON,
        PUMPKIN,
        POTATO,
        CARROT,
        CUSTOM,
        SUGAR,
        CACTUS;


        public String toString() {
            if (this == CARROT) {
                return "\u80e1\u841d\u535c";
            }
            if (this == MELON) {
                return "\u897f\u74dc";
            }
            if (this == POTATO) {
                return "\u571f\u8c46";
            }
            if (this == PUMPKIN) {
                return "\u5357\u74dc";
            }
            if (this == WHEAT) {
                return "\u5c0f\u9ea6";
            }
            if (this == CUSTOM) {
                return "\u81ea\u5b9a\u4e49";
            }
            if (this == SUGAR) {
                return "\u7518\u8517";
            }
            if (this == CACTUS) {
                return "\u4ed9\u4eba\u638c";
            }
            return "\u672a\u77e5";
        }
    }
}

