/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.server;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.common.PacketHandler;
import com.kingrunes.somnia.common.PlayerSleepTickHandler;
import com.kingrunes.somnia.common.util.SomniaEntityPlayerProperties;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.EntityEvent;

public class ForgeEventHandler {
    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity.field_70170_p != null && !event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            SomniaEntityPlayerProperties.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        boolean isSleeping;
        if (event.phase != TickEvent.Phase.START || event.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.player;
        SomniaEntityPlayerProperties props = SomniaEntityPlayerProperties.get(player);
        if (props == null) {
            props = SomniaEntityPlayerProperties.register(player);
        }
        double fatigue = props.getFatigue();
        boolean bl = isSleeping = PlayerSleepTickHandler.serverState.sleepOverride || player.func_70608_bn();
        if (!player.field_71075_bZ.field_75098_d) {
            fatigue = isSleeping ? (fatigue -= Somnia.proxy.fatigueReplenishRate) : (fatigue += Somnia.proxy.fatigueRate);
        }
        if (fatigue > 100.0) {
            fatigue = 100.0;
        } else if (fatigue < 0.0) {
            fatigue = 0.0;
        }
        props.setFatigue(fatigue);
        if (++props.fatigueUpdateCounter >= 100 || props.fatigueUpdateCounter == 0) {
            props.fatigueUpdateCounter = 0;
            ForgeEventHandler.sendFatigueUpdate((EntityPlayerMP)player, fatigue);
            if (Somnia.proxy.fatigueSideEffects && !player.field_71075_bZ.field_75098_d) {
                if (fatigue > 70.0 && props.lastSideEffectStage < 70) {
                    props.lastSideEffectStage = 70;
                    player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 0));
                } else if (fatigue > 80.0 && props.lastSideEffectStage < 80) {
                    props.lastSideEffectStage = 80;
                    player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 300, 2));
                } else if (fatigue > 90.0 && props.lastSideEffectStage < 90) {
                    props.lastSideEffectStage = 90;
                    player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 1));
                } else if (fatigue > 95.0) {
                    player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 150, 3));
                } else if (fatigue < 70.0) {
                    props.lastSideEffectStage = -1;
                }
            }
        }
    }

    public static void sendFatigueUpdate(EntityPlayerMP player, double fatigue) {
        Somnia.channel.sendTo(PacketHandler.buildPropUpdatePacket(1, 0, fatigue), player);
    }
}

