/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.common;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.common.StreamUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;

public class PacketHandler {
    private static HashMap<Byte, FMLProxyPacket> cache = new HashMap();

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        if (event.packet.channel().equals("Somnia")) {
            this.onPacket(event.packet, ((NetHandlerPlayServer)event.handler).field_147369_b);
        }
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        if (event.packet.channel().equals("Somnia")) {
            this.onPacket(event.packet, null);
        }
    }

    public void onPacket(FMLProxyPacket packet, EntityPlayerMP player) {
        DataInputStream in = new DataInputStream((InputStream)new ByteBufInputStream(packet.payload()));
        try {
            byte id = in.readByte();
            switch (id) {
                case 0: {
                    this.handleGUIOpenPacket();
                    break;
                }
                case 1: {
                    this.handleGUIClosePacket(player, in);
                    break;
                }
                case 2: {
                    this.handlePropUpdatePacket(in);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleGUIOpenPacket() throws IOException {
        Somnia.proxy.handleGUIOpenPacket();
    }

    private void handlePropUpdatePacket(DataInputStream in) throws IOException {
        Somnia.proxy.handlePropUpdatePacket(in);
    }

    private void handleGUIClosePacket(EntityPlayerMP player, DataInputStream in) throws IOException {
        Somnia.proxy.handleGUIClosePacket(player);
    }

    private static void close(OutputStream os) {
        try {
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static FMLProxyPacket buildGUIOpenPacket() {
        FMLProxyPacket packet = cache.get(PacketHandler.byteOf(0));
        if (packet == null) {
            packet = PacketHandler.doBuildGUIOpenPacket();
            cache.put(PacketHandler.byteOf(0), packet);
        }
        return packet;
    }

    private static FMLProxyPacket doBuildGUIOpenPacket() {
        ByteBufOutputStream bbos = PacketHandler.unpooled();
        try {
            bbos.writeByte(0);
            FMLProxyPacket fMLProxyPacket = new FMLProxyPacket(bbos.buffer(), "Somnia");
            return fMLProxyPacket;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(ioe);
        }
        finally {
            PacketHandler.close((OutputStream)bbos);
        }
    }

    public static FMLProxyPacket buildGUIClosePacket() {
        FMLProxyPacket packet = cache.get(PacketHandler.byteOf(1));
        if (packet == null) {
            packet = PacketHandler.doBuildGUIOpenPacket();
            cache.put(PacketHandler.byteOf(1), packet);
        }
        return packet;
    }

    public static FMLProxyPacket doBuildGUIClosePacket() {
        ByteBufOutputStream bbos = PacketHandler.unpooled();
        try {
            bbos.writeByte(1);
            FMLProxyPacket fMLProxyPacket = new FMLProxyPacket(bbos.buffer(), "Somnia");
            return fMLProxyPacket;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(ioe);
        }
        finally {
            PacketHandler.close((OutputStream)bbos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FMLProxyPacket buildPropUpdatePacket(int target, Object ... fields) {
        ByteBufOutputStream bbos = PacketHandler.unpooled();
        try {
            bbos.writeByte(2);
            bbos.writeByte(target);
            bbos.writeInt(fields.length / 2);
            for (int i = 0; i < fields.length; ++i) {
                bbos.writeByte(((Integer)fields[i]).intValue());
                StreamUtils.writeObject(fields[++i], bbos);
            }
            FMLProxyPacket i = new FMLProxyPacket(bbos.buffer(), "Somnia");
            return i;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            PacketHandler.close((OutputStream)bbos);
        }
        return null;
    }

    private static ByteBufOutputStream unpooled() {
        return new ByteBufOutputStream(Unpooled.buffer());
    }

    public static Byte byteOf(int i) {
        return (byte)i;
    }
}

