/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.common;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.SomniaVersion;
import com.kingrunes.somnia.common.PacketHandler;
import com.kingrunes.somnia.common.PlayerSleepTickHandler;
import com.kingrunes.somnia.common.util.ClassUtils;
import com.kingrunes.somnia.common.util.SomniaEntityPlayerProperties;
import com.kingrunes.somnia.common.util.TimePeriod;
import com.kingrunes.somnia.server.ForgeEventHandler;
import com.kingrunes.somnia.server.ServerTickHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.WorldEvent;

public class CommonProxy {
    private static final int CONFIG_VERSION = 2;
    public TimePeriod enterSleepPeriod;
    public TimePeriod validSleepPeriod;
    public double fatigueRate;
    public double fatigueReplenishRate;
    public double minimumFatigueToSleep;
    public double baseMultiplier;
    public double multiplierCap;
    public boolean fatigueSideEffects;
    public boolean tpsGraph;
    public boolean secondsOnGraph;
    public boolean sleepWithArmor;
    public boolean vanillaBugFixes;
    public boolean fading;
    public boolean somniaGui;
    public boolean muteSoundWhenSleeping;
    public boolean ignoreMonsters;
    public boolean checkForUpdates;
    public boolean disableCreatureSpawning;
    public boolean disableRendering;
    public boolean disableMoodSoundAndLightCheck;
    public String displayFatigue;
    public int ticksPerDay;
    public int halfTicksPerDay;
    public static ForgeEventHandler forgeEventHandler;
    private static long lastUpdateCheck;

    public void configure(File file) {
        Configuration config = new Configuration(file);
        config.load();
        Property property = config.get("general", "configVersion", 0);
        if (property.getInt() != 2) {
            file.delete();
        }
        config = new Configuration(file);
        config.load();
        config.get("general", "configVersion", 2);
        this.enterSleepPeriod = new TimePeriod(config.get("timings", "enterSleepStart", 0).getInt(), config.get("timings", "enterSleepEnd", 24000).getInt());
        this.validSleepPeriod = new TimePeriod(config.get("timings", "validSleepStart", 0).getInt(), config.get("timings", "validSleepEnd", 24000).getInt());
        this.ticksPerDay = config.get("timings", "ticksPerDay", 24000).getInt();
        this.halfTicksPerDay = this.ticksPerDay / 2;
        this.fatigueSideEffects = config.get("fatigue", "fatigueSideEffects", true).getBoolean(true);
        this.displayFatigue = config.get("fatigue", "displayFatigue", "br").getString();
        this.fatigueRate = config.get("fatigue", "fatigueRate", 0.00208).getDouble(0.00208);
        this.fatigueReplenishRate = config.get("fatigue", "fatigueReplenishRate", 0.00833).getDouble(0.00833);
        this.minimumFatigueToSleep = config.get("fatigue", "minimumFatigueToSleep", 20.0).getDouble(20.0);
        this.baseMultiplier = config.get("logic", "baseMultiplier", 1.0).getDouble(1.0);
        this.multiplierCap = config.get("logic", "multiplierCap", 100.0).getDouble(100.0);
        this.sleepWithArmor = config.get("options", "sleepWithArmor", false).getBoolean(false);
        this.vanillaBugFixes = config.get("options", "vanillaBugFixes", true).getBoolean(true);
        this.fading = config.get("options", "fading", true).getBoolean(true);
        this.somniaGui = config.get("options", "somniaGui", true).getBoolean(true);
        this.muteSoundWhenSleeping = config.get("options", "muteSoundWhenSleeping", false).getBoolean(false);
        this.ignoreMonsters = config.get("options", "ignoreMonsters", false).getBoolean(false);
        this.checkForUpdates = config.get("options", "checkForUpdates", true).getBoolean(true);
        this.disableCreatureSpawning = config.get("performance", "disableCreatureSpawning", false).getBoolean(false);
        this.disableRendering = config.get("performance", "disableRendering", false).getBoolean(false);
        this.disableMoodSoundAndLightCheck = config.get("performance", "disableMoodSoundAndLightCheck", false).getBoolean(false);
        config.save();
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)new PlayerSleepTickHandler());
        forgeEventHandler = new ForgeEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)forgeEventHandler);
        FMLCommonHandler.instance().bus().register((Object)forgeEventHandler);
    }

    public boolean shouldCheckForUpdates() {
        return this.checkForUpdates && FMLCommonHandler.instance().getEffectiveSide().isClient() != this.getClass().equals(CommonProxy.class) && System.currentTimeMillis() - lastUpdateCheck > 3600000L;
    }

    private void checkForUpdates() {
        lastUpdateCheck = System.currentTimeMillis();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("[Somnia] Checking for updates...");
                try {
                    SomniaVersion.UpdateCheckerEntry result = SomniaVersion.checkForUpdates();
                    if (result != null) {
                        CommonProxy.this.printMessage(String.format("Somnia %s is available for download from: %s", result.getVersionString(), result.getUrl()));
                        if (result.getComment().length() > 0) {
                            CommonProxy.this.printMessage("Comment: " + result.getComment());
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.setName("Somnia-Updater");
        thread.start();
    }

    public void printMessage(String message) {
        System.out.println("[Somnia] " + message);
    }

    @SubscribeEvent
    public void worldLoadHook(WorldEvent.Load event) {
        if (this.shouldCheckForUpdates()) {
            this.checkForUpdates();
        }
        if (event.world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)event.world;
            Somnia.instance.tickHandlers.add(new ServerTickHandler(worldServer));
            System.out.println("[Somnia] Registering tick handler for loading world [" + worldServer.field_73011_w.field_76574_g + "]");
        }
    }

    @SubscribeEvent
    public void worldUnloadHook(WorldEvent.Unload event) {
        if (event.world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)event.world;
            Iterator<ServerTickHandler> iter = Somnia.instance.tickHandlers.iterator();
            while (iter.hasNext()) {
                ServerTickHandler serverTickHandler = iter.next();
                if (serverTickHandler.worldServer != worldServer) continue;
                System.out.println("[Somnia] Removing tick handler for unloading world [" + worldServer.field_73011_w.field_76574_g + "]");
                iter.remove();
                break;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDamage(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayerMP) {
            if (!PlayerSleepTickHandler.serverState.sleepOverride) {
                return;
            }
            Somnia.channel.sendTo(PacketHandler.buildGUIClosePacket(), (EntityPlayerMP)event.entityLiving);
        }
    }

    @SubscribeEvent
    public void sleepHook(PlayerSleepInBedEvent event) {
        this.onSleep(event);
    }

    public void onSleep(PlayerSleepInBedEvent event) {
        if (event.result != null && event.result != EntityPlayer.EnumStatus.OK) {
            return;
        }
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            double d1;
            double d0;
            List list;
            SomniaEntityPlayerProperties props = SomniaEntityPlayerProperties.get(event.entityPlayer);
            if (props != null && props.getFatigue() < this.minimumFatigueToSleep) {
                event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("somnia.status.cooldown", new Object[0]));
                return;
            }
            if (!this.enterSleepPeriod.isTimeWithin(event.entityPlayer.field_70170_p.func_72820_D() % (long)Somnia.proxy.ticksPerDay)) {
                event.result = EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW;
                return;
            }
            if (!this.sleepWithArmor && Somnia.doesPlayHaveAnyArmor(event.entityPlayer)) {
                event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("somnia.status.armor", new Object[0]));
                return;
            }
            if (event.entityPlayer.func_70608_bn() || !event.entityPlayer.func_70089_S()) {
                event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
                return;
            }
            if (!event.entityPlayer.field_70170_p.field_73011_w.func_76569_d()) {
                event.result = EntityPlayer.EnumStatus.NOT_POSSIBLE_HERE;
                return;
            }
            if (Math.abs(event.entityPlayer.field_70165_t - (double)event.x) > 3.0 || Math.abs(event.entityPlayer.field_70163_u - (double)event.y) > 2.0 || Math.abs(event.entityPlayer.field_70161_v - (double)event.z) > 3.0) {
                event.result = EntityPlayer.EnumStatus.TOO_FAR_AWAY;
                return;
            }
            if (!this.ignoreMonsters && !(list = event.entityPlayer.field_70170_p.func_72872_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)((double)event.x - (d0 = 8.0)), (double)((double)event.y - (d1 = 5.0)), (double)((double)event.z - d0), (double)((double)event.x + d0), (double)((double)event.y + d1), (double)((double)event.z + d0)))).isEmpty()) {
                event.result = EntityPlayer.EnumStatus.NOT_SAFE;
                return;
            }
        }
        if (event.entityPlayer.func_70115_ae()) {
            event.entityPlayer.func_70078_a((Entity)null);
        }
        ClassUtils.setSize(event.entityPlayer, 0.2f, 0.2f);
        event.entityPlayer.field_70129_M = 0.2f;
        if (event.entityPlayer.field_70170_p.func_72899_e(event.x, event.y, event.z)) {
            int l = event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z).getBedDirection((IBlockAccess)event.entityPlayer.field_70170_p, event.x, event.y, event.z);
            float f1 = 0.5f;
            float f = 0.5f;
            switch (l) {
                case 0: {
                    f1 = 0.9f;
                    break;
                }
                case 1: {
                    f = 0.1f;
                    break;
                }
                case 2: {
                    f1 = 0.1f;
                    break;
                }
                case 3: {
                    f = 0.9f;
                }
            }
            ClassUtils.call_func_71013_b(event.entityPlayer, l);
            event.entityPlayer.func_70107_b((double)((float)event.x + f), (double)((float)event.y + 0.9375f), (double)((float)event.z + f1));
        } else {
            event.entityPlayer.func_70107_b((double)((float)event.x + 0.5f), (double)((float)event.y + 0.9375f), (double)((float)event.z + 0.5f));
        }
        ClassUtils.setSleeping(event.entityPlayer, true);
        ClassUtils.setSleepTimer(event.entityPlayer, 0);
        event.entityPlayer.field_71081_bT = new ChunkCoordinates(event.x, event.y, event.z);
        event.entityPlayer.field_70181_x = 0.0;
        event.entityPlayer.field_70179_y = 0.0;
        event.entityPlayer.field_70159_w = 0.0;
        if (!event.entityPlayer.field_70170_p.field_72995_K) {
            event.entityPlayer.field_70170_p.func_72854_c();
        }
        event.result = EntityPlayer.EnumStatus.OK;
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        Somnia.channel.sendTo(PacketHandler.buildGUIOpenPacket(), (EntityPlayerMP)event.entityPlayer);
    }

    public void handleGUIOpenPacket() throws IOException {
    }

    public void handlePropUpdatePacket(DataInputStream in) throws IOException {
    }

    public void handleGUIClosePacket(EntityPlayerMP player) {
    }

    static {
        lastUpdateCheck = 0L;
    }
}

