/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.client.gui;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.common.StreamUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C0BPacketEntityAction;
import net.minecraft.util.ChatComponentTranslation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSomnia
extends GuiSleepMP {
    public static final String COLOR = new String(new char[]{'\u00a7'});
    public static final String BLACK = COLOR + "0";
    public static final String WHITE = COLOR + "f";
    public static final String RED = COLOR + "c";
    public static final String DARK_RED = COLOR + "4";
    public static final String GOLD = COLOR + "6";
    public static final String TRANSLATION_FORMAT = "somnia.status.%s";
    public static final String SPEED_FORMAT = "%sx%s";
    public static final String ETA_FORMAT = WHITE + "(%s:%s)";
    public static final byte[] BYTES_WHITE = new byte[]{-1, -1, -1};
    public static final byte[] BYTES_DARK_RED = new byte[]{-85, 0, 0};
    public static final byte[] BYTES_RED = new byte[]{-1, 0, 0};
    public static final byte[] BYTES_GOLD = new byte[]{-16, -56, 30};
    private static RenderItem presetIconRenderer = new RenderItem();
    private static ItemStack clockItemStack = new ItemStack(Items.field_151113_aN);
    private List<Double> speedValues = new ArrayList<Double>();
    public String status = "Waiting...";
    public double speed = 0.0;
    public long startTicks = -1L;

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.field_146297_k.field_71439_g != null) {
            this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)new C0BPacketEntityAction((Entity)this.field_146297_k.field_71439_g, 3));
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        boolean currentlySleeping;
        super.func_73863_a(par1, par2, par3);
        boolean bl = currentlySleeping = this.speed != 0.0;
        if (currentlySleeping) {
            if (this.startTicks == -1L) {
                this.startTicks = this.field_146297_k.field_71441_e.func_82737_E();
            }
        } else {
            this.startTicks = -1L;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        if (this.startTicks != -1L && Somnia.clientAutoWakeTime != -1L) {
            this.field_146297_k.func_110434_K().func_110577_a(Gui.field_110324_m);
            double rel = this.field_146297_k.field_71441_e.func_82737_E() - this.startTicks;
            double diff = Somnia.clientAutoWakeTime - this.startTicks;
            double progress = rel / diff;
            int x = 20;
            int maxWidth = this.field_146294_l - x * 2;
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            this.renderProgressBar(x, 10, maxWidth, 1.0);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderProgressBar(x, 10, maxWidth, progress);
            this.renderScaledString(x, 20, 1.5f, SPEED_FORMAT, GuiSomnia.getColorStringForSpeed(this.speed), this.speed);
            double total = 0.0;
            for (double value : this.speedValues) {
                total += value;
            }
            double avg = total / (double)this.speedValues.size();
            int etaTotalSeconds = (int)((diff - rel) / (avg * 20.0));
            int etaSeconds = etaTotalSeconds % 60;
            int etaMinutes = (etaTotalSeconds - etaSeconds) / 60;
            this.renderScaledString(x + 50 + 10, 20, 1.5f, ETA_FORMAT, (etaMinutes < 10 ? "0" : "") + etaMinutes, (etaSeconds < 10 ? "0" : "") + etaSeconds);
            this.renderClock(maxWidth - 40, 30, 4.0f);
        }
    }

    private void renderProgressBar(int x, int y, int maxWidth, double progress) {
        int amount = (int)(progress * (double)maxWidth);
        while (amount > 0) {
            this.func_73729_b(x, y, 0, 69, amount > 180 ? 180 : amount, 5);
            amount -= 180;
            x += 180;
        }
    }

    private void renderScaledString(int x, int y, float scale, String format, Object ... args) {
        String str = String.format(format, args);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)20.0f, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        this.func_73731_b(this.field_146289_q, str, 0, 0, Integer.MIN_VALUE);
        GL11.glPopMatrix();
    }

    private void renderClock(int x, int y, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        presetIconRenderer.func_77015_a(this.field_146289_q, this.field_146297_k.field_71446_o, clockItemStack, 0, 0);
        GL11.glPopMatrix();
    }

    public void readField(DataInputStream in) throws IOException {
        switch (in.readByte()) {
            case 0: {
                this.speed = in.readDouble();
                this.speedValues.add(this.speed);
                if (this.speedValues.size() <= 5) break;
                this.speedValues.remove(0);
                break;
            }
            case 1: {
                String str = StreamUtils.readString(in);
                this.status = str.startsWith("f:") ? new ChatComponentTranslation(String.format(TRANSLATION_FORMAT, str.substring(2).toLowerCase()), new Object[0]).func_150261_e() : str;
            }
        }
    }

    public static byte[] getColorForSpeed(double speed) {
        if (speed < 8.0) {
            return BYTES_WHITE;
        }
        if (speed < 20.0) {
            return BYTES_DARK_RED;
        }
        if (speed < 30.0) {
            return BYTES_RED;
        }
        return BYTES_GOLD;
    }

    public static String getColorStringForSpeed(double speed) {
        if (speed < 8.0) {
            return WHITE;
        }
        if (speed < 20.0) {
            return DARK_RED;
        }
        if (speed < 30.0) {
            return RED;
        }
        return GOLD;
    }
}

