/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia;

import com.google.gson.Gson;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;

public class SomniaVersion {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 4;
    public static final int REVISION_VERSION = 8;
    public static final int CORE_MAJOR_VERSION = 1;
    public static final int CORE_MINOR_VERSION = 3;
    public static final int CORE_REVISION_VERSION = 1;
    public static final int BUILD = 55;
    private static final String FORMAT = "%s.%s.%s.%s";
    private static final String UPDATE_URL_FORMAT = "https://codeheist.net/somnia-update.php?v=%s";
    private static final String USER_AGENT = "Somnia-Updater (v1.0)";

    public static String getVersionString() {
        return String.format(FORMAT, 1, 4, 8, 55);
    }

    public static String getCoreVersionString() {
        return String.format(FORMAT, 1, 3, 1, 55);
    }

    private static int[] parseVersionString(String versionString) {
        String[] segments = versionString.split("\\.");
        if (segments.length < 3) {
            return null;
        }
        int[] intArray = new int[segments.length];
        for (int i = 0; i < segments.length; ++i) {
            try {
                intArray[i] = Integer.parseInt(segments[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                return null;
            }
        }
        return intArray;
    }

    private static boolean isHigher(String versionString) {
        return SomniaVersion.isHigher(versionString, 1, 4, 8, 55);
    }

    private static boolean isHigher(String baseVersion, String altVersion) {
        int[] intArray = SomniaVersion.parseVersionString(baseVersion);
        int build = intArray.length >= 4 ? intArray[3] : Integer.MAX_VALUE;
        return SomniaVersion.isHigher(altVersion, intArray[0], intArray[1], intArray[2], build);
    }

    private static boolean isHigher(String versionString, int major, int minor, int rev, int build) {
        int[] intArray = SomniaVersion.parseVersionString(versionString);
        if (intArray != null) {
            return major < intArray[0] ? true : (minor < intArray[1] ? true : (rev < intArray[2] ? true : intArray.length >= 4 && build < intArray[3]));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateCheckerEntry checkForUpdates() throws IOException {
        HttpURLConnection conn = null;
        BufferedReader br = null;
        try {
            URL url = new URL(String.format(UPDATE_URL_FORMAT, SomniaVersion.getVersionString()));
            conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", USER_AGENT);
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                UpdateCheckerEntry[] entries;
                String line;
                br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                String str = sb.toString();
                sb.setLength(0);
                sb = null;
                Gson gson = new Gson();
                UpdateCheckerResponse response = (UpdateCheckerResponse)gson.fromJson(str, UpdateCheckerResponse.class);
                if (response != null && (entries = response.entriesFor(String.valueOf(FMLInjectionData.data()[4]))).length > 0) {
                    UpdateCheckerEntry mostRecent = null;
                    for (UpdateCheckerEntry e : entries) {
                        if (mostRecent != null && !SomniaVersion.isHigher(mostRecent.getVersionString(), e.getVersionString())) continue;
                        mostRecent = e;
                    }
                    if (SomniaVersion.isHigher(mostRecent.getVersionString())) {
                        UpdateCheckerEntry updateCheckerEntry = mostRecent;
                        return updateCheckerEntry;
                    }
                }
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static class UpdateCheckerResponse {
        private HashMap<String, UpdateCheckerEntry[]> versionMap;

        public UpdateCheckerResponse() {
            this(new HashMap<String, UpdateCheckerEntry[]>());
        }

        public UpdateCheckerResponse(HashMap<String, UpdateCheckerEntry[]> versionMap) {
            this.versionMap = versionMap;
        }

        public UpdateCheckerEntry[] entriesFor(String mcVersion) {
            return this.versionMap.get(mcVersion);
        }
    }

    public static class UpdateCheckerEntry {
        private String versionString;
        private String url;
        private String comment;

        public UpdateCheckerEntry(String versionString, String url, String comment) {
            this.versionString = versionString;
            this.url = url;
            this.comment = comment;
        }

        public String getVersionString() {
            return this.versionString;
        }

        public String getUrl() {
            return this.url;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

