/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia;

import com.kingrunes.somnia.SomniaVersion;
import com.kingrunes.somnia.common.CommonProxy;
import com.kingrunes.somnia.common.PacketHandler;
import com.kingrunes.somnia.common.util.SomniaState;
import com.kingrunes.somnia.server.ServerTickHandler;
import com.kingrunes.somnia.server.SomniaCommand;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.opengl.GL11;

@Mod(modid="Somnia", name="Somnia", version="-au")
public class Somnia {
    public static final String MOD_ID = "Somnia";
    public static final String NAME = "Somnia";
    public static final String VERSION = SomniaVersion.getVersionString();
    public Configuration config;
    public List<ServerTickHandler> tickHandlers = new ArrayList<ServerTickHandler>();
    public List<WeakReference<EntityPlayerMP>> ignoreList = new ArrayList<WeakReference<EntityPlayerMP>>();
    @Mod.Instance(value="Somnia")
    public static Somnia instance;
    @SidedProxy(serverSide="com.kingrunes.somnia.common.CommonProxy", clientSide="com.kingrunes.somnia.client.ClientProxy")
    public static CommonProxy proxy;
    public static FMLEventChannel channel;
    public static long clientAutoWakeTime;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().version = VERSION;
        proxy.configure(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("Somnia");
        channel.register((Object)new PacketHandler());
        proxy.register();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new SomniaCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<ServerTickHandler> list = Somnia.instance.tickHandlers;
        synchronized (list) {
            for (ServerTickHandler serverTickHandler : Somnia.instance.tickHandlers) {
                serverTickHandler.tickStart();
            }
        }
    }

    public static String timeStringForWorldTime(long time) {
        time += 6000L;
        int hours = (int)Math.floor((double)(time %= (long)Somnia.proxy.ticksPerDay) / 1000.0);
        int minutes = (int)((double)(time % 1000L) / 1000.0 * 60.0);
        String lsHours = String.valueOf(hours);
        String lsMinutes = String.valueOf(minutes);
        if (lsHours.length() == 1) {
            lsHours = "0" + lsHours;
        }
        if (lsMinutes.length() == 1) {
            lsMinutes = "0" + lsMinutes;
        }
        return lsHours + ":" + lsMinutes;
    }

    public static boolean doesPlayHaveAnyArmor(EntityPlayer e) {
        ItemStack[] armor = e.field_71071_by.field_70460_b;
        for (int a = 0; a < armor.length; ++a) {
            if (armor[a] == null) continue;
            return true;
        }
        return false;
    }

    public static long calculateWakeTime(long totalWorldTime, int i) {
        long timeInDay = totalWorldTime % (long)Somnia.proxy.ticksPerDay;
        long l = totalWorldTime - timeInDay + (long)i;
        if (timeInDay > (long)i) {
            l += (long)Somnia.proxy.ticksPerDay;
        }
        return l;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderWorld(float par1, long par2) {
        if (Minecraft.func_71410_x().field_71439_g.func_70608_bn() && Somnia.proxy.disableRendering) {
            GL11.glClear((int)16640);
            return;
        }
        Minecraft.func_71410_x().field_71460_t.func_78471_a(par1, par2);
    }

    public static boolean doMobSpawning(WorldServer par1WorldServer) {
        boolean defValue = par1WorldServer.func_82736_K().func_82766_b("doMobSpawning");
        if (!Somnia.proxy.disableCreatureSpawning || !defValue) {
            return defValue;
        }
        for (ServerTickHandler serverTickHandler : Somnia.instance.tickHandlers) {
            if (serverTickHandler.worldServer != par1WorldServer) continue;
            return serverTickHandler.currentState != SomniaState.ACTIVE;
        }
        throw new IllegalStateException("tickHandlers doesn't contain match for given world server");
    }

    public static void chunkLightCheck(Chunk chunk) {
        if (!Somnia.proxy.disableMoodSoundAndLightCheck) {
            chunk.func_150809_p();
        }
        for (ServerTickHandler serverTickHandler : Somnia.instance.tickHandlers) {
            if (serverTickHandler.worldServer != chunk.field_76637_e) continue;
            if (serverTickHandler.currentState != SomniaState.ACTIVE) {
                chunk.func_150809_p();
            }
            return;
        }
        chunk.func_150809_p();
    }

    static {
        clientAutoWakeTime = -1L;
    }
}

