/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class MapCollection<K, V>
implements Collection<V> {
    protected final Map<K, V> backingMap;

    public MapCollection(Map<K, V> backingMap) {
        this.backingMap = backingMap;
        for (Map.Entry<K, V> entry : backingMap.entrySet()) {
            V value;
            K nKey;
            K key = entry.getKey();
            if (key == (nKey = this.getKey(value = entry.getValue())) || key != null && key.equals(nKey)) continue;
            throw new IllegalArgumentException("Backing set contains inconsistent key/value pair '" + key + "' -> '" + value + "', expected '" + nKey + "' -> '" + value + "'");
        }
    }

    protected abstract K getKey(V var1);

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        try {
            K key = this.getKey(o);
            return this.backingMap.containsKey(key);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public Iterator<V> iterator() {
        return this.backingMap.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.backingMap.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backingMap.values().toArray(a);
    }

    @Override
    public boolean add(V v) {
        K key = this.getKey(v);
        if (v != null) {
            return this.backingMap.put(key, v) != v;
        }
        boolean hasKey = this.backingMap.containsKey(key);
        V prev = this.backingMap.put(key, v);
        return !hasKey || v != prev;
    }

    @Override
    public boolean remove(Object o) {
        try {
            K key = this.getKey(o);
            return this.backingMap.keySet().remove(key);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V v : c) {
            changed |= this.add(v);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList<K> keys = new ArrayList<K>(this.backingMap.size());
        for (Object o : c) {
            try {
                K key = this.getKey(o);
                keys.add(key);
            }
            catch (ClassCastException classCastException) {}
        }
        return this.backingMap.keySet().retainAll(keys);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public int hashCode() {
        return this.backingMap.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof MapCollection ? this.backingMap.equals(((MapCollection)obj).backingMap) : false;
    }

    public String toString() {
        return this.backingMap.values().toString();
    }
}

