/*
 * Decompiled with CFR 0.152.
 */
package CustomOreGen.Config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class ExpressionEvaluator {
    protected static Map<String, TokenType> _symbolMap = new HashMap<String, TokenType>();

    protected Object getIdentifierValue(String identifier) {
        return null;
    }

    public Object evaluate(String expression) throws EvaluatorException {
        Stack<Token> input = this.parse(expression);
        if (input.isEmpty()) {
            return null;
        }
        Object result = null;
        try {
            result = ExpressionEvaluator.evaluate(input);
        }
        catch (EmptyStackException var5) {
            throw new EvaluatorException("Incomplete expression.", new Token(expression, expression.length(), expression.length()));
        }
        if (!input.isEmpty()) {
            throw new EvaluatorException("Expression contains too many values.", input.peek());
        }
        return result;
    }

    protected static Object evaluate(Stack<Token> input) throws EmptyStackException, EvaluatorException {
        Token token = input.pop();
        if (!token.type.retain) {
            throw new EvaluatorException("Un-evaluatable token.", token);
        }
        switch (token.type) {
            case SCIENTIFIC: {
                double rhs2 = ExpressionEvaluator.evaluateNumber(input);
                return ExpressionEvaluator.evaluateNumber(input) * Math.pow(10.0, rhs2);
            }
            case TO_STRING: {
                return ExpressionEvaluator.evaluate(input).toString();
            }
            case TO_NUMBER: {
                Object rhs1 = ExpressionEvaluator.evaluate(input);
                if (rhs1 instanceof Number) {
                    return (Number)rhs1;
                }
                if (rhs1 instanceof Boolean) {
                    return (Boolean)rhs1 != false ? 1L : 0L;
                }
                if (rhs1 instanceof String) {
                    try {
                        if (rhs1.toString().contains(".")) {
                            return Double.parseDouble(rhs1.toString());
                        }
                        return Long.decode(rhs1.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                throw new EvaluatorException("Cannot reduce '" + rhs1 + "' to a numerical value.", token);
            }
            case TO_BOOLEAN: {
                Object rhs1 = ExpressionEvaluator.evaluate(input);
                if (rhs1 instanceof Boolean) {
                    return (Boolean)rhs1;
                }
                if (rhs1 instanceof Number) {
                    return ((Number)rhs1).doubleValue() != 0.0;
                }
                if (rhs1 instanceof String) {
                    if (rhs1.toString().equalsIgnoreCase("true")) {
                        return Boolean.TRUE;
                    }
                    if (rhs1.toString().equalsIgnoreCase("false")) {
                        return Boolean.FALSE;
                    }
                }
                throw new EvaluatorException("Cannot reduce '" + rhs1 + "' to a boolean value.", token);
            }
            case LOGICAL_NOT: {
                return !ExpressionEvaluator.evaluateBoolean(input);
            }
            case UNARY_MINUS: {
                return -ExpressionEvaluator.evaluateNumber(input);
            }
            case UNARY_PLUS: {
                return ExpressionEvaluator.evaluateNumber(input);
            }
            case IF: {
                Object rhs1 = ExpressionEvaluator.evaluate(input);
                Object lhs1 = ExpressionEvaluator.evaluate(input);
                return ExpressionEvaluator.evaluateBoolean(input) ? lhs1 : rhs1;
            }
            case MATCH: {
                String rhs3 = ExpressionEvaluator.evaluateString(input);
                String lhs2 = ExpressionEvaluator.evaluateString(input);
                return lhs2.matches(rhs3);
            }
            case REPLACE: {
                String rhs3 = ExpressionEvaluator.evaluateString(input);
                String lhs2 = ExpressionEvaluator.evaluateString(input);
                String equal1 = ExpressionEvaluator.evaluateString(input);
                return equal1.replaceAll(lhs2, rhs3);
            }
            case MULTIPLY: {
                return ExpressionEvaluator.evaluateNumber(input) * ExpressionEvaluator.evaluateNumber(input);
            }
            case DIVIDE: {
                double rhs2 = ExpressionEvaluator.evaluateNumber(input);
                return ExpressionEvaluator.evaluateNumber(input) / rhs2;
            }
            case MODULUS: {
                double rhs2 = ExpressionEvaluator.evaluateNumber(input);
                return ExpressionEvaluator.evaluateNumber(input) % rhs2;
            }
            case ADD: {
                return ExpressionEvaluator.evaluateNumber(input) + ExpressionEvaluator.evaluateNumber(input);
            }
            case SUBTRACT: {
                double rhs2 = ExpressionEvaluator.evaluateNumber(input);
                return ExpressionEvaluator.evaluateNumber(input) - rhs2;
            }
            case CONCATENATE: {
                String rhs3 = ExpressionEvaluator.evaluateString(input);
                String lhs2 = ExpressionEvaluator.evaluateString(input);
                return lhs2 + rhs3;
            }
            case LESS: {
                double rhs2 = ExpressionEvaluator.evaluateNumber(input);
                return ExpressionEvaluator.evaluateNumber(input) < rhs2;
            }
            case LESS_EQUAL: {
                double rhs2 = ExpressionEvaluator.evaluateNumber(input);
                return ExpressionEvaluator.evaluateNumber(input) <= rhs2;
            }
            case GREATER: {
                double rhs2 = ExpressionEvaluator.evaluateNumber(input);
                return ExpressionEvaluator.evaluateNumber(input) > rhs2;
            }
            case GREATER_EQUAL: {
                double rhs2 = ExpressionEvaluator.evaluateNumber(input);
                return ExpressionEvaluator.evaluateNumber(input) >= rhs2;
            }
            case EQUAL: 
            case NOT_EQUAL: {
                Object rhs1 = ExpressionEvaluator.evaluate(input);
                Object lhs1 = ExpressionEvaluator.evaluate(input);
                boolean equal = false;
                if (lhs1 instanceof Number && rhs1 instanceof Number) {
                    equal = ((Number)lhs1).doubleValue() == ((Number)rhs1).doubleValue();
                } else {
                    if (!lhs1.getClass().isAssignableFrom(rhs1.getClass())) {
                        throw new EvaluatorException("Cannot compare equality of '" + lhs1.getClass().getSimpleName() + "' and '" + rhs1.getClass().getSimpleName() + "'.", token);
                    }
                    equal = rhs1.equals(lhs1);
                }
                return token.type == TokenType.EQUAL ? equal : !equal;
            }
            case AND: {
                boolean rhs = ExpressionEvaluator.evaluateBoolean(input);
                boolean lhs = ExpressionEvaluator.evaluateBoolean(input);
                return lhs && rhs;
            }
            case OR: {
                boolean rhs = ExpressionEvaluator.evaluateBoolean(input);
                boolean lhs = ExpressionEvaluator.evaluateBoolean(input);
                return lhs || rhs;
            }
        }
        if (token.data == null) {
            throw new EvaluatorException("Un-evaluatable token.", token);
        }
        if (token.data instanceof EvaluationDelegate) {
            return ((EvaluationDelegate)token.data).evaluate(token, input);
        }
        return token.data;
    }

    protected static String evaluateString(Stack<Token> input) throws EmptyStackException, EvaluatorException {
        Token token = input.peek();
        Object value = ExpressionEvaluator.evaluate(input);
        try {
            return (String)value;
        }
        catch (ClassCastException var4) {
            throw new EvaluatorException("Expected a string value.", token, var4);
        }
    }

    protected static double evaluateNumber(Stack<Token> input) throws EmptyStackException, EvaluatorException {
        Token token = input.peek();
        Object value = ExpressionEvaluator.evaluate(input);
        try {
            return ((Number)value).doubleValue();
        }
        catch (ClassCastException var4) {
            throw new EvaluatorException("Expected a numeric value.", token, var4);
        }
    }

    protected static boolean evaluateBoolean(Stack<Token> input) throws EmptyStackException, EvaluatorException {
        Token token = input.peek();
        Object value = ExpressionEvaluator.evaluate(input);
        try {
            return (Boolean)value;
        }
        catch (ClassCastException var4) {
            throw new EvaluatorException("Expected a boolean value.", token, var4);
        }
    }

    public Stack<Token> parse(String expression) throws EvaluatorException {
        Stack<Token> output = new Stack<Token>();
        Stack<Token> held = new Stack<Token>();
        Token lastToken = null;
        Assoc lastAssoc = Assoc.RIGHT;
        Token heldTop = this.getToken(expression, 0);
        while (heldTop != null) {
            Assoc assoc = heldTop.type.associativity;
            if (assoc == Assoc.BRACKET_OPEN) {
                assoc = Assoc.RIGHT;
            } else if (assoc == Assoc.BRACKET_CLOSE) {
                assoc = Assoc.LEFT;
            }
            if (assoc == Assoc.LEFT != (lastAssoc == Assoc.NONE)) {
                if (heldTop.type == TokenType.ADD) {
                    heldTop = new Token(heldTop.source, heldTop.start, heldTop.end, TokenType.UNARY_PLUS);
                } else {
                    if (heldTop.type != TokenType.SUBTRACT) {
                        throw new EvaluatorException("'" + heldTop + "' cannot follow '" + lastToken + "'.", heldTop);
                    }
                    heldTop = new Token(heldTop.source, heldTop.start, heldTop.end, TokenType.UNARY_MINUS);
                }
            }
            lastAssoc = assoc;
            lastToken = heldTop;
            switch (heldTop.type.associativity) {
                case NONE: {
                    if (!heldTop.type.retain) break;
                    output.push(heldTop);
                    break;
                }
                case BRACKET_OPEN: {
                    held.push(heldTop);
                    break;
                }
                case BRACKET_CLOSE: {
                    Token heldTop1 = null;
                    while (heldTop1 == null && !held.isEmpty()) {
                        Token heldTop2 = (Token)held.pop();
                        if (heldTop2.type.associativity == Assoc.BRACKET_OPEN) {
                            if (!heldTop2.toString().equals(heldTop.data)) {
                                throw new EvaluatorException("Missing corresponding " + heldTop2.data + ".", heldTop2);
                            }
                            heldTop1 = heldTop2;
                            continue;
                        }
                        if (!heldTop2.type.retain) continue;
                        output.push(heldTop2);
                    }
                    if (heldTop1 == null) {
                        throw new EvaluatorException("Missing corresponding " + heldTop.data + ".", heldTop);
                    }
                    if (heldTop.type.retain) {
                        output.push(heldTop1);
                        output.push(heldTop);
                    }
                    lastAssoc = Assoc.NONE;
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    Token heldTop1;
                    while (!held.isEmpty()) {
                        heldTop1 = (Token)held.peek();
                        if (heldTop1.type.associativity != Assoc.LEFT && heldTop1.type.associativity != Assoc.RIGHT || heldTop.type.associativity == Assoc.RIGHT && heldTop.type.precedence == heldTop1.type.precedence || heldTop.type.precedence < heldTop1.type.precedence) break;
                        held.pop();
                        if (!heldTop1.type.retain) continue;
                        output.push(heldTop1);
                    }
                    held.push(heldTop);
                }
            }
            heldTop = this.getToken(expression, heldTop.end);
        }
        if (!output.isEmpty() && lastAssoc != Assoc.NONE) {
            throw new EvaluatorException("Incomplete expression.", new Token(expression, expression.length(), expression.length()));
        }
        while (!held.isEmpty()) {
            heldTop = (Token)held.pop();
            if (heldTop.type.associativity == Assoc.BRACKET_OPEN) {
                throw new EvaluatorException("Missing corresponding " + heldTop.data + ".", heldTop);
            }
            if (!heldTop.type.retain) continue;
            output.push(heldTop);
        }
        return output;
    }

    public Token getToken(String input, int start) throws EvaluatorException {
        if (input != null && !input.isEmpty()) {
            TokenType var10;
            int end;
            while (input.length() > start && Character.isWhitespace(input.charAt(start))) {
                ++start;
            }
            if (input.length() <= start) {
                return null;
            }
            char ch = input.charAt(start);
            if (Character.isDigit(ch)) {
                boolean var9 = false;
                if (ch == '0' && input.length() > end && Character.toLowerCase(input.charAt(end)) == 'x') {
                    char ex;
                    ++end;
                    while (input.length() > end && (Character.isDigit(ex = input.charAt(end)) || ex >= 'a' && ex <= 'f' || ex >= 'A' && ex <= 'F')) {
                        ++end;
                    }
                } else {
                    while (input.length() > end) {
                        char ex = input.charAt(end);
                        if (Character.isDigit(ex)) {
                            ++end;
                            continue;
                        }
                        if (ex == '.') {
                            ++end;
                            var9 = true;
                            continue;
                        }
                        break;
                    }
                }
                try {
                    return var9 ? new Token(input, start, end, TokenType.NUMBER, Double.parseDouble(input.substring(start, end))) : new Token(input, start, end, TokenType.NUMBER, Long.decode(input.substring(start, end)));
                }
                catch (NumberFormatException var7) {
                    throw new EvaluatorException("Invalid number.", new Token(input, start, end));
                }
            }
            if (!Character.isLetter(ch) && ch != '_') {
                if (ch == '\"' || ch == '\'') {
                    if ((end = input.indexOf(ch, end)) < 0) {
                        throw new EvaluatorException("Unmatched string delimeter " + ch + ".", new Token(input, start, start + 1));
                    }
                    return new Token(input, start, ++end, TokenType.STRING, input.substring(start + 1, end - 1));
                }
                if ((ch == '<' || ch == '>' || ch == '!') && input.length() > end && input.charAt(end) == '=') {
                    ++end;
                }
            } else {
                char type;
                for (end = start + 1; input.length() > end && (Character.isLetterOrDigit(type = input.charAt(end)) || type == '_' || type == '.'); ++end) {
                }
                Object var8 = this.getIdentifierValue(input.substring(start, end));
                if (var8 != null) {
                    if (var8 instanceof EvaluationDelegate && ((EvaluationDelegate)var8).explicitArguments() > 0) {
                        return new Token(input, start, end, TokenType.FUNCTION, var8);
                    }
                    return new Token(input, start, end, TokenType.VARIABLE, var8);
                }
            }
            if ((var10 = _symbolMap.get(input.substring(start, end).toLowerCase())) != null) {
                return new Token(input, start, end, var10);
            }
            throw new EvaluatorException("Unexpected token.", new Token(input, start, end));
        }
        return null;
    }

    static {
        for (TokenType type : TokenType.values()) {
            if (type.symbol == null) continue;
            _symbolMap.put(type.symbol, type);
        }
    }

    public static class Token {
        public final String source;
        public final int start;
        public final int end;
        public final TokenType type;
        public final Object data;
        private String _str = null;

        public String toString() {
            if (this._str == null) {
                this._str = this.source.substring(this.start, this.end);
            }
            return this._str;
        }

        protected Token(String source, int start, int end, TokenType type, Object data) {
            this.source = source;
            this.start = start;
            this.end = end;
            this.type = type;
            this.data = data;
        }

        protected Token(String source, int start, int end, TokenType type) {
            this(source, start, end, type, type.data);
        }

        protected Token(String source, int start, int end) {
            this(source, start, end, null, null);
        }
    }

    public static class EvaluatorException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final Token token;

        public EvaluatorException(String message, Token token, Throwable cause) {
            super(message, cause);
            this.token = token;
        }

        public EvaluatorException(String message, Token token) {
            super(message);
            this.token = token;
        }

        public EvaluatorException(String message, Throwable cause) {
            this(message, null, cause);
        }

        public EvaluatorException(String message) {
            this(message, (Token)null);
        }

        @Override
        public String getMessage() {
            if (this.token == null) {
                return super.getMessage();
            }
            String name = this.token.type == null ? "" : this.token.type.name();
            return String.format("At %s(%d-%d) %s : %s", name, this.token.start, this.token.end, this.token, super.getMessage());
        }

        @Override
        public String toString() {
            StringBuilder msg = new StringBuilder(this.getMessage());
            if (this.token != null && this.token.source != null && !this.token.source.isEmpty()) {
                int quoteStart = (this.token.start + this.token.end - 60) / 2;
                String quotePrefix = "... ";
                if (quoteStart < 0) {
                    quotePrefix = "    ";
                    quoteStart = 0;
                }
                int quoteEnd = (this.token.start + this.token.end + 60) / 2;
                String quoteSuffix = " ...";
                if (quoteEnd > this.token.source.length()) {
                    quoteSuffix = "";
                    quoteEnd = this.token.source.length();
                }
                msg.append("\n  ");
                msg.append(quotePrefix);
                msg.append(this.token.source.substring(quoteStart, quoteEnd).replace("\n", " "));
                msg.append(quoteSuffix);
                msg.append("\n   at ");
                for (int i = quoteStart; i < this.token.end; ++i) {
                    if (i != this.token.start && i != this.token.end - 1) {
                        msg.append('-');
                        continue;
                    }
                    msg.append('^');
                }
            }
            return msg.toString();
        }
    }

    public static class EvaluationDelegate {
        private final Object _obj;
        private final Method _method;
        private final boolean _passToken;

        public EvaluationDelegate(boolean passToken, Object obj, String methodName, Class<?> ... argTypes) {
            this(passToken, obj, obj.getClass(), methodName, argTypes);
        }

        public EvaluationDelegate(boolean passToken, Class<?> clazz, String methodName, Class<?> ... argTypes) {
            this(passToken, (Object)null, clazz, methodName, argTypes);
        }

        private EvaluationDelegate(boolean passToken, Object obj, Class<?> clazz, String methodName, Class<?> ... argTypes) {
            Method method = null;
            if (argTypes != null) {
                try {
                    method = clazz.getMethod(methodName, argTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            } else {
                Method[] valid;
                for (Method m : valid = clazz.getMethods()) {
                    if (!m.getName().equals(methodName)) continue;
                    if (method != null) {
                        throw new IllegalArgumentException("Method '" + methodName + "' is ambiguous for class " + clazz.getSimpleName());
                    }
                    method = m;
                }
            }
            if (method == null) {
                throw new IllegalArgumentException("Method '" + methodName + "' is not defined for class " + clazz.getSimpleName());
            }
            if (!((method.getModifiers() & 8) != 0 || obj != null && clazz.isInstance(obj))) {
                throw new IllegalArgumentException("Method '" + methodName + "' for class " + clazz.getSimpleName() + " requires an object instance");
            }
            if (passToken) {
                Class<Object> var13;
                boolean var12 = false;
                if (method.getParameterTypes().length > 0 && ((var13 = method.getParameterTypes()[0]).isAssignableFrom(String.class) || var13.isAssignableFrom(Token.class))) {
                    var12 = true;
                }
                if (!var12) {
                    throw new IllegalArgumentException("Method '" + methodName + "' for class " + clazz.getSimpleName() + " must take a String or Token as the first parameter");
                }
            }
            this._obj = obj;
            this._method = method;
            this._passToken = passToken;
        }

        protected Object evaluate(Token token, Stack<Token> argumentStack) throws EmptyStackException, EvaluatorException {
            Class<?>[] argTypes = this._method.getParameterTypes();
            Object[] argValues = new Object[argTypes.length];
            for (int ex = argValues.length - 1; ex >= 0; --ex) {
                if (ex == 0 && this._passToken) {
                    if (argTypes[0].isAssignableFrom(Token.class)) {
                        argValues[0] = token;
                        continue;
                    }
                    argValues[0] = token.toString();
                    continue;
                }
                if (argTypes[ex].isAssignableFrom(String.class)) {
                    argValues[ex] = ExpressionEvaluator.evaluateString(argumentStack);
                    continue;
                }
                if (!argTypes[ex].isAssignableFrom(Double.class) && !argTypes[ex].isAssignableFrom(Double.TYPE)) {
                    if (argTypes[ex].isAssignableFrom(Boolean.class)) {
                        argValues[ex] = ExpressionEvaluator.evaluateBoolean(argumentStack);
                        continue;
                    }
                    argValues[ex] = ExpressionEvaluator.evaluate(argumentStack);
                    continue;
                }
                argValues[ex] = ExpressionEvaluator.evaluateNumber(argumentStack);
            }
            try {
                Object var9 = this._method.invoke(this._obj, argValues);
                if (var9 == null) {
                    throw new EvaluatorException("Delegate evaluation produced null value.", token);
                }
                return var9;
            }
            catch (IllegalAccessException var6) {
                throw new EvaluatorException("Cannot evaluate delegate.", token, var6);
            }
            catch (IllegalArgumentException var7) {
                throw new EvaluatorException(var7.getMessage(), token, var7);
            }
            catch (InvocationTargetException var8) {
                throw new EvaluatorException(var8.getCause().getMessage(), token, var8);
            }
        }

        public int explicitArguments() {
            return this._method.getParameterTypes().length - (this._passToken ? 1 : 0);
        }

        public String toString() {
            String prefix = this._method.getDeclaringClass().getSimpleName() + "." + this._method.getName();
            return this._obj != null ? prefix + "(" + this._obj + ")" : prefix;
        }
    }

    public static enum Assoc {
        NONE,
        LEFT,
        RIGHT,
        BRACKET_OPEN,
        BRACKET_CLOSE;

    }

    public static enum TokenType {
        TRUE("true", 0, Assoc.NONE, true, true),
        FALSE("false", 0, Assoc.NONE, true, false),
        NUMBER(null, 0, Assoc.NONE, true, null),
        HEXNUMBER(null, 0, Assoc.NONE, true, null),
        STRING(null, 0, Assoc.NONE, true, null),
        VARIABLE(null, 0, Assoc.NONE, true, null),
        PAREN_OPEN("(", 10, Assoc.BRACKET_OPEN, false, ")"),
        PAREN_CLOSE(")", 10, Assoc.BRACKET_CLOSE, false, "("),
        BRACKET_OPEN("[", 10, Assoc.BRACKET_OPEN, false, "]"),
        BRACKET_CLOSE("]", 10, Assoc.BRACKET_CLOSE, false, "["),
        BRACE_OPEN("{", 10, Assoc.BRACKET_OPEN, false, "}"),
        BRACE_CLOSE("}", 10, Assoc.BRACKET_CLOSE, false, "{"),
        EXPONENT("^", 20, Assoc.LEFT, true, new EvaluationDelegate(false, Math.class, "pow", Double.TYPE, Double.TYPE)),
        SCIENTIFIC("e", 20, Assoc.LEFT, true, null),
        TO_STRING("$", 20, Assoc.RIGHT, true, null),
        TO_NUMBER("#", 20, Assoc.RIGHT, true, null),
        TO_BOOLEAN("?", 20, Assoc.RIGHT, true, null),
        LOGICAL_NOT("!", 20, Assoc.RIGHT, true, null),
        UNARY_MINUS(null, 20, Assoc.RIGHT, true, null),
        UNARY_PLUS(null, 20, Assoc.RIGHT, true, null),
        IF("if", 20, Assoc.RIGHT, true, null),
        ABS("abs", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "abs", Double.TYPE)),
        SIGN("sign", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "signum", Double.TYPE)),
        MIN("min", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "min", Double.TYPE, Double.TYPE)),
        MAX("max", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "max", Double.TYPE, Double.TYPE)),
        FLOOR("floor", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "floor", Double.TYPE)),
        CEILING("ceil", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "ceil", Double.TYPE)),
        ROUND("round", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "round", Double.TYPE)),
        EXP("exp", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "exp", Double.TYPE)),
        LOG("log", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "log", Double.TYPE)),
        SINE("sin", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "sin", Double.TYPE)),
        COSINE("cos", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "cos", Double.TYPE)),
        TANGENT("tan", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "tan", Double.TYPE)),
        ARCSINE("asin", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "asin", Double.TYPE)),
        ARCCOSINE("acos", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "acos", Double.TYPE)),
        ARCTANGENT("atan", 20, Assoc.RIGHT, true, new EvaluationDelegate(false, Math.class, "atan", Double.TYPE)),
        MATCH("match", 20, Assoc.RIGHT, true, null),
        REPLACE("replace", 20, Assoc.RIGHT, true, null),
        FUNCTION(null, 20, Assoc.RIGHT, true, null),
        MULTIPLY("*", 30, Assoc.LEFT, true, null),
        DIVIDE("/", 30, Assoc.LEFT, true, null),
        MODULUS("%", 30, Assoc.LEFT, true, null),
        ADD("+", 40, Assoc.LEFT, true, null),
        SUBTRACT("-", 40, Assoc.LEFT, true, null),
        CONCATENATE("~", 40, Assoc.LEFT, true, null),
        LESS("<", 50, Assoc.LEFT, true, null),
        LESS_EQUAL("<=", 50, Assoc.LEFT, true, null),
        GREATER(">", 50, Assoc.LEFT, true, null),
        GREATER_EQUAL(">=", 50, Assoc.LEFT, true, null),
        EQUAL("=", 60, Assoc.LEFT, true, null),
        NOT_EQUAL("!=", 60, Assoc.LEFT, true, null),
        AND("&", 70, Assoc.LEFT, true, null),
        OR("|", 75, Assoc.LEFT, true, null),
        COMMA(",", 80, Assoc.LEFT, false, null),
        SEMICOLON(";", 80, Assoc.LEFT, false, null),
        COLON(":", 80, Assoc.LEFT, false, null);

        public final String symbol;
        public final int precedence;
        public final Assoc associativity;
        public final boolean retain;
        public final Object data;

        private TokenType(String symbol, int precedence, Assoc associativity, boolean retain, Object data) {
            this.symbol = symbol;
            this.precedence = precedence;
            this.associativity = associativity;
            this.retain = retain;
            this.data = data;
        }
    }
}

