/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class CraftingHandler {
    private static HashMap<String, Field> knownCraftingContainer;
    private static HashSet<String> notCraftingContainer;

    public static void enableGuessing() {
        knownCraftingContainer = new HashMap();
        notCraftingContainer = new HashSet();
    }

    public static InventoryCrafting getCraftingMatrix(Container container) {
        String name;
        if (container == null) {
            return null;
        }
        if (container instanceof ContainerPlayer) {
            return ((ContainerPlayer)container).field_75181_e;
        }
        if (container instanceof ContainerWorkbench) {
            return ((ContainerWorkbench)container).field_75162_e;
        }
        if (notCraftingContainer != null && !notCraftingContainer.contains(name = container.getClass().getName())) {
            Field f = knownCraftingContainer.get(name);
            if (f == null) {
                for (Field field : container.getClass().getDeclaredFields()) {
                    if (field == null || !InventoryCrafting.class.isAssignableFrom(field.getClass())) continue;
                    try {
                        InventoryCrafting craft = (InventoryCrafting)InventoryCrafting.class.cast(field.get(container));
                        if (craft == null) continue;
                        knownCraftingContainer.put(name, field);
                        return craft;
                    }
                    catch (ReflectiveOperationException ref) {
                        // empty catch block
                    }
                }
                notCraftingContainer.add(name);
            } else {
                try {
                    return (InventoryCrafting)InventoryCrafting.class.cast(f.get(container));
                }
                catch (ReflectiveOperationException ref) {
                    knownCraftingContainer.put(name, null);
                }
            }
        }
        return null;
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting craft, World world, int i) {
        if (CraftingManager.func_77594_a().func_82787_a(craft, world) != null) {
            List<ItemStack> result = CraftingHandler.getCraftResult(craft, world);
            if (result.size() == 0) {
                return null;
            }
            if (i < 0) {
                int j1 = -i;
                j1 %= result.size();
                j1 = result.size() - j1;
                if (j1 == result.size()) {
                    j1 = 0;
                }
                return result.get(j1);
            }
            return result.get(i % result.size());
        }
        return null;
    }

    public static List<ItemStack> getCraftResult(InventoryCrafting craft, World world) {
        Iterator recipes = CraftingManager.func_77594_a().func_77592_b().iterator();
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        while (recipes.hasNext()) {
            IRecipe irecipe = (IRecipe)recipes.next();
            if (!irecipe.func_77569_a(craft, world)) continue;
            arraylist.add(irecipe.func_77572_b(craft));
        }
        return arraylist;
    }

    public static IInventory getResultSlot(Container container, int size) {
        if (container == null) {
            return null;
        }
        if (container instanceof ContainerPlayer) {
            return ((ContainerPlayer)container).field_75179_f;
        }
        if (container instanceof ContainerWorkbench) {
            return ((ContainerWorkbench)container).field_75160_f;
        }
        if (notCraftingContainer != null) {
            for (Field field : container.getClass().getDeclaredFields()) {
                if (field == null || !IInventory.class.isAssignableFrom(field.getClass())) continue;
                try {
                    IInventory result = (IInventory)IInventory.class.cast(field.get(container));
                    if (result.func_70302_i_() == size) {
                        return result;
                    }
                }
                catch (ReflectiveOperationException ref) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static int getNumberOfCraft(Container container, World world) {
        InventoryCrafting craft = CraftingHandler.getCraftingMatrix(container);
        if (craft != null) {
            return CraftingHandler.getCraftResult(craft, world).size();
        }
        return 0;
    }
}

