/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.wildlife.integration.waila;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.interfaces.ICropDataSupplier;
import com.draco18s.hardlib.api.internal.CropWeatherOffsets;
import com.draco18s.wildlife.WildlifeBase;
import com.draco18s.wildlife.WildlifeEventHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class WailaItemFrameProvider
implements IWailaEntityProvider {
    private static boolean useMetric;
    private Method me;
    private Method me2;
    private String deg;
    private String cen;
    private String inc;

    public WailaItemFrameProvider() throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> clz = Class.forName("mcp.mobius.waila.api.impl.ModuleRegistrar");
        this.me = clz.getDeclaredMethod("instance", new Class[0]);
        for (Method ff : clz.getDeclaredMethods()) {
            if (!ff.getName().equals("getHeadProviders")) continue;
            this.me2 = ff;
        }
        int codePoint = 7484;
        char[] charPair = Character.toChars(codePoint);
        this.deg = new String(charPair);
        codePoint = 13213;
        charPair = Character.toChars(codePoint);
        this.cen = new String(charPair);
        codePoint = 8243;
        charPair = Character.toChars(codePoint);
        this.inc = new String(charPair);
        useMetric = WildlifeBase.config.getBoolean("metricUnits", "SEASONS", false, "Set to true to use " + this.deg + "C and cm.  Temperatures are only approximately equivalent to the real world\nat 10" + this.deg + "F = 0.1" + this.deg + "MC");
        WildlifeBase.config.save();
    }

    @Override
    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound t;
        NBTTagCompound tag = new NBTTagCompound();
        entity.func_70109_d(tag);
        if (tag.func_74764_b("Item") && (t = tag.func_74775_l("Item")).func_74764_b("id")) {
            short id = t.func_74765_d("id");
            Item it = Item.func_150899_d((int)id);
            if (it == WildlifeBase.thermometer) {
                int z;
                int y;
                int x;
                long lwt = WildlifeEventHandler.getLastWorldTime(entity.field_70170_p.field_73011_w.field_76574_g);
                NBTTagCompound stackTagCompound = null;
                if (t.func_74764_b("tag")) {
                    stackTagCompound = t.func_74775_l("tag");
                    x = (int)entity.field_70165_t;
                    y = (int)entity.field_70163_u;
                    z = (int)entity.field_70161_v;
                } else {
                    x = (int)entity.field_70165_t;
                    y = (int)entity.field_70163_u;
                    z = (int)entity.field_70161_v;
                }
                BiomeGenBase bio = entity.field_70170_p.func_72807_a(x, z);
                float tt = bio.field_76750_F;
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                    tt += WildlifeEventHandler.getSeasonTemp(lwt) * 0.333f;
                }
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) != entity.field_70170_p.func_72874_g(x, z) > y) {
                    tt = (tt + 0.8f) / 2.0f;
                }
                float c = tt;
                if (stackTagCompound != null) {
                    Block block = Block.func_149729_e((int)stackTagCompound.func_74762_e("blockID"));
                    CropWeatherOffsets offs = HardLibAPI.cropManager.getCropOffsets(block);
                    if (block instanceof ICropDataSupplier && stackTagCompound.func_74764_b("HasOffsets")) {
                        float tf = stackTagCompound.func_74760_g("tempflat");
                        float rf = stackTagCompound.func_74760_g("tempflat");
                        int ot = stackTagCompound.func_74762_e("raintime");
                        int or = stackTagCompound.func_74762_e("temptime");
                        offs = new CropWeatherOffsets(tf, rf, ot, or);
                    }
                    List<String> name = new ArrayList<String>();
                    ItemStack itemStack = new ItemStack(block);
                    try {
                        List all = (List)this.me2.invoke(this.me.invoke(null, new Object[0]), block);
                        if (block == Blocks.field_150464_aj) {
                            itemStack = new ItemStack(Items.field_151015_O);
                        }
                        if (block == Blocks.field_150393_bb) {
                            itemStack = new ItemStack(Blocks.field_150423_aK);
                        }
                        if (block == Blocks.field_150394_bc) {
                            itemStack = new ItemStack(Blocks.field_150440_ba);
                        }
                        for (IWailaDataProvider dataProvider : all) {
                            name = dataProvider.getWailaHead(itemStack, name, (IWailaDataAccessor)((Object)accessor), config);
                        }
                        if (name.size() == 0 || ((String)name.get(0)).equals("<ERROR>")) {
                            currenttip.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"description.cropLink") + ": " + itemStack.func_82833_r());
                        } else {
                            currenttip.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"description.cropLink") + ": " + name.get(0).substring(2));
                        }
                    }
                    catch (Exception e) {
                        currenttip.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"description.cropLink") + ": " + itemStack.func_82833_r());
                    }
                    double dt = tt;
                    if (useMetric) {
                        dt = (dt - 0.32) / 1.8;
                    }
                    currenttip.add(StatCollector.func_74838_a((String)"description.temperature") + ": " + Math.round(dt * 50.0) * 2L + this.deg);
                    if (offs.tempTimeOffset != 0) {
                        tt = tt - WildlifeEventHandler.getSeasonTemp(lwt) + WildlifeEventHandler.getSeasonTemp(lwt + (long)offs.tempTimeOffset);
                    }
                    currenttip.add(StatCollector.func_74838_a((String)"description.prefers") + ": " + (useMetric ? (double)Math.round(((double)(0.8f - (tt - c)) - 0.32) / 1.8 * 40.0) * 2.5 : (double)(Math.round((0.8f - ((tt += offs.tempFlat) - c)) * 20.0f) * 5)) + this.deg);
                } else {
                    double dt = tt;
                    if (useMetric) {
                        dt = (dt - 0.32) / 1.8;
                    }
                    currenttip.add(StatCollector.func_74838_a((String)"description.temperature") + ": " + Math.round(dt * 50.0) * 2L + this.deg);
                }
            } else if (it == WildlifeBase.rainmeter) {
                int z;
                int y;
                int x;
                long lwt = WildlifeEventHandler.getLastWorldTime(entity.field_70170_p.field_73011_w.field_76574_g);
                NBTTagCompound stackTagCompound = null;
                if (t.func_74764_b("tag")) {
                    stackTagCompound = t.func_74775_l("tag");
                    x = (int)entity.field_70165_t;
                    y = (int)entity.field_70163_u;
                    z = (int)entity.field_70161_v;
                } else {
                    x = (int)entity.field_70165_t;
                    y = (int)entity.field_70163_u;
                    z = (int)entity.field_70161_v;
                }
                BiomeGenBase bio = entity.field_70170_p.func_72807_a(x, z);
                float r = bio.field_76751_G;
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                    r += WildlifeEventHandler.getSeasonRain(lwt) * 0.333f;
                }
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) != entity.field_70170_p.func_72874_g(x, z) > y) {
                    r = (r + 1.0f) / 2.0f;
                }
                float c = r;
                if (stackTagCompound != null) {
                    Block block = Block.func_149729_e((int)stackTagCompound.func_74762_e("blockID"));
                    CropWeatherOffsets offs = HardLibAPI.cropManager.getCropOffsets(block);
                    if (block instanceof ICropDataSupplier && stackTagCompound.func_74764_b("HasOffsets")) {
                        float tf = stackTagCompound.func_74760_g("tempflat");
                        float rf = stackTagCompound.func_74760_g("tempflat");
                        int ot = stackTagCompound.func_74762_e("raintime");
                        int or = stackTagCompound.func_74762_e("temptime");
                        offs = new CropWeatherOffsets(tf, rf, ot, or);
                    }
                    List<String> name = new ArrayList<String>();
                    ItemStack itemStack = new ItemStack(block);
                    try {
                        List all = (List)this.me2.invoke(this.me.invoke(null, new Object[0]), block);
                        if (block == Blocks.field_150464_aj) {
                            itemStack = new ItemStack(Items.field_151015_O);
                        }
                        if (block == Blocks.field_150393_bb) {
                            itemStack = new ItemStack(Blocks.field_150423_aK);
                        }
                        if (block == Blocks.field_150394_bc) {
                            itemStack = new ItemStack(Blocks.field_150440_ba);
                        }
                        for (IWailaDataProvider dataProvider : all) {
                            name = dataProvider.getWailaHead(itemStack, name, (IWailaDataAccessor)((Object)accessor), config);
                        }
                        if (name.size() == 0 || name.get(0) == "<ERROR>") {
                            currenttip.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"description.cropLink") + ": " + itemStack.func_82833_r());
                        } else {
                            currenttip.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"description.cropLink") + ": " + name.get(0).substring(2));
                        }
                    }
                    catch (Exception e) {
                        currenttip.add(EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"description.cropLink") + ": " + itemStack.func_82833_r());
                    }
                    double dt = r + 1.0f;
                    if (useMetric) {
                        dt /= 0.3937;
                    }
                    currenttip.add(StatCollector.func_74838_a((String)"description.rainfall") + ": " + String.format("%.2f", dt) + (useMetric ? this.cen : this.inc));
                    if (offs.rainTimeOffset != 0) {
                        r = r - WildlifeEventHandler.getSeasonRain(lwt) + WildlifeEventHandler.getSeasonRain(lwt + (long)offs.rainTimeOffset);
                    }
                    dt = 1.0f - ((r += offs.rainFlat) - c);
                    dt += 1.0;
                    if (useMetric) {
                        dt /= 0.3937;
                    }
                    currenttip.add(StatCollector.func_74838_a((String)"description.prefers") + ": " + String.format("%.2f", dt) + (useMetric ? this.cen : this.inc));
                } else {
                    double dt = r + 1.0f;
                    if (useMetric) {
                        dt /= 0.3937;
                    }
                    currenttip.add(StatCollector.func_74838_a((String)"description.rainfall") + ": " + String.format("%.2f", dt) + (useMetric ? this.cen : this.inc));
                }
            } else if (it == WildlifeBase.calendar) {
                currenttip.add(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"description.season"));
                int season = (int)(entity.field_70170_p.func_72820_D() % WildlifeEventHandler.yearLength / (WildlifeEventHandler.yearLength / 4L));
                if (entity.field_70170_p.field_73011_w.field_76575_d) {
                    season += 4;
                }
                switch (season) {
                    case 0: {
                        currenttip.add(StatCollector.func_74838_a((String)"description.spring"));
                        break;
                    }
                    case 1: {
                        currenttip.add(StatCollector.func_74838_a((String)"description.summer"));
                        break;
                    }
                    case 2: {
                        currenttip.add(StatCollector.func_74838_a((String)"description.fall"));
                        break;
                    }
                    case 3: {
                        currenttip.add(StatCollector.func_74838_a((String)"description.winter"));
                        break;
                    }
                    case 4: {
                        currenttip.add(StatCollector.func_74838_a((String)"description.blaze"));
                        break;
                    }
                    case 5: {
                        currenttip.add(StatCollector.func_74838_a((String)"description.fire\t"));
                        break;
                    }
                    case 6: {
                        currenttip.add(StatCollector.func_74838_a((String)"description.rod"));
                        break;
                    }
                    case 7: {
                        currenttip.add(StatCollector.func_74838_a((String)"description.obsidian"));
                    }
                }
            }
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        return null;
    }
}

