/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.recipes.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.draco18s.hardlib.api.HardLibAPI;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class SifterNEI
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Sifter";
    }

    public String getOverlayIdentifier() {
        return "sifter";
    }

    public String getGuiTexture() {
        return "ores:textures/gui/sifter.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if ((outputId.equals("item") || outputId.equals("sifter")) && results.length > 0) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        ItemStack ingredient = HardLibAPI.recipeManager.getSiftRecipeInput(result);
        if (ingredient != null && !ItemStack.func_77989_b((ItemStack)ingredient, (ItemStack)result)) {
            CachedSifterRecipe recipe = new CachedSifterRecipe(ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (ingredients.length >= 1 && ingredients[0] instanceof ItemStack) {
            this.loadUsageRecipes((ItemStack)ingredients[0]);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ItemStack output = HardLibAPI.recipeManager.getSiftResult(ingredient, false);
        if (output != null && !ItemStack.func_77989_b((ItemStack)ingredient, (ItemStack)output)) {
            CachedSifterRecipe recipe = new CachedSifterRecipe(HardLibAPI.recipeManager.getSiftRecipeInput(output));
            this.arecipes.add(recipe);
        }
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(74, 20, 176, 0, 17, 24, 40, 1);
    }

    public class CachedSifterRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private PositionedStack ingredient;
        private PositionedStack stack;

        public CachedSifterRecipe(Object _ingredient) {
            super((TemplateRecipeHandler)SifterNEI.this);
            if (_ingredient instanceof ItemStack) {
                ItemStack ingred = ((ItemStack)_ingredient).func_77946_l();
                ingred.field_77994_a = 64;
                ingred.field_77994_a = HardLibAPI.recipeManager.getSiftAmount(ingred);
                this.ingredient = new PositionedStack((Object)ingred, 66, 2);
                this.stack = new PositionedStack((Object)HardLibAPI.recipeManager.getSiftResult((ItemStack)_ingredient, false), 75, 47);
            } else if (_ingredient instanceof String) {
                ArrayList list = OreDictionary.getOres((String)((String)_ingredient));
                if (list.size() > 0) {
                    this.ingredient = new PositionedStack((Object)list, 66, 2);
                    this.stack = new PositionedStack((Object)HardLibAPI.recipeManager.getSiftResult((ItemStack)_ingredient, false), 75, 47);
                }
            } else {
                this.ingredient = null;
            }
        }

        public PositionedStack getIngredient() {
            return this.ingredient;
        }

        public PositionedStack getResult() {
            return this.stack;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CachedSifterRecipe)) {
                return false;
            }
            CachedSifterRecipe other = (CachedSifterRecipe)((Object)obj);
            if (this.ingredient == null ? other.ingredient != null : (this.ingredient.item == null ? other.ingredient.item != null : !ItemStack.func_77989_b((ItemStack)this.ingredient.item, (ItemStack)other.ingredient.item))) {
                return false;
            }
            return !(this.stack == null ? other.stack != null : (this.stack.item == null ? other.stack.item != null : !ItemStack.func_77989_b((ItemStack)this.stack.item, (ItemStack)other.stack.item)));
        }
    }
}

