/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.entities;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.interfaces.IMechanicalPowerUser;
import com.draco18s.ores.OresBase;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityMillstone
extends TileEntity
implements ISidedInventory,
IMechanicalPowerUser {
    private float grindTime;
    private ItemStack[] inventory = new ItemStack[2];
    private float powerLevel;

    public void func_145845_h() {
        if (this.grindTime > 0.0f) {
            this.grindTime -= this.powerLevel;
            if (this.inventory[0] == null) {
                this.grindTime = 0.0f;
            } else if (this.grindTime <= 0.0f) {
                this.grindItem();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.func_70296_d();
        } else if (this.canGrind()) {
            this.grindTime = 400.0f;
            OresBase.proxy.startMillSound(this);
        } else if (this.inventory[0] != null) {
            ItemStack items;
            int x = 0;
            int z = 0;
            switch (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                case 3: {
                    ++z;
                    break;
                }
                case 5: {
                    --x;
                    break;
                }
                case 7: {
                    --z;
                    break;
                }
                case 9: {
                    ++x;
                }
            }
            TileEntityMillstone te = (TileEntityMillstone)this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z);
            if (te != null && ((items = te.func_70301_a(0)) == null || items.field_77994_a < 64)) {
                if (items == null) {
                    te.func_70299_a(0, this.inventory[0].func_77946_l());
                    this.inventory[0] = null;
                } else if (items.func_77973_b() == this.inventory[0].func_77973_b() && items.func_77960_j() == this.inventory[0].func_77960_j()) {
                    int room = 64 - items.field_77994_a;
                    room = Math.min(room, this.inventory[0].field_77994_a);
                    this.inventory[0].field_77994_a -= room;
                    items.field_77994_a += room;
                    if (this.inventory[0].field_77994_a <= 0) {
                        this.inventory[0] = null;
                    }
                }
            }
        }
    }

    @Override
    public int minimumTorque() {
        return 650;
    }

    @Override
    public float powerScale(int p) {
        float f = (float)p / 40.0f;
        return ((float)Math.sqrt(f) - 0.1f) * 1.1f;
    }

    public float getGrindTime() {
        return this.grindTime;
    }

    public boolean canGrind() {
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) != 1) {
            return false;
        }
        boolean ret = false;
        if (this.inventory[0] == null) {
            ret = false;
        } else {
            ItemStack itemstack = HardLibAPI.recipeManager.getMillResult(this.inventory[0]);
            if (itemstack == null) {
                ret = false;
            } else if (this.inventory[1] == null) {
                ret = true;
            } else if (this.inventory[1].func_77973_b() != itemstack.func_77973_b() || this.inventory[1].func_77960_j() != itemstack.func_77960_j()) {
                ret = false;
            } else {
                int result = this.inventory[1].field_77994_a + itemstack.field_77994_a;
                boolean bl = ret = result <= this.func_70297_j_() && result <= this.inventory[1].func_77976_d();
            }
        }
        if (this.inventory[1] != null && (!ret || !this.field_145850_b.field_72995_K && this.inventory[1].field_77994_a >= 8) && this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            if (!this.field_145850_b.field_72995_K) {
                Random rand = new Random();
                float rx = rand.nextFloat() * 0.6f + 0.2f;
                float ry = rand.nextFloat() * 0.2f + 0.6f - 1.0f;
                float rz = rand.nextFloat() * 0.6f + 0.2f;
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + rx), (double)((float)this.field_145848_d + ry), (double)((float)this.field_145849_e + rz), new ItemStack(this.inventory[1].func_77973_b(), this.inventory[1].field_77994_a, this.inventory[1].func_77960_j()));
                this.field_145850_b.func_72838_d((Entity)entityItem);
                entityItem.field_70159_w = 0.0;
                entityItem.field_70181_x = -0.2f;
                entityItem.field_70179_y = 0.0;
            }
            this.inventory[1] = null;
        }
        return ret;
    }

    private void grindItem() {
        if (this.canGrind()) {
            ItemStack itemstack = HardLibAPI.recipeManager.getMillResult(this.inventory[0]);
            if (this.inventory[1] == null) {
                this.inventory[1] = itemstack.func_77946_l();
            } else if (this.inventory[1].func_77973_b() == itemstack.func_77973_b()) {
                this.inventory[1].field_77994_a += itemstack.field_77994_a;
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
        }
    }

    @Override
    public void setPowerLevel(float p) {
        this.powerLevel = p;
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amt) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(amt);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "Millstone";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return HardLibAPI.recipeManager.canInsert(this, stack) && (this.inventory[slot] == null || this.inventory[slot].func_77973_b() == stack.func_77973_b() && this.inventory[slot].func_77960_j() == stack.func_77960_j());
    }

    public void func_145839_a(NBTTagCompound tc) {
        super.func_145839_a(tc);
        NBTTagList nbttaglist = tc.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.grindTime = tc.func_74760_g("grindTime");
    }

    public void func_145841_b(NBTTagCompound tc) {
        super.func_145841_b(tc);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        tc.func_74782_a("Items", (NBTBase)nbttaglist);
        tc.func_74776_a("grindTime", this.grindTime);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        if (this.grindTime > 0.0f) {
            OresBase.proxy.startMillSound(this);
        }
    }

    public int[] func_94128_d(int side) {
        if (this.field_145850_b != null) {
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (meta % 2 == 0) {
                return new int[0];
            }
            if (side == 1) {
                return new int[]{0};
            }
            if (side == 0) {
                return new int[]{1};
            }
            return new int[0];
        }
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        int meta;
        if (this.field_145850_b != null && ((meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) == 1 || meta % 2 == 0)) {
            return false;
        }
        if (side == 1 && slot == 0) {
            return this.func_94041_b(slot, stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        if (this.field_145850_b != null && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) != 1) {
            return false;
        }
        return side == 0 && slot == 1;
    }

    @Override
    public boolean hasPower() {
        return this.powerLevel > 0.0f;
    }

    @Override
    public String getActionString() {
        return "Grind";
    }
}

