/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.block.ores;

import com.draco18s.hardlib.HashUtils;
import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.interfaces.IBlockMultiBreak;
import com.draco18s.hardlib.api.internal.BlockWrapper;
import com.draco18s.hardlib.api.internal.OreFlowerData;
import com.draco18s.ores.OresBase;
import com.draco18s.ores.util.EnumOreType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.Level;

public abstract class BlockHardOreBase
extends Block
implements IBlockMultiBreak {
    public static final ForgeDirection[] DROP_SEARCH_DIRECTIONS = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.DOWN};
    protected IIcon[] icons;
    private boolean avoidGeneration = false;
    protected final EnumOreType thisType;
    private final int scatterRadius;
    private final int scatterNum;
    private final int clusterSize;
    private final int maxMeta;
    private final int flowerProbability;
    public final int metaChange;
    private int reqCount = 0;
    private int lastIcon = 0;

    public BlockHardOreBase(EnumOreType t, int metaReduction, int metaThreshhold, int flowerChance, int scatRad, int scatNum, int clustSize) {
        super(Material.field_151576_e);
        this.func_149752_b(5.0f);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.thisType = t;
        this.metaChange = metaReduction;
        this.maxMeta = metaThreshhold;
        this.flowerProbability = flowerChance;
        this.scatterRadius = scatRad;
        this.scatterNum = scatNum;
        this.clusterSize = clustSize;
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149691_a(int side, int meta) {
        if (meta < this.icons.length) {
            return this.icons[meta];
        }
        this.reqCount = (this.reqCount + 1) % 100;
        if (this.reqCount == 0) {
            this.lastIcon = (this.lastIcon + 1) % 16;
        }
        return this.icons[15 - this.lastIcon];
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int p) {
        return this.icons[world.func_72805_g(x, y, z)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[16];
        for (int i = 0; i < 16; ++i) {
            this.icons[i] = iconRegister.func_94245_a("ores:ores/" + this.func_149641_N() + "_" + i);
        }
    }

    public abstract int quantityDropped(int var1, int var2, Random var3);

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return OresBase.oreChunks;
    }

    public final int func_149692_a(int meta) {
        return this.thisType.value;
    }

    public final int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List p_149666_3_) {
        p_149666_3_.add(new ItemStack(p_149666_1_, 1, 15));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
        ret.add(new ItemStack(item, count, this.func_149692_a(metadata)));
        for (int m = metadata - this.metaChange; m >= 0; m -= this.metaChange) {
            ArrayList<ItemStack> extra = this.getDropsStandard(world, x, y, z, m, fortune);
            for (ItemStack ex : extra) {
                int c;
                float f = (float)ex.field_77994_a * 0.75f;
                if (!((f -= (float)(c = (int)Math.floor(f))) > 0.0f) || world.field_73012_v.nextFloat() < f) {
                    // empty if block
                }
                ex.field_77994_a = ++c;
            }
            ret.addAll(extra);
        }
        return ret;
    }

    protected ArrayList<ItemStack> getDropsStandard(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        ret.add(new ItemStack(item, count, this.func_149692_a(metadata)));
        return ret;
    }

    protected final void func_149642_a(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
            if (((Boolean)this.captureDrops.get()).booleanValue()) {
                ((List)this.capturedDrops.get()).add(stack);
                return;
            }
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            for (ForgeDirection dir : DROP_SEARCH_DIRECTIONS) {
                if (world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).func_149721_r() && dir != ForgeDirection.DOWN) continue;
                EntityItem entityitem = new EntityItem(world, (double)x + d0 + (double)dir.offsetX, (double)y + d1 + (double)dir.offsetY, (double)z + d2 + (double)dir.offsetZ, stack);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
                return;
            }
        }
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int fortune) {
        if (!world.field_72995_K) {
            ArrayList<ItemStack> drops = this.getDrops(world, x, y, z, meta, fortune);
            drops.subList(1, drops.size()).clear();
            chance = ForgeEventFactory.fireBlockHarvesting(drops, (World)world, (Block)this, (int)x, (int)y, (int)z, (int)meta, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            if (world.func_147439_a(x, y, z) != this && meta >= this.metaChange) {
                world.func_147465_d(x, y, z, (Block)this, meta - this.metaChange, 3);
            }
            for (ItemStack item : drops) {
                if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                this.func_149642_a(world, x, y, z, item);
            }
        }
    }

    protected final ItemStack func_149644_j(int meta) {
        Item item = Item.func_150898_a((Block)this);
        return new ItemStack(item, 1, meta);
    }

    public final boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (player != null && player.field_71075_bZ.field_75098_d) {
            this.avoidGeneration = true;
            world.func_72921_c(x, y, z, 0, 3);
        }
        return this.removedByPlayer(world, player, x, y, z);
    }

    public final void func_149726_b(World world, int x, int y, int z) {
        if (this.avoidGeneration) {
            this.avoidGeneration = false;
            return;
        }
        int s = HashUtils.hash((int)world.func_72905_C(), x);
        s = HashUtils.hash(s, y);
        s = HashUtils.hash(s, z);
        Random rand = new Random(s);
        int m = world.func_72805_g(x, y, z);
        BlockWrapper bw = new BlockWrapper(this, -1);
        OreFlowerData dat = HardLibAPI.oreManager.getOreList().get(bw);
        if (dat == null) {
            Map<BlockWrapper, OreFlowerData> map = HardLibAPI.oreManager.getOreList();
            for (BlockWrapper b : map.keySet()) {
                if (!b.equals(bw)) continue;
                dat = map.get(b);
                OresBase.logger.log(Level.INFO, "Issue retrieving data for " + this.func_149739_a() + ". " + b.block.func_149739_a() + ":" + b.meta + " should be equal to " + bw.block.func_149739_a() + ":" + bw.meta);
                break;
            }
        }
        if (dat != null) {
            if (m < this.maxMeta && rand.nextInt(this.flowerProbability) == 0) {
                int j = 1;
                while (y + j < 250) {
                    if (world.func_147439_a(x, y + j, z) == Blocks.field_150349_c) {
                        OresBase.scatterFlowers(world, x, y + j + 1, z, dat.flower, dat.metadata, this.scatterRadius, this.scatterNum, this.clusterSize);
                        return;
                    }
                    ++j;
                }
            }
        } else {
            OresBase.logger.log(Level.ERROR, "Hard Ore block, " + this.func_149739_a() + " has no flower data.  This is a bug!");
        }
    }

    @Override
    public int getMetaChangeOnBreak() {
        return this.metaChange;
    }
}

