/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hardlib.client;

import com.draco18s.hardlib.HardLib;
import com.draco18s.hazards.UndergroundBase;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

public class TextureAtlasDynamic
extends TextureAtlasSprite {
    protected String textureBase;
    protected String textureOverlay;
    protected Color colorMulti;
    protected boolean invert;

    public TextureAtlasDynamic(String p_i1282_1_, String base, String overlay, Color color, boolean inv) {
        super(p_i1282_1_);
        this.textureBase = base;
        this.textureOverlay = overlay;
        this.colorMulti = color;
        this.invert = inv;
    }

    public void func_94219_l() {
        TextureUtil.func_147955_a((int[][])((int[][])this.field_110976_a.get(0)), (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        this.field_110976_a.clear();
        this.field_110973_g = 0;
        this.field_110983_h = 0;
        ResourceLocation resource1 = new ResourceLocation(this.textureBase);
        ResourceLocation resource2 = new ResourceLocation(this.textureOverlay);
        try {
            TextureMap map = Minecraft.func_71410_x().func_147117_R();
            resource1 = TextureAtlasDynamic.completeResourceLocation(map, resource1, 0);
            resource2 = TextureAtlasDynamic.completeResourceLocation(map, resource2, 0);
            BufferedImage buff = ImageIO.read(manager.func_110536_a(resource1).func_110527_b());
            BufferedImage buff2 = ImageIO.read(manager.func_110536_a(resource2).func_110527_b());
            int[] rawBase = new int[buff.getWidth() * buff.getHeight()];
            int[] rawOverlay = new int[buff2.getWidth() * buff2.getHeight()];
            buff.getRGB(0, 0, buff.getWidth(), buff.getHeight(), rawBase, 0, buff.getWidth());
            buff2.getRGB(0, 0, buff2.getWidth(), buff2.getHeight(), rawOverlay, 0, buff2.getWidth());
            int min = Math.min(buff.getWidth(), buff2.getWidth());
            rawBase = TextureAtlasDynamic.scaleToSmaller(rawBase, buff.getWidth(), min);
            rawOverlay = TextureAtlasDynamic.scaleToSmaller(rawOverlay, buff2.getWidth(), min);
            this.field_130223_c = min;
            this.field_130224_d = min;
            for (int p = 0; p < rawBase.length; ++p) {
                Color c1 = new Color(rawBase[p], true);
                Color c2 = new Color(rawOverlay[p], true);
                c2 = TextureAtlasDynamic.colorize(this.colorMulti, c2, this.invert);
                float a1 = (float)c1.getAlpha() / 255.0f;
                int r1 = c1.getRed();
                int g1 = c1.getGreen();
                int b1 = c1.getBlue();
                float a2 = (float)c2.getAlpha() / 255.0f;
                int r2 = c2.getRed();
                int g2 = c2.getGreen();
                int b2 = c2.getBlue();
                float a3 = a2 + a1 * (1.0f - a2);
                if (a3 > 0.0f) {
                    r1 = Math.round(((float)r2 * a2 + (float)r1 * a1 * (1.0f - a2)) / a3);
                    g1 = Math.round(((float)g2 * a2 + (float)g1 * a1 * (1.0f - a2)) / a3);
                    b1 = Math.round(((float)b2 * a2 + (float)b1 * a1 * (1.0f - a2)) / a3);
                } else {
                    b1 = 0;
                    g1 = 0;
                    r1 = 0;
                }
                Color c3 = new Color(r1, g1, b1, Math.round(a3 * 255.0f));
                rawBase[p] = c3.getRGB();
            }
            int[][] aint = new int[1 + MathHelper.func_151239_c((int)min)][];
            for (int k = 0; k < aint.length; ++k) {
                aint[k] = rawBase;
            }
            this.field_110976_a.add(aint);
        }
        catch (IOException e) {
            UndergroundBase.logger.error("Using missing texture, unable to load " + resource2, (Throwable)e);
            int[][] aint = new int[1][];
            for (int k = 0; k < 1; ++k) {
                aint[k] = new int[256];
                for (int l = 0; l < aint[k].length; ++l) {
                    aint[k][l] = -1;
                }
            }
            this.field_130223_c = 16;
            this.field_130224_d = 16;
            this.field_110976_a.add(aint);
        }
        return false;
    }

    private static int[] scaleToSmaller(int[] data, int width, int min) {
        if (width == min) {
            return data;
        }
        int scale = width / min;
        int[] output = new int[min * min];
        int j = 0;
        for (int i = 0; i < output.length; ++i) {
            if (i % min == 0) {
                j += width;
            }
            output[i] = data[i * scale + j];
        }
        return output;
    }

    private static ResourceLocation completeResourceLocation(TextureMap map, ResourceLocation loc, int c) {
        try {
            return (ResourceLocation)HardLib.proxy.resourceLocation.invoke((Object)map, loc, c);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static Color colorize(Color cm, Color c2, boolean invert) {
        float[] pix = new float[3];
        float[] mul = new float[3];
        Color.RGBtoHSB(c2.getRed(), c2.getGreen(), c2.getBlue(), pix);
        Color.RGBtoHSB(cm.getRed(), cm.getGreen(), cm.getBlue(), mul);
        float v = invert ? 1.0f - pix[2] : pix[2];
        Color c3 = new Color(Color.HSBtoRGB(mul[0], mul[1], v));
        return new Color(c3.getRed(), c3.getGreen(), c3.getBlue(), c2.getAlpha());
    }
}

