/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.common;

import com.kingrunes.somnia.Somnia;
import com.kingrunes.somnia.common.StreamUtils;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class PacketHandler {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        if (event.packet.channel().equals("Somnia")) {
            this.onPacket(event.packet, ((NetHandlerPlayServer)event.handler).field_147369_b);
        }
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        if (event.packet.channel().equals("Somnia")) {
            this.onPacket(event.packet, null);
        }
    }

    public void onPacket(FMLProxyPacket packet, EntityPlayerMP player) {
        DataInputStream in = new DataInputStream((InputStream)new ByteBufInputStream(packet.payload()));
        try {
            byte id = in.readByte();
            switch (id) {
                case 0: {
                    this.handleGUIOpenPacket();
                    break;
                }
                case 1: {
                    this.handleGUIClosePacket(player, in);
                    break;
                }
                case 2: {
                    this.handlePropUpdatePacket(in);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleGUIOpenPacket() throws IOException {
        Somnia.proxy.handleGUIOpenPacket();
    }

    private void handlePropUpdatePacket(DataInputStream in) throws IOException {
        Somnia.proxy.handlePropUpdatePacket(in);
    }

    private void handleGUIClosePacket(EntityPlayerMP player, DataInputStream in) throws IOException {
        Somnia.proxy.handleGUIClosePacket(player);
    }

    public static FMLProxyPacket buildGUIOpenPacket() {
        return PacketHandler.doBuildGUIOpenPacket();
    }

    private static FMLProxyPacket doBuildGUIOpenPacket() {
        PacketBuffer buffer = PacketHandler.unpooled();
        buffer.writeByte(0);
        return new FMLProxyPacket(buffer, "Somnia");
    }

    public static FMLProxyPacket buildGUIClosePacket() {
        return PacketHandler.doBuildGUIClosePacket();
    }

    public static FMLProxyPacket doBuildGUIClosePacket() {
        PacketBuffer buffer = PacketHandler.unpooled();
        buffer.writeByte(1);
        return new FMLProxyPacket(buffer, "Somnia");
    }

    public static FMLProxyPacket buildPropUpdatePacket(int target, Object ... fields) {
        PacketBuffer buffer = PacketHandler.unpooled();
        buffer.writeByte(2);
        buffer.writeByte(target);
        buffer.writeInt(fields.length / 2);
        for (int i = 0; i < fields.length; ++i) {
            buffer.writeByte(((Integer)fields[i]).intValue());
            StreamUtils.writeObject(fields[++i], buffer);
        }
        return new FMLProxyPacket(buffer, "Somnia");
    }

    private static PacketBuffer unpooled() {
        return new PacketBuffer(Unpooled.buffer());
    }

    public static Byte byteOf(int i) {
        return (byte)i;
    }
}

