/*
 * Decompiled with CFR 0.152.
 */
package com.kingrunes.somnia.asm;

import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SClassTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.equalsIgnoreCase("net.minecraft.client.renderer.EntityRenderer")) {
            return this.patchEntityRenderer(bytes, false);
        }
        if (name.equalsIgnoreCase("cji")) {
            return this.patchEntityRenderer(bytes, true);
        }
        if (name.equalsIgnoreCase("net.minecraft.world.WorldServer")) {
            return this.patchWorldServer(bytes, false);
        }
        if (name.equalsIgnoreCase("qt")) {
            return this.patchWorldServer(bytes, true);
        }
        if (name.equalsIgnoreCase("net.minecraft.world.chunk.Chunk")) {
            return this.patchChunk(bytes, false);
        }
        if (name.equalsIgnoreCase("bfh")) {
            return this.patchChunk(bytes, true);
        }
        if (name.equalsIgnoreCase("net.minecraft.server.MinecraftServer")) {
            return this.patchMinecraftServer(bytes);
        }
        return bytes;
    }

    private byte[] patchEntityRenderer(byte[] bytes, boolean obf) {
        String methodName = obf ? "b" : "updateCameraAndRender";
        String methodName2 = obf ? "a" : "renderWorld";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean f = true;
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodName) || !m.desc.equals("(F)V")) continue;
            for (AbstractInsnNode ain : m.instructions) {
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(methodName2) || !min.desc.equalsIgnoreCase("(FJ)V") || min.getOpcode() != 182) continue;
                min.setOpcode(184);
                min.name = "renderWorld";
                min.owner = "com/kingrunes/somnia/Somnia";
                VarInsnNode vin = (VarInsnNode)m.instructions.get(m.instructions.indexOf((AbstractInsnNode)min) - (f ? 9 : 3));
                m.instructions.remove((AbstractInsnNode)vin);
                f = false;
            }
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] patchWorldServer(byte[] bytes, boolean obf) {
        String methodTick = obf ? "c" : "tick";
        String methodGetGameRule = obf ? "b" : "getGameRuleBooleanValue";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodTick) || !m.desc.equals("()V")) continue;
            for (AbstractInsnNode ain : m.instructions) {
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(methodGetGameRule) || !min.desc.equals("(Ljava/lang/String;)Z")) continue;
                int index = m.instructions.indexOf((AbstractInsnNode)min);
                LdcInsnNode lin = (LdcInsnNode)m.instructions.get(index - 1);
                if (!lin.cst.equals("doMobSpawning")) continue;
                min.setOpcode(184);
                min.desc = "(Lnet/minecraft/world/WorldServer;)Z";
                min.name = "doMobSpawning";
                min.owner = "com/kingrunes/somnia/Somnia";
                m.instructions.remove((AbstractInsnNode)lin);
                m.instructions.remove(m.instructions.get(index - 2));
                break block0;
            }
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] patchChunk(byte[] bytes, boolean obf) {
        String methodName = obf ? "b" : "func_150804_b";
        String methodName2 = obf ? "n" : "func_150809_p";
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals(methodName)) continue;
            for (AbstractInsnNode ain : m.instructions) {
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals(methodName2)) continue;
                min.setOpcode(184);
                min.desc = "(Lnet/minecraft/world/chunk/Chunk;)V";
                min.name = "chunkLightCheck";
                min.owner = "com/kingrunes/somnia/Somnia";
            }
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] patchMinecraftServer(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        Iterator methods = classNode.methods.iterator();
        AbstractInsnNode ain2 = null;
        while (methods.hasNext()) {
            MethodNode m = (MethodNode)methods.next();
            if (!m.name.equals("y") && !m.name.equals("tick") || !m.desc.equals("()V")) continue;
            AbstractInsnNode lrin = null;
            for (AbstractInsnNode ain2 : m.instructions) {
                if (!(ain2 instanceof InsnNode) || ((InsnNode)ain2).getOpcode() != 177) continue;
                lrin = ain2;
            }
            if (lrin == null) break;
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, "com/kingrunes/somnia/Somnia", "tick", "()V", false));
            m.instructions.insertBefore(lrin, toInject);
            break;
        }
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

