/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.wildlife.integration.waila;

import com.draco18s.wildlife.WildlifeEventHandler;
import com.draco18s.wildlife.entity.ai.EntityAgeTracker;
import com.draco18s.wildlife.util.AnimalUtil;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class WailaAnimalProvider
implements IWailaEntityProvider {
    private String infinity;

    public WailaAnimalProvider() {
        int codePoint = 8734;
        char[] charPair = Character.toChars(codePoint);
        this.infinity = new String(charPair);
    }

    @Override
    public Entity getWailaOverride(IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    @Override
    public List<String> getWailaHead(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public List<String> getWailaBody(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        EntityAnimal anim;
        EntityAgeTracker ageTrack;
        if (entity instanceof EntityAnimal && (ageTrack = WildlifeEventHandler.instance.getTracker(anim = (EntityAnimal)entity)) != null) {
            long ca = ageTrack.entityAge;
            long da = ageTrack.deathAge;
            int relative = Math.round(ca / (long)(AnimalUtil.animalMaxAge / ageTrack.ageFactor / 8));
            switch (relative) {
                case 0: 
                case 1: {
                    if (((EntityAnimal)entity).func_70631_g_()) {
                        currenttip.add(StatCollector.func_74838_a((String)"age.baby"));
                        break;
                    }
                    currenttip.add(StatCollector.func_74838_a((String)"age.young"));
                    break;
                }
                case 2: 
                case 3: {
                    currenttip.add(StatCollector.func_74838_a((String)"age.mature"));
                    break;
                }
                case 4: 
                case 5: {
                    currenttip.add(StatCollector.func_74838_a((String)"age.adult"));
                    break;
                }
                case 6: 
                case 7: {
                    currenttip.add(StatCollector.func_74838_a((String)"age.old"));
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    currenttip.add(StatCollector.func_74838_a((String)"age.ancient"));
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    currenttip.add(StatCollector.func_74838_a((String)"age.unaging"));
                    break;
                }
                default: {
                    currenttip.add("ERROR: Age " + relative + " unknown");
                }
            }
        }
        return currenttip;
    }

    @Override
    public List<String> getWailaTail(Entity entity, List<String> currenttip, IWailaEntityAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, Entity ent, NBTTagCompound tag, World world) {
        return null;
    }
}

