/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.wildlife;

import CustomOreGen.Util.CogOreGenEvent;
import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.api.interfaces.ICropDataSupplier;
import com.draco18s.hardlib.api.internal.CropWeatherOffsets;
import com.draco18s.hardlib.events.EntityAnimalInteractEvent;
import com.draco18s.hardlib.events.SpecialBlockEvent;
import com.draco18s.wildlife.WildlifeBase;
import com.draco18s.wildlife.entity.EntityGoat;
import com.draco18s.wildlife.entity.EntityLizard;
import com.draco18s.wildlife.entity.TileEntityGrassSnow;
import com.draco18s.wildlife.entity.ai.EntityAIAging;
import com.draco18s.wildlife.entity.ai.EntityAgeTracker;
import com.draco18s.wildlife.util.AnimalUtil;
import com.draco18s.wildlife.util.StatsAchievements;
import com.draco18s.wildlife.util.TreeDataHooks;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenTaiga;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import org.apache.logging.log4j.Level;
import squeek.applecore.api.plants.PlantGrowthEvent;

public class WildlifeEventHandler {
    private ArrayList<EntityAnimal> toConstruct = new ArrayList();
    private HashMap<EntityAnimal, EntityAgeTracker> tracker = new HashMap();
    public static boolean trackTrees;
    public static boolean autoSaplings;
    public static boolean doYearCycle;
    public static int weekLength;
    public static long yearLength;
    public static boolean doSnowMelt;
    public static boolean doSlowCrops;
    public static boolean doBiomeCrops;
    public static boolean doRawLeather;
    public static boolean doNativeTreeKill;
    public static int cropsWorst;
    public static boolean modifyAnimalDrops;
    public static int[] dimensionBlacklist;
    private Random rand = new Random();
    public static Field rains;
    public static Field snows;
    private HashMap<Integer, BiomeWeatherData> biomeTemps = new HashMap();
    BiomeGenBase[] allBiomes;
    private float tempStatic;
    private float rainStatic;
    private final int WEEK_MODULO = 2400;
    private HashMap<Integer, Long> lastWorldTime = new HashMap();
    private long lastClientWorldTime = 0L;
    public static WildlifeEventHandler instance;

    public WildlifeEventHandler() {
        this.tempStatic = WildlifeBase.config.getFloat("staticTempModifier", "SEASONS", WildlifeEventHandler.getSeasonTemp(0L), -2.0f, 2.0f, "Takes the place of the season modifier when seasons are off.\n");
        this.rainStatic = WildlifeBase.config.getFloat("staticRainModifier", "SEASONS", WildlifeEventHandler.getSeasonRain(0L), -2.0f, 2.0f, "Takes the place of the season modifier when seasons are off.\n");
        WildlifeBase.config.save();
        for (BiomeGenBase bio : this.allBiomes = (BiomeGenBase[])FluentIterable.from(Arrays.asList(BiomeGenBase.func_150565_n())).filter(Predicates.notNull()).toArray(BiomeGenBase.class)) {
            BiomeWeatherData dat = this.biomeTemps.get(bio.field_76756_M);
            BiomeGenBase bio2 = bio;
            if (bio.field_76756_M >= 128 && BiomeGenBase.func_150565_n()[bio.field_76756_M - 128] != null && bio.func_150569_a(BiomeGenBase.func_150565_n()[bio.field_76756_M - 128])) {
                bio2 = BiomeGenBase.func_150565_n()[bio.field_76756_M - 128];
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                dat = new BiomeWeatherData(bio.field_76750_F, bio.field_76751_G, 0.667f, 1.0f);
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH)) {
                bio.field_76750_F -= 0.3f;
                dat = new BiomeWeatherData(bio.field_76750_F, bio.field_76751_G, 0.667f, 1.0f);
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                bio.field_76750_F += 1.0f;
                bio.field_76751_G -= 2.0f;
                dat = new BiomeWeatherData(bio.field_76750_F, bio.field_76751_G, 1.0f, 0.25f);
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
                bio.field_76750_F -= 0.1f;
                bio.field_76751_G += 0.1f;
                dat = new BiomeWeatherData(bio.field_76750_F, bio.field_76751_G, 0.4f, 4.0f);
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                if (bio.field_76750_F > 1.5f) {
                    bio.field_76750_F -= 0.8f;
                }
                bio.field_76751_G -= 0.3f;
                dat = new BiomeWeatherData(bio.field_76750_F, bio.field_76751_G, 0.4f, 2.5f);
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                bio.field_76750_F += 0.1f;
                bio.field_76751_G += 0.3f;
                dat = new BiomeWeatherData(bio.field_76750_F, bio.field_76751_G, 0.667f, 0.5f);
            }
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH)) {
                dat = new BiomeWeatherData(bio.field_76750_F, bio.field_76751_G, 0.667f, 0.5f);
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
                bio.field_76750_F -= 0.5f;
                bio.field_76751_G -= 2.5f;
                dat = new BiomeWeatherData(bio.field_76750_F, bio.field_76751_G, 1.5f, 1.0f);
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio2, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
                if ((double)bio.field_76750_F >= 0.3) {
                    bio.field_76750_F -= 0.2f;
                }
                bio.field_76750_F -= 0.1f;
                dat = new BiomeWeatherData(bio.field_76750_F, bio.field_76751_G, 0.5f, 1.0f);
            } else {
                bio.field_76750_F = (float)((double)bio.field_76750_F - 0.2);
                dat = new BiomeWeatherData(bio.field_76750_F, bio.field_76751_G, 1.0f, 1.0f);
            }
            this.biomeTemps.put(bio.field_76756_M, dat);
        }
        instance = this;
    }

    @SubscribeEvent
    public void onEntityAdded(EntityJoinWorldEvent event) {
        if (AnimalUtil.animalGlobalAgeRate > 0 && event.entity instanceof EntityAnimal && !event.entity.field_70170_p.field_72995_K) {
            EntityAnimal animal = (EntityAnimal)event.entity;
            EntityAgeTracker t = new EntityAgeTracker();
            animal.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIAging(new Random(), animal, event.entity.getClass(), t));
            this.tracker.put(animal, t);
        }
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayerMP p;
            int val;
            EntityPlayer player = (EntityPlayer)event.entity;
            player.func_71064_a((StatBase)StatsAchievements.playTime, 1);
            if (player instanceof EntityPlayerMP && (long)(val = (p = (EntityPlayerMP)player).func_147099_x().func_77444_a((StatBase)StatsAchievements.playTime)) > yearLength) {
                player.func_71064_a((StatBase)StatsAchievements.playAYear, 1);
            }
        }
    }

    public EntityAgeTracker getTracker(EntityAnimal animal) {
        return this.tracker.get(animal);
    }

    @SubscribeEvent
    public void onEntityDead(LivingDropsEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (event.entity instanceof EntityAgeable && ((EntityAgeable)event.entity).func_70631_g_()) {
            return;
        }
        ArrayList<EntityItem> drps = new ArrayList<EntityItem>();
        if (modifyAnimalDrops) {
            EntityItem e;
            ItemStack foodItem;
            ArrayList<FoodDrops> foodItems = new ArrayList<FoodDrops>();
            int totalLeather = -1;
            int totalWool = -1;
            if (event.entity instanceof EntityCow || event.entity instanceof EntityPig || event.entity instanceof EntityHorse) {
                totalLeather = 0;
            }
            if (event.entity instanceof EntitySheep) {
                totalWool = 0;
            }
            for (EntityItem d : event.drops) {
                FoodDrops thisDrop = new FoodDrops(d.func_92059_d().func_77973_b(), d.func_92059_d().field_77994_a);
                if (d.func_92059_d().func_77973_b() instanceof ItemFood) {
                    if (!foodItems.contains(thisDrop)) {
                        foodItems.add(thisDrop);
                        continue;
                    }
                    thisDrop = (FoodDrops)foodItems.get(foodItems.indexOf(thisDrop));
                    thisDrop.num += d.func_92059_d().field_77994_a;
                    continue;
                }
                if (d.func_92059_d().func_77973_b() == Items.field_151116_aA) {
                    if (totalLeather >= 0) {
                        totalLeather += d.func_92059_d().field_77994_a;
                    }
                    if (doRawLeather) {
                        foodItem = new ItemStack(WildlifeBase.itemRawLeather);
                        foodItem.field_77994_a = d.func_92059_d().field_77994_a;
                        EntityItem e2 = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                        drps.add(e2);
                        continue;
                    }
                    drps.add(d);
                    continue;
                }
                if (totalWool >= 0 && d.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L)) {
                    totalWool += d.func_92059_d().field_77994_a;
                    drps.add(d);
                    continue;
                }
                drps.add(d);
            }
            event.drops.clear();
            event.drops.addAll(drps);
            if (event.source == DamageSource.field_82727_n) {
                return;
            }
            if (foodItems.size() > 0) {
                for (FoodDrops dr : foodItems) {
                    foodItem = new ItemStack(dr.dropped);
                    if (event.entity instanceof EntityCow) {
                        foodItem.field_77994_a = 4 + this.rand.nextInt(7);
                    } else if (event.entity instanceof EntityGoat) {
                        foodItem = (double)((ItemFood)dr.dropped).func_150906_h(foodItem) > 0.5 ? new ItemStack(WildlifeBase.cookedChevon) : new ItemStack(WildlifeBase.rawChevon);
                        foodItem.field_77994_a = 2 + this.rand.nextInt(4);
                    } else {
                        foodItem.field_77994_a = event.entity instanceof EntitySheep ? 2 + this.rand.nextInt(4) : (event.entity instanceof EntityPig ? 3 + this.rand.nextInt(3) : dr.num);
                    }
                    EntityItem e3 = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                    event.drops.add(e3);
                }
            }
            if (totalLeather >= 0) {
                foodItem = doRawLeather ? new ItemStack(WildlifeBase.itemRawLeather) : new ItemStack(Items.field_151116_aA);
                foodItem.field_77994_a = 1 + this.rand.nextInt(2);
                e = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                event.drops.add(e);
                foodItem.field_77994_a = 1 + this.rand.nextInt(2);
                e = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                event.drops.add(e);
                if (event.entity instanceof EntityCow) {
                    foodItem.field_77994_a = 4 + this.rand.nextInt(3);
                    e = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                    event.drops.add(e);
                } else if (event.entity instanceof EntityHorse) {
                    foodItem.field_77994_a = 1;
                    e = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                    event.drops.add(e);
                }
            }
            if (totalWool >= 0) {
                if (event.entity instanceof EntitySheep) {
                    EntitySheep s = (EntitySheep)event.entity;
                    foodItem = new ItemStack(Blocks.field_150325_L, 1, s.func_70896_n());
                } else {
                    foodItem = new ItemStack(Blocks.field_150325_L);
                }
                foodItem.field_77994_a = 1 + this.rand.nextInt(3);
                e = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                event.drops.add(e);
            }
            if (event.entity instanceof EntitySkeleton) {
                foodItem = new ItemStack(Items.field_151032_g);
                foodItem.field_77994_a = 3 + this.rand.nextInt(2);
                e = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                event.drops.add(e);
                foodItem = new ItemStack(Items.field_151103_aS);
                foodItem.field_77994_a = 1;
                e = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                event.drops.add(e);
            }
            if (event.entity instanceof EntitySpider) {
                foodItem = new ItemStack(Items.field_151007_F);
                foodItem.field_77994_a = 2;
                e = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                event.drops.add(e);
            }
        } else if (doRawLeather) {
            for (EntityItem d : event.drops) {
                if (d.func_92059_d().func_77973_b() == Items.field_151116_aA) {
                    ItemStack foodItem = new ItemStack(WildlifeBase.itemRawLeather);
                    foodItem.field_77994_a = d.func_92059_d().field_77994_a;
                    EntityItem e = new EntityItem(event.entity.field_70170_p, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, foodItem.func_77946_l());
                    drps.add(e);
                    continue;
                }
                drps.add(d);
            }
            event.drops.clear();
            event.drops.addAll(drps);
        }
        if (event.entity instanceof EntityLizard && event.source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)event.source.func_76364_f();
            p.func_71064_a((StatBase)StatsAchievements.killLizard, 1);
        }
    }

    @SubscribeEvent
    public void onPickup(PlayerEvent.ItemPickupEvent event) {
        Item item = event.pickedUp.func_92059_d().func_77973_b();
        if (item == WildlifeBase.itemRawLeather) {
            event.player.func_71064_a((StatBase)StatsAchievements.collectRawhide, 1);
        }
        if (item == WildlifeBase.winterWheatSeeds) {
            event.player.func_71064_a((StatBase)StatsAchievements.collectWinterWheat, 1);
        }
        if (item == Item.func_150898_a((Block)WildlifeBase.rottingWood)) {
            event.player.func_71064_a((StatBase)StatsAchievements.collectCompost, 1);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        if (item == Item.func_150898_a((Block)WildlifeBase.blockTanner)) {
            event.player.func_71064_a((StatBase)StatsAchievements.craftTanner, 1);
        }
        if (item == WildlifeBase.thermometer || item == WildlifeBase.rainmeter) {
            event.player.func_71064_a((StatBase)StatsAchievements.craftThermometer, 1);
        }
    }

    @SubscribeEvent
    public void harvestGrass(BlockEvent.HarvestDropsEvent event) {
        if (event.block instanceof BlockTallGrass) {
            BiomeGenBase bio = event.world.func_72807_a(event.x, event.z);
            if ((double)this.biomeTemps.get((Object)Integer.valueOf((int)bio.field_76756_M)).temp <= 0.3) {
                ArrayList<ItemStack> drps = new ArrayList<ItemStack>();
                for (ItemStack is : event.drops) {
                    if (is.func_77973_b() == Items.field_151014_N) {
                        drps.add(new ItemStack(WildlifeBase.winterWheatSeeds, is.field_77994_a));
                        continue;
                    }
                    drps.add(is);
                }
                event.drops.clear();
                event.drops.addAll(drps);
            }
        }
        if (event.block instanceof BlockCrops) {
            EntityPlayer p;
            boolean flag3;
            Block block = event.world.func_147439_a(event.x, event.y, event.z - 1);
            Block block1 = event.world.func_147439_a(event.x, event.y, event.z + 1);
            Block block2 = event.world.func_147439_a(event.x - 1, event.y, event.z);
            Block block3 = event.world.func_147439_a(event.x + 1, event.y, event.z);
            Block block4 = event.world.func_147439_a(event.x - 1, event.y, event.z - 1);
            Block block5 = event.world.func_147439_a(event.x + 1, event.y, event.z - 1);
            Block block6 = event.world.func_147439_a(event.x + 1, event.y, event.z + 1);
            Block block7 = event.world.func_147439_a(event.x - 1, event.y, event.z + 1);
            boolean flag = block2 == Blocks.field_150350_a || block2 == WildlifeBase.weeds || block3 == Blocks.field_150350_a || block3 == WildlifeBase.weeds || block == Blocks.field_150350_a || block == WildlifeBase.weeds || block1 == Blocks.field_150350_a || block1 == WildlifeBase.weeds || block4 == Blocks.field_150350_a || block4 == WildlifeBase.weeds || block5 == Blocks.field_150350_a || block5 == WildlifeBase.weeds || block6 == Blocks.field_150350_a || block6 == WildlifeBase.weeds || block7 == Blocks.field_150350_a || block7 == WildlifeBase.weeds;
            boolean bl = flag3 = block2 == Blocks.field_150404_cg || block1 == Blocks.field_150404_cg || block2 == Blocks.field_150404_cg || block3 == Blocks.field_150404_cg || block4 == Blocks.field_150404_cg || block5 == Blocks.field_150404_cg || block6 == Blocks.field_150404_cg || block7 == Blocks.field_150404_cg;
            if (!flag && !flag3) {
                EntityPlayer p2;
                boolean flag2;
                boolean flag0 = block2 == event.block || block3 == event.block;
                boolean flag1 = block == event.block || block1 == event.block;
                boolean bl2 = flag2 = block4 == event.block || block5 == event.block || block6 == event.block || block7 == event.block;
                if (!(flag2 || flag0 && flag1 || (p2 = event.world.func_72977_a((double)event.x, (double)event.y, (double)event.z, 5.0)) == null)) {
                    p2.func_71064_a((StatBase)StatsAchievements.cropRotation, 1);
                }
            } else if (flag3 && (p = event.world.func_72977_a((double)event.x, (double)event.y, (double)event.z, 5.0)) != null) {
                p.func_71064_a((StatBase)StatsAchievements.weedSuppressor, 1);
            }
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkDataEvent.Load event) {
        if (!event.world.field_72995_K) {
            TreeDataHooks.readData(event.world, event.getChunk().field_76635_g, event.getChunk().field_76647_h, event.getData());
        }
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        if (!event.world.field_72995_K) {
            TreeDataHooks.saveData(event.world, event.getChunk().field_76635_g, event.getChunk().field_76647_h, event.getData());
        }
    }

    @SubscribeEvent
    public void chunkGen(CogOreGenEvent event) {
        if (trackTrees && !event.world.field_72995_K && event.world.field_73011_w.field_76574_g > Integer.MIN_VALUE) {
            Chunk c = event.world.func_72938_d(event.worldX, event.worldZ);
            int cx = c.field_76635_g;
            int cz = c.field_76647_h;
            WildlifeBase.treeCounter.generate(null, cx, cz, event.world);
        }
    }

    @SubscribeEvent
    public void onSaplingItemDead(ItemExpireEvent event) {
        block14: {
            World world;
            Block id;
            ItemStack item;
            EntityItem ent;
            block15: {
                int z;
                int y;
                int x;
                block16: {
                    block18: {
                        block17: {
                            if (!autoSaplings) break block14;
                            ent = event.entityItem;
                            item = ent.func_92059_d();
                            if (item.field_77994_a > 1) {
                                ItemStack i2 = item.func_77946_l();
                                --i2.field_77994_a;
                                EntityItem e = new EntityItem(event.entityItem.field_70170_p, event.entityItem.field_70165_t, event.entityItem.field_70163_u + 0.25, event.entityItem.field_70161_v, i2);
                                e.field_70292_b = event.entityItem.field_70292_b - 10;
                                event.entityItem.field_70170_p.func_72838_d((Entity)e);
                                item.field_77994_a = 1;
                            }
                            if (item == null || !(item.func_77973_b() instanceof ItemBlock)) break block15;
                            id = Block.func_149634_a((Item)item.func_77973_b());
                            world = ent.field_70170_p;
                            x = MathHelper.func_76128_c((double)ent.field_70165_t);
                            y = MathHelper.func_76128_c((double)ent.field_70163_u);
                            z = MathHelper.func_76128_c((double)ent.field_70161_v);
                            int r = 10;
                            if (item.func_77960_j() == 0) {
                                r = 14;
                            }
                            if (item.func_77960_j() == 2) {
                                r = 12;
                            }
                            if (HardLibAPI.plantManager.getType(id) == null) break block14;
                            if (!id.func_149742_c(world, x, y, z) || item.func_77960_j() != 3 && item.func_77960_j() != 5 && this.rand.nextInt(r) >= 6) break block16;
                            if (item.func_77960_j() != 5 && (item.func_77960_j() != 3 && item.func_77960_j() != 1 || this.rand.nextInt(4) != 0) && (item.func_77960_j() != 1 || world.func_72807_a(x, z).func_150562_l() != BiomeGenTaiga.class)) break block17;
                            this.handle2x2Placement(ent, item, id, x, y, z);
                            break block14;
                        }
                        if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)world.func_72807_a(x, z), (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || world.func_147439_a(x, y, z).func_149688_o() != Material.field_151586_h) break block18;
                        boolean placed = false;
                        for (int oy = 0; oy <= 3 && !placed; ++oy) {
                            for (int ox = -5; ox <= 5 && !placed; ++ox) {
                                for (int oz = -5; oz <= 5 && !placed; ++oz) {
                                    if (world.func_147439_a(x + ox, y + oy, z + oz) != Blocks.field_150349_c) continue;
                                    world.func_147465_d(x + ox, y + oy + 1, z + oz, id, item.func_77960_j() | 8, 3);
                                    if (trackTrees) {
                                        TreeDataHooks.addTree(world, x + ox, y + oy + 1, z + oz, this.rand.nextInt(3000));
                                    }
                                    placed = true;
                                }
                            }
                        }
                        break block14;
                    }
                    world.func_147465_d(x, y, z, id, item.func_77960_j() | 8, 3);
                    if (!trackTrees) break block14;
                    TreeDataHooks.addTree(world, x, y, z, this.rand.nextInt(3000));
                    break block14;
                }
                if (item.func_77960_j() != 3 || world.func_147439_a(x, y - 1, z) != Blocks.field_150362_t || world.func_147439_a(x, y - 2, z) != Blocks.field_150349_c) break block14;
                world.func_147465_d(x, y - 1, z, id, item.func_77960_j() | 8, 3);
                if (trackTrees) {
                    TreeDataHooks.addTree(world, x, y - 1, z, this.rand.nextInt(3000));
                }
                break block14;
            }
            if (item.func_77973_b() == Items.field_151120_aE) {
                int z;
                int y;
                id = Blocks.field_150436_aH;
                world = ent.field_70170_p;
                int x = MathHelper.func_76128_c((double)ent.field_70165_t);
                if (id.func_149742_c(world, x, y = MathHelper.func_76128_c((double)ent.field_70163_u), z = MathHelper.func_76128_c((double)ent.field_70161_v)) && world.func_147437_c(x, y, z)) {
                    world.func_147465_d(x, y, z, id, item.func_77960_j(), 3);
                } else {
                    boolean placed = false;
                    for (int oy = 0; oy <= 2 && !placed; ++oy) {
                        for (int ox = -3; ox <= 3 && !placed; ++ox) {
                            for (int oz = -3; oz <= 3 && !placed; ++oz) {
                                if (!id.func_149742_c(world, x + ox, y + oy, z + oz) || !world.func_147437_c(x + ox, y + oy, z + oz)) continue;
                                world.func_147465_d(x + ox, y + oy, z + oz, id, item.func_77960_j(), 3);
                                placed = true;
                            }
                        }
                    }
                }
            }
        }
    }

    private void handle2x2Placement(EntityItem ent, ItemStack item, Block id, int x, int y, int z) {
        int area = this.canMake2x2(ent.field_70170_p, id, x, y, z);
        if (area >= 1) {
            List nearbyItems = ent.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - 5), (double)(y - 2), (double)(z - 5), (double)(x + 5), (double)(y + 2), (double)(z + 5)));
            int count = ent.func_92059_d().field_77994_a;
            if (nearbyItems.size() > 0) {
                ArrayList<EntityItem> sameType = new ArrayList<EntityItem>();
                for (EntityItem ee : nearbyItems) {
                    ItemStack eitem = ee.func_92059_d();
                    if (eitem == null || !(eitem.func_77973_b() instanceof ItemBlock) || eitem.func_77960_j() != item.func_77960_j() || ee == ent) continue;
                    sameType.add(ee);
                    count += eitem.field_77994_a;
                }
                if (count >= 3) {
                    int c = ent.func_92059_d().field_77994_a;
                    Vec3 pos = Vec3.func_72443_a((double)x, (double)y, (double)z);
                    int bestLight = ent.field_70170_p.func_72957_l(x, y, z);
                    for (int i = sameType.size() - 1; i >= 0 && c < 3; --i) {
                        int atArea;
                        EntityItem eii = (EntityItem)sameType.get(i);
                        int lightAt = ent.field_70170_p.func_72957_l((int)eii.field_70165_t, (int)eii.field_70163_u, (int)eii.field_70161_v);
                        if (lightAt > bestLight && (atArea = this.canMake2x2(ent.field_70170_p, id, (int)eii.field_70165_t, (int)eii.field_70163_u, (int)eii.field_70161_v)) > 0) {
                            pos.field_72450_a = eii.field_70165_t;
                            pos.field_72448_b = eii.field_70163_u;
                            pos.field_72449_c = eii.field_70161_v;
                        }
                        while (eii.func_92059_d().field_77994_a > 0 && c < 3) {
                            ++c;
                            --eii.func_92059_d().field_77994_a;
                        }
                        if (eii.func_92059_d().field_77994_a != 0) continue;
                        eii.func_70106_y();
                    }
                    x = (int)pos.field_72450_a;
                    y = (int)pos.field_72448_b;
                    z = (int)pos.field_72449_c;
                    area = this.canMake2x2(ent.field_70170_p, id, x, y, z);
                    switch (area) {
                        case 1: {
                            ent.field_70170_p.func_147465_d(x, y, z, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x + 1, y, z, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x, y, z + 1, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x + 1, y, z + 1, id, item.func_77960_j() | 8, 3);
                            break;
                        }
                        case 2: {
                            ent.field_70170_p.func_147465_d(x, y, z, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x + 1, y, z, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x, y, z - 1, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x + 1, y, z - 1, id, item.func_77960_j() | 8, 3);
                            break;
                        }
                        case 3: {
                            ent.field_70170_p.func_147465_d(x, y, z, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x - 1, y, z, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x, y, z - 1, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x - 1, y, z - 1, id, item.func_77960_j() | 8, 3);
                            break;
                        }
                        case 4: {
                            ent.field_70170_p.func_147465_d(x, y, z, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x - 1, y, z, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x, y, z + 1, id, item.func_77960_j() | 8, 3);
                            ent.field_70170_p.func_147465_d(x - 1, y, z + 1, id, item.func_77960_j() | 8, 3);
                        }
                    }
                    if (trackTrees) {
                        TreeDataHooks.addTree(ent.field_70170_p, x, y, z, this.rand.nextInt(3000));
                        TreeDataHooks.addTree(ent.field_70170_p, x + 1, y, z, this.rand.nextInt(3000));
                        TreeDataHooks.addTree(ent.field_70170_p, x - 1, y, z, this.rand.nextInt(3000));
                        TreeDataHooks.addTree(ent.field_70170_p, x, y, z + 1, this.rand.nextInt(3000));
                        TreeDataHooks.addTree(ent.field_70170_p, x, y, z - 1, this.rand.nextInt(3000));
                        TreeDataHooks.addTree(ent.field_70170_p, x + 1, y, z + 1, this.rand.nextInt(3000));
                        TreeDataHooks.addTree(ent.field_70170_p, x + 1, y, z - 1, this.rand.nextInt(3000));
                        TreeDataHooks.addTree(ent.field_70170_p, x - 1, y, z + 1, this.rand.nextInt(3000));
                        TreeDataHooks.addTree(ent.field_70170_p, x - 1, y, z - 1, this.rand.nextInt(3000));
                    }
                } else {
                    boolean placed = false;
                    for (int oy = -2; oy <= 2 && !placed; ++oy) {
                        for (int ox = -5; ox <= 5 && !placed; ++ox) {
                            for (int oz = -5; oz <= 5 && !placed; ++oz) {
                                if (!(ent.field_70170_p.func_147439_a(x + ox, y + oy, z + oz) instanceof BlockSapling)) continue;
                                placed = this.placeAdjacent(ent.field_70170_p, id, item.func_77960_j(), x + ox, y + oy, z + oz);
                                this.complete2x2(ent.field_70170_p, id, item.func_77960_j(), x + ox, y + oy, z + oz);
                            }
                        }
                    }
                    if (!placed) {
                        ent.field_70170_p.func_147465_d(x, y, z, id, item.func_77960_j() | 8, 3);
                        if (trackTrees) {
                            TreeDataHooks.addTree(ent.field_70170_p, x, y, z, this.rand.nextInt(3000));
                        }
                    }
                }
            } else {
                boolean placed = false;
                for (int oy = -2; oy <= 2 && !placed; ++oy) {
                    for (int ox = -5; ox <= 5 && !placed; ++ox) {
                        for (int oz = -5; oz <= 5 && !placed; ++oz) {
                            if (!(ent.field_70170_p.func_147439_a(x + ox, y + oy, z + oz) instanceof BlockSapling)) continue;
                            placed = this.placeAdjacent(ent.field_70170_p, id, item.func_77960_j(), x + ox, y + oy, z + oz);
                            this.complete2x2(ent.field_70170_p, id, item.func_77960_j(), x + ox, y + oy, z + oz);
                        }
                    }
                }
                if (!placed) {
                    ent.field_70170_p.func_147465_d(x, y, z, id, item.func_77960_j() | 8, 3);
                    if (trackTrees) {
                        TreeDataHooks.addTree(ent.field_70170_p, x, y, z, this.rand.nextInt(3000));
                    }
                }
            }
        } else if (item.func_77960_j() != 5) {
            ent.field_70170_p.func_147465_d(x, y, z, id, item.func_77960_j() | 8, 3);
            if (trackTrees) {
                TreeDataHooks.addTree(ent.field_70170_p, x, y, z, this.rand.nextInt(3000));
            }
        }
    }

    private boolean placeAdjacent(World worldObj, Block id, int itemDamage, int x, int y, int z) {
        if ((id.func_149742_c(worldObj, x + 1, y, z) || worldObj.func_147439_a(x + 1, y, z) instanceof BlockSapling) && (id.func_149742_c(worldObj, x, y, z + 1) || worldObj.func_147439_a(x, y, z + 1) instanceof BlockSapling) && (id.func_149742_c(worldObj, x + 1, y, z + 1) || worldObj.func_147439_a(x + 1, y, z + 1) instanceof BlockSapling)) {
            if (worldObj.func_147439_a(x + 1, y, z) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x + 1, y, z, id, itemDamage | 8, 3);
                return true;
            }
            if (worldObj.func_147439_a(x, y, z + 1) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x, y, z + 1, id, itemDamage | 8, 3);
                return true;
            }
            if (worldObj.func_147439_a(x + 1, y, z + 1) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x + 1, y, z + 1, id, itemDamage | 8, 3);
                return true;
            }
        }
        if ((id.func_149742_c(worldObj, x - 1, y, z) || worldObj.func_147439_a(x - 1, y, z) instanceof BlockSapling) && (id.func_149742_c(worldObj, x, y, z + 1) || worldObj.func_147439_a(x, y, z + 1) instanceof BlockSapling) && (id.func_149742_c(worldObj, x - 1, y, z + 1) || worldObj.func_147439_a(x - 1, y, z + 1) instanceof BlockSapling)) {
            if (worldObj.func_147439_a(x - 1, y, z) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x - 1, y, z, id, itemDamage | 8, 3);
                return true;
            }
            if (worldObj.func_147439_a(x, y, z + 1) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x, y, z + 1, id, itemDamage | 8, 3);
                return true;
            }
            if (worldObj.func_147439_a(x - 1, y, z + 1) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x - 1, y, z + 1, id, itemDamage | 8, 3);
                return true;
            }
        }
        if ((id.func_149742_c(worldObj, x - 1, y, z) || worldObj.func_147439_a(x - 1, y, z) instanceof BlockSapling) && (id.func_149742_c(worldObj, x, y, z - 1) || worldObj.func_147439_a(x, y, z - 1) instanceof BlockSapling) && (id.func_149742_c(worldObj, x - 1, y, z - 1) || worldObj.func_147439_a(x - 1, y, z - 1) instanceof BlockSapling)) {
            if (worldObj.func_147439_a(x - 1, y, z) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x - 1, y, z, id, itemDamage | 8, 3);
                return true;
            }
            if (worldObj.func_147439_a(x, y, z - 1) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x, y, z - 1, id, itemDamage | 8, 3);
                return true;
            }
            if (worldObj.func_147439_a(x - 1, y, z - 1) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x - 1, y, z - 1, id, itemDamage | 8, 3);
                return true;
            }
        }
        if ((id.func_149742_c(worldObj, x + 1, y, z) || worldObj.func_147439_a(x + 1, y, z) instanceof BlockSapling) && (id.func_149742_c(worldObj, x, y, z - 1) || worldObj.func_147439_a(x, y, z - 1) instanceof BlockSapling) && (id.func_149742_c(worldObj, x + 1, y, z - 1) || worldObj.func_147439_a(x + 1, y, z - 1) instanceof BlockSapling)) {
            if (worldObj.func_147439_a(x + 1, y, z) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x + 1, y, z, id, itemDamage | 8, 3);
                return true;
            }
            if (worldObj.func_147439_a(x, y, z - 1) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x, y, z - 1, id, itemDamage | 8, 3);
                return true;
            }
            if (worldObj.func_147439_a(x + 1, y, z - 1) == Blocks.field_150350_a) {
                worldObj.func_147465_d(x + 1, y, z - 1, id, itemDamage | 8, 3);
                return true;
            }
        }
        return false;
    }

    private int canMake2x2(World worldObj, Block id, int x, int y, int z) {
        boolean xnzn;
        boolean xp = id.func_149742_c(worldObj, x + 1, y, z) || worldObj.func_147439_a(x + 1, y, z) == id;
        boolean xn = id.func_149742_c(worldObj, x - 1, y, z) || worldObj.func_147439_a(x - 1, y, z) == id;
        boolean zp = id.func_149742_c(worldObj, x, y, z + 1) || worldObj.func_147439_a(x, y, z + 1) == id;
        boolean zn = id.func_149742_c(worldObj, x, y, z - 1) || worldObj.func_147439_a(x, y, z - 1) == id;
        boolean xpzp = id.func_149742_c(worldObj, x + 1, y, z + 1) || worldObj.func_147439_a(x + 1, y, z + 1) == id;
        boolean xpzn = id.func_149742_c(worldObj, x + 1, y, z - 1) || worldObj.func_147439_a(x + 1, y, z - 1) == id;
        boolean xnzp = id.func_149742_c(worldObj, x - 1, y, z + 1) || worldObj.func_147439_a(x - 1, y, z + 1) == id;
        boolean bl = xnzn = id.func_149742_c(worldObj, x - 1, y, z - 1) || worldObj.func_147439_a(x - 1, y, z - 1) == id;
        if (xp && zp && xpzp) {
            return 1;
        }
        if (xp && zn && xpzn) {
            return 2;
        }
        if (xn && zn && xnzn) {
            return 3;
        }
        if (xn && zp && xnzp) {
            return 4;
        }
        return 0;
    }

    private void complete2x2(World world, Block id, int meta, int x, int y, int z) {
        boolean xp = world.func_147439_a(x + 1, y, z) == Blocks.field_150345_g;
        boolean xn = world.func_147439_a(x - 1, y, z) == Blocks.field_150345_g;
        boolean zp = world.func_147439_a(x, y, z + 1) == Blocks.field_150345_g;
        boolean zn = world.func_147439_a(x, y, z - 1) == Blocks.field_150345_g;
        boolean xpzp = world.func_147439_a(x + 1, y, z + 1) == Blocks.field_150345_g;
        boolean xpzn = world.func_147439_a(x + 1, y, z - 1) == Blocks.field_150345_g;
        boolean xnzp = world.func_147439_a(x - 1, y, z + 1) == Blocks.field_150345_g;
        boolean xnzn = world.func_147439_a(x - 1, y, z - 1) == Blocks.field_150345_g;
        int t = (xp ? 1 : 0) + (zp ? 1 : 0) + (xpzp ? 1 : 0);
        if (t == 2) {
            if (id.func_149742_c(world, x + 1, y, z)) {
                world.func_147465_d(x + 1, y, z, id, meta | 8, 3);
            }
            if (id.func_149742_c(world, x, y, z + 1)) {
                world.func_147465_d(x, y, z + 1, id, meta | 8, 3);
            }
            if (id.func_149742_c(world, x + 1, y, z + 1)) {
                world.func_147465_d(x + 1, y, z + 1, id, meta | 8, 3);
            }
            if (trackTrees) {
                TreeDataHooks.addTree(world, x + 1, y, z, this.rand.nextInt(3000));
                TreeDataHooks.addTree(world, x, y, z + 1, this.rand.nextInt(3000));
                TreeDataHooks.addTree(world, x + 1, y, z + 1, this.rand.nextInt(3000));
            }
            return;
        }
        t = (xn ? 1 : 0) + (zp ? 1 : 0) + (xnzp ? 1 : 0);
        if (t == 2) {
            if (id.func_149742_c(world, x - 1, y, z)) {
                world.func_147465_d(x - 1, y, z, id, meta | 8, 3);
            }
            if (id.func_149742_c(world, x, y, z + 1)) {
                world.func_147465_d(x, y, z + 1, id, meta | 8, 3);
            }
            if (id.func_149742_c(world, x - 1, y, z + 1)) {
                world.func_147465_d(x - 1, y, z + 1, id, meta | 8, 3);
            }
            if (trackTrees) {
                TreeDataHooks.addTree(world, x - 1, y, z, this.rand.nextInt(3000));
                TreeDataHooks.addTree(world, x, y, z + 1, this.rand.nextInt(3000));
                TreeDataHooks.addTree(world, x - 1, y, z + 1, this.rand.nextInt(3000));
            }
            return;
        }
        t = (xp ? 1 : 0) + (zn ? 1 : 0) + (xpzn ? 1 : 0);
        if (t == 2) {
            if (id.func_149742_c(world, x + 1, y, z)) {
                world.func_147465_d(x + 1, y, z, id, meta | 8, 3);
            }
            if (id.func_149742_c(world, x, y, z - 1)) {
                world.func_147465_d(x, y, z - 1, id, meta | 8, 3);
            }
            if (id.func_149742_c(world, x + 1, y, z - 1)) {
                world.func_147465_d(x + 1, y, z - 1, id, meta | 8, 3);
            }
            if (trackTrees) {
                TreeDataHooks.addTree(world, x + 1, y, z, this.rand.nextInt(3000));
                TreeDataHooks.addTree(world, x, y, z - 1, this.rand.nextInt(3000));
                TreeDataHooks.addTree(world, x + 1, y, z - 1, this.rand.nextInt(3000));
            }
            return;
        }
        t = (xn ? 1 : 0) + (zn ? 1 : 0) + (xnzn ? 1 : 0);
        if (t == 2) {
            if (id.func_149742_c(world, x - 1, y, z)) {
                world.func_147465_d(x - 1, y, z, id, meta | 8, 3);
            }
            if (id.func_149742_c(world, x, y, z - 1)) {
                world.func_147465_d(x, y, z - 1, id, meta | 8, 3);
            }
            if (id.func_149742_c(world, x - 1, y, z - 1)) {
                world.func_147465_d(x - 1, y, z - 1, id, meta | 8, 3);
            }
            if (trackTrees) {
                TreeDataHooks.addTree(world, x - 1, y, z, this.rand.nextInt(3000));
                TreeDataHooks.addTree(world, x, y, z - 1, this.rand.nextInt(3000));
                TreeDataHooks.addTree(world, x - 1, y, z - 1, this.rand.nextInt(3000));
            }
            return;
        }
    }

    @SubscribeEvent
    public void clientTickStart(TickEvent.ClientTickEvent event) {
        block15: {
            float rainMod;
            float tempMod;
            World w;
            block16: {
                if (event.phase != TickEvent.Phase.END) break block15;
                w = WildlifeBase.proxy.getWorld();
                if (w == null) {
                    return;
                }
                boolean initialSet = true;
                if (Math.abs(this.lastClientWorldTime - w.func_72820_D()) > 500L) {
                    initialSet = false;
                }
                this.lastClientWorldTime = w.func_72820_D();
                if (!initialSet) break block16;
                if (w.func_82737_E() % (long)(weekLength * 2400) != 0L) break block15;
            }
            if (doYearCycle) {
                if (Arrays.binarySearch(dimensionBlacklist, w.field_73011_w.field_76574_g) >= 0) {
                    tempMod = 0.0f;
                    rainMod = 0.0f;
                } else {
                    tempMod = WildlifeEventHandler.getSeasonTemp(this.lastClientWorldTime);
                    rainMod = WildlifeEventHandler.getSeasonRain(this.lastClientWorldTime);
                }
            } else {
                tempMod = this.tempStatic;
                rainMod = this.rainStatic;
            }
            for (BiomeGenBase bio : this.allBiomes) {
                BiomeWeatherData dat = this.biomeTemps.get(bio.field_76756_M);
                try {
                    if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                        bio.field_76750_F = dat.temp + tempMod * dat.tempScale;
                        bio.field_76751_G = dat.rain + rainMod * dat.rainScale;
                        if (bio.field_76751_G <= 0.0f) {
                            rains.set(bio, false);
                            snows.set(bio, false);
                            continue;
                        }
                        if ((double)bio.field_76750_F <= 0.2) {
                            rains.set(bio, false);
                            snows.set(bio, true);
                            continue;
                        }
                        rains.set(bio, true);
                        snows.set(bio, false);
                        continue;
                    }
                    bio.field_76750_F = dat.temp + tempMod;
                    bio.field_76751_G = dat.rain + rainMod / 5.0f;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public void tickStart(TickEvent.WorldTickEvent event) {
        block16: {
            float rainMod;
            float tempMod;
            long lwt;
            block17: {
                if (event.phase != TickEvent.Phase.END) break block16;
                if (this.lastWorldTime.containsKey(event.world.field_73011_w.field_76574_g) && this.lastWorldTime.get(event.world.field_73011_w.field_76574_g).longValue() == event.world.func_72820_D()) {
                    return;
                }
                float sunHeightVal = (float)Math.sin((double)((event.world.func_72826_c(0.0f) + 0.25f) * 2.0f) * Math.PI);
                if (autoSaplings && trackTrees) {
                    TreeDataHooks.ageTrees(event.world);
                }
                boolean initialSet = true;
                if (!this.lastWorldTime.containsKey(event.world.field_73011_w.field_76574_g) || Math.abs(this.lastWorldTime.get(event.world.field_73011_w.field_76574_g) - event.world.func_72820_D()) > 500L) {
                    initialSet = false;
                }
                event.world.func_82737_E();
                lwt = event.world.func_72820_D();
                this.lastWorldTime.put(event.world.field_73011_w.field_76574_g, lwt);
                if (!initialSet) break block17;
                if (event.world.func_82737_E() % (long)(weekLength * 2400) != 0L) break block16;
            }
            if (doYearCycle) {
                if (Arrays.binarySearch(dimensionBlacklist, event.world.field_73011_w.field_76574_g) >= 0) {
                    tempMod = 0.0f;
                    rainMod = 0.0f;
                } else {
                    tempMod = WildlifeEventHandler.getSeasonTemp(lwt);
                    rainMod = WildlifeEventHandler.getSeasonRain(lwt);
                }
            } else {
                tempMod = this.tempStatic;
                rainMod = this.rainStatic;
            }
            WildlifeBase.logger.log(Level.INFO, "Time: " + lwt);
            WildlifeBase.logger.log(Level.INFO, "Temp: " + tempMod);
            WildlifeBase.logger.log(Level.INFO, "Rain: " + rainMod);
            for (BiomeGenBase bio : this.allBiomes) {
                BiomeWeatherData dat = this.biomeTemps.get(bio.field_76756_M);
                try {
                    if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                        bio.field_76750_F = dat.temp + tempMod * dat.tempScale;
                        bio.field_76751_G = dat.rain + rainMod * dat.rainScale;
                        if (bio.field_76751_G <= 0.0f) {
                            rains.set(bio, false);
                            snows.set(bio, false);
                            continue;
                        }
                        if ((double)bio.field_76750_F <= 0.2) {
                            rains.set(bio, false);
                            snows.set(bio, true);
                            continue;
                        }
                        rains.set(bio, true);
                        snows.set(bio, false);
                        continue;
                    }
                    bio.field_76750_F = dat.temp + tempMod * dat.tempScale;
                    bio.field_76751_G = dat.rain + rainMod * dat.rainScale;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static float getSeasonRain(long worldTime) {
        double m = (double)(worldTime + yearLength / 3L) / (double)yearLength * 2.0 * Math.PI;
        m = Math.sin(m) * 0.4 + 0.2;
        return (float)m;
    }

    public static float getSeasonTemp(long worldTime) {
        double m = (double)worldTime / (double)yearLength * 2.0 * Math.PI;
        m = Math.sin(m) * 0.6;
        return (float)m;
    }

    @SubscribeEvent
    public void onBlockUpdate(SpecialBlockEvent.BlockUpdateEvent event) {
        if (event.block == Blocks.field_150431_aC || event.block == WildlifeBase.snowyGrass) {
            this.handleSnow(event);
        } else if (event.block == Blocks.field_150432_aD) {
            this.handleIce(event);
        } else if (event.block instanceof IGrowable || event.block instanceof BlockReed) {
            this.handleCrops(event);
        }
    }

    public static long getLastWorldTime(int dim) {
        if (WildlifeEventHandler.instance.lastWorldTime.containsKey(dim)) {
            return WildlifeEventHandler.instance.lastWorldTime.get(dim);
        }
        return WildlifeEventHandler.instance.lastClientWorldTime;
    }

    private void handleCrops(SpecialBlockEvent.BlockUpdateEvent event) {
        if (doSlowCrops) {
            World world = event.world;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            int blockMetadata = event.blockMetadata;
            Block block = event.block;
            BiomeGenBase bio = event.biome;
            int rr = 0;
            int inc = 0;
            if (blockMetadata < 7 && block != Blocks.field_150436_aH) {
                for (int ox = -1; ox <= 1; ++ox) {
                    for (int oz = -1; oz <= 1; ++oz) {
                        Block bb = world.func_147439_a(x + ox, y, z + oz);
                        if ((ox == 0 || oz == 0) && ox != oz && (inc == 0 && bb == block || bb == WildlifeBase.weeds) && world.func_72807_a(x + ox, z + oz) == bio) {
                            int om = world.func_72805_g(x + ox, y, z + oz);
                            if (om + 1 == blockMetadata || om + 2 == blockMetadata) {
                                ++inc;
                                world.func_147464_a(x + ox, y, z + oz, block, 1);
                            }
                            if (block == WildlifeBase.weeds || bb != WildlifeBase.weeds) continue;
                            inc += 2;
                            world.func_147464_a(x + ox, y, z + oz, block, 1);
                            continue;
                        }
                        if (block != WildlifeBase.weeds && world.func_147439_a(x + ox, y - 1, z + oz) == Blocks.field_150458_ak) {
                            if (bb == Blocks.field_150350_a) {
                                if (this.rand.nextInt(1500) != 0) continue;
                                world.func_147449_b(x + ox, y, z + oz, WildlifeBase.weeds);
                                continue;
                            }
                            if (bb != Blocks.field_150404_cg || this.rand.nextInt(4) != 0 || this.rand.nextInt(1500) != 0) continue;
                            Blocks.field_150404_cg.func_149697_b(world, x + ox, y, z + oz, world.func_72805_g(x + ox, y, z + oz), 0);
                            world.func_147465_d(x + ox, y, z + oz, WildlifeBase.weeds, 0, 3);
                            continue;
                        }
                        if (block == WildlifeBase.weeds || bb != Blocks.field_150329_H && !(bb instanceof BlockCrops)) continue;
                        ++inc;
                    }
                }
            }
            if (doBiomeCrops) {
                Block block2;
                float t = bio.field_76750_F;
                float r = bio.field_76751_G;
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
                    t += WildlifeEventHandler.getSeasonTemp(WildlifeEventHandler.getLastWorldTime(world.field_73011_w.field_76574_g)) * 0.333f;
                }
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)bio, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) != world.func_72874_g(x, z) > y) {
                    t = (t + 0.8f) / 2.0f;
                    r = (r + 1.0f) / 2.0f;
                }
                if (block instanceof IPlantable && block != (block2 = ((IPlantable)block).getPlant((IBlockAccess)world, x, y, z))) {
                    block = block2;
                }
                CropWeatherOffsets o = HardLibAPI.cropManager.getCropOffsets(block);
                if (block instanceof ICropDataSupplier) {
                    o = ((ICropDataSupplier)block).getCropData(world, x, y, z);
                }
                if (o != null) {
                    if (o.tempTimeOffset != 0 && doYearCycle) {
                        t = t - WildlifeEventHandler.getSeasonTemp(WildlifeEventHandler.getLastWorldTime(world.field_73011_w.field_76574_g)) + WildlifeEventHandler.getSeasonTemp(WildlifeEventHandler.getLastWorldTime(world.field_73011_w.field_76574_g) + (long)o.tempTimeOffset);
                    }
                    t += o.tempFlat;
                    if (o.rainTimeOffset != 0 && doYearCycle) {
                        r = r - WildlifeEventHandler.getSeasonRain(WildlifeEventHandler.getLastWorldTime(world.field_73011_w.field_76574_g)) + WildlifeEventHandler.getSeasonRain(WildlifeEventHandler.getLastWorldTime(world.field_73011_w.field_76574_g) + (long)o.rainTimeOffset);
                    }
                    r += o.rainFlat;
                }
                r = (float)((double)r - 1.75);
                if ((rr = (int)Math.round(Math.pow((t -= 0.4f) - 1.5f, 4.0) * (double)0.6f + (double)(t * t * 2.0f) - ((double)(r * r) * -2.2 - (double)0.3f * Math.pow(r + 2.0f, 4.0) + 7.0))) < 0) {
                    --rr;
                }
                if (rr < -8) {
                    rr = -8;
                }
                if (rr > cropsWorst) {
                    rr = cropsWorst;
                }
                rr += 2 * inc;
            }
            if (block == WildlifeBase.weeds) {
                rr = rr >= 0 ? (rr /= 2) : (rr -= 4);
                if (rr < -9) {
                    rr = -9;
                }
            }
            if (block == Blocks.field_150436_aH && (rr -= 3) < -8) {
                rr = -8;
            }
            if (this.rand.nextInt(10 + rr) != 0) {
                event.setCanceled(true);
            }
        }
    }

    private void handleIce(SpecialBlockEvent.BlockUpdateEvent event) {
        if (doSnowMelt) {
            int light = event.world.func_72972_b(EnumSkyBlock.Sky, event.x, event.y, event.z);
            if (light <= 7) {
                return;
            }
            float temp = event.biome.field_76750_F;
            float hot = 0.0f;
            int adj = 0;
            int r = 0;
            if ((double)event.biome.field_76750_F > 0.4) {
                hot = 0.5f;
            } else {
                for (int ox = -2; ox <= 2; ++ox) {
                    for (int oz = -2; oz <= 2; ++oz) {
                        Block b = event.world.func_147439_a(event.x + ox, event.y, event.z + oz);
                        if (b == Blocks.field_150432_aD) {
                            hot -= 0.002f;
                            if (Math.abs(ox) > 1 || Math.abs(oz) > 1) continue;
                            hot -= 0.005f;
                            ++adj;
                            continue;
                        }
                        if (b.func_149662_c()) {
                            if (!((double)temp < 0.3)) continue;
                            hot -= 0.01f;
                            continue;
                        }
                        hot += 0.0015f;
                        if (Math.abs(ox) > 1 || Math.abs(oz) > 1) continue;
                        hot += 0.015f;
                    }
                }
                hot = hot / 16.0f * 9.0f;
                if (light > 7) {
                    hot += temp;
                }
                float sunHeightVal = (float)Math.sin((double)((event.world.func_72826_c(0.0f) + 0.25f) * 2.0f) * Math.PI);
                if (event.world.func_72937_j(event.x, event.y + 1, event.z)) {
                    hot += 0.01f + 0.25f * (sunHeightVal * (0.3f - Math.min(event.biome.field_76751_G, 1.0f) / 4.0f));
                }
                if ((r = (int)Math.min((hot - 0.2f) * 24.0f, 6.0f) + (adj == 8 ? 2 : 0) - (adj > 8 ? 256 : 0) + (adj <= 1 ? 8 : 0)) > 9) {
                    r = 9;
                }
            }
            if ((double)hot > 0.4 || hot >= 0.175f && this.rand.nextInt(10 - r) == 0) {
                event.world.func_147449_b(event.x, event.y, event.z, Blocks.field_150355_j);
                if (adj >= 8) {
                    for (int ox = -1; ox <= 1; ++ox) {
                        for (int oz = -1; oz <= 1; ++oz) {
                            event.world.func_147464_a(event.x + ox, event.y, event.z + oz, Blocks.field_150355_j, 20);
                        }
                    }
                }
            }
        }
    }

    private void handleSnow(SpecialBlockEvent.BlockUpdateEvent event) {
        boolean inc = true;
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        int blockMetadata = event.blockMetadata;
        BiomeGenBase biome = event.biome;
        Block block = event.block;
        if (biome.field_76750_F < 0.15f && world.func_72896_J()) {
            int wet = Math.round(biome.field_76751_G * 2.0f);
            if (wet > 6) {
                wet = 6;
            }
            if (this.rand.nextInt(8 - wet) == 0 && doSnowMelt) {
                for (int ox = -1; ox <= 1 && inc; ++ox) {
                    for (int oz = -1; oz <= 1 && inc; ++oz) {
                        int mm;
                        Block b = world.func_147439_a(x + ox, y, z + oz);
                        if (b == Blocks.field_150431_aC || b == WildlifeBase.snowyGrass) {
                            mm = world.func_72805_g(x + ox, y, z + oz);
                            if (mm >= blockMetadata) continue;
                            inc = false;
                            world.func_72921_c(x + ox, y, z + oz, mm + 1, 3);
                            continue;
                        }
                        if (b.func_149645_b() == 1 || b == Blocks.field_150404_cg) {
                            inc = false;
                            mm = world.func_72805_g(x + ox, y, z + oz);
                            if (!doYearCycle && b instanceof BlockSapling) continue;
                            world.func_147465_d(x + ox, y, z + oz, WildlifeBase.snowyGrass, 0, 3);
                            TileEntityGrassSnow te = (TileEntityGrassSnow)world.func_147438_o(x + ox, y, z + oz);
                            if (te != null) {
                                te.oBlock = b;
                                te.oMeta = mm;
                                world.func_147471_g(x + ox, y, z + oz);
                                continue;
                            }
                            world.func_147465_d(x + ox, y, z + oz, b, mm, 3);
                            continue;
                        }
                        if (b != Blocks.field_150350_a || !world.func_147439_a(x + ox, y - 1, z + oz).isSideSolid((IBlockAccess)world, x + ox, y - 1, z + oz, ForgeDirection.UP)) continue;
                        inc = false;
                        world.func_147449_b(x + ox, y, z + oz, Blocks.field_150431_aC);
                    }
                }
                if (inc && blockMetadata < 7) {
                    world.func_72921_c(x, y, z, blockMetadata + 1, 3);
                }
            }
        } else {
            int wet = Math.round((world.func_72896_J() ? 0.1f : 0.0f) + (biome.field_76750_F + (float)Math.sin((double)((world.func_72826_c(0.0f) + 0.25f) * 2.0f) * Math.PI) * (0.3f - Math.min(biome.field_76751_G, 1.0f) / 4.0f)) * 4.0f);
            if (wet > 10) {
                wet = 10;
            }
            BiomeWeatherData dat = this.biomeTemps.get(biome.field_76756_M);
            if (this.rand.nextInt(12 - wet) == 0 && (doSnowMelt || (blockMetadata & 7) > 0 || (double)biome.field_76750_F > 0.2)) {
                for (int ox = -1; ox <= 1 && inc; ++ox) {
                    for (int oz = -1; oz <= 1 && inc; ++oz) {
                        int mm;
                        Block b = world.func_147439_a(x + ox, y, z + oz);
                        if (b != Blocks.field_150431_aC && b != WildlifeBase.snowyGrass || (mm = world.func_72805_g(x + ox, y, z + oz)) <= blockMetadata) continue;
                        inc = false;
                        world.func_72921_c(x + ox, y, z + oz, mm - 1, 3);
                    }
                }
                if (inc) {
                    if (blockMetadata > 0) {
                        world.func_72921_c(x, y, z, blockMetadata - 1, 3);
                    } else if (biome.field_76750_F > 0.3f && blockMetadata == 0) {
                        if (block == WildlifeBase.snowyGrass) {
                            TileEntityGrassSnow te = (TileEntityGrassSnow)world.func_147438_o(x, y, z);
                            if (te.oBlock == null) {
                                te.oBlock = Blocks.field_150329_H;
                                te.oMeta = blockMetadata >= 8 ? 2 : 1;
                            }
                            world.func_147465_d(x, y, z, te.oBlock, te.oMeta, 3);
                            if (te.oBlock == Blocks.field_150345_g) {
                                TreeDataHooks.addTree(world, x, y, z, -1);
                            }
                        } else {
                            world.func_147468_f(x, y, z);
                        }
                    } else if (block == WildlifeBase.snowyGrass && blockMetadata == 0) {
                        TileEntityGrassSnow te = (TileEntityGrassSnow)world.func_147438_o(x, y, z);
                        if (te.oBlock == null) {
                            te.oBlock = Blocks.field_150329_H;
                            te.oMeta = blockMetadata >= 8 ? 2 : 1;
                        }
                        world.func_147465_d(x, y, z, te.oBlock, te.oMeta, 3);
                        if (te.oBlock == Blocks.field_150345_g) {
                            TreeDataHooks.addTree(world, x, y, z, -1);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onAnimalFeed(EntityAnimalInteractEvent.AnimalLoveEvent event) {
        event.loveTime *= 2;
        if (event.animalBred == EntityCow.class) {
            if (this.rand.nextInt(8) != 0) {
                event.loveTime = 0;
            }
        } else if (event.animalBred == EntityPig.class) {
            if (this.rand.nextInt(4) != 0) {
                event.loveTime = 0;
            }
        } else if (event.animalBred == EntityGoat.class) {
            if (this.rand.nextInt(8) != 0) {
                event.loveTime = 0;
            }
        } else if (event.animalBred == EntitySheep.class) {
            if (Loader.isModLoaded((String)"ganyssurface")) {
                if (this.rand.nextInt(8) != 0) {
                    event.loveTime = 0;
                }
            } else if (this.rand.nextInt(2) != 0) {
                event.loveTime = 0;
            }
        } else if (event.animalBred == EntityChicken.class) {
            if (this.rand.nextInt(12) != 0) {
                event.loveTime = 0;
            }
        } else if (this.rand.nextInt(6) != 0) {
            event.loveTime = 0;
        }
    }

    @SubscribeEvent
    public void onBreakCrops(BlockEvent.BreakEvent event) {
        ItemStack s;
        if ((event.block instanceof BlockCrops || event.block instanceof BlockStem) && event.block != WildlifeBase.weeds && (s = event.getPlayer().func_71045_bC()) != null && s.func_77973_b() instanceof ItemHoe) {
            event.setCanceled(true);
        }
    }

    @Optional.Method(modid="AppleCore")
    public void appleCoreAllowGrowth(PlantGrowthEvent.AllowGrowthTick event) {
        if (event.getResult() == Event.Result.DEFAULT) {
            SpecialBlockEvent.BlockUpdateEvent newEvent = new SpecialBlockEvent.BlockUpdateEvent(event.world, event.x, event.y, event.z, event.world.func_72805_g(event.x, event.y, event.z), event.block, event.world.func_72807_a(event.x, event.z));
            this.handleCrops(newEvent);
            if (newEvent.isCanceled()) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    public static BiomeWeatherData getBiomeData(BiomeGenBase bio) {
        return WildlifeEventHandler.instance.biomeTemps.get(bio.field_76756_M);
    }

    private static class BiomeWeatherData {
        public float temp;
        public float rain;
        public float tempScale;
        public float rainScale;

        private BiomeWeatherData(float t, float r, float s, float q) {
            if ((double)t < -0.1 && (double)t >= -0.3) {
                t = (float)((double)t - 0.1);
            } else if ((double)t < -0.3) {
                t = (t + 0.3f) * 3.0f / 4.0f - 0.4f;
            }
            this.temp = t;
            this.rain = r;
            this.tempScale = s;
            this.rainScale = q;
        }
    }

    private static class FoodDrops {
        public Item dropped;
        public int num;
        private int itemID;

        public FoodDrops(Item i, int n) {
            this.dropped = i;
            this.num = n;
            this.itemID = Item.func_150891_b((Item)i);
        }

        public int hashCode() {
            return this.itemID;
        }

        public boolean equals(Object o) {
            if (o instanceof FoodDrops) {
                FoodDrops f = (FoodDrops)o;
                return this.itemID == f.itemID;
            }
            return false;
        }
    }
}

