/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.ores.block;

import com.draco18s.ores.entities.TileEntityMillstone;
import com.draco18s.ores.util.StatsAchievements;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMillstone
extends BlockContainer {
    private IIcon[] icons;

    public BlockMillstone() {
        super(Material.field_151575_d);
        this.func_149663_c("millstone");
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 1);
        this.func_149752_b(2.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149658_d("ores:millstone-top");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side <= 1) {
            return this.icons[0];
        }
        return this.icons[10];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (side <= 1) {
            return this.icons[world.func_72805_g(x, y, z)];
        }
        return this.icons[10];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[11];
        this.icons[0] = iconRegister.func_94245_a("ores:mill-generic");
        this.icons[1] = iconRegister.func_94245_a("ores:mill-center");
        this.icons[2] = iconRegister.func_94245_a("ores:mill-ul");
        this.icons[3] = iconRegister.func_94245_a("ores:mill-um");
        this.icons[4] = iconRegister.func_94245_a("ores:mill-ur");
        this.icons[5] = iconRegister.func_94245_a("ores:mill-mr");
        this.icons[6] = iconRegister.func_94245_a("ores:mill-lr");
        this.icons[7] = iconRegister.func_94245_a("ores:mill-bm");
        this.icons[8] = iconRegister.func_94245_a("ores:mill-ll");
        this.icons[9] = iconRegister.func_94245_a("ores:mill-ml");
        this.icons[10] = iconRegister.func_94245_a("ores:mill-side");
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        world.func_147464_a(x, y, z, (Block)this, 1);
        return 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.func_72805_g(x, y, z) % 2 == 1) {
            ISidedInventory is = (ISidedInventory)world.func_147438_o(x, y, z);
            ItemStack held = player.func_70694_bm();
            if (held != null && is.func_102007_a(0, held, 1)) {
                ItemStack ii = is.func_70301_a(0);
                if (ii == null) {
                    is.func_70299_a(0, held.func_77979_a(1));
                } else if (ii.field_77994_a < 64) {
                    ++ii.field_77994_a;
                    --held.field_77994_a;
                }
                switch (world.func_72805_g(x, y, z)) {
                    case 3: {
                        ++z;
                        break;
                    }
                    case 5: {
                        --x;
                        break;
                    }
                    case 7: {
                        --z;
                        break;
                    }
                    case 9: {
                        ++x;
                    }
                }
                TileEntityMillstone st = (TileEntityMillstone)world.func_147438_o(x, y, z);
                if (st.hasPower()) {
                    player.func_71064_a((StatBase)StatsAchievements.constructMill, 1);
                }
            }
        }
        return false;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        boolean flag = false;
        flag = this.checkPlacement(world, x, y, z);
        if (!flag) {
            for (int i = -1; i <= 1 && !flag; ++i) {
                for (int j = -1; j <= 1 && !flag; ++j) {
                    Block b = world.func_147439_a(x + i, y, z + j);
                    if (b != this) continue;
                    flag = ((BlockMillstone)b).checkPlacement(world, x + i, y, z + j);
                }
            }
        }
    }

    public boolean checkPlacement(World world, int x, int y, int z) {
        if (world.func_147439_a(x + 1, y, z - 1) == this && world.func_147439_a(x + 1, y, z) == this && world.func_147439_a(x + 1, y, z + 1) == this && world.func_147439_a(x - 1, y, z - 1) == this && world.func_147439_a(x - 1, y, z) == this && world.func_147439_a(x - 1, y, z + 1) == this && world.func_147439_a(x, y, z - 1) == this && world.func_147439_a(x, y, z + 1) == this) {
            world.func_72921_c(x + 1, y, z + 1, 6, 3);
            world.func_72921_c(x + 1, y, z, 5, 3);
            world.func_72921_c(x + 1, y, z - 1, 4, 3);
            world.func_72921_c(x - 1, y, z + 1, 8, 3);
            world.func_72921_c(x - 1, y, z, 9, 3);
            world.func_72921_c(x - 1, y, z - 1, 2, 3);
            world.func_72921_c(x, y, z + 1, 7, 3);
            world.func_72921_c(x, y, z, 1, 3);
            world.func_72921_c(x, y, z - 1, 3, 3);
            return true;
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMillstone();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        this.dropItems(world, x, y, z);
        this.resetMetadata(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public void resetMetadata(World world, int x, int y, int z) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (world.func_147439_a(x + i, y, z + j) != this) continue;
                world.func_72921_c(x + i, y, z + j, 0, 3);
            }
        }
    }

    private void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }
}

