/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.industry.entities;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;

public class TileEntityFilter
extends TileEntityHopper {
    private ItemStack[] filters = new ItemStack[6];
    private IInventory[] fakeEntities = new IInventory[6];
    private EnumAcceptType acceptRule = EnumAcceptType.OR;

    public TileEntityFilter() {
        this.func_145886_a("Wooden Hopper");
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 5) {
            return super.func_70301_a(slot);
        }
        return this.filters[slot - 5];
    }

    public ItemStack func_70298_a(int slot, int num) {
        if (slot < 5) {
            return super.func_70298_a(slot, num);
        }
        if (this.filters[slot - 5] != null) {
            if (this.filters[slot - 5].field_77994_a <= num) {
                ItemStack itemstack = this.filters[slot - 5];
                this.filters[slot - 5] = null;
                this.fakeEntities[slot - 5] = null;
                return itemstack;
            }
            ItemStack itemstack = this.filters[slot - 5].func_77979_a(num);
            if (this.filters[slot - 5].field_77994_a == 0) {
                this.filters[slot - 5] = null;
                this.fakeEntities[slot - 5] = null;
            }
            return itemstack;
        }
        return null;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (slot < 5) {
            if (this.doIHaveFilters()) {
                switch (this.acceptRule) {
                    case OR: {
                        return this.acceptOr(slot, stack);
                    }
                    case AND: {
                        return this.acceptAnd(slot, stack);
                    }
                    case NONE: {
                        return !this.acceptOr(slot, stack);
                    }
                    case SOME: {
                        return this.acceptOr(slot, stack) && !this.acceptAnd(slot, stack);
                    }
                }
            }
        } else if (stack.func_77973_b() instanceof ItemBlock) {
            ItemBlock ib = (ItemBlock)stack.func_77973_b();
            if (ib.field_150939_a.hasTileEntity(stack.func_77960_j())) {
                TileEntity te = ib.field_150939_a.createTileEntity(this.field_145850_b, stack.func_77960_j());
                return te instanceof IInventory;
            }
        }
        return false;
    }

    private boolean acceptOr(int slot, ItemStack stack) {
        for (int i = this.fakeEntities.length - 1; i >= 0; --i) {
            if (this.fakeEntities[i] == null) continue;
            if (this.fakeEntities[i] instanceof ISidedInventory) {
                ISidedInventory isi = (ISidedInventory)this.fakeEntities[i];
                int a = 0;
                switch (i) {
                    case 0: 
                    case 1: {
                        a = 1;
                        break;
                    }
                    case 2: 
                    case 3: {
                        a = 2;
                        break;
                    }
                    case 4: 
                    case 5: {
                        a = 0;
                    }
                }
                int[] accessibleSlots = isi.func_94128_d(a);
                boolean ret = false;
                for (int s : accessibleSlots) {
                    ret |= this.doesAccept(isi, s, a, stack);
                }
                return ret;
            }
            for (int s = this.fakeEntities[i].func_70302_i_() - 1; s >= 0; --s) {
                if (!this.doesAccept(this.fakeEntities[i], s, stack)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean acceptAnd(int slot, ItemStack stack) {
        boolean ret = true;
        for (int i = this.fakeEntities.length - 1; i >= 0; --i) {
            if (this.fakeEntities[i] == null) continue;
            boolean anySlot = false;
            if (this.fakeEntities[i] instanceof ISidedInventory) {
                int[] accessibleSlots;
                ISidedInventory isi = (ISidedInventory)this.fakeEntities[i];
                int a = 0;
                switch (i) {
                    case 0: 
                    case 1: {
                        a = 1;
                        break;
                    }
                    case 2: 
                    case 3: {
                        a = 2;
                        break;
                    }
                    case 4: 
                    case 5: {
                        a = 0;
                    }
                }
                for (int s : accessibleSlots = isi.func_94128_d(a)) {
                    anySlot = anySlot || this.doesAccept(isi, s, a, stack);
                }
            } else {
                for (int s = this.fakeEntities[i].func_70302_i_() - 1; !anySlot && s >= 0; --s) {
                    if (!this.doesAccept(this.fakeEntities[i], s, stack)) continue;
                    anySlot = true;
                }
            }
            ret &= anySlot;
        }
        return ret;
    }

    private boolean doesAccept(IInventory inven, int slot, ItemStack stack) {
        try {
            if (inven.func_94041_b(slot, stack)) {
                return true;
            }
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        return false;
    }

    private boolean doesAccept(ISidedInventory inven, int slot, int side, ItemStack stack) {
        try {
            if (inven instanceof TileEntityFurnace) {
                if (slot == 1) {
                    return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
                }
                if (slot == 0) {
                    return FurnaceRecipes.func_77602_a().func_151395_a(stack) != null;
                }
            } else if (inven.func_102007_a(slot, stack, side)) {
                return true;
            }
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        return false;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < 5) {
            super.func_70299_a(slot, stack);
        } else if (stack == null) {
            this.filters[slot - 5] = null;
            this.fakeEntities[slot - 5] = null;
        } else if (stack.func_77973_b() instanceof ItemBlock) {
            TileEntity te;
            ItemBlock ib = (ItemBlock)stack.func_77973_b();
            if (ib.field_150939_a.hasTileEntity(stack.func_77960_j()) && (te = ib.field_150939_a.createTileEntity(this.field_145850_b, stack.func_77960_j())) instanceof IInventory) {
                this.filters[slot - 5] = stack;
                this.fakeEntities[slot - 5] = (IInventory)te;
            }
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.func_70296_d();
    }

    public boolean doIHaveFilters() {
        for (IInventory ii : this.fakeEntities) {
            if (ii == null) continue;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList nbttaglist = tag.func_150295_c("Filters", 10);
        this.filters = new ItemStack[6];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            TileEntity te;
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("FSlot") & 0xFF;
            if (j < 0 || j >= this.filters.length) continue;
            this.filters[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            ItemBlock ib = (ItemBlock)this.filters[j].func_77973_b();
            if (!ib.field_150939_a.hasTileEntity(this.filters[j].func_77960_j()) || !((te = ib.field_150939_a.createTileEntity(this.field_145850_b, this.filters[j].func_77960_j())) instanceof IInventory)) continue;
            this.fakeEntities[j] = (IInventory)te;
        }
        this.acceptRule = EnumAcceptType.values()[tag.func_74762_e("AcceptType")];
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.filters.length; ++i) {
            if (this.filters[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("FSlot", (byte)i);
            this.filters[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        tag.func_74782_a("Filters", (NBTBase)nbttaglist);
        tag.func_74768_a("AcceptType", this.acceptRule.ordinal());
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public EnumAcceptType getEnumType() {
        return this.acceptRule;
    }

    public void setEnumType(EnumAcceptType a) {
        this.acceptRule = a;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.func_70296_d();
    }

    public static enum EnumAcceptType {
        OR,
        AND,
        NONE,
        SOME;

    }
}

