/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hazards.entities;

import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerStats
implements IExtendedEntityProperties {
    private static final String PLAYER_PROP = "HazPlayerStats";
    public int airRemaining;
    public int maxAir;
    public WeakReference<EntityLivingBase> living;

    public PlayerStats(EntityLivingBase p) {
        this.living = new WeakReference<EntityLivingBase>(p);
        this.airRemaining = 3000;
        this.maxAir = -1;
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a("playerAirRemaining", this.airRemaining);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.airRemaining = compound.func_74762_e("playerAirRemaining");
    }

    public void init(Entity entity, World world) {
    }

    public static PlayerStats get(EntityLivingBase entityLiving) {
        return (PlayerStats)entityLiving.getExtendedProperties(PLAYER_PROP);
    }

    public static void register(EntityLivingBase entity) {
        entity.registerExtendedProperties(PLAYER_PROP, (IExtendedEntityProperties)new PlayerStats(entity));
    }
}

