/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hazards.client;

import com.draco18s.hazards.HazardsEventHandler;
import com.draco18s.hazards.UndergroundBase;
import com.draco18s.hazards.block.BlockUnstableStone;
import com.draco18s.hazards.block.helper.UnstableStoneHelper;
import com.draco18s.hazards.entities.PlayerStats;
import com.draco18s.hazards.item.ItemBlockUnstable;
import com.draco18s.hazards.network.CtoSMessage;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class HazardsClientEventHandler {
    private FloatBuffer fogColorBuffer = GLAllocation.func_74529_h((int)16);
    private Random rand = new Random();

    @SubscribeEvent
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (event.entity instanceof EntityPlayer && event.entity.field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.entity;
            PlayerStats stats = PlayerStats.get(event.entity);
            if (stats != null) {
                float farPlaneDistance;
                float f1 = farPlaneDistance = (float)(Minecraft.func_71410_x().field_71474_y.field_151451_c * 16);
                if (stats.airRemaining < 1000) {
                    GL11.glFog((int)2918, (FloatBuffer)this.setFogColorBuffer(0.0f, 0.0f, 0.0f, 1.0f));
                    f1 = 5.0f + (farPlaneDistance - 5.0f) * ((float)Math.max(stats.airRemaining, 0) / 1000.0f);
                    GL11.glFogi((int)2917, (int)9729);
                    GL11.glFogf((int)2915, (float)(f1 * 0.25f));
                    GL11.glFogf((int)2916, (float)f1);
                    if (GLContext.getCapabilities().GL_NV_fog_distance) {
                        GL11.glFogi((int)34138, (int)34139);
                    }
                    event.setCanceled(true);
                    event.density = 0.1f;
                }
            }
        }
    }

    private FloatBuffer setFogColorBuffer(float red, float green, float blue, float alpha) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(red).put(green).put(blue).put(alpha);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }

    @SubscribeEvent
    public void tickStart(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            int jumpKey = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151463_i();
            boolean sendPacket = false;
            boolean state = false;
            if (jumpKey >= 0) {
                sendPacket = HazardsEventHandler.instance.setPlayerSwimming((EntityPlayer)player, Keyboard.isKeyDown((int)jumpKey));
                state = Keyboard.isKeyDown((int)jumpKey);
            } else if ((jumpKey += 100) >= 0) {
                sendPacket = HazardsEventHandler.instance.setPlayerSwimming((EntityPlayer)player, Mouse.isButtonDown((int)jumpKey));
                state = Keyboard.isKeyDown((int)jumpKey);
            }
            if (sendPacket) {
                PacketBuffer out = new PacketBuffer(Unpooled.buffer());
                out.writeBoolean(state);
                CtoSMessage packet = new CtoSMessage(player.func_145782_y(), (ByteBuf)out);
                UndergroundBase.networkWrapper.sendToServer((IMessage)packet);
            }
        }
    }

    @SubscribeEvent
    public void renderEvent(DrawBlockHighlightEvent event) {
        ItemStack s = event.player.func_71124_b(4);
        ItemStack h = event.player.func_71124_b(0);
        int sneakKey = Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i();
        boolean isSneaking = false;
        if (sneakKey >= 0) {
            isSneaking = Keyboard.isKeyDown((int)sneakKey);
        } else if ((sneakKey += 100) >= 0) {
            isSneaking = Keyboard.isKeyDown((int)sneakKey);
        }
        if (s != null && (isSneaking || h != null) && s.func_77973_b() == UndergroundBase.goggles && (isSneaking || h.func_77973_b().getToolClasses(h).contains("pickaxe"))) {
            int meta;
            Block block;
            Vec3 thisBlock;
            boolean isEnchanted = EnchantmentHelper.func_77506_a((int)UndergroundBase.enchStoneStress.field_77352_x, (ItemStack)s) > 0;
            boolean isBlock = h != null && h.func_77973_b() instanceof ItemBlockUnstable;
            World theWorld = event.player.field_70170_p;
            if (!isBlock) {
                thisBlock = Vec3.func_72443_a((double)event.target.field_72311_b, (double)event.target.field_72312_c, (double)event.target.field_72309_d);
                block = theWorld.func_147439_a((int)thisBlock.field_72450_a, (int)thisBlock.field_72448_b, (int)thisBlock.field_72449_c);
                meta = theWorld.func_72805_g((int)thisBlock.field_72450_a, (int)thisBlock.field_72448_b, (int)thisBlock.field_72449_c) & 7;
            } else if (!theWorld.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d).isAir((IBlockAccess)theWorld, event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d)) {
                block = Block.func_149634_a((Item)h.func_77973_b());
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[event.target.field_72310_e];
                thisBlock = Vec3.func_72443_a((double)(event.target.field_72311_b + dir.offsetX), (double)(event.target.field_72312_c + dir.offsetY), (double)(event.target.field_72309_d + dir.offsetZ));
                meta = h.func_77960_j();
            } else {
                return;
            }
            if (block instanceof BlockUnstableStone) {
                if (!isEnchanted && event.target.field_72310_e <= 1 && meta == 1 && theWorld.func_147445_c((int)thisBlock.field_72450_a + 1, (int)thisBlock.field_72448_b, (int)thisBlock.field_72449_c, true) && theWorld.func_147445_c((int)thisBlock.field_72450_a - 1, (int)thisBlock.field_72448_b, (int)thisBlock.field_72449_c, true) && theWorld.func_147445_c((int)thisBlock.field_72450_a, (int)thisBlock.field_72448_b, (int)thisBlock.field_72449_c + 1, true) && theWorld.func_147445_c((int)thisBlock.field_72450_a, (int)thisBlock.field_72448_b, (int)thisBlock.field_72449_c - 1, true)) {
                    meta = 0;
                }
                Vec3[] points = UnstableStoneHelper.getSupportByMeta(theWorld, (int)thisBlock.field_72450_a, (int)thisBlock.field_72448_b, (int)thisBlock.field_72449_c, meta, isEnchanted);
                GL11.glPushMatrix();
                GL11.glPushAttrib((int)8192);
                Vec3 pos = event.player.func_70666_h(event.partialTicks);
                GL11.glTranslated((double)(-pos.field_72450_a), (double)(-pos.field_72448_b), (double)(-pos.field_72449_c));
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3553);
                if (points != null) {
                    if (points.length > 0) {
                        if (isBlock) {
                            thisBlock.field_72448_b += 0.1;
                        }
                        for (int i = points.length - 1; i >= 0; --i) {
                            this.drawLine(thisBlock, points[i], meta == 2 ? (points.length < 4 ? 0 : points.length) : points.length, i + 1);
                        }
                    } else {
                        this.drawSquare(thisBlock);
                    }
                } else {
                    if (event.target.field_72310_e == 1) {
                        thisBlock.field_72448_b -= 1.0;
                    }
                    this.drawTopGreenSquare(thisBlock);
                }
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            }
        }
    }

    private void drawTopGreenSquare(Vec3 thisBlock) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(7);
        tess.func_78380_c(0xF000F0);
        tess.func_78386_a(0.0f, 1.0f, 0.0f);
        float f = 0.0625f;
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78381_a();
    }

    private void drawSquare(Vec3 thisBlock) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78371_b(7);
        tess.func_78380_c(0xF000F0);
        tess.func_78386_a(1.0f, 0.0f, 0.0f);
        float f = 0.0625f;
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b - 0.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b - 0.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b - 0.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b - 0.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b - 0.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b - 0.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b - 0.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b - 0.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a - 0.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a - 0.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a - 0.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a - 0.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a - 0.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a - 0.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a - 0.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a - 0.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c - 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c - 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c - 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c - 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c - 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c - 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c - 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c - 0.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.999, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.999, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.999, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.999, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 1.001, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.999, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.999, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.999, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.999, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.999, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.999, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.999, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.999, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 1.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 1.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 1.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 1.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 1.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 1.001, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 1.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 1.001, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.999, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.999, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.999, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 + (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.999, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.5 - (double)f);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.999);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.999);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.999);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.999);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 1.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 1.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 1.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 1.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 1.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 1.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 1.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 1.001);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.999);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 - (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.999);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 + (double)f, thisBlock.field_72449_c + 0.999);
        tess.func_78377_a(thisBlock.field_72450_a + 0.5 + (double)f, thisBlock.field_72448_b + 0.5 - (double)f, thisBlock.field_72449_c + 0.999);
        tess.func_78381_a();
    }

    private void drawLine(Vec3 blockA, Vec3 blockB, int num, int f) {
        Tessellator tess = Tessellator.field_78398_a;
        blockB.field_72448_b += 1.0;
        int d = Math.round((float)blockA.func_72438_d(blockB) + 0.2f);
        blockB.field_72448_b -= 1.0;
        if (num == 0) {
            blockA.field_72448_b -= (double)0.02f;
            this.drawSquare(blockA);
        }
        tess.func_78371_b(7);
        tess.func_78380_c(0xF000F0);
        if (num == 0) {
            tess.func_78386_a(1.0f, 0.0f, 0.0f);
        } else if (num == 1) {
            switch (d) {
                case 5: 
                case 6: 
                case 7: {
                    tess.func_78386_a(1.0f, 0.0f, 0.0f);
                    break;
                }
                case 4: {
                    tess.func_78386_a(1.0f, 0.35f, 0.0f);
                    break;
                }
                case 3: {
                    tess.func_78386_a(1.0f, 0.75f, 0.0f);
                    break;
                }
                default: {
                    tess.func_78386_a(0.75f, 1.0f, 0.0f);
                    break;
                }
            }
        } else {
            switch (d) {
                case 5: 
                case 6: 
                case 7: {
                    tess.func_78386_a(1.0f, 0.45f, 0.0f);
                    break;
                }
                case 4: {
                    tess.func_78386_a(0.8f, 0.8f, 0.0f);
                    break;
                }
                case 3: {
                    tess.func_78386_a(0.8f, 1.0f, 0.0f);
                    break;
                }
                default: {
                    tess.func_78386_a(0.0f, 1.0f, 0.0f);
                }
            }
        }
        Vec3 recLong = blockA.func_72444_a(blockB);
        Vec3 perpendicular = Vec3.func_72443_a((double)recLong.field_72449_c, (double)recLong.field_72448_b, (double)(-recLong.field_72450_a));
        perpendicular = perpendicular.func_72432_b();
        float Width = 0.0625f;
        Vec3 R1 = blockA.func_72444_a(blockB);
        Vec3 R2 = blockA.func_72444_a(blockB);
        Vec3 R3 = blockA.func_72444_a(blockB);
        Vec3 R4 = blockA.func_72444_a(blockB);
        R1.field_72450_a = blockA.field_72450_a + perpendicular.field_72450_a * (double)Width;
        R1.field_72449_c = blockA.field_72449_c + perpendicular.field_72449_c * (double)Width;
        R2.field_72450_a = blockA.field_72450_a - perpendicular.field_72450_a * (double)Width;
        R2.field_72449_c = blockA.field_72449_c - perpendicular.field_72449_c * (double)Width;
        R1.field_72448_b = blockA.field_72448_b - 0.01;
        R2.field_72448_b = blockA.field_72448_b - 0.01;
        R3.field_72450_a = blockB.field_72450_a + perpendicular.field_72450_a * (double)Width;
        R3.field_72449_c = blockB.field_72449_c + perpendicular.field_72449_c * (double)Width;
        R4.field_72450_a = blockB.field_72450_a - perpendicular.field_72450_a * (double)Width;
        R4.field_72449_c = blockB.field_72449_c - perpendicular.field_72449_c * (double)Width;
        R3.field_72448_b = blockB.field_72448_b + 0.75;
        R4.field_72448_b = blockB.field_72448_b + 0.75;
        tess.func_78377_a(R1.field_72450_a + 0.5, R1.field_72448_b, R1.field_72449_c + 0.5);
        tess.func_78377_a(R3.field_72450_a + 0.5, R3.field_72448_b, R3.field_72449_c + 0.5);
        tess.func_78377_a(R4.field_72450_a + 0.5, R4.field_72448_b, R4.field_72449_c + 0.5);
        tess.func_78377_a(R2.field_72450_a + 0.5, R2.field_72448_b, R2.field_72449_c + 0.5);
        tess.func_78381_a();
        this.drawTopGreenSquare(blockA);
    }
}

