/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hazards.block.helper;

import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hazards.HazardsEventHandler;
import com.draco18s.hazards.UndergroundBase;
import com.draco18s.hazards.block.IBreathable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class UnstableStoneHelper {
    private static List<Block> supportBlocks = new ArrayList<Block>();
    private static final int maxDist = 5;
    private static final ForgeDirection[] dirs = new ForgeDirection[]{ForgeDirection.UNKNOWN, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.NORTH};

    public static void addSupportBlock(Block b) {
        supportBlocks.add(b);
    }

    public static void updateUnstable(World world, int x, int y, int z, Random rand, Block block, int meta) {
        boolean falling = false;
        int m = world.func_72805_g(x, y, z) & 8;
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) || m > 0) {
            return;
        }
        int i = x;
        int j = y;
        int k = z;
        boolean bl = falling = y == 0 || UnstableStoneHelper.isBlockUnsupported(world, x, y, z);
        if (falling) {
            world.func_147465_d(i, j, k, block, 3, 3);
            UnstableStoneHelper.damageNeighbors(world, i, j, k);
            UnstableStoneHelper.damageNeighbors(world, i, j, k);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isBlockUnsupported(World world, int x, int y, int z) {
        dir = 0;
        ox = 0;
        oz = 0;
        do {
            switch (dir) {
                case 0: {
                    ++ox;
                    break;
                }
                case 1: {
                    ++oz;
                    break;
                }
                case 2: {
                    --ox;
                    break;
                }
                case 3: {
                    --oz;
                }
            }
            s = world.func_147439_a(x + ox, y, z + oz);
            m = world.func_72805_g(x + ox, y, z + oz);
            v0 = a = UnstableStoneHelper.supportBlocks.indexOf(s) >= 0;
            if (HardLibAPI.stoneManager.isUnstableBlock(s) && m != 0) {
                a = false;
            }
            s = world.func_147439_a(x + ox, y - 1, z + oz);
            m = world.func_72805_g(x + ox, y - 1, z + oz);
            v1 = b = UnstableStoneHelper.supportBlocks.indexOf(s) >= 0;
            if (HardLibAPI.stoneManager.isUnstableBlock(s) && m != 0) {
                b = false;
            }
            if (b) ** GOTO lbl-1000
            if (world.func_147445_c(x + ox, y - 1, z + oz, true)) {
                ** if (!World.func_147466_a((IBlockAccess)world, (int)(x + ox), (int)(y - 1), (int)(z + oz))) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v2 = true;
                ** GOTO lbl35
            }
lbl-1000:
            // 2 sources

            {
                v2 = b = false;
            }
lbl35:
            // 2 sources

            if (!a || ox > 5 || ox < -5 || oz > 5 || oz < -5) {
                ox = 0;
                oz = 0;
                ++dir;
                continue;
            }
            if (a && b) break;
        } while (dir >= 0 && dir < 4);
        return dir == 4;
    }

    public static void updateFractured(World world, int x, int y, int z, Random rand, Block block, int meta) {
        boolean nz;
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
            return;
        }
        Block s = world.func_147439_a(x + 1, y, z);
        int m = world.func_72805_g(x + 1, y, z);
        boolean px = s == Blocks.field_150348_b || HardLibAPI.stoneManager.isUnstableBlock(s) && m == 0;
        s = world.func_147439_a(x - 1, y, z);
        m = world.func_72805_g(x - 1, y, z);
        boolean nx = s == Blocks.field_150348_b || HardLibAPI.stoneManager.isUnstableBlock(s) && m == 0;
        s = world.func_147439_a(x, y, z + 1);
        m = world.func_72805_g(x, y, z + 1);
        boolean pz = s == Blocks.field_150348_b || HardLibAPI.stoneManager.isUnstableBlock(s) && m == 0;
        s = world.func_147439_a(x, y, z - 1);
        m = world.func_72805_g(x, y, z - 1);
        boolean bl = nz = s == Blocks.field_150348_b || HardLibAPI.stoneManager.isUnstableBlock(s) && m == 0;
        if (!(px || nx || pz || nz)) {
            world.func_147465_d(x, y, z, block, 3, 3);
            UnstableStoneHelper.damageNeighbors(world, x, y, z);
        }
    }

    public static void updateBroken(World world, int x, int y, int z, Random rand, Block block, int meta) {
        boolean falling = false;
        if (world.isSideSolid(x, y - 1, z, ForgeDirection.DOWN)) {
            return;
        }
        int t = world.isSideSolid(x + 1, y - 1, z, ForgeDirection.DOWN) ? 1 : 0;
        t += world.isSideSolid(x - 1, y - 1, z, ForgeDirection.DOWN) ? 1 : 0;
        t += world.isSideSolid(x, y - 1, z + 1, ForgeDirection.DOWN) ? 1 : 0;
        if ((t += world.isSideSolid(x, y - 1, z - 1, ForgeDirection.DOWN) ? 1 : 0) < 2) {
            t *= 2;
            t += world.isSideSolid(x + 1, y - 1, z + 1, ForgeDirection.DOWN) ? 1 : 0;
            t += world.isSideSolid(x - 1, y - 1, z - 1, ForgeDirection.DOWN) ? 1 : 0;
            t += world.isSideSolid(x - 1, y - 1, z + 1, ForgeDirection.DOWN) ? 1 : 0;
            if ((t += world.isSideSolid(x + 1, y - 1, z - 1, ForgeDirection.DOWN) ? 1 : 0) < 4) {
                falling = true;
            }
        }
        if (falling) {
            world.func_147465_d(x, y, z, block, 3, 3);
            UnstableStoneHelper.damageNeighbors(world, x, y, z);
        }
    }

    public static void updateCobble(World world, int x, int y, int z, Random rand, Block block, int meta) {
        int c = UnstableStoneHelper.canFall(world, x, y - 1, z);
        if (c > 0) {
            if (c % 2 == 1) {
                int b0;
                if (UnstableStoneHelper.canFall(world, x, y - 1, z) > 0 && y >= 0 && world.func_72904_c(x - (b0 = 32), y - b0, z - b0, x + b0, y + b0, z + b0) && !world.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block, meta);
                    world.func_72838_d((Entity)entityfallingblock);
                }
                return;
            }
            if (HazardsEventHandler.sidwaysFallPhysics) {
                world.func_147468_f(x, y, z);
                ArrayList<Long> a = new ArrayList<Long>();
                if ((c >>= 1) % 2 == 1) {
                    a.add(1L);
                }
                if ((c >>= 1) % 2 == 1) {
                    a.add(2L);
                }
                if ((c >>= 1) % 2 == 1) {
                    a.add(3L);
                }
                if ((c >>= 1) % 2 == 1) {
                    a.add(4L);
                }
                int r = rand.nextInt(a.size());
                r = (int)((Long)a.get(r) & 0xFL);
                switch (r) {
                    case 1: {
                        world.func_147465_d(x + 1, y - 1, z, block, meta, 2);
                        break;
                    }
                    case 2: {
                        world.func_147465_d(x - 1, y - 1, z, block, meta, 2);
                        break;
                    }
                    case 3: {
                        world.func_147465_d(x, y - 1, z + 1, block, meta, 2);
                        break;
                    }
                    case 4: {
                        world.func_147465_d(x, y - 1, z - 1, block, meta, 2);
                    }
                }
            }
        }
    }

    private static int canFall(World world, int x, int y, int z) {
        int r = 0;
        int i = 0;
        for (ForgeDirection dir : dirs) {
            Block l = world.func_147439_a(x + dir.offsetX, y, z + dir.offsetZ);
            if (l.isReplaceable((IBlockAccess)world, x + dir.offsetX, y, z + dir.offsetZ) || l == Blocks.field_150350_a || l == Blocks.field_150480_ab || l instanceof IBreathable) {
                r += 1 << i;
            }
            ++i;
        }
        return r;
    }

    public static void drawLine3D(World world, Block block, int meta, int x1, int y1, int z1, int x2, int y2, int z2) {
        UnstableStoneHelper.drawLine3D(world, block, meta, x1, y1, z1, x2, y2, z2, false, false);
    }

    public static void drawLine3D(World world, Block block, int meta, int x1, int y1, int z1, int x2, int y2, int z2, boolean incremental) {
        UnstableStoneHelper.drawLine3D(world, block, meta, x1, y1, z1, x2, y2, z2, incremental, false);
    }

    public static void drawLine3D(World world, Block block, int meta, int x1, int y1, int z1, int x2, int y2, int z2, boolean incremental, boolean resist) {
        int[] pixel = new int[]{x1, y1, z1};
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int l = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int m = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int n = Math.abs(dz);
        int dx2 = l << 1;
        int dy2 = m << 1;
        int dz2 = n << 1;
        float res = 0.0f;
        if (l >= m && l >= n) {
            int err_1 = dy2 - l;
            int err_2 = dz2 - l;
            float ll = l;
            int i = 0;
            while ((float)i < ll) {
                res = UnstableStoneHelper.PUT_PIXEL(world, block, meta, pixel, incremental);
                if (err_1 > 0) {
                    pixel[1] = pixel[1] + y_inc;
                    err_1 -= dx2;
                }
                if (err_2 > 0) {
                    pixel[2] = pixel[2] + z_inc;
                    err_2 -= dx2;
                }
                err_1 += dy2;
                err_2 += dz2;
                pixel[0] = pixel[0] + x_inc;
                ll -= res;
                ++i;
            }
        } else if (m >= l && m >= n) {
            int err_1 = dx2 - m;
            int err_2 = dz2 - m;
            float ll = m;
            int i = 0;
            while ((float)i < ll) {
                res = UnstableStoneHelper.PUT_PIXEL(world, block, meta, pixel, incremental);
                if (err_1 > 0) {
                    pixel[0] = pixel[0] + x_inc;
                    err_1 -= dy2;
                }
                if (err_2 > 0) {
                    pixel[2] = pixel[2] + z_inc;
                    err_2 -= dy2;
                }
                err_1 += dx2;
                err_2 += dz2;
                pixel[1] = pixel[1] + y_inc;
                ll -= res;
                ++i;
            }
        } else {
            int err_1 = dy2 - n;
            int err_2 = dx2 - n;
            float ll = n;
            int i = 0;
            while ((float)i < ll) {
                res = UnstableStoneHelper.PUT_PIXEL(world, block, meta, pixel, incremental);
                if (err_1 > 0) {
                    pixel[1] = pixel[1] + y_inc;
                    err_1 -= dz2;
                }
                if (err_2 > 0) {
                    pixel[0] = pixel[0] + x_inc;
                    err_2 -= dz2;
                }
                err_1 += dy2;
                err_2 += dx2;
                pixel[2] = pixel[2] + z_inc;
                ll -= res;
                ++i;
            }
        }
        UnstableStoneHelper.PUT_PIXEL(world, block, meta, pixel, incremental);
    }

    private static float PUT_PIXEL(World w, Block b, int m, int[] p) {
        return UnstableStoneHelper.PUT_PIXEL(w, b, m, p, false);
    }

    private static float PUT_PIXEL(World w, Block b, int m, int[] p, boolean inc) {
        Block s = w.func_147439_a(p[0], p[1], p[2]);
        float r = 1000.0f;
        if (s == Blocks.field_150348_b || HardLibAPI.stoneManager.isUnstableBlock(s)) {
            r = s.func_149712_f(w, p[0], p[1], p[2]);
            w.func_147465_d(p[0], p[1], p[2], b, m, 3);
        }
        if (inc) {
            if (s == b) {
                r = s.func_149712_f(w, p[0], p[1], p[2]);
                w.func_147465_d(p[0], p[1], p[2], b, m + 1, 3);
            } else if (s == b) {
                r = s.func_149712_f(w, p[0], p[1], p[2]);
                w.func_147465_d(p[0], p[1], p[2], b, m + 2, 3);
            }
        }
        return r / 10.0f;
    }

    public static void damageNeighbors(World world, int x, int y, int z) {
        Block b;
        Block s = world.func_147439_a(x + 1, y, z);
        int m = world.func_72805_g(x + 1, y, z);
        if (HardLibAPI.stoneManager.isUnstableBlock(s)) {
            if (++m > 3) {
                m = 3;
            }
        } else {
            b = HardLibAPI.stoneManager.getReplacement(s, m);
            if (b != null) {
                s = b;
                m = 0;
            }
        }
        world.func_147465_d(x + 1, y, z, s, m, 3);
        s = world.func_147439_a(x - 1, y, z);
        m = world.func_72805_g(x - 1, y, z);
        if (HardLibAPI.stoneManager.isUnstableBlock(s)) {
            if (++m > 3) {
                m = 3;
            }
        } else {
            b = HardLibAPI.stoneManager.getReplacement(s, m);
            if (b != null) {
                s = b;
                m = 0;
            }
        }
        world.func_147465_d(x - 1, y, z, s, m, 3);
        s = world.func_147439_a(x, y, z + 1);
        m = world.func_72805_g(x, y, z + 1);
        if (HardLibAPI.stoneManager.isUnstableBlock(s)) {
            if (++m > 3) {
                m = 3;
            }
        } else {
            b = HardLibAPI.stoneManager.getReplacement(s, m);
            if (b != null) {
                s = b;
                m = 0;
            }
        }
        world.func_147465_d(x, y, z + 1, s, m, 3);
        s = world.func_147439_a(x, y, z - 1);
        m = world.func_72805_g(x, y, z - 1);
        if (HardLibAPI.stoneManager.isUnstableBlock(s)) {
            if (++m > 3) {
                m = 3;
            }
        } else {
            b = HardLibAPI.stoneManager.getReplacement(s, m);
            if (b != null) {
                s = b;
                m = 0;
            }
        }
        world.func_147465_d(x, y, z - 1, s, m, 3);
        s = world.func_147439_a(x, y + 1, z);
        m = world.func_72805_g(x, y + 1, z);
        if (HardLibAPI.stoneManager.isUnstableBlock(s)) {
            if (++m > 3) {
                m = 3;
            }
        } else {
            b = HardLibAPI.stoneManager.getReplacement(s, m);
            if (b != null) {
                s = b;
                m = 0;
            }
        }
        world.func_147465_d(x, y + 1, z, s, m, 3);
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "hazards:random.rock", 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
        Random rand = new Random();
        if (HazardsEventHandler.enableRockDust) {
            for (int i = -3; i <= 3; ++i) {
                for (int k = -3; k <= 3; ++k) {
                    if (world.func_147437_c(x + i, y - 2, z + k)) {
                        if (rand.nextInt(24) != 0) continue;
                        world.func_147465_d(x + i, y - 2, z + k, UndergroundBase.rockDust, rand.nextInt(4), 3);
                        return;
                    }
                    if (world.func_147437_c(x + i, y - 1, z + k)) {
                        if (rand.nextInt(24) != 0) continue;
                        world.func_147465_d(x + i, y - 1, z + k, UndergroundBase.rockDust, rand.nextInt(4), 3);
                        return;
                    }
                    if (!world.func_147437_c(x + i, y, z + k) || rand.nextInt(24) != 0) continue;
                    world.func_147465_d(x + i, y, z + k, UndergroundBase.rockDust, rand.nextInt(4), 3);
                    return;
                }
            }
        }
    }

    public static Vec3[] getSupportByMeta(World world, int x, int y, int z, int meta, boolean isEnchanted) {
        if (World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
            return null;
        }
        switch (meta) {
            case 0: {
                return UnstableStoneHelper.getSupportStone(world, x, y, z, meta, isEnchanted);
            }
            case 1: {
                return UnstableStoneHelper.getSupportFrac(world, x, y, z, meta, isEnchanted);
            }
            case 2: {
                return UnstableStoneHelper.getSupportBroke(world, x, y, z, meta, isEnchanted);
            }
        }
        return new Vec3[0];
    }

    private static Vec3[] getSupportBroke(World world, int x, int y, int z, int meta, boolean isEnchanted) {
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        Vec3[] p = new Vec3[]{};
        if (world.isSideSolid(x + 1, y - 1, z, ForgeDirection.DOWN)) {
            points.add(Vec3.func_72443_a((double)(x + 1), (double)(y - 1), (double)z));
        }
        if (world.isSideSolid(x - 1, y - 1, z, ForgeDirection.DOWN)) {
            points.add(Vec3.func_72443_a((double)(x - 1), (double)(y - 1), (double)z));
        }
        if (world.isSideSolid(x, y - 1, z + 1, ForgeDirection.DOWN)) {
            points.add(Vec3.func_72443_a((double)x, (double)(y - 1), (double)(z + 1)));
        }
        if (world.isSideSolid(x, y - 1, z - 1, ForgeDirection.DOWN)) {
            points.add(Vec3.func_72443_a((double)x, (double)(y - 1), (double)(z - 1)));
        }
        if (points.size() < 2) {
            if (world.isSideSolid(x + 1, y - 1, z + 1, ForgeDirection.DOWN)) {
                points.add(Vec3.func_72443_a((double)(x + 1), (double)(y - 1), (double)(z + 1)));
            }
            if (world.isSideSolid(x + 1, y - 1, z - 1, ForgeDirection.DOWN)) {
                points.add(Vec3.func_72443_a((double)(x + 1), (double)(y - 1), (double)(z - 1)));
            }
            if (world.isSideSolid(x - 1, y - 1, z + 1, ForgeDirection.DOWN)) {
                points.add(Vec3.func_72443_a((double)(x - 1), (double)(y - 1), (double)(z + 1)));
            }
            if (world.isSideSolid(x - 1, y - 1, z - 1, ForgeDirection.DOWN)) {
                points.add(Vec3.func_72443_a((double)(x - 1), (double)(y - 1), (double)(z - 1)));
            }
        } else {
            points.add(Vec3.func_72443_a((double)x, (double)y, (double)z));
            points.add(Vec3.func_72443_a((double)x, (double)y, (double)z));
        }
        return points.toArray(p);
    }

    private static Vec3[] getSupportFrac(World world, int x, int y, int z, int meta, boolean isEnchanted) {
        Block s = world.func_147439_a(x + 1, y, z);
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        Vec3[] p = new Vec3[]{};
        int m = world.func_72805_g(x + 1, y, z);
        if ((s == Blocks.field_150348_b || HardLibAPI.stoneManager.isUnstableBlock(s)) && (m == 0 || !isEnchanted && world.func_147445_c(x + 2, y, z, true) && world.func_147445_c(x + 1, y, z + 1, true) && world.func_147445_c(x + 1, y, z - 1, true))) {
            points.add(Vec3.func_72443_a((double)(x + 1), (double)((double)y - 0.76), (double)z));
        }
        s = world.func_147439_a(x - 1, y, z);
        m = world.func_72805_g(x - 1, y, z);
        if ((s == Blocks.field_150348_b || HardLibAPI.stoneManager.isUnstableBlock(s)) && (m == 0 || !isEnchanted && world.func_147445_c(x - 2, y, z, true) && world.func_147445_c(x - 1, y, z + 1, true) && world.func_147445_c(x - 1, y, z - 1, true))) {
            points.add(Vec3.func_72443_a((double)(x - 1), (double)((double)y - 0.76), (double)z));
        }
        s = world.func_147439_a(x, y, z + 1);
        m = world.func_72805_g(x, y, z + 1);
        if ((s == Blocks.field_150348_b || HardLibAPI.stoneManager.isUnstableBlock(s)) && (m == 0 || !isEnchanted && world.func_147445_c(x + 1, y, z + 1, true) && world.func_147445_c(x, y, z + 2, true) && world.func_147445_c(x - 1, y, z + 1, true))) {
            points.add(Vec3.func_72443_a((double)x, (double)((double)y - 0.76), (double)(z + 1)));
        }
        s = world.func_147439_a(x, y, z - 1);
        m = world.func_72805_g(x, y, z - 1);
        if ((s == Blocks.field_150348_b || HardLibAPI.stoneManager.isUnstableBlock(s)) && (m == 0 || !isEnchanted && world.func_147445_c(x + 1, y, z - 1, true) && world.func_147445_c(x, y, z - 2, true) && world.func_147445_c(x - 1, y, z - 1, true))) {
            points.add(Vec3.func_72443_a((double)x, (double)((double)y - 0.76), (double)(z - 1)));
        }
        return points.toArray(p);
    }

    /*
     * Unable to fully structure code
     */
    private static Vec3[] getSupportStone(World world, int x, int y, int z, int m, boolean isEnchanted) {
        dir = 0;
        ox = 0;
        oz = 0;
        points = new ArrayList<Vec3>();
        p = new Vec3[]{};
        do {
            switch (dir) {
                case 0: {
                    ++ox;
                    break;
                }
                case 1: {
                    ++oz;
                    break;
                }
                case 2: {
                    --ox;
                    break;
                }
                case 3: {
                    --oz;
                }
            }
            s = world.func_147439_a(x + ox, y, z + oz);
            m = world.func_72805_g(x + ox, y, z + oz);
            v0 = a = UnstableStoneHelper.supportBlocks.indexOf(s) >= 0;
            if (!(!HardLibAPI.stoneManager.isUnstableBlock(s) || m == 0 || !isEnchanted && world.func_147445_c(x + ox + 1, y, z + oz, true) && world.func_147445_c(x + ox - 1, y, z + oz, true) && world.func_147445_c(x + ox, y, z + oz + 1, true) && world.func_147445_c(x + ox, y, z + oz - 1, true))) {
                a = false;
            }
            if (!isEnchanted && !a && world.func_147445_c(x + ox, y - 1, z + oz, true) && world.func_147445_c(x + ox + 1, y, z + oz, true) && world.func_147445_c(x + ox - 1, y, z + oz, true) && world.func_147445_c(x + ox, y, z + oz + 1, true) && world.func_147445_c(x + ox, y, z + oz - 1, true)) {
                a = true;
            }
            s = world.func_147439_a(x + ox, y - 1, z + oz);
            m = world.func_72805_g(x + ox, y - 1, z + oz);
            v1 = b = UnstableStoneHelper.supportBlocks.indexOf(s) >= 0;
            if (HardLibAPI.stoneManager.isUnstableBlock(s) && m != 0) {
                b = false;
            }
            if (b) ** GOTO lbl-1000
            if (world.func_147445_c(x + ox, y - 1, z + oz, true)) {
                ** if (!World.func_147466_a((IBlockAccess)world, (int)(x + ox), (int)(y - 1), (int)(z + oz))) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v2 = true;
                ** GOTO lbl39
            }
lbl-1000:
            // 2 sources

            {
                v2 = b = false;
            }
lbl39:
            // 2 sources

            if (!a || ox > 5 || ox < -5 || oz > 5 || oz < -5) {
                ox = 0;
                oz = 0;
                ++dir;
                continue;
            }
            if (!a || !b) continue;
            points.add(Vec3.func_72443_a((double)(x + ox), (double)(y - 1), (double)(z + oz)));
            ox = 0;
            oz = 0;
            ++dir;
        } while (dir >= 0 && dir < 4);
        return points.toArray(p);
    }
}

