/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hazards.block;

import com.draco18s.hazards.block.BlockGas;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class BlockVolcanicGas
extends BlockGas {
    public BlockVolcanicGas(Fluid fluid) {
        super(fluid, 5);
        this.setDensity(-10);
        this.setTemperature(675);
        this.func_149663_c("VolcanicGas");
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    public boolean causesNausea(int meta) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.stillIcon = register.func_94245_a("hazards:volcanic_still");
        this.flowingIcon = register.func_94245_a("hazards:volcanic_flow");
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        if (world.func_147439_a(x, y, z) != this && world.func_147439_a(x, y + 1, z) == this) {
            this.smokeDecay(world, x, y + 1, z, rand);
        }
        this.smokeDecay(world, x, y, z, rand);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void smokeDecay(World world, int x, int y, int z, Random rand) {
        int m = world.func_72805_g(x, y, z);
        if (rand.nextInt(24) == 0) {
            if (m <= 0) {
                world.func_147468_f(x, y, z);
                return;
            }
            world.func_72921_c(x, y, z, m - 1, 3);
        } else {
            boolean f = false;
            int j = -8;
            while (true) {
                if (j < 0 && !f) {
                } else {
                    if (f) break;
                    if (m <= 0) {
                        world.func_147468_f(x, y, z);
                        return;
                    }
                    world.func_72921_c(x, y, z, m - 1, 3);
                    break;
                }
                for (int i = -8; i <= 8 && !f; ++i) {
                    for (int k = -8; k <= 8 && !f; ++k) {
                        Block b = world.func_147439_a(x + i, y + j, z + k);
                        if (b != Blocks.field_150353_l && b != Blocks.field_150356_k && b != Blocks.field_150480_ab) continue;
                        f = true;
                    }
                }
                ++j;
            }
        }
        world.func_147464_a(x, y, z, (Block)this, this.tickRate * 4);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        world.func_147464_a(x, y, z, (Block)this, this.tickRate);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity ent) {
        if (ent instanceof EntityLivingBase) {
            ((EntityLivingBase)ent).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 19));
        }
    }
}

