/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hazards;

import CustomOreGen.Util.CogOreGenEvent;
import com.draco18s.hardlib.api.HardLibAPI;
import com.draco18s.hardlib.events.SpecialBlockEvent;
import com.draco18s.hazards.UndergroundBase;
import com.draco18s.hazards.block.IBreathable;
import com.draco18s.hazards.block.helper.UnstableStoneHelper;
import com.draco18s.hazards.client.PlayerStatsClient;
import com.draco18s.hazards.entities.PlayerStats;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

public class HazardsEventHandler {
    private int delay = 0;
    private Random rand = new Random();
    public static HazardsEventHandler instance;
    public static boolean sidwaysFallPhysics;
    public static int rockDustUpdateCount;
    public static boolean enableRockDust;
    private HashMap<EntityPlayer, Boolean> playersSwimming = new HashMap();

    public HazardsEventHandler() {
        instance = this;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        int x = (int)event.player.field_70165_t;
        int y = (int)event.player.field_70163_u;
        int z = (int)event.player.field_70161_v;
        World world = event.player.field_70170_p;
        if (event.phase == TickEvent.Phase.START) {
            boolean ingas;
            boolean flag = false;
            if (this.playersSwimming.containsKey(event.player)) {
                flag = this.playersSwimming.get(event.player);
            }
            if (flag && (ingas = event.player.field_70170_p.func_72875_a(event.player.field_70121_D.func_72314_b((double)-0.1f, 0.0, (double)-0.1f), UndergroundBase.gas))) {
                if (event.player.field_70170_p.func_72875_a(event.player.field_70121_D.func_72314_b((double)-0.1f, -0.125, (double)-0.1f), Material.field_151587_i)) {
                    event.player.field_70181_x += 0.105;
                } else if (event.player.field_70170_p.func_72875_a(event.player.field_70121_D.func_72314_b((double)-0.1f, -0.125, (double)-0.1f), Material.field_151586_h)) {
                    event.player.field_70181_x += 0.105;
                }
            }
        }
        if ((UndergroundBase.doVolcanicGas || UndergroundBase.doSmoke) && event.phase == TickEvent.Phase.END) {
            ++this.delay;
            if (this.delay >= 40 && event.player instanceof EntityPlayer && !world.field_72995_K) {
                if (world.field_73011_w.field_76575_d) {
                    return;
                }
                this.delay = 0;
                for (int i = -32; i <= 32; ++i) {
                    for (int j = -16; j <= 16; ++j) {
                        for (int k = -32; k <= 32; ++k) {
                            Block b = world.func_147439_a(x + i, y + j, z + k);
                            if (UndergroundBase.doVolcanicGas && (b == Blocks.field_150353_l || b == Blocks.field_150356_k)) {
                                if (this.rand.nextInt(16) != 0) continue;
                                b = world.func_147439_a(x + i, y + j + 1, z + k);
                                if (b == Blocks.field_150350_a) {
                                    world.func_147465_d(x + i, y + j + 1, z + k, UndergroundBase.blockVolcanicGas, 3, 3);
                                    continue;
                                }
                                if (b != UndergroundBase.blockVolcanicGas) continue;
                                world.func_72921_c(x + i, y + j + 1, z + k, Math.min(world.func_72805_g(x + i, y + j + 1, z + k) + 2, 7), 3);
                                world.func_147464_a(x + i, y + j + 1, z + k, b, 1);
                                continue;
                            }
                            if (!UndergroundBase.doSmoke || b != Blocks.field_150480_ab || this.rand.nextInt(16) != 0) continue;
                            b = world.func_147439_a(x + i, y + j + 1, z + k);
                            if (b == Blocks.field_150350_a) {
                                world.func_147465_d(x + i, y + j + 1, z + k, UndergroundBase.blockVolcanicGas, 3, 3);
                                continue;
                            }
                            if (b == UndergroundBase.blockVolcanicGas) {
                                world.func_72921_c(x + i, y + j + 1, z + k, Math.min(world.func_72805_g(x + i, y + j + 1, z + k) + 2, 7), 3);
                                world.func_147464_a(x + i, y + j + 1, z + k, b, 1);
                                continue;
                            }
                            int rx = 0;
                            int rz = 0;
                            switch (this.rand.nextInt(4)) {
                                case 0: {
                                    rx = 1;
                                    break;
                                }
                                case 1: {
                                    rx = -1;
                                    break;
                                }
                                case 2: {
                                    rz = 1;
                                    break;
                                }
                                case 3: {
                                    rz = -1;
                                }
                            }
                            b = world.func_147439_a(x + i + rx, y + j, z + k + rz);
                            if (b == Blocks.field_150350_a) {
                                world.func_147465_d(x + i + rx, y + j, z + k + rz, UndergroundBase.blockVolcanicGas, 3, 3);
                                continue;
                            }
                            if (b != UndergroundBase.blockVolcanicGas) continue;
                            world.func_72921_c(x + i + rx, y + j, z + k + rz, Math.min(world.func_72805_g(x + i + rx, y + j, z + k + rz) + 2, 7), 3);
                            world.func_147464_a(x + i + rx, y + j, z + k + rz, b, 1);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        PlayerStats stats;
        if (UndergroundBase.needsToBreath(event.entityLiving) && (stats = PlayerStats.get(event.entityLiving)) != null) {
            AxisAlignedBB aabb;
            if (stats.maxAir <= 0 && (aabb = event.entityLiving.field_70121_D) != null) {
                double volume = (aabb.field_72336_d - aabb.field_72340_a) * (aabb.field_72337_e - aabb.field_72338_b) * (aabb.field_72334_f - aabb.field_72339_c);
                int max = (int)Math.max(Math.floor(volume / 0.00216) * 10.0, 100.0);
                stats.airRemaining = Math.min(stats.airRemaining, max);
                stats.maxAir = max;
            }
            if (event.entityLiving.func_70055_a(UndergroundBase.gas)) {
                double d0 = event.entityLiving.field_70163_u + (double)event.entityLiving.func_70047_e();
                int i = MathHelper.func_76128_c((double)event.entityLiving.field_70165_t);
                int j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d0));
                int k = MathHelper.func_76128_c((double)event.entityLiving.field_70161_v);
                Block block = event.entityLiving.field_70170_p.func_147439_a(i, j, k);
                if (event.entityLiving instanceof EntityPlayer && ((EntityPlayer)event.entityLiving).field_71075_bZ.field_75098_d) {
                    return;
                }
                int meta = event.entityLiving.field_70170_p.func_72805_g(i, j, k);
                int amt = ((IBreathable)block).getAirQuality(meta);
                stats.airRemaining = this.decreaseAirSupply(event.entityLiving, stats.airRemaining, amt);
                if (Math.floor((float)stats.airRemaining / 10.0f) == 40.0) {
                    event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100));
                }
                if (stats.airRemaining <= -200) {
                    stats.airRemaining = 0;
                    event.entityLiving.func_70097_a(DamageSource.field_76369_e, 1.0f);
                    if (((IBreathable)block).causesNausea(meta)) {
                        event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100));
                    }
                }
            } else {
                stats.airRemaining = Math.min(stats.airRemaining + 50, Math.max(stats.maxAir, 100));
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayerMP && PlayerStats.get((EntityLivingBase)((EntityPlayerMP)event.entity)) == null && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.onEntityConstructingClient(event);
        }
        if (event.entity instanceof EntityLivingBase && PlayerStats.get((EntityLivingBase)event.entity) == null) {
            PlayerStats.register((EntityLivingBase)event.entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onEntityConstructingClient(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityClientPlayerMP && PlayerStatsClient.get((EntityPlayerSP)((EntityClientPlayerMP)event.entity)) == null) {
            PlayerStatsClient.register((EntityPlayerSP)((EntityClientPlayerMP)event.entity));
        }
    }

    protected int decreaseAirSupply(EntityLivingBase ent, int air, int amt) {
        while (amt > 0) {
            air = this.decreaseAirSupply(ent, air);
            --amt;
        }
        return air;
    }

    protected int decreaseAirSupply(EntityLivingBase ent, int air) {
        int j = EnchantmentHelper.func_77501_a((EntityLivingBase)ent);
        return j > 0 && this.rand.nextInt(j + 1) > 0 ? air : air - 1;
    }

    @SubscribeEvent
    public void chunkGen(CogOreGenEvent event) {
        if (UndergroundBase.doStoneReplace) {
            this.replaceStone(event.worldX, event.worldZ, event.world);
        }
    }

    @SubscribeEvent
    public void onBlockUpdate(SpecialBlockEvent.BlockUpdateEvent event) {
        if (sidwaysFallPhysics && event.block instanceof BlockFalling && !BlockFalling.field_149832_M) {
            UnstableStoneHelper.updateCobble(event.world, event.x, event.y, event.z, this.rand, event.block, event.blockMetadata);
        }
    }

    public void replaceStone(int blockx, int blockz, World world) {
        Chunk chunk = world.func_72938_d(blockx, blockz);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    boolean flag;
                    int m;
                    Block b = chunk.func_150810_a(x, y, z);
                    Block bl = HardLibAPI.stoneManager.getReplacement(b, m = chunk.func_76628_c(x, y, z));
                    if (bl == null) continue;
                    boolean bl2 = flag = !World.func_147466_a((IBlockAccess)world, (int)(blockx + x), (int)(y - 1), (int)(blockz + z)) && UnstableStoneHelper.isBlockUnsupported(world, blockx + x, y, blockz + z);
                    if (flag) {
                        for (int oy = 2; flag && oy <= 16; ++oy) {
                            if (y - oy < 0 || chunk.func_150810_a(x, y - oy, z).func_149688_o() == Material.field_151579_a) continue;
                            flag = false;
                        }
                    }
                    if (flag) continue;
                    chunk.func_150807_a(x, y, z, bl, 0);
                }
            }
        }
    }

    @SubscribeEvent
    public void tickStart(TickEvent.WorldTickEvent event) {
        rockDustUpdateCount = 0;
    }

    public boolean setPlayerSwimming(EntityPlayer player, boolean keyUpdown) {
        boolean ret = false;
        if (this.playersSwimming.containsKey(player)) {
            ret = this.playersSwimming.get(player);
        }
        this.playersSwimming.put(player, keyUpdown);
        return ret != keyUpdown;
    }
}

