/*
 * Decompiled with CFR 0.152.
 */
package com.draco18s.hardlib;

import com.draco18s.hardlib.HardLib;
import cpw.mods.fml.common.Loader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CogConfig {
    private static List<String> extraModules = new ArrayList<String>();

    public static void addCogModule(String name) {
        extraModules.add(name);
    }

    public static void unpackConfigs() {
        CogConfig.unpackConfigs(false);
    }

    public static void unpackConfigs(boolean clean) {
        File defaultModulesDir;
        File defaultCustomDir;
        File configPath = CogConfig.getConfigDir();
        File modulesDir = new File(configPath, "modules");
        if (clean && (defaultCustomDir = new File(modulesDir, "custom")).exists()) {
            for (String module : extraModules) {
                File writeFile = new File(defaultCustomDir, module);
                if (!writeFile.exists()) continue;
                writeFile.delete();
            }
        }
        if ((defaultModulesDir = new File(modulesDir, "mods")).exists()) {
            File[] defaultModules;
            for (File defaultModule : defaultModules = defaultModulesDir.listFiles()) {
                System.out.println("Deleted file " + defaultModule.getName());
                defaultModule.delete();
            }
        } else {
            configPath.mkdir();
            modulesDir.mkdir();
            defaultModulesDir.mkdir();
        }
        for (String module : extraModules) {
            File writeFile = new File(defaultModulesDir, module);
            if (writeFile.exists()) continue;
            CogConfig.unpackConfigFile(module, writeFile);
        }
    }

    public static void unpackDefaultConfig() {
    }

    private static boolean unpackConfigFile(String configName, File destination) {
        String resourceName = "cog_config/" + configName;
        try {
            int len1;
            InputStream ex = HardLib.class.getClassLoader().getResourceAsStream(resourceName);
            BufferedOutputStream streamOut = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] buffer = new byte[1024];
            boolean len = false;
            while ((len1 = ex.read(buffer)) >= 0) {
                streamOut.write(buffer, 0, len1);
            }
            ex.close();
            streamOut.close();
            return true;
        }
        catch (Exception var6) {
            throw new RuntimeException("Failed to unpack resource '" + resourceName + "'", var6);
        }
    }

    private static File getConfigDir() {
        return new File(Loader.instance().getConfigDir(), "CustomOreGen");
    }
}

