/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal.leasure;

import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;

public class GoalGoDrink
extends Goal {
    @Override
    public int actionDuration(MillVillager villager) throws Exception {
        return 10000;
    }

    @Override
    public boolean allowRandomMoves() {
        return true;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) {
        return this.packDest(villager.getTownHall().getRandomLocationWithTag("Drinking"));
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) {
        if (villager.field_70170_p.func_72820_D() % 24000L < 10000L) {
            return false;
        }
        if (villager.hasDrunkToday) {
            return false;
        }
        Point p = villager.getTownHall().getRandomLocationWithTag("Drinking");
        if (p == null) {
            return false;
        }
        return villager.getPos().distanceTo(p) > 5.0;
    }

    @Override
    public boolean performAction(MillVillager villager) {
        villager.hasDrunkToday = true;
        return MillCommonUtilities.chanceOn(600);
    }

    @Override
    public int priority(MillVillager villager) {
        if (villager.isReligious()) {
            return MillCommonUtilities.randomInt(20) - 10;
        }
        return MillCommonUtilities.randomInt(10) - 7;
    }
}

