/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal.generic;

import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import org.millenaire.common.InvItem;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.goal.generic.GoalGeneric;
import org.millenaire.common.item.Goods;
import org.millenaire.common.pathing.atomicstryker.AStarConfig;

public class GoalGenericSlaughterAnimal
extends GoalGeneric {
    public String animalKey = null;
    public List<InvItem> extraItems = new ArrayList<InvItem>();
    public List<Integer> extraItemsChance = new ArrayList<Integer>();
    public List<String> extraItemsTag = new ArrayList<String>();

    public static GoalGenericSlaughterAnimal loadGenericSlaughterAnimalGoal(File file) {
        GoalGenericSlaughterAnimal g = new GoalGenericSlaughterAnimal();
        g.key = file.getName().split("\\.")[0].toLowerCase();
        try {
            String line;
            BufferedReader reader = MillCommonUtilities.getReader(file);
            while ((line = reader.readLine()) != null) {
                String value;
                if (line.trim().length() <= 0 || line.startsWith("//")) continue;
                String[] temp = line.split("=");
                if (temp.length != 2) {
                    MLN.error(null, "Invalid line when loading generic slaughter goal " + file.getName() + ": " + line);
                    continue;
                }
                String key = temp[0].trim().toLowerCase();
                if (GoalGeneric.readGenericGoalConfigLine(g, key, value = temp[1].trim(), file, line)) continue;
                if (key.equals("animalkey")) {
                    if (EntityList.field_75625_b.containsKey(value)) {
                        g.animalKey = value;
                        continue;
                    }
                    MLN.error(null, "Unknown animalkey in generic slaughter goal " + file.getName() + ": " + line + ". Careful, it is case-sensitive.");
                    continue;
                }
                if (key.equals("bonusitem")) {
                    String[] temp2 = value.split(",");
                    if (temp2.length != 3 && temp2.length != 2) {
                        MLN.error(null, "bonusitem must take the form of bonusitem=goodname,chanceon100 or bonusitem=goodname,chanceon100,requiredtag (ex: leather,50 or tripes,10,oven) in generic slaughter goal " + file.getName() + ": " + line);
                        continue;
                    }
                    if (Goods.goodsName.containsKey(temp2[0])) {
                        g.extraItems.add(Goods.goodsName.get(temp2[0]));
                        g.extraItemsChance.add(Integer.parseInt(temp2[1]));
                        if (temp2.length == 3) {
                            g.extraItemsTag.add(temp2[2].trim());
                            continue;
                        }
                        g.extraItemsTag.add(null);
                        continue;
                    }
                    MLN.error(null, "Unknown bonusitem item in generic slaughter goal " + file.getName() + ": " + line);
                    continue;
                }
                MLN.error(null, "Unknown line in generic slaughter goal " + file.getName() + ": " + line);
            }
            if (g.animalKey == null) {
                MLN.error(null, "The animalKey is mandatory in custom slaughter goals " + file.getName());
                return null;
            }
            reader.close();
        }
        catch (Exception e) {
            MLN.printException(e);
            return null;
        }
        return g;
    }

    public GoalGenericSlaughterAnimal() {
        this.duration = 100;
    }

    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        Point pos = villager.getPos();
        Entity closest = null;
        Building destBuilding = null;
        double bestDist = Double.MAX_VALUE;
        List<Building> buildings = this.getBuildings(villager);
        for (Building dest : buildings) {
            if (!this.isDestPossible(villager, dest)) continue;
            List<Entity> animals = MillCommonUtilities.getEntitiesWithinAABB(villager.field_70170_p, (Class)EntityList.field_75625_b.get(this.animalKey), dest.getPos(), 15, 10);
            for (Entity ent : animals) {
                if (ent.field_70128_L || this.isEntityChild(ent) || closest != null && !(pos.distanceTo(ent) < bestDist)) continue;
                closest = ent;
                destBuilding = dest;
                bestDist = pos.distanceTo(ent);
            }
        }
        if (closest == null) {
            return null;
        }
        return this.packDest(null, destBuilding, closest);
    }

    @Override
    public AStarConfig getPathingConfig() {
        if (this.animalKey.equals("Squid")) {
            return JPS_CONFIG_SLAUGHTERSQUIDS;
        }
        return JPS_CONFIG_TIGHT;
    }

    @Override
    public boolean isDestPossibleSpecific(MillVillager villager, Building b) {
        List<Entity> animals = MillCommonUtilities.getEntitiesWithinAABB(villager.field_70170_p, (Class)EntityList.field_75625_b.get(this.animalKey), b.getPos(), 15, 10);
        if (animals == null) {
            return false;
        }
        int nbanimals = 0;
        for (Entity ent : animals) {
            if (ent.field_70128_L || this.isEntityChild(ent)) continue;
            ++nbanimals;
        }
        int targetAnimals = 0;
        for (int i = 0; i < b.getResManager().spawns.size(); ++i) {
            if (!b.getResManager().spawnTypes.get(i).equals(this.animalKey)) continue;
            targetAnimals = b.getResManager().spawns.get(i).size();
        }
        return nbanimals > targetAnimals;
    }

    private boolean isEntityChild(Entity ent) {
        if (!(ent instanceof EntityAgeable)) {
            return false;
        }
        EntityAgeable animal = (EntityAgeable)ent;
        return animal.func_70631_g_();
    }

    @Override
    public boolean isFightingGoal() {
        return true;
    }

    @Override
    public boolean isPossibleGenericGoal(MillVillager villager) throws Exception {
        return this.getDestination(villager) != null;
    }

    @Override
    public boolean lookAtGoal() {
        return true;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        Building dest = villager.getGoalBuildingDest();
        if (dest == null) {
            return true;
        }
        List<Entity> animals = MillCommonUtilities.getEntitiesWithinAABB(villager.field_70170_p, (Class)EntityList.field_75625_b.get(this.animalKey), villager.getPos(), 2, 5);
        for (Entity ent : animals) {
            if (ent.field_70128_L || this.isEntityChild(ent) || !villager.func_70685_l(ent)) continue;
            villager.setEntityToAttack(ent);
            for (int i = 0; i < this.extraItems.size(); ++i) {
                if (this.extraItemsTag.get(i) != null && !dest.location.tags.contains(this.extraItemsTag.get(i)) || MillCommonUtilities.randomInt(100) >= this.extraItemsChance.get(i)) continue;
                villager.addToInv(this.extraItems.get(i), 1);
            }
            villager.func_71038_i();
            return true;
        }
        animals = MillCommonUtilities.getEntitiesWithinAABB(villager.field_70170_p, (Class)EntityList.field_75625_b.get(this.animalKey), villager.getPos(), 2, 5);
        for (Entity ent : animals) {
            if (ent.field_70128_L || this.isEntityChild(ent) || !villager.func_70685_l(ent)) continue;
            villager.setEntityToAttack(ent);
            for (int i = 0; i < this.extraItems.size(); ++i) {
                if (this.extraItemsTag.get(i) != null && !dest.location.tags.contains(this.extraItemsTag.get(i)) || MillCommonUtilities.randomInt(100) >= this.extraItemsChance.get(i)) continue;
                villager.addToInv(this.extraItems.get(i), 1);
            }
            villager.func_71038_i();
            return true;
        }
        return true;
    }

    @Override
    public int range(MillVillager villager) {
        return 2;
    }
}

