/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal.generic;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.millenaire.common.MLN;
import org.millenaire.common.MillVillager;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.goal.Goal;
import org.millenaire.common.goal.generic.GoalGenericCooking;
import org.millenaire.common.goal.generic.GoalGenericCrafting;
import org.millenaire.common.goal.generic.GoalGenericHarvestCrop;
import org.millenaire.common.goal.generic.GoalGenericPlantCrop;
import org.millenaire.common.goal.generic.GoalGenericSlaughterAnimal;
import org.millenaire.common.item.Goods;

public abstract class GoalGeneric
extends Goal {
    public String buildingTag = null;
    public String requiredTag = null;
    public boolean townHallGoal = false;
    public int priority = 50;
    public int duration = 5000;
    public String sentenceKey = null;
    public String labelKey = null;
    public ItemStack[] heldItems = null;
    public String sound = null;

    private static List<File> getGenericGoalFiles(String directoryName) {
        ArrayList<File> genericGoalFile = new ArrayList<File>();
        for (File loadDir : Mill.loadingDirs) {
            File dir = new File(new File(loadDir, "goals"), directoryName);
            if (!dir.exists()) continue;
            for (File file : dir.listFiles(new MillCommonUtilities.ExtFileFilter("txt"))) {
                genericGoalFile.add(file);
            }
        }
        return genericGoalFile;
    }

    public static void loadGenericGoals() {
        GoalGeneric goal;
        for (File file : GoalGeneric.getGenericGoalFiles("genericcrafting")) {
            try {
                goal = GoalGenericCrafting.loadGenericCraftingGoal(file);
                if (goal == null) continue;
                if (MLN.LogGeneralAI >= 1) {
                    MLN.major(goal, "loaded crafting goal");
                }
                goals.put(goal.key, goal);
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
        for (File file : GoalGeneric.getGenericGoalFiles("genericcooking")) {
            try {
                goal = GoalGenericCooking.loadGenericCookingGoal(file);
                if (goal == null) continue;
                if (MLN.LogGeneralAI >= 1) {
                    MLN.major(goal, "loaded cooking goal");
                }
                goals.put(((GoalGenericCooking)goal).key, goal);
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
        for (File file : GoalGeneric.getGenericGoalFiles("genericslaughteranimal")) {
            try {
                goal = GoalGenericSlaughterAnimal.loadGenericSlaughterAnimalGoal(file);
                if (goal == null) continue;
                if (MLN.LogGeneralAI >= 1) {
                    MLN.major(goal, "loaded slaughtering goal");
                }
                goals.put(((GoalGenericSlaughterAnimal)goal).key, goal);
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
        for (File file : GoalGeneric.getGenericGoalFiles("genericplanting")) {
            try {
                goal = GoalGenericPlantCrop.loadGenericPlantCropGoal(file);
                if (goal == null) continue;
                if (MLN.LogGeneralAI >= 1) {
                    MLN.major(goal, "loaded planting goal");
                }
                goals.put(((GoalGenericPlantCrop)goal).key, goal);
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
        for (File file : GoalGeneric.getGenericGoalFiles("genericharvesting")) {
            try {
                goal = GoalGenericHarvestCrop.loadGenericHarvestCropGoal(file);
                if (goal == null) continue;
                if (MLN.LogGeneralAI >= 1) {
                    MLN.major(goal, "loaded harvesting goal");
                }
                goals.put(((GoalGenericHarvestCrop)goal).key, goal);
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
    }

    public static boolean readGenericGoalConfigLine(GoalGeneric g, String key, String value, File file, String line) {
        if (key.equals("buildingtag")) {
            g.buildingTag = value.toLowerCase();
        } else if (key.equals("townhallgoal")) {
            g.townHallGoal = Boolean.parseBoolean(value);
        } else if (key.equals("requiredtag")) {
            g.requiredTag = value.toLowerCase();
        } else if (key.equals("sentencekey")) {
            g.sentenceKey = value.toLowerCase();
        } else if (key.equals("labelkey")) {
            g.labelKey = value.toLowerCase();
        } else if (key.equals("priority")) {
            g.priority = Integer.parseInt(value);
        } else if (key.equals("maxsimultaneousinbuilding")) {
            g.maxSimultaneousInBuilding = Integer.parseInt(value);
        } else if (key.equals("maxsimultaneoustotal")) {
            g.maxSimultaneousTotal = Integer.parseInt(value);
        } else if (key.equals("duration")) {
            g.duration = Integer.parseInt(value);
        } else if (key.equals("sound")) {
            g.sound = value;
        } else if (key.equals("helditems")) {
            String[] temp2 = value.split(",");
            g.heldItems = new ItemStack[temp2.length];
            for (int i = 0; i < temp2.length; ++i) {
                if (Goods.goodsName.containsKey(temp2[i])) {
                    g.heldItems[i] = Goods.goodsName.get(temp2[i]).getItemStack();
                    if (g.heldItems[i].func_77973_b() != null) continue;
                    MLN.error(null, "Held item with null item: " + temp2[i] + " in generic goal " + file.getName() + ": " + line);
                    continue;
                }
                g.heldItems[i] = null;
                MLN.error(null, "Unknown held item in generic goal " + file.getName() + ": " + line);
            }
        } else if (key.equals("buildinglimit")) {
            String[] temp2 = value.split(",");
            if (temp2.length != 2) {
                MLN.error(null, "buildinglimits must take the form of buildinglimit=goodname,goodquatity in generic goal " + file.getName() + ": " + line);
            } else if (Goods.goodsName.containsKey(temp2[0])) {
                g.buildingLimit.put(Goods.goodsName.get(temp2[0]), Integer.parseInt(temp2[1]));
            } else {
                MLN.error(null, "Unknown buildinglimits item in generic goal " + file.getName() + ": " + line);
            }
        } else if (key.equals("townhalllimit")) {
            String[] temp2 = value.split(",");
            if (temp2.length != 2) {
                MLN.error(null, "townhalllimits must take the form of townhalllimit=goodname,goodquatity in generic goal " + file.getName() + ": " + line);
            } else if (Goods.goodsName.containsKey(temp2[0])) {
                g.townhallLimit.put(Goods.goodsName.get(temp2[0]), Integer.parseInt(temp2[1]));
            } else {
                MLN.error(null, "Unknown townhalllimits item in generic goal " + file.getName() + ": " + line);
            }
        } else if (key.equals("itemsbalance")) {
            String[] temp2 = value.split(",");
            if (temp2.length != 2) {
                MLN.error(null, "itemsbalance must take the form of itemsbalance=firstgood,secondgood in generic goal " + file.getName() + ": " + line);
            } else if (Goods.goodsName.containsKey(temp2[0]) || Goods.goodsName.containsKey(temp2[1])) {
                g.balanceOutput1 = Goods.goodsName.get(temp2[0]);
                g.balanceOutput2 = Goods.goodsName.get(temp2[1]);
            } else {
                MLN.error(null, "Unknown itemsbalance item in generic goal " + file.getName() + ": " + line);
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public int actionDuration(MillVillager villager) throws Exception {
        return this.duration;
    }

    public List<Building> getBuildings(MillVillager villager) {
        ArrayList<Building> buildings = new ArrayList<Building>();
        if (this.townHallGoal) {
            if (this.requiredTag == null || villager.getTownHall().location.tags.contains(this.requiredTag)) {
                buildings.add(villager.getTownHall());
            }
        } else if (this.buildingTag == null) {
            if (this.requiredTag == null || villager.getHouse().location.tags.contains(this.requiredTag)) {
                buildings.add(villager.getHouse());
            }
        } else {
            for (Building b : villager.getTownHall().getBuildingsWithTag(this.buildingTag)) {
                if (this.requiredTag != null && !b.location.tags.contains(this.requiredTag)) continue;
                buildings.add(b);
            }
        }
        return buildings;
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) throws Exception {
        return this.heldItems;
    }

    public final boolean isDestPossible(MillVillager villager, Building dest) throws MLN.MillenaireException {
        return this.validateDest(villager, dest) && this.isDestPossibleSpecific(villager, dest);
    }

    public abstract boolean isDestPossibleSpecific(MillVillager var1, Building var2);

    public abstract boolean isPossibleGenericGoal(MillVillager var1) throws Exception;

    @Override
    public final boolean isPossibleSpecific(MillVillager villager) throws Exception {
        if (!this.isPossibleGenericGoal(villager)) {
            return false;
        }
        List<Building> buildings = this.getBuildings(villager);
        boolean destFound = false;
        if (!buildings.isEmpty()) {
            for (Building dest : buildings) {
                if (destFound) continue;
                destFound = this.isDestPossible(villager, dest);
            }
            return destFound;
        }
        return false;
    }

    @Override
    public String labelKey(MillVillager villager) {
        if (this.labelKey == null) {
            return this.key;
        }
        return this.labelKey;
    }

    @Override
    public String labelKeyWhileTravelling(MillVillager villager) {
        if (this.labelKey == null) {
            return this.key;
        }
        return this.labelKey;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return this.priority + villager.func_70681_au().nextInt(10);
    }

    @Override
    public String sentenceKey() {
        if (this.sentenceKey == null) {
            return this.key;
        }
        return this.sentenceKey;
    }
}

