/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.goal;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import org.millenaire.common.InvItem;
import org.millenaire.common.MillVillager;
import org.millenaire.common.goal.Goal;

public class GoalDeliverGoodsHousehold
extends Goal {
    @Override
    public Goal.GoalInformation getDestination(MillVillager villager) throws Exception {
        return this.packDest(villager.getHouse().getResManager().getSellingPos(), villager.getHouse());
    }

    @Override
    public ItemStack[] getHeldItemsTravelling(MillVillager villager) throws Exception {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (MillVillager v : villager.getHouse().villagers) {
            for (InvItem key : v.requiresGoods().keySet()) {
                if (villager.countInv(key.getItem(), key.meta) <= 0) continue;
                items.add(new ItemStack(key.getItem(), 1, key.meta));
            }
        }
        return items.toArray(new ItemStack[items.size()]);
    }

    @Override
    public boolean isPossibleSpecific(MillVillager villager) throws Exception {
        return false;
    }

    @Override
    public boolean performAction(MillVillager villager) throws Exception {
        for (MillVillager v : villager.getHouse().villagers) {
            for (InvItem key : v.requiresGoods().keySet()) {
                villager.putInBuilding(villager.getHouse(), key.getItem(), key.meta, 256);
            }
        }
        return true;
    }

    @Override
    public int priority(MillVillager villager) throws Exception {
        return 100;
    }
}

