/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import org.millenaire.common.MLN;
import org.millenaire.common.MillWorld;
import org.millenaire.common.Point;
import org.millenaire.common.Quest;
import org.millenaire.common.building.Building;
import org.millenaire.common.core.MillCommonUtilities;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.forge.MillAchievements;
import org.millenaire.common.network.ServerSender;
import org.millenaire.common.network.StreamReadWrite;

public class UserProfile {
    public static final String OLD_PROFILE_SINGLE_PLAYER = "SinglePlayer";
    private static final int CULTURE_MAX_REPUTATION = 4096;
    private static final int CULTURE_MIN_REPUTATION = -640;
    public static final int UPDATE_ALL = 1;
    public static final int UPDATE_REPUTATION = 2;
    public static final int UPDATE_DIPLOMACY = 3;
    public static final int UPDATE_ACTIONDATA = 4;
    public static final int UPDATE_TAGS = 5;
    public static final int UPDATE_LANGUAGE = 6;
    public static final int UPDATE_GLOBAL_TAGS = 7;
    private final HashMap<Point, Integer> villageReputations = new HashMap();
    private final HashMap<Point, Byte> villageDiplomacy = new HashMap();
    private final HashMap<String, Integer> cultureReputations = new HashMap();
    private final HashMap<String, Integer> cultureLanguages = new HashMap();
    private final List<String> profileTags = new ArrayList<String>();
    public String key;
    public String playerName;
    public List<Quest.QuestInstance> questInstances = new ArrayList<Quest.QuestInstance>();
    public HashMap<Long, Quest.QuestInstance> villagersInQuests = new HashMap();
    private final HashMap<String, String> actionData = new HashMap();
    private final MillWorld mw;
    boolean connectionActionDone = false;
    public boolean connected = false;
    private boolean showNewWorldMessageDone = false;
    public String releaseNumber = null;
    public HashMap<Point, Integer> panelsSent = new HashMap();
    public HashMap<Point, Long> buildingsSent = new HashMap();

    public static UserProfile readProfile(MillWorld world, File dir) {
        UserProfile profile = new UserProfile(world, dir.getName(), dir.getName());
        profile.loadProfileConfig(new File(profile.getDir(), "config.txt"));
        profile.loadProfileTags();
        profile.loadActionData(new File(profile.getDir(), "actiondata.txt"));
        profile.loadQuestInstances(new File(profile.getDir(), "quests.txt"));
        profile.loadLegacyFiles();
        return profile;
    }

    public UserProfile(MillWorld world, String key, String name) {
        this.key = key;
        this.playerName = name;
        this.mw = world;
    }

    public void adjustDiplomacyPoint(Building b, int change) {
        int dp = 0;
        if (this.villageDiplomacy.containsKey(b.getPos())) {
            dp = this.villageDiplomacy.get(b.getPos()).byteValue();
        }
        if ((dp += change) > 5) {
            dp = 5;
        }
        if (dp < 0) {
            dp = 0;
        }
        this.villageDiplomacy.put(b.getPos(), (byte)dp);
        this.saveProfileConfig();
        this.sendProfilePacket(3);
    }

    public void adjustLanguage(String culture, int change) {
        if (this.cultureLanguages.containsKey(culture)) {
            this.cultureLanguages.put(culture, this.cultureLanguages.get(culture) + change);
        } else {
            this.cultureLanguages.put(culture, change);
        }
        this.saveProfileConfig();
        this.sendProfilePacket(6);
    }

    public void adjustReputation(Building b, int change) {
        if (b == null) {
            return;
        }
        if (this.villageReputations.containsKey(b.getPos())) {
            this.villageReputations.put(b.getPos(), this.villageReputations.get(b.getPos()) + change);
        } else {
            this.villageReputations.put(b.getPos(), change);
        }
        int rep = 0;
        if (this.cultureReputations.containsKey(b.culture.key)) {
            rep = this.cultureReputations.get(b.culture.key);
        }
        rep += change / 10;
        rep = Math.max(-640, rep);
        rep = Math.min(4096, rep);
        this.cultureReputations.put(b.culture.key, rep);
        if (rep <= -640) {
            int nbAwfulRep = 0;
            for (int cultureRep : this.cultureReputations.values()) {
                if (cultureRep > -640) continue;
                ++nbAwfulRep;
            }
            if (nbAwfulRep >= 3) {
                this.getPlayer().func_71064_a((StatBase)MillAchievements.attila, 1);
            }
        }
        this.saveProfileConfig();
        this.sendProfilePacket(2);
    }

    public void changeProfileKey(String newKey) {
        MillCommonUtilities.deleteDir(this.getDir());
        this.key = newKey;
        this.saveProfile();
    }

    public void clearActionData(String key) {
        if (this.actionData.containsKey(key)) {
            this.actionData.remove(key);
            this.saveActionData();
            this.sendProfilePacket(4);
        }
    }

    private void clearFarAwayPanels() {
        ArrayList<Point> farAway = new ArrayList<Point>();
        EntityPlayer player = this.getPlayer();
        for (Point p : this.panelsSent.keySet()) {
            if (!(p.distanceToSquared((Entity)player) > 900.0)) continue;
            farAway.add(p);
        }
        for (Point p : farAway) {
            this.panelsSent.remove(p);
        }
    }

    public void clearTag(String tag) {
        if (this.profileTags.contains(tag)) {
            this.profileTags.remove(tag);
            this.saveProfileTags();
            this.sendProfilePacket(5);
        }
    }

    public void connectUser() {
        this.connected = true;
        this.connectionActionDone = false;
    }

    private void deleteQuestInstances(long id) {
        ArrayList<Long> toDelete = new ArrayList<Long>();
        for (long vid : this.villagersInQuests.keySet()) {
            if (this.villagersInQuests.get((Object)Long.valueOf((long)vid)).uniqueid != id) continue;
            toDelete.add(vid);
        }
        for (long vid : toDelete) {
            this.villagersInQuests.remove(vid);
        }
        for (int i = this.questInstances.size() - 1; i >= 0; --i) {
            if (this.questInstances.get((int)i).uniqueid != id) continue;
            this.questInstances.remove(i);
        }
    }

    public void disconnectUser() {
        this.connected = false;
        this.panelsSent.clear();
        this.buildingsSent.clear();
        if (MLN.LogNetwork >= 1) {
            MLN.major(this, "Disconnected user.");
        }
    }

    public String getActionData(String key) {
        return this.actionData.get(key);
    }

    public int getCultureLanguageKnowledge(String key) {
        if (this.cultureLanguages.containsKey(key)) {
            return this.cultureLanguages.get(key);
        }
        return 0;
    }

    public int getCultureReputation(String key) {
        if (this.cultureReputations.containsKey(key)) {
            return this.cultureReputations.get(key);
        }
        return 0;
    }

    public int getDiplomacyPoints(Building b) {
        int dp = 0;
        if (this.villageDiplomacy.containsKey(b.getPos())) {
            dp = this.villageDiplomacy.get(b.getPos()).byteValue();
        }
        return dp;
    }

    private File getDir() {
        File dir = new File(new File(this.mw.millenaireDir, "profiles"), this.key);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public EntityPlayer getPlayer() {
        return this.mw.world.func_72924_a(this.key);
    }

    public int getReputation(Building b) {
        int rep = 0;
        if (this.villageReputations.containsKey(b.getPos())) {
            rep = this.villageReputations.get(b.getPos());
        }
        if (b.culture != null && this.cultureReputations.containsKey(b.culture.key)) {
            rep += this.cultureReputations.get(b.culture.key).intValue();
        }
        return rep;
    }

    public List<String> getWorldQuestStatus() {
        ArrayList<String> res = new ArrayList<String>();
        boolean remaining = false;
        for (int i = 0; i < Quest.WORLD_MISSION_NB.length; ++i) {
            String status = this.getActionData(Quest.WORLD_MISSION_KEYS[i] + "queststatus");
            String chapterName = MLN.string("quest.cqchapter" + Quest.WORLD_MISSION_KEYS[i]);
            if (status == null) {
                res.add(MLN.string("quest.cqchapternotstarted", chapterName));
                res.add("");
                res.add(MLN.string("quest.cq" + Quest.WORLD_MISSION_KEYS[i] + "startexplanation"));
                remaining = true;
            } else {
                int nbMission;
                int mission = Integer.parseInt(status);
                if (mission >= (nbMission = Quest.WORLD_MISSION_NB[i])) {
                    res.add(MLN.string("quest.cqchaptercompleted", chapterName));
                } else {
                    res.add(MLN.string("quest.cqchapterinprogress", chapterName, "" + mission, "" + nbMission));
                    remaining = true;
                }
            }
            res.add("");
        }
        if (!remaining) {
            res.add(MLN.string("quest.cqallcompleted"));
            res.add("");
            res.add(MLN.string("quest.cqcheckforupdates"));
        }
        return res;
    }

    private String getWorldQuestStatusShort() {
        String res = MLN.string("quest.creationqueststatusshort") + " ";
        for (int i = 0; i < Quest.WORLD_MISSION_NB.length; ++i) {
            int nbMission;
            int mission;
            String status = this.getActionData(Quest.WORLD_MISSION_KEYS[i] + "queststatus");
            String chapterName = MLN.string("quest.cqchapter" + Quest.WORLD_MISSION_KEYS[i]);
            res = status == null ? res + MLN.string("quest.cqchapternotstartedshort", chapterName) + " " : ((mission = Integer.parseInt(status)) >= (nbMission = Quest.WORLD_MISSION_NB[i]) ? res + MLN.string("quest.cqchaptercompletedshort", chapterName) + " " : res + MLN.string("quest.cqchapterinprogressshort", chapterName, "" + mission, "" + nbMission) + " ");
        }
        return res + " " + MLN.string("quest.cqcheckquestlistandhelp", Mill.proxy.getQuestKeyName());
    }

    public boolean isTagSet(String tag) {
        return this.profileTags.contains(tag);
    }

    public boolean isWorldQuestFinished() {
        boolean remaining = false;
        for (int i = 0; i < Quest.WORLD_MISSION_NB.length; ++i) {
            int nbMission;
            String status = this.getActionData(Quest.WORLD_MISSION_KEYS[i] + "queststatus");
            if (status == null) {
                remaining = true;
                continue;
            }
            int mission = Integer.parseInt(status);
            if (mission >= (nbMission = Quest.WORLD_MISSION_NB[i])) continue;
            remaining = true;
        }
        return !remaining;
    }

    private void loadActionData(File dataFile) {
        this.actionData.clear();
        if (dataFile.exists()) {
            try {
                BufferedReader reader = MillCommonUtilities.getReader(dataFile);
                String line = reader.readLine();
                while (line != null) {
                    if (line.trim().length() > 0 && line.split(":").length == 2) {
                        this.actionData.put(line.split(":")[0], line.split(":")[1]);
                    }
                    line = reader.readLine();
                }
                if (MLN.LogWorldGeneration >= 1) {
                    MLN.major(null, "Loaded " + this.actionData.size() + " action data.");
                }
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
    }

    private void loadLegacyFiles() {
        File millenaireDir = this.mw.millenaireDir;
        File questDataFile = new File(millenaireDir, "quests.txt");
        if (questDataFile.exists()) {
            File configFile;
            this.loadQuestInstances(questDataFile);
            for (String tag : this.mw.globalTags) {
                this.setTag(tag);
            }
            File dataFile = new File(millenaireDir, "actiondata.txt");
            if (dataFile != null) {
                this.loadActionData(dataFile);
            }
            if ((configFile = new File(millenaireDir, "config.txt")) != null) {
                this.loadProfileConfig(configFile);
            }
            this.saveProfile();
            questDataFile.delete();
            if (dataFile != null) {
                dataFile.delete();
            }
        }
    }

    private void loadProfileConfig(File configFile) {
        if (configFile != null && configFile.exists()) {
            try {
                String line;
                BufferedReader reader = MillCommonUtilities.getReader(configFile);
                while ((line = reader.readLine()) != null) {
                    Point p;
                    int level;
                    String c;
                    String[] temp;
                    if (line.trim().length() <= 0 || line.startsWith("//") || (temp = line.split("=")).length != 2) continue;
                    String key = temp[0];
                    String value = temp[1];
                    if (key.equalsIgnoreCase("culture_reputation")) {
                        c = value.split(",")[0];
                        level = Integer.parseInt(value.split(",")[1]);
                        this.cultureReputations.put(c, level);
                        continue;
                    }
                    if (key.equalsIgnoreCase("culture_language")) {
                        c = value.split(",")[0];
                        level = Integer.parseInt(value.split(",")[1]);
                        this.cultureLanguages.put(c, level);
                        continue;
                    }
                    if (key.equalsIgnoreCase("village_reputations")) {
                        p = new Point(value.split(",")[0]);
                        level = Integer.parseInt(value.split(",")[1]);
                        this.villageReputations.put(p, level);
                        continue;
                    }
                    if (!key.equalsIgnoreCase("village_diplomacy")) continue;
                    p = new Point(value.split(",")[0]);
                    level = Integer.parseInt(value.split(",")[1]);
                    this.villageDiplomacy.put(p, (byte)level);
                }
                reader.close();
            }
            catch (IOException e) {
                MLN.printException(e);
            }
        }
        if (MLN.LogWorldGeneration >= 1) {
            MLN.major(null, "Config loaded. generateVillages: " + MLN.generateVillages);
        }
    }

    private void loadProfileTags() {
        File tagsFile = new File(this.getDir(), "tags.txt");
        this.profileTags.clear();
        if (tagsFile.exists()) {
            try {
                BufferedReader reader = MillCommonUtilities.getReader(tagsFile);
                String line = reader.readLine();
                while (line != null) {
                    if (line.trim().length() > 0) {
                        this.profileTags.add(line.trim());
                    }
                    line = reader.readLine();
                }
                if (MLN.LogWorldGeneration >= 1) {
                    MLN.major(this, "Loaded " + this.profileTags.size() + " tags.");
                }
            }
            catch (Exception e) {
                MLN.printException(e);
            }
        }
    }

    private void loadQuestInstances(File questDataFile) {
        this.questInstances.clear();
        this.villagersInQuests.clear();
        try {
            if (questDataFile != null && questDataFile.exists()) {
                String line;
                BufferedReader reader = MillCommonUtilities.getReader(questDataFile);
                while ((line = reader.readLine()) != null) {
                    Quest.QuestInstance qi;
                    if (line.trim().length() <= 0 || line.startsWith("//") || (qi = Quest.QuestInstance.loadFromString(this.mw, line, this)) == null) continue;
                    this.questInstances.add(qi);
                    for (Quest.QuestInstanceVillager qiv : qi.villagers.values()) {
                        this.villagersInQuests.put(qiv.id, qi);
                    }
                }
                reader.close();
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public void receiveDeclareReleaseNumberPacket(ByteBufInputStream ds) {
        try {
            this.releaseNumber = ds.readUTF();
            if (MLN.LogNetwork >= 1) {
                MLN.major(this, "Declared release number: " + this.releaseNumber);
            }
        }
        catch (IOException e) {
            MLN.printException("Error in receiveDeclareReleaseNumberPacket", e);
        }
    }

    public void receiveProfilePacket(ByteBufInputStream ds) {
        if (MLN.LogNetwork >= 2) {
            MLN.minor(null, "Receiving profile packet");
        }
        try {
            int i;
            int nb;
            int updateType = ds.read();
            if (updateType == 1 || updateType == 2) {
                nb = ds.readInt();
                this.villageReputations.clear();
                for (i = 0; i < nb; ++i) {
                    this.villageReputations.put(StreamReadWrite.readNullablePoint((DataInput)ds), ds.readInt());
                }
                nb = ds.readInt();
                this.cultureReputations.clear();
                for (i = 0; i < nb; ++i) {
                    String culture = ds.readUTF();
                    int rep = ds.readInt();
                    this.cultureReputations.put(culture, rep);
                }
            }
            if (updateType == 1 || updateType == 6) {
                nb = ds.readInt();
                this.cultureLanguages.clear();
                for (i = 0; i < nb; ++i) {
                    this.cultureLanguages.put(ds.readUTF(), ds.readInt());
                }
            }
            if (updateType == 1 || updateType == 3) {
                nb = ds.readInt();
                this.villageDiplomacy.clear();
                for (i = 0; i < nb; ++i) {
                    this.villageDiplomacy.put(StreamReadWrite.readNullablePoint((DataInput)ds), ds.readByte());
                }
            }
            if (updateType == 1 || updateType == 4) {
                nb = ds.readInt();
                this.actionData.clear();
                for (i = 0; i < nb; ++i) {
                    this.actionData.put(ds.readUTF(), StreamReadWrite.readNullableString((DataInput)ds));
                }
            }
            if (updateType == 1 || updateType == 5) {
                nb = ds.readInt();
                this.profileTags.clear();
                for (i = 0; i < nb; ++i) {
                    this.profileTags.add(ds.readUTF());
                }
            }
            if (updateType == 1 || updateType == 7) {
                nb = ds.readInt();
                this.mw.globalTags.clear();
                for (i = 0; i < nb; ++i) {
                    this.mw.globalTags.add(ds.readUTF());
                }
            }
            this.showNewWorldMessage();
        }
        catch (IOException e) {
            MLN.printException("Error in receiveProfilePacket", e);
        }
    }

    public void receiveQuestInstanceDeletePacket(ByteBufInputStream ds) {
        try {
            this.deleteQuestInstances(ds.readLong());
        }
        catch (IOException e) {
            MLN.printException("Error in receiveQuestInstanceDeletePacket", e);
        }
    }

    public void receiveQuestInstancePacket(ByteBufInputStream ds) {
        try {
            Quest.QuestInstance qi = StreamReadWrite.readNullableQuestInstance(this.mw, (DataInput)ds);
            this.deleteQuestInstances(qi.uniqueid);
            this.questInstances.add(qi);
            for (String key : qi.villagers.keySet()) {
                this.villagersInQuests.put(qi.villagers.get((Object)key).id, qi);
            }
        }
        catch (IOException e) {
            MLN.printException("Error in receiveQuestInstancePacket", e);
        }
    }

    private void saveActionData() {
        if (this.mw.world.field_72995_K) {
            return;
        }
        File configFile = new File(this.getDir(), "actiondata.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(configFile);
            for (String key : this.actionData.keySet()) {
                writer.write(key + ":" + this.actionData.get(key) + MLN.EOL);
            }
            writer.flush();
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public void saveProfile() {
        if (this.mw.world.field_72995_K) {
            return;
        }
        this.saveProfileConfig();
        this.saveProfileTags();
        this.saveQuestInstances();
        this.saveActionData();
    }

    private void saveProfileConfig() {
        if (this.mw.world.field_72995_K) {
            return;
        }
        File configFile = new File(this.getDir(), "config.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(configFile);
            for (String c : this.cultureReputations.keySet()) {
                writer.write("culture_reputation=" + c + "," + this.cultureReputations.get(c) + MLN.EOL);
            }
            for (String c : this.cultureLanguages.keySet()) {
                writer.write("culture_language=" + c + "," + this.cultureLanguages.get(c) + MLN.EOL);
            }
            for (Point p : this.villageReputations.keySet()) {
                writer.write("village_reputations=" + p + "," + this.villageReputations.get(p) + MLN.EOL);
            }
            for (Point p : this.villageDiplomacy.keySet()) {
                writer.write("village_diplomacy=" + p + "," + this.villageDiplomacy.get(p) + MLN.EOL);
            }
            writer.flush();
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    private void saveProfileTags() {
        if (this.mw.world.field_72995_K) {
            return;
        }
        File configFile = new File(this.getDir(), "tags.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(configFile);
            for (String tag : this.profileTags) {
                writer.write(tag + MLN.EOL);
            }
            writer.flush();
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public void saveQuestInstances() {
        if (this.mw.world.field_72995_K) {
            return;
        }
        File questDataFile = new File(this.getDir(), "quests.txt");
        try {
            BufferedWriter writer = MillCommonUtilities.getWriter(questDataFile);
            for (Quest.QuestInstance qi : this.questInstances) {
                writer.write(qi.writeToString() + MLN.EOL);
            }
            writer.flush();
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    public void sendInitialPackets() {
        if (MLN.LogNetwork >= 1) {
            MLN.major(this, "Sending initial packets.");
        }
        this.sendProfilePacket(1);
        for (Quest.QuestInstance qi : this.questInstances) {
            this.sendQuestInstancePacket(qi);
        }
    }

    public void sendProfilePacket(int updateType) {
        if (this.mw.world.field_72995_K) {
            return;
        }
        if (this.getPlayer() == null) {
            MLN.printException(new MLN.MillenaireException("Null player while trying to send packet:"));
            return;
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(101);
            data.write(updateType);
            if (updateType == 1 || updateType == 2) {
                data.writeInt(this.villageReputations.size());
                for (Point p : this.villageReputations.keySet()) {
                    StreamReadWrite.writeNullablePoint(p, data);
                    data.writeInt(this.villageReputations.get(p));
                }
                data.writeInt(this.cultureReputations.size());
                for (String culture : this.cultureReputations.keySet()) {
                    data.writeUTF(culture);
                    data.writeInt(this.cultureReputations.get(culture));
                }
            }
            if (updateType == 1 || updateType == 6) {
                data.writeInt(this.cultureLanguages.size());
                for (String culture : this.cultureLanguages.keySet()) {
                    data.writeUTF(culture);
                    data.writeInt(this.cultureLanguages.get(culture));
                }
            }
            if (updateType == 1 || updateType == 3) {
                data.writeInt(this.villageDiplomacy.size());
                for (Point p : this.villageDiplomacy.keySet()) {
                    StreamReadWrite.writeNullablePoint(p, data);
                    data.write(this.villageDiplomacy.get(p).byteValue());
                }
            }
            if (updateType == 1 || updateType == 4) {
                data.writeInt(this.actionData.size());
                for (String key : this.actionData.keySet()) {
                    data.writeUTF(key);
                    StreamReadWrite.writeNullableString(this.actionData.get(key), data);
                }
            }
            if (updateType == 1 || updateType == 5) {
                data.writeInt(this.profileTags.size());
                for (String tag : this.profileTags) {
                    data.writeUTF(tag);
                }
            }
            if (updateType == 1 || updateType == 7) {
                data.writeInt(this.mw.globalTags.size());
                for (String tag : this.mw.globalTags) {
                    data.writeUTF(tag);
                }
            }
        }
        catch (IOException e) {
            MLN.printException(this + ": Error in sendProfilePacket", e);
        }
        ServerSender.createAndSendPacketToPlayer(data, this.getPlayer());
    }

    public void sendQuestInstanceDeletePacket(long id) {
        if (this.mw.world.field_72995_K) {
            return;
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(103);
            data.writeLong(id);
        }
        catch (IOException e) {
            MLN.printException(this + ": Error in sendQuestInstanceDeletePacket", e);
        }
        ServerSender.createAndSendPacketToPlayer(data, this.getPlayer());
    }

    public void sendQuestInstancePacket(Quest.QuestInstance qi) {
        if (this.mw.world.field_72995_K) {
            return;
        }
        for (Quest.QuestInstanceVillager qiv : qi.villagers.values()) {
            Building th = qiv.getTownHall(this.mw.world);
            if (th == null || this.buildingsSent.containsKey(th.getPos())) continue;
            th.sendBuildingPacket(this.getPlayer(), false);
        }
        DataOutput data = ServerSender.getNewByteBufOutputStream();
        try {
            data.write(102);
            StreamReadWrite.writeNullableQuestInstance(qi, data);
        }
        catch (IOException e) {
            MLN.printException(this + ": Error in sendQuestInstancePacket", e);
        }
        ServerSender.createAndSendPacketToPlayer(data, this.getPlayer());
    }

    public void setActionData(String key, String value) {
        if (!this.actionData.containsKey(key) || !this.actionData.get(key).equals(value)) {
            this.actionData.put(key, value);
            this.saveActionData();
            this.sendProfilePacket(4);
        }
    }

    public void setTag(String tag) {
        if (!this.profileTags.contains(tag)) {
            this.profileTags.add(tag);
            this.saveProfileTags();
            this.sendProfilePacket(5);
        }
    }

    public void showNewWorldMessage() {
        if (!this.showNewWorldMessageDone) {
            ServerSender.sendChat(this.getPlayer(), EnumChatFormatting.YELLOW, this.getWorldQuestStatusShort());
            this.showNewWorldMessageDone = true;
        }
    }

    public void testQuests() {
        if (!this.mw.world.field_72995_K) {
            boolean change = false;
            for (int i = this.questInstances.size() - 1; i >= 0; --i) {
                Quest.QuestInstance qi = this.questInstances.get(i);
                change |= qi.checkStatus(this.mw.world);
            }
            for (Quest q : Quest.quests.values()) {
                Quest.QuestInstance qi = q.testQuest(this.mw, this);
                change |= qi != null;
                if (qi == null) continue;
                this.sendQuestInstancePacket(qi);
            }
            if (change) {
                this.saveQuestInstances();
            }
        }
    }

    public String toString() {
        return "Profile: " + this.key + "/" + this.playerName;
    }

    public void updateProfile() {
        EntityPlayer player = this.getPlayer();
        if (this.connected) {
            if (player != null) {
                this.clearFarAwayPanels();
                if (player.field_71093_bK == 0 && !this.connectionActionDone && !this.mw.world.field_72995_K) {
                    this.sendInitialPackets();
                    this.connectionActionDone = true;
                }
                if (player != null && this.mw.world.func_72820_D() % 1000L == 0L && this.mw.world.func_72935_r()) {
                    this.testQuests();
                }
                if (MLN.DEV && player != null && this.mw.world.func_72820_D() % 20L == 0L && this.mw.world.func_72935_r()) {
                    this.testQuests();
                }
            } else {
                this.connectionActionDone = false;
            }
        }
    }
}

