/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common;

import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import org.millenaire.common.MLN;
import org.millenaire.common.MillWorldInfo;
import org.millenaire.common.Point;
import org.millenaire.common.building.Building;
import org.millenaire.common.forge.Mill;
import org.millenaire.common.network.ServerSender;
import org.millenaire.common.network.StreamReadWrite;

public class MillMapInfo {
    public static final byte WATER = 1;
    public static final byte DANGER = 2;
    public static final byte BUILDING_FORBIDDEN = 3;
    public static final byte BUILDING_LOC = 4;
    public static final byte TREE = 5;
    public static final byte UNREACHABLE = 6;
    public static final byte UNBUILDABLE = 7;
    public static final byte OUTOFRANGE = 8;
    public static final byte OTHER = 9;
    public static final byte PATH = 10;
    public byte[][] data;
    public int width;
    public int length;
    public int mapStartX = 0;
    public int mapStartZ = 0;
    public Building townHall;

    public static void readPacket(ByteBufInputStream ds) {
        Point pos = null;
        try {
            pos = StreamReadWrite.readNullablePoint((DataInput)ds);
        }
        catch (IOException e) {
            MLN.printException(e);
            return;
        }
        Building building = Mill.clientWorld.getBuilding(pos);
        if (building == null) {
            return;
        }
        MillMapInfo minfo = new MillMapInfo(building);
        try {
            minfo.length = ds.readInt();
            minfo.width = ds.readInt();
            minfo.mapStartX = ds.readInt();
            minfo.mapStartZ = ds.readInt();
            minfo.data = new byte[minfo.length][];
            for (int x = 0; x < minfo.length; ++x) {
                minfo.data[x] = new byte[minfo.width];
                for (int z = 0; z < minfo.width; ++z) {
                    minfo.data[x][z] = ds.readByte();
                }
            }
            building.mapInfo = minfo;
            if (MLN.LogNetwork >= 3) {
                MLN.debug(null, "Receiving map info packet.");
            }
        }
        catch (IOException e) {
            MLN.printException(e);
        }
    }

    private MillMapInfo(Building townHall) {
        this.townHall = townHall;
    }

    public MillMapInfo(Building townHall, MillWorldInfo winfo) {
        this.townHall = townHall;
        byte thRegionId = 0;
        if (townHall.pathing != null) {
            thRegionId = townHall.pathing.thRegion;
        }
        Point centre = townHall.location.pos;
        int relcentreX = centre.getiX() - winfo.mapStartX;
        int relcentreZ = centre.getiZ() - winfo.mapStartZ;
        this.width = winfo.width;
        this.length = winfo.length;
        this.mapStartX = winfo.mapStartX;
        this.mapStartZ = winfo.mapStartZ;
        this.data = new byte[winfo.length][];
        for (int x = 0; x < winfo.length; ++x) {
            this.data[x] = new byte[winfo.width];
            for (int y = 0; y < winfo.width; ++y) {
                this.data[x][y] = winfo.water[x][y] ? 1 : (winfo.danger[x][y] ? 2 : (winfo.buildingForbidden[x][y] ? 3 : (winfo.buildingLoc[x][y] ? 4 : (winfo.tree[x][y] ? 5 : (winfo.path[x][y] ? 10 : (townHall.pathing != null && townHall.pathing.regions[x][y] != thRegionId ? 6 : (!winfo.canBuild[x][y] ? 7 : (Math.abs(relcentreX - x) > townHall.villageType.radius || Math.abs(relcentreZ - y) > townHall.villageType.radius ? 8 : 9))))))));
            }
        }
    }

    public void sendMapInfoPacket(EntityPlayer player) {
        DataOutput ds = ServerSender.getNewByteBufOutputStream();
        try {
            ds.write(7);
            StreamReadWrite.writeNullablePoint(this.townHall.getPos(), ds);
            ds.writeInt(this.length);
            ds.writeInt(this.width);
            ds.writeInt(this.mapStartX);
            ds.writeInt(this.mapStartZ);
            for (int x = 0; x < this.length; ++x) {
                for (int z = 0; z < this.width; ++z) {
                    ds.writeByte(this.data[x][z]);
                }
            }
        }
        catch (IOException e) {
            MLN.printException(this + ": Error in sendUpdatePacket", e);
        }
        ServerSender.createAndSendPacketToPlayer(ds, player);
    }
}

