/*
 * Decompiled with CFR 0.152.
 */
package minechess.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import minechess.client.LocalizationHandler;
import minechess.common.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class PacketAddChatMessage
extends AbstractPacket {
    private String message;
    private String[] replacements;

    public PacketAddChatMessage() {
    }

    public PacketAddChatMessage(String message, String ... replacements) {
        this.message = message;
        this.replacements = replacements;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.message);
        if (this.replacements != null) {
            buffer.writeInt(this.replacements.length);
            for (String replacement : this.replacements) {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)replacement);
            }
        } else {
            buffer.writeInt(0);
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.message = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.replacements = new String[buffer.readInt()];
        for (int i = 0; i < this.replacements.length; ++i) {
            this.replacements[i] = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        player.func_146105_b((IChatComponent)new ChatComponentTranslation(LocalizationHandler.getStringFromUnlocalizedParts(this.message, this.replacements), new Object[0]));
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

