/*
 * Decompiled with CFR 0.152.
 */
package minechess.common.ai;

import minechess.common.EntityBaseChessPiece;
import minechess.common.EntityKing;
import minechess.common.ai.AIPersonality;
import minechess.common.ai.Chess;
import minechess.common.ai.ChessMove;
import minechess.common.ai.ChessPosition;
import org.apache.commons.lang3.time.StopWatch;

public class AICaller
extends Thread {
    Chess chess;
    public EntityBaseChessPiece entityPiece;
    boolean bStart = false;
    private boolean bRunning = false;

    public void go(EntityBaseChessPiece entityPiece) {
        if (!this.bStart) {
            this.entityPiece = entityPiece;
            this.chess.pos = new ChessPosition(entityPiece);
            if (!entityPiece.isBlack()) {
                this.chess.HUMAN = false;
                this.chess.PROGRAM = true;
            }
            entityPiece.sendChatToNearbyPlayers(null, AIPersonality.getPreTurnMessage(this.chess.positionEvaluation(this.chess.pos, this.chess.PROGRAM), ((EntityKing)entityPiece).lastPositionScore, entityPiece.func_70681_au()));
            ((EntityKing)entityPiece).lastPositionScore = this.chess.positionEvaluation(this.chess.pos, this.chess.PROGRAM);
            this.bStart = true;
        }
    }

    public void cancel() {
        this.bStart = false;
    }

    public void exit() {
        this.bRunning = false;
    }

    public AICaller(Chess chess) {
        this.chess = chess;
    }

    @Override
    public void run() {
        if (this.bRunning) {
            return;
        }
        this.bRunning = true;
        while (!this.chess.main.bQuit && this.bRunning) {
            if (this.bStart) {
                this.bStart = false;
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    System.out.println("AICaller Thread Sleep Error");
                }
                StopWatch stopwatch = new StopWatch();
                stopwatch.start();
                this.chess.bThinking = true;
                ChessMove n = this.chess.playGame(this.chess.pos, this.chess.PROGRAM);
                if (this.chess.bThinking) {
                    this.chess.bThinking = false;
                    this.entityPiece.executeMove(n);
                    this.chess.pos.makeMove(n);
                    this.entityPiece.sendChatToNearbyPlayers(null, AIPersonality.getPostTurnMessage(this.chess.positionEvaluation(this.chess.pos, this.chess.PROGRAM), ((EntityKing)this.entityPiece).lastPositionScore, (int)(stopwatch.getTime() / 1000L), this.entityPiece.func_70681_au()));
                    this.chess.main.bQuit = true;
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                System.out.println("AICaller Thread Sleep Error");
            }
        }
        this.bRunning = false;
    }
}

