/*
 * Decompiled with CFR 0.152.
 */
package minechess.common;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import minechess.common.AchievementHandler;
import minechess.common.CommandAIDepth;
import minechess.common.CommandDraw;
import minechess.common.CommandKillPiece;
import minechess.common.CommonProxyMineChess;
import minechess.common.EntityBishop;
import minechess.common.EntityKing;
import minechess.common.EntityKnight;
import minechess.common.EntityPawn;
import minechess.common.EntityPickyXPOrb;
import minechess.common.EntityQueen;
import minechess.common.EntityRook;
import minechess.common.ItemPieceMover;
import minechess.common.WorldGeneratorMineChess;
import minechess.common.ai.Chess;
import minechess.common.network.PacketAddChatMessage;
import minechess.common.network.PacketOpenPromotionGUI;
import minechess.common.network.PacketPieceSelectedUpdate;
import minechess.common.network.PacketPipeline;
import minechess.common.network.PacketPlaySound;
import minechess.common.network.PacketPromotePawn;
import minechess.common.network.PacketSpawnParticle;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@Mod(modid="MineChess", name="MineChess", version="1.3.8")
public class MineChess {
    @SidedProxy(clientSide="minechess.client.ClientProxyMineChess", serverSide="minechess.common.CommonProxyMineChess")
    public static CommonProxyMineChess proxy;
    @Mod.Instance(value="MineChess")
    public static MineChess instance;
    public static PacketPipeline packetPipeline;
    public static final boolean DEBUG = false;
    public static Item itemPieceMover;
    public static boolean configRenderMovement;
    public static int configWorldgenPuzzleUnderground;
    public static Property propertyAIDepth;
    public static Configuration config;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        File oldConfig = new File(configFile.getAbsolutePath().replace("MineChess", "Minemaarten_Chess Mod"));
        if (oldConfig.exists()) {
            configFile = oldConfig;
        }
        Configuration config = new Configuration(configFile);
        config.load();
        Property PropertyRenderMovement = config.get("general", "Display possible moves", true);
        PropertyRenderMovement.comment = "Setting this to false doesn't show the green tiles indicating the possible moves of the current selected chesspiece.";
        configRenderMovement = PropertyRenderMovement.getBoolean(false);
        Property PropertyPuzzleUnderground = config.get("general", "Spawnrate of underground Chess Puzzles", 40);
        PropertyPuzzleUnderground.comment = "Determines the spawnrate of the underground chess puzzles. The lesser the number, the more spawns. Set to 0 to completely disable the spawns.";
        configWorldgenPuzzleUnderground = PropertyPuzzleUnderground.getInt();
        propertyAIDepth = config.get("AI settings", "AI depth", 5);
        MineChess.propertyAIDepth.comment = "Determines the difficulty of the AI. This can also be changed in-game by using the command \"aidepth <depth>\". The default is quite a challenge and takes about 30 seconds before making a move. Decreasing the number lowers the diffuculty quite severely. Increasing it is also possible, but take more time in account.";
        Chess.maxDepthSetting = propertyAIDepth.getInt();
        config.save();
        itemPieceMover = new ItemPieceMover().func_77637_a(CreativeTabs.field_78040_i).func_77655_b("pieceMover");
        this.gameRegisters();
        proxy.registerHandlers();
        AchievementHandler.init();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenders();
        packetPipeline = new PacketPipeline();
        packetPipeline.registerPacket(PacketAddChatMessage.class);
        packetPipeline.registerPacket(PacketOpenPromotionGUI.class);
        packetPipeline.registerPacket(PacketPlaySound.class);
        packetPipeline.registerPacket(PacketPromotePawn.class);
        packetPipeline.registerPacket(PacketPieceSelectedUpdate.class);
        packetPipeline.registerPacket(PacketSpawnParticle.class);
        packetPipeline.initialise();
    }

    public void gameRegisters() {
        GameRegistry.registerItem((Item)itemPieceMover, (String)"pieceMover", (String)"MineChess");
        ItemStack chessColumn = new ItemStack(itemPieceMover, 1, 3);
        ItemStack blackWool = new ItemStack(Blocks.field_150325_L, 1, 15);
        ItemStack whiteWool = new ItemStack(Blocks.field_150325_L, 1, 0);
        for (int i = 0; i < 2; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(itemPieceMover, 1, 1 - i), (Object[])new Object[]{" ww", " ww", "s  ", Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, i * 15), Character.valueOf('s'), new ItemStack(Items.field_151055_y)});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(itemPieceMover, 1, 2), (Object[])new Object[]{chessColumn, chessColumn, chessColumn, chessColumn, chessColumn, chessColumn, chessColumn, chessColumn});
        GameRegistry.addShapelessRecipe((ItemStack)chessColumn, (Object[])new Object[]{blackWool, blackWool, blackWool, blackWool, whiteWool, whiteWool, whiteWool, whiteWool});
        EntityRegistry.registerModEntity(EntityKing.class, (String)"King", (int)0, (Object)this, (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityRook.class, (String)"Rook", (int)1, (Object)this, (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityPawn.class, (String)"Pawn", (int)2, (Object)this, (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityKnight.class, (String)"Knight", (int)3, (Object)this, (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityQueen.class, (String)"Queen", (int)4, (Object)this, (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityBishop.class, (String)"Bishop", (int)5, (Object)this, (int)80, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityPickyXPOrb.class, (String)"Picky XP Orb", (int)6, (Object)this, (int)80, (int)1, (boolean)true);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorMineChess(), (int)0);
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        ServerCommandManager comManager = (ServerCommandManager)MinecraftServer.func_71276_C().func_71187_D();
        comManager.func_71560_a((ICommand)new CommandAIDepth());
        comManager.func_71560_a((ICommand)new CommandKillPiece());
        comManager.func_71560_a((ICommand)new CommandDraw());
    }

    static {
        instance = new MineChess();
    }
}

