/*
 * Decompiled with CFR 0.152.
 */
package minechess.common;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import minechess.client.LocalizationHandler;
import minechess.common.EntityBaseChessPiece;
import minechess.common.EntityBishop;
import minechess.common.EntityKing;
import minechess.common.EntityKnight;
import minechess.common.EntityPawn;
import minechess.common.EntityQueen;
import minechess.common.EntityRook;
import minechess.common.MineChessUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemPieceMover
extends Item {
    private final IIcon[] texture = new IIcon[5];

    public ItemPieceMover() {
        this.func_77627_a(true);
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < 5; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        String name = super.func_77658_a() + ".";
        switch (par1ItemStack.func_77960_j()) {
            case 0: {
                return name + "blackPieceMover";
            }
            case 1: {
                return name + "whitePieceMover";
            }
            case 2: {
                return name + "chessBoardGenerator";
            }
            case 3: {
                return name + "chessBoardColumn";
            }
        }
        return name + "chessAI";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.texture[0] = par1IconRegister.func_94245_a("chessMod:blackMover");
        this.texture[1] = par1IconRegister.func_94245_a("chessMod:whiteMover");
        this.texture[2] = par1IconRegister.func_94245_a("chessMod:chessBoard");
        this.texture[3] = par1IconRegister.func_94245_a("chessMod:chessBoardColumn");
        this.texture[4] = par1IconRegister.func_94245_a("chessMod:AIInjector");
    }

    public IIcon func_77617_a(int par1) {
        if (par1 < 5) {
            return this.texture[par1];
        }
        return this.texture[2];
    }

    public boolean func_77648_a(ItemStack iStack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        if (iStack.func_77960_j() < 2) {
            EntityBaseChessPiece entitySelected = ItemPieceMover.getEntitySelected(world, iStack);
            if (entitySelected != null && !entitySelected.field_70128_L && !world.field_72995_K) {
                try {
                    if (!entitySelected.getEnemyPiece().computerPiece) {
                        entitySelected.setLosingPlayer(player, entitySelected.isBlack());
                    }
                    entitySelected.tryToGoTo(x - entitySelected.xOffset, z - entitySelected.zOffset, player);
                }
                catch (Exception e) {
                    System.err.println("An unknown exception has been thrown with MineChess. Here's a stacktrace: ");
                    e.printStackTrace();
                }
                ItemPieceMover.setEntitySelected(-1, iStack);
                ItemPieceMover.setRenderTiles(null, 0, iStack);
                return true;
            }
        } else if (iStack.func_77960_j() == 2) {
            if (world.field_72995_K) {
                return false;
            }
            int orientation = MineChessUtils.determineOrientation(player);
            int startX = x;
            int startZ = z;
            switch (orientation) {
                case 0: {
                    startX -= 7;
                    break;
                }
                case 1: {
                    startX -= 7;
                    startZ -= 7;
                    break;
                }
                case 2: {
                    startZ -= 7;
                }
            }
            AxisAlignedBB bbBox = AxisAlignedBB.func_72330_a((double)(startX - 1), (double)(y - 1), (double)(startZ - 1), (double)(startX + 9), (double)(y + 2), (double)(startZ + 9));
            List pieces = world.func_72872_a(EntityBaseChessPiece.class, bbBox);
            if (pieces.size() > 0) {
                MineChessUtils.sendUnlocalizedMessage(player, "message.error.targetOccupied", EnumChatFormatting.DARK_RED.toString());
                return false;
            }
            for (int curX = 0; curX < 8; ++curX) {
                for (int curZ = 0; curZ < 8; ++curZ) {
                    if (!(world.func_147439_a(startX + curX, y, startZ + curZ).func_149712_f(world, startX + curX, y, startZ + curZ) < 0.0f)) continue;
                    MineChessUtils.sendUnlocalizedMessage(player, "message.error.unbreakableBlocks", EnumChatFormatting.DARK_RED.toString());
                    return false;
                }
            }
            this.generateChessEntities(world, startX, y, startZ, false);
            MineChessUtils.generateChessBoard(world, startX, y, startZ);
            --iStack.field_77994_a;
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack iStack, EntityPlayer player, List list, boolean par4) {
        if (iStack.func_77960_j() < 2) {
            EntityBaseChessPiece entitySelected = ItemPieceMover.getEntitySelected(player.field_70170_p, iStack);
            if (entitySelected != null) {
                list.add(LocalizationHandler.getStringFromUnlocalizedParts(entitySelected.isBlack() ? "tooltip.selectedBlackPiece" : "tooltip.selectedWhitePiece", EnumChatFormatting.GRAY.toString(), "entity." + EntityList.func_75621_b((Entity)entitySelected) + ".name", entitySelected.getColumnName(entitySelected.targetX) + (entitySelected.targetZ + 1)));
            } else {
                list.add(LocalizationHandler.getStringLocalization("tooltip.noSelectedPiece"));
            }
        } else if (iStack.func_77960_j() == 4) {
            list.add(LocalizationHandler.getStringLocalization("tooltip.aiInjector"));
        }
    }

    private void generateChessEntities(World world, int x, int y, int z, boolean computerNeeded) {
        if (!world.field_72995_K) {
            for (int side = 0; side < 2; ++side) {
                int i;
                EntityKing king = new EntityKing(world);
                king.setPositionAndOffset((double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
                king.setTargetPosition(3, side * 7);
                king.setIsBlack(side == 1);
                king.computerPiece = computerNeeded;
                world.func_72838_d((Entity)king);
                EntityQueen queen = new EntityQueen(world);
                queen.setPositionAndOffset((double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
                queen.setTargetPosition(4, side * 7);
                queen.setIsBlack(side == 1);
                queen.computerPiece = computerNeeded;
                world.func_72838_d((Entity)queen);
                for (i = 0; i < 2; ++i) {
                    EntityRook rook = new EntityRook(world);
                    rook.setPositionAndOffset((double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
                    rook.setTargetPosition(i * 7, side * 7);
                    rook.setIsBlack(side == 1);
                    rook.computerPiece = computerNeeded;
                    world.func_72838_d((Entity)rook);
                }
                for (i = 0; i < 2; ++i) {
                    EntityKnight knight = new EntityKnight(world);
                    knight.setPositionAndOffset((double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
                    knight.targetX = 1 + i * 5;
                    knight.targetY = y + 1;
                    knight.targetZ = side * 7;
                    knight.setIsBlack(side == 1);
                    knight.computerPiece = computerNeeded;
                    world.func_72838_d((Entity)knight);
                }
                for (i = 0; i < 2; ++i) {
                    EntityBishop bishop = new EntityBishop(world);
                    bishop.setPositionAndOffset((double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
                    bishop.setTargetPosition(2 + i * 3, side * 7);
                    bishop.setIsBlack(side == 1);
                    bishop.computerPiece = computerNeeded;
                    world.func_72838_d((Entity)bishop);
                }
                for (i = 0; i < 8; ++i) {
                    EntityPawn pawn = new EntityPawn(world);
                    pawn.setPositionAndOffset((double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
                    pawn.setTargetPosition(i, 1 + side * 5);
                    pawn.setIsBlack(side == 1);
                    pawn.computerPiece = computerNeeded;
                    world.func_72838_d((Entity)pawn);
                }
            }
        }
    }

    public static void setEntitySelected(int entityID, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("entitySelected", entityID);
    }

    public static EntityBaseChessPiece getEntitySelected(World world, ItemStack stack) {
        Entity entity = world.func_73045_a(stack.func_77942_o() ? stack.func_77978_p().func_74762_e("entitySelected") : -1);
        return entity instanceof EntityBaseChessPiece ? (EntityBaseChessPiece)entity : null;
    }

    public static void setRenderTiles(List<int[]> tiles, int renderHeight, ItemStack stack) {
        NBTTagCompound tileTag = new NBTTagCompound();
        if (tiles != null) {
            tileTag.func_74768_a("size", tiles.size());
            tileTag.func_74768_a("renderHeight", renderHeight);
            for (int i = 0; i < tiles.size(); ++i) {
                tileTag.func_74783_a("tile" + i, tiles.get(i));
            }
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("renderTiles", (NBTBase)tileTag);
    }

    public static List<int[]> getRenderTiles(ItemStack stack) {
        NBTTagCompound tileTag;
        if (stack.func_77942_o() && (tileTag = stack.func_77978_p().func_74775_l("renderTiles")) != null) {
            ArrayList<int[]> tiles = new ArrayList<int[]>();
            int size = tileTag.func_74762_e("size");
            for (int i = 0; i < size; ++i) {
                tiles.add(tileTag.func_74759_k("tile" + i));
            }
            return tiles;
        }
        return null;
    }

    public static int getRenderHeight(ItemStack stack) {
        NBTTagCompound tileTag;
        if (stack.func_77942_o() && (tileTag = stack.func_77978_p().func_74775_l("renderTiles")) != null) {
            return tileTag.func_74762_e("renderHeight");
        }
        return 0;
    }
}

