/*
 * Decompiled with CFR 0.152.
 */
package minechess.common;

import java.util.ArrayList;
import java.util.List;
import minechess.common.EntityBaseChessPiece;
import minechess.common.MineChess;
import minechess.common.MineChessUtils;
import minechess.common.network.PacketOpenPromotionGUI;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class EntityPawn
extends EntityBaseChessPiece {
    public EntityPawn(World par1World) {
        super(par1World);
        this.func_70105_a(0.4f, 0.93f);
    }

    @Override
    public Entity getMob() {
        return new EntityZombie(this.field_70170_p);
    }

    @Override
    public List<int[]> getPossibleMoves() {
        ArrayList<int[]> moves = new ArrayList<int[]>();
        int[] move1 = new int[]{this.targetX, this.targetZ + (this.isBlack() ? -1 : 1)};
        if (this.firstMove) {
            int[] move2 = new int[]{this.targetX, this.targetZ + (this.isBlack() ? -2 : 2)};
            if (!this.isEnemyAt(move2[0], move2[1])) {
                moves.add(move2);
            }
        }
        if (!this.isEnemyAt(move1[0], move1[1])) {
            moves.add(move1);
        }
        if (this.isEnemyAt(this.targetX + 1, this.targetZ + (this.isBlack() ? -1 : 1))) {
            int[] move3 = new int[]{this.targetX + 1, this.targetZ + (this.isBlack() ? -1 : 1)};
            moves.add(move3);
        }
        if (this.isEnemyAt(this.targetX - 1, this.targetZ + (this.isBlack() ? -1 : 1))) {
            int[] move4 = new int[]{this.targetX - 1, this.targetZ + (this.isBlack() ? -1 : 1)};
            moves.add(move4);
        }
        return moves;
    }

    private boolean isEnemyAt(int x, int z) {
        List<EntityBaseChessPiece> pieces = this.getChessPieces(true);
        for (int i = 0; i < pieces.size(); ++i) {
            if (pieces.get(i).getTargetPosition()[0] != x || pieces.get(i).getTargetPosition()[1] != z && (!pieces.get((int)i).enPassantPossibility || pieces.get((int)i).targetZ != this.targetZ) || !(pieces.get(i).isBlack() ^ this.isBlack())) continue;
            return true;
        }
        return false;
    }

    public void promote(EntityPlayer player, String promotedPieceName) {
        if (this.isPromoting() && !this.field_70170_p.field_72995_K && !this.field_70128_L) {
            EntityBaseChessPiece promotedPiece = (EntityBaseChessPiece)EntityList.func_75620_a((String)promotedPieceName, (World)this.field_70170_p);
            promotedPiece.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            promotedPiece.xOffset = this.xOffset;
            promotedPiece.zOffset = this.zOffset;
            promotedPiece.setTargetPosition(this.targetX, this.targetZ);
            promotedPiece.setIsBlack(this.isBlack());
            this.field_70170_p.func_72838_d((Entity)promotedPiece);
            this.func_70106_y();
            for (int i = 0; i < 40; ++i) {
                MineChessUtils.spawnParticle("explode", this.field_70170_p, this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * 1.5, this.field_70161_v, this.field_70146_Z.nextDouble() / 10.0 - 0.05, this.field_70146_Z.nextDouble() / 10.0 - 0.05, this.field_70146_Z.nextDouble() / 10.0 - 0.05);
            }
            this.handleAfterTurn(player);
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K && this.isPromoting() && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == MineChess.itemPieceMover && (player.field_71071_by.func_70448_g().func_77960_j() == 0 && this.isBlack() || player.field_71071_by.func_70448_g().func_77960_j() == 1 && !this.isBlack())) {
            MineChess.packetPipeline.sendTo(new PacketOpenPromotionGUI(this), (EntityPlayerMP)player);
        } else {
            super.func_70085_c(player);
        }
        return false;
    }

    private boolean isPromoting() {
        return this.targetZ % 7 == 0;
    }

    @Override
    protected void handleAfterTurn(EntityPlayer player) {
        super.handleAfterTurn(player);
        if (this.computerPiece && this.isPawnAwaitingPromotion()) {
            this.promote(player, "MineChess.Queen");
        }
    }
}

